<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Admin extends CI_Controller {
	function __construct(){
		parent::__construct();
		$this->load->model('Model_admin', 'admin');
		$this->load->model('Model_setting', 'setting');
		
	}
	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/Admin
	 *	- or -
	 * 		http://example.com/index.php/Admin/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/Admin/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */
	public function index(){
		$meta['page_title'] = "Login";
		if($this->session->userdata(APP_NAME.'_logged_in'))
			redirect('/admin/dashboard', 'refresh');
		if($this->input->post()){
			$this->form_validation->set_rules('email','Email', 'required');
			$this->form_validation->set_rules('password','Password', 'required');
			if ($this->form_validation->run() == true){
				$data = array(
					'email' => $this->input->post('email'),
					'password' => md5($this->input->post('password'))
				);
				$result = $this->admin->checkAdmin($data);
				
				if($result) {
					$this->session->set_userdata(APP_NAME.'_logged_in', $result);
					$adminInfo = $this->session->userdata(APP_NAME.'_logged_in');
					if($adminInfo['permission'] == 2){
						redirect('/admin/store', 'refresh');
					}else{
						// $this->session->set_flashdata('success', 'Admin login successfully.');
						redirect('/admin/dashboard', 'refresh');
					}
					
				} else {
					$this->session->set_flashdata('error','Invalid Email or Password');
					redirect('/admin', 'refresh');
				}
			}
		}
		$this->load->view('admin/common/blank_header', $meta);
		$this->load->view('admin/login');
		$this->load->view('admin/common/blank_footer');
	}
	public function forgot(){
		$meta['page_title'] = "Forgot Password";
		if($this->session->userdata(APP_NAME.'_logged_in'))
			redirect('dashboard', 'refresh');
		if($this->input->post()){
			$this->form_validation->set_rules('email','Email', 'required');
			if ($this->form_validation->run() == true){
				$result = $this->admin->checkAdminByEmail($this->input->post('email'));
				if($result) {
					
					$code = random_string('alnum',10);
					$this->admin->editCode($this->input->post('email'), $code);
					
					
					// Sending mail Start
					$mail_to = $this->input->post('email');
					$mail_subject = 'Reset Password';
					$encryptedCode = encryption($code);
					$data = array(
						'password_reset_link' => base_url('/admin/password_reset').'?code='.$encryptedCode,
						'title' => $mail_subject
					);
					$mail_message = $this->load->view('admin/email/forgotpassword', $data, true);
					$this->Model_mail->sendMail($mail_to, $mail_subject, $mail_message);
					// Sending mail End
					$this->session->set_flashdata('success', 'Password Reset Link send.');
					redirect('/admin/forgotpassword', 'refresh');
				} else {
					$this->session->set_flashdata('error','User Not found for Email id');
					redirect('/admin/forgot', 'refresh');
				}
			}
		}
		$this->load->view('admin/common/blank_header', $meta);
		$this->load->view('admin/forgot');
		$this->load->view('admin/common/blank_footer');
	}
	public function forgotpassword(){
		$meta['page_title'] = "Forgot Password";
		$this->load->view('admin/common/blank_header', $meta);
		$this->load->view('admin/mail_send');
		$this->load->view('admin/common/blank_footer');
	}
	public function password_reset(){
		$meta['page_title'] = 'Reset Password';
		if($this->input->get('code') != ''){
			$code = decryption($this->input->get('code'));
			$checkUserByCode = $this->admin->checkUserByOtp($code);
			
			if($checkUserByCode){
				if($this->input->post()){
					$this->form_validation->set_rules('password', 'New Password', 'required');
					$this->form_validation->set_rules('co_password', 'Re-type New Password', 'required|matches[password]');
					
					if ($this->form_validation->run() == true){
						$this->admin->updateUserPassword($this->input->post('password'), $code);
						$this->session->set_flashdata('success','Your Password Successfully reset. ');
						redirect('/admin', 'refresh');
					}else{
						$this->session->set_flashdata('error','Please check Form carfully for errors!');
					}
				}
				$data['password_link'] = base_url('/admin/password_reset').'?code='.$this->input->get('code');
				$this->load->view('admin/common/blank_header', $meta);
				$this->load->view('admin/reset_password', $data);
				$this->load->view('admin/common/blank_footer');
			}else{
				$this->session->set_flashdata('error','Password Reset link expired. Please try again');
				redirect('/admin/forgot', 'refresh');	
			}
		}else{
			$this->session->set_flashdata('error','Invalid Link');
			redirect('/admin', 'refresh');
		}
	}
	public function changepass(){
		if(!$this->session->userdata(APP_NAME.'_logged_in'))
			redirect('admin', 'refresh');
		$meta['page_title'] = $data['page_title'] = 'Change Password';
		$this->load->view('admin/common/header', $meta);
		$this->load->view('admin/change_password', $data);
		$this->load->view('admin/common/footer');
	}
	public function validatePassword(){
		$this->form_validation->set_rules('current_password', 'Current Password', 'required');
        $this->form_validation->set_rules('password', 'Password', 'required');
        $this->form_validation->set_rules('co_password', 'Confirm Password', 'required|matches[password]');
        if ($this->form_validation->run() == true){
            $result = array();
        }else{
			$result['errors'] = $this->form_validation->error_array();
        }
        echo json_encode($result);
        die;
	}
	public function updatePassword(){
		$post = $this->input->post();
		
        $admin = $this->session->userdata(APP_NAME.'_logged_in');
        $profile = $this->admin->getAdminById($admin['admin_id']);
        if($profile['password'] == md5($post['current_password'])){
            $updatePasswrod = $this->admin->updatePassword($post['password'], $admin['admin_id']);
            if($updatePasswrod){
                $this->session->set_flashdata('success', 'Passwrod successfully Updated.');
            }else{
                $this->session->set_flashdata('error','Password Not updated.');
            }
        }else{
            $this->session->set_flashdata('error','Current Password Not match.');
        }
        redirect('admin/changepass','refresh');
	}
	public function logout(){
		$this->session->unset_userdata(APP_NAME.'_logged_in');
		session_destroy();
		$this->session->set_flashdata('success', 'Logout successfully.');
		redirect('/admin', 'refresh');
	}
	public function blank(){
		$meta['page_title'] = "Blank Page";
		$this->load->view('admin/common/header', $meta);
		$this->load->view('admin/blank');
		$this->load->view('admin/common/footer');
	}
}
