<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class User extends CI_Controller {

	function __construct(){

		parent::__construct();

		if(!$this->session->userdata(APP_NAME.'_logged_in'))

            redirect('/admin', 'refresh');

		if($this->session->userdata(APP_NAME.'_logged_in')['permission'] != 1){
			$this->session->set_flashdata('error','You dont have permission for this.');
			redirect('/admin/store', 'refresh');
		}

		$this->adminInfo = $this->session->userdata(APP_NAME.'_logged_in');

		$this->load->model('Model_user');

    }

    public function index(){

		$meta['page_title'] = $data['page_title'] = 'User Management';

		$data['ajax_data_url'] = base_url('admin/user/ajaxList');

		$this->load->view('admin/common/header', $meta);

		$this->load->view('admin/user/list', $data);

		$this->load->view('admin/common/footer');

	}

	public function ajaxList(){        

        $start = $this->input->get('start');

        $no_of_rec = $this->input->get('length');

        $searchKeyword = $this->input->get('sSearch');

        $data['records'] = $this->Model_user->getListRecord($start,$no_of_rec,$this->input->get());

        $total_rec = $this->Model_user->countAllRecord($this->input->get());

        $data['iDisplayStart'] = $start;

		

		$r_data = $this->load->view('admin/user/ajax/list', $data, true);

        // dd($r_data);

        if($total_rec != '') {

            $t_data['a_data']['aaData'] = json_decode($r_data, true);

        } else {

            $t_data['a_data']['aaData'] = array();

        }

        $t_data['a_data']['sEcho'] = $this->input->get('sEcho');

        $t_data['a_data']['iTotalRecords'] = $total_rec;

        $t_data['a_data']['iTotalDisplayRecords'] = $total_rec;

        echo json_encode($t_data['a_data']);

    }

    public function create(){

		$meta['page_title'] = $data['page_title'] = 'Add User';

        

        $data['is_back'] = true;

		if($this->session->flashdata('validation')){

			$data['validation'] = $this->session->flashdata('validation');

		}

		$data['validation_url'] = base_url('admin/user/validateAdmin');

		

		$this->load->view('admin/common/header', $meta);

		$this->load->view('admin/user/form', $data);

		$this->load->view('admin/common/footer');

	}

	

	public function validateAdmin($isJson = true){

		$post = $this->input->post();

		

        $this->form_validation->set_rules('first_name', 'First Name', 'required');

		$this->form_validation->set_rules('last_name', 'Last Name', 'required');

		if($post['admin_id'] != ''){

			$this->form_validation->set_rules('email', 'email', 'required|edit_unique['.TBL_ADMIN.'.email.'.$post['admin_id'].'.admin_id]', [ 'is_unique' => 'This %s already exists.' ]);

		}else{

			$this->form_validation->set_rules('email', 'email', 'required|is_unique['.TBL_ADMIN.'.email]', [ 'is_unique' => 'This %s already exists.' ]);

		}

		

		$this->form_validation->set_rules('password', 'Password', 'required');

		$this->form_validation->set_rules('co_password', 'Confirm Password', 'required|matches[password]');

		$this->form_validation->set_rules('role', 'Role', 'required');

		$this->form_validation->set_rules('permission', 'Permission', 'required');

		$this->form_validation->set_rules('status', 'Status', 'required');

        if ($this->form_validation->run() == true){

            $result = array();

        }else{

			$result['errors'] = $this->form_validation->error_array();

		}

		if($isJson == true){

			echo json_encode($result);

			die;

		}else{

			return $result;

		}

	}

	public function save(){

		$post = $this->input->post();

		

		$validateRequest = $this->validateAdmin(false);

		if(count($validateRequest) > 0){

			$this->session->set_flashdata('validation', $validateRequest['errors']);

			$this->session->set_flashdata('error','Please check the form carefully for errors!.');

			redirect('admin/user/create','refresh');

		}else{

			if($post['admin_id'] != ''){

				$this->Model_user->update($post);

				$this->session->set_flashdata('success','User successfully Updated!.');

			}else{

				$this->Model_user->insert($post);

				$this->session->set_flashdata('success','User successfully created!.');

			}

			redirect('admin/user','refresh');

		}

	}

	public function searchUserByName(){

		$json = [];

        

        $search = !empty($this->input->get("q")) ? $this->input->get("q") : '';

        $getData = $this->Model_user->searchAdminByName($search);

		echo json_encode($getData);

		die;

	}

	public function edit($admin_id){

		$meta['page_title'] = $data['page_title'] = 'Update User';

        $data['is_back'] = true;

		$data['validation_url'] = base_url('admin/user/validateAdmin');

		if($this->session->flashdata('validation')){

			$data['validation'] = $this->session->flashdata('validation');

		}

		$loginUser = $this->session->userdata(APP_NAME.'_logged_in');

		$adminProfile = $this->Model_user->getAdminById($admin_id);

		$data['user'] = $adminProfile;

		$data['admin_id'] = $loginUser['admin_id'];

		$this->load->view('admin/common/header', $meta);

		$this->load->view('admin/user/form', $data);

		$this->load->view('admin/common/footer');

    }

    

    public function remove($admin_id){

        $this->Model_user->remove($admin_id);

        $this->session->set_flashdata('success','User successfully Removed!.');

        redirect('admin/user','refresh');

    }

}