<?php

defined('BASEPATH') OR exit('No direct script access allowed');
class States extends CI_Controller {
	function __construct(){
		parent::__construct();
		if(!$this->session->userdata(APP_NAME.'_logged_in'))
            redirect('/admin', 'refresh');

		$this->adminInfo = $this->session->userdata(APP_NAME.'_logged_in');
        $this->load->model('Model_states');
        $this->load->model('Model_setting', 'setting');
    }

    public function index(){
        $meta['page_title'] = $data['page_title'] = 'Search History';
        
        $categoryStats = $this->Model_states->getCategoryStats();
        $heatMapData = $this->Model_states->heatMapData();
        foreach($heatMapData as $mapData){
            $history[] = array( $mapData['latitude'], $mapData['longitude'], $mapData['count'] );
        }

        $data['heat_map'] = $history;
        // dd($data);
        $data['category_states'] = $categoryStats;

        $allSetting = $this->setting->getAllSetting();
		$map_center = json_decode($allSetting['map_center'], true);

		$data['default_lat'] = $map_center['lat'];
		$data['default_lng'] = $map_center['lng'];
		$data['default_zoom'] = $map_center['zoom'];
		$data['ajax_data_url'] = base_url('admin/states/ajaxList');
		$this->load->view('admin/common/header', $meta);
		$this->load->view('admin/states/list', $data);
		$this->load->view('admin/common/footer');
	}

	public function ajaxList(){        
        $start = $this->input->get('start');
        $no_of_rec = $this->input->get('length');
        $searchKeyword = $this->input->get('sSearch');
        $data['records'] = $this->Model_states->getListRecord($start,$no_of_rec,$this->input->get());
        $total_rec = $this->Model_states->countAllRecord($this->input->get());
        $data['iDisplayStart'] = $start;
        
		$r_data = $this->load->view('admin/states/ajax/list', $data, true);
        // dd($r_data);
        if($total_rec != '') {
            $t_data['a_data']['aaData'] = json_decode($r_data, true);
        } else {
            $t_data['a_data']['aaData'] = array();
        }
        $t_data['a_data']['sEcho'] = $this->input->get('sEcho');
        $t_data['a_data']['iTotalRecords'] = $total_rec;
        $t_data['a_data']['iTotalDisplayRecords'] = $total_rec;
        echo json_encode($t_data['a_data']);
    }
}