<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/cropper/2.3.4/cropper.min.css">
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/0.8.1/cropper.min.js"></script>
<style> img { max-width: 100%;  } .cropped { max-width: 125px; } </style>
<div class="content">

    <!-- Start Content-->
    <div class="container-fluid">
        
        <!-- start page title -->
            <?php $this->load->view('admin/common/breadcrumb', true); ?>
        <!-- end page title --> 
            
        <div class="row">
            <div class="col-lg-6 col-12">
                <!-- generalInfoForm -->
                <div class="card">
                    <h5 class="card-header"> Event Information</h5>
                    <div class="card-body">
                        <form role="form" id="generalInfoForm" action="<?php echo $save_generalInfo ?>" method="POST">
                            <input type="hidden" value="<?php echo isset($event['event_id']) ? $event['event_id'] : '' ?>" name="event_id" />
                            <div class="form-group">
                                <label for="user"><i class="fa fa-info-circle"></i> Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="name" id="name" placeholder="Event Name" value="<?php echo isset($event['name']) ? $event['name'] : '' ?>">
                                <small id="error_name" class="form-text form-error text-danger"><?php echo isset($validation['name']) ? $validation['name'] : '' ?></small>
                            </div>
                            <?php if($admin_permission == 1){ ?>
                                <div class="form-group">
                                    <label for="user_id"><i class="fa fa-user"></i> User <span class="text-danger">*</span></label>
                                    <select class="form-control" name="user_id" id="user_id">
                                        <option value="">--- Select User ---</option>
                                        <?php foreach($users as $user){ ?>
                                            <option value="<?php echo $user['admin_id'] ?>" <?php echo $event['user_id'] == $user['admin_id'] ? 'selected' : '' ?>><?php echo $user['name'] ?> (<?php echo $user['permission'] == '1' ? 'Super Admin' : 'Business User' ?>)</option>
                                        <?php } ?>
                                    </select>
                                    <small id="error_user_id" class="form-text form-error text-danger"><?php echo isset($validation['user_id']) ? $validation['user_id'] : '' ?></small>
                                </div>
                            <?php }else{ ?>
                                <input type="hidden"name="user_id" value="<?php echo isset($admin_id) ? $admin_id : '' ?>">
                            <?php } ?>
                            <div class="form-group row">
                                <div class="col-lg-6 col-12">
                                    <label for="email"><i class="fa fa-envelope"></i> Email <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="email" id="email" placeholder="example@example.com" value="<?php echo isset($event['email']) ? $event['email'] : '' ?>">
                                    <small id="error_email" class="form-text form-error text-danger"><?php echo isset($validation['email']) ? $validation['email'] : '' ?></small>
                                </div>
                                <div class="col-lg-6 col-12">
                                    <label for="website"><i class="fa fa-globe"></i> Website <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="website" id="website" placeholder="domain.com" value="<?php echo isset($event['website']) ? $event['website'] : '' ?>">
                                    <small id="error_website" class="form-text form-error text-danger"><?php echo isset($validation['website']) ? $validation['website'] : '' ?></small>
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-lg-6 col-12">
                                    <label for="phone"><i class="fa fa-phone-square"></i> Phone <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="phone" id="phone" placeholder="Phone No" value="<?php echo isset($event['phone']) ? $event['phone'] : '' ?>">
                                    <small id="error_phone" class="form-text form-error text-danger"><?php echo isset($validation['phone']) ? $validation['phone'] : '' ?></small>
                                </div>
                                <div class="col-lg-6 col-12">
                                    <label for="fax"><i class="fa fa-phone-square"></i> Fax</label>
                                    <input type="text" class="form-control" name="fax" id="fax" placeholder="Fax" value="<?php echo isset($event['fax']) ? $event['fax'] : '' ?>">
                                    <small id="error_fax" class="form-text form-error text-danger"><?php echo isset($validation['fax']) ? $validation['fax'] : '' ?></small>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="description">Description</label>
                                <textarea class="form-control" name="description" id="description" placeholder="Event Description" rows="5"><?php echo isset($event['description']) ? $event['description'] : '' ?></textarea>
                                <small id="error_description" class="form-text form-error text-danger"><?php echo isset($validation['description']) ? $validation['description'] : '' ?></small>
                            </div>
                            <div class="form-group">
                                <label for="status">Status</label>
                                <div class="custom-control custom-radio">
                                    <input type="radio" id="active" name="status" value="1" <?php echo isset($event['status']) && $event['status'] == 1 ? 'checked' : '' ?> class="custom-control-input">
                                    <label class="custom-control-label" for="active">Active</label>
                                </div>
                                <div class="custom-control custom-radio">
                                    <input type="radio" id="inactive" name="status" value="0" <?php echo isset($event['status']) && $event['status'] == 0 ? 'checked' : '' ?> class="custom-control-input">
                                    <label class="custom-control-label" for="inactive">Inactive</label>
                                </div>
                                <small id="error_status" class="form-text form-error text-danger"><?php echo isset($validation['status']) ? $validation['status'] : '' ?></small>
                            </div>
                            <div class="form-group text-right mb-0">
                                <button class="btn btn-primary waves-effect waves-light" type="submit" name="submit_"><i class="fa fa-save"></i> Save</button>
                            </div>
                        </form>
                    </div>
                </div>
				
				<!--locationForm -->
				 <div class="card">
                    <h5 class="card-header"> Location</h5>
                    <div class="card-body">
                        <form role="form" id="locationForm" action="<?php echo $save_location ?>" method="POST">
                            <input type="hidden" value="<?php echo isset($event['event_id']) ? $event['event_id'] : '' ?>" name="event_id" />
                            <div class="form-group">
                                <label for="address">Address <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="address" id="address" placeholder="Address" value="<?php echo isset($event['address']) ? $event['address'] : '' ?>">
                                <small id="error_address" class="form-text form-error text-danger"><?php echo isset($validation['address']) ? $validation['address'] : '' ?></small>
                            </div>
                            <div class="form-group row">								
								
								<div class="col-lg-6 col-12">
                                    <label for="country_id">Country <span class="text-danger">*</span></label>
									<select name="country_id" class="form-control" id="country_id">
										<option value="" selected disabled>--- Select ---</option>
										<?php foreach($countries as $country){ ?>
											<option value="<?= $country['id'] ?>" <?php if(isset($event['country_id']) && $event['country_id'] != 0){ echo $event['country_id'] == $country['id'] ? 'selected' : '';} else if($country['id'] == '231'){ echo 'selected';} ?>><?= $country['name'] ?></option>
										<?php } ?>
									</select>                                    
                                    <small id="error_country_id" class="form-text form-error text-danger"><?php echo isset($validation['country_id']) ? $validation['country_id'] : '' ?></small>
                                </div>                                
                                <div class="col-lg-6 col-12">
                                    <label for="state_id">State/Region <span class="text-danger">*</span></label>
                                    <select name="state_id" class="form-control" id="state_id">
										<option value="" selected disabled>--- Select ---</option>
										<?php foreach($states as $state){ ?>
											<option value="<?= $state['id'] ?>" <?php echo isset($event['state_id']) && $event['state_id'] == $state['id'] ? 'selected' : ''; ?> ><?= $state['name'] ?></option>
										<?php } ?>
									</select>
                                    <small id="error_state_id" class="form-text form-error text-danger"><?php echo isset($validation['state_id']) ? $validation['state_id'] : '' ?></small>
                                </div>
                            </div>
                            <div class="form-group row">
								<div class="col-lg-6 col-12">
                                    <label for="city">City/Province <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="city" id="city" placeholder="City/Province" value="<?php echo isset($event['city']) ? $event['city'] : '' ?>">
                                    <small id="error_city" class="form-text form-error text-danger"><?php echo isset($validation['city']) ? $validation['city'] : '' ?></small>
                                </div>
                                <div class="col-lg-6 col-12">
                                    <label for="postal_code">Postal Code <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="postal_code" id="postal_code" placeholder="Postal Code" value="<?php echo isset($event['postal_code']) ? $event['postal_code'] : '' ?>">
                                    <small id="error_postal_code" class="form-text form-error text-danger"><?php echo isset($validation['postal_code']) ? $validation['postal_code'] : '' ?></small>
                                </div>
                                
                            </div>
                            <div class="form-group row">
                                <div class="col-lg-6 col-12">
                                    <label for="latitude">Latitude</label>
                                    <input type="text" class="form-control" name="latitude" id="latitude" placeholder="Latitude" value="<?php echo isset($event['latitude']) ? $event['latitude'] : '' ?>">
                                    <small id="error_latitude" class="form-text form-error text-danger"><?php echo isset($validation['latitude']) ? $validation['latitude'] : '' ?></small>
                                </div>
                                <div class="col-lg-6 col-12">
                                    <label for="longitude">Longitude</label>
                                    <input type="text" class="form-control" name="longitude" id="longitude" placeholder="Longitude" value="<?php echo isset($event['longitude']) ? $event['longitude'] : '' ?>">
                                    <small id="error_longitude" class="form-text form-error text-danger"><?php echo isset($validation['longitude']) ? $validation['longitude'] : '' ?></small>
                                </div>
                                <small class="form-text col-12 text-right"><i class="fa fa-leaf mr-1"></i>Leave latitude/longitude values blank to fetch (geocode) on submit.</small>
                            </div>
                            <div class="form-group text-right mb-0">
                                <button class="btn btn-primary waves-effect waves-light" type="submit"><i class="fa fa-save"></i> Save</button>
                            </div>
                        </form>
                    </div>
                </div>              
                
            </div><!-- end col -->
            
            <div class="col-lg-6 col-12">			
				<!-- eventdateForm -->
                <div class="card">
                    <h5 class="card-header"> Date & Time</h5>
                    <div class="card-body">
                        <form role="form" id="eventdateForm" action="<?php echo $save_event_time ?>" method="POST">
								<div class="form-group row">
                                <label class="col-sm-2 col-form-label">Time Zone</label>
                                <div class="col-sm-10">
									<select name="event_timezone" class="form-control">
										<option value="" selected disabled>--- Select ---</option>
										<?php foreach($timezones as $timezone){ ?>
											<option value="<?= $timezone['name'] ?>" <?php if(isset($event['event_timezone']) && $event['event_timezone'] != ''){ echo $event['event_timezone'] == $timezone['name'] ? 'selected' : '';} ?>><?= $timezone['name'] ?></option>
										<?php } ?>
									</select>
									<small id="error_event_timezone" class="form-text form-error text-danger"><?php echo isset($validation['event_timezone']) ? $validation['event_timezone'] : '' ?></small>
                                </div>
                            </div>
							
							<div class="form-group row mt-2">
								<div class="col-sm-12">	
										<div class="form-check-inline">
										  <label class="form-check-label">
											<input type="radio" class="form-check-input event_time_option" name="event_time_option" value="daily" <?php echo isset($event['event_time_option']) && trim($event['event_time_option']) == "daily" ? 'checked' : '';?> >Daily
										  </label>
										</div>
										<div class="form-check-inline">
										  <label class="form-check-label">
											<input type="radio" class="form-check-input event_time_option" name="event_time_option" value="weekly" <?php echo isset($event['event_time_option']) && trim($event['event_time_option']) == "weekly" ? 'checked' : '';?> >Weekly
										  </label>
										</div>
										<div class="form-check-inline disabled">
										  <label class="form-check-label">
											<input type="radio" class="form-check-input event_time_option" name="event_time_option" value="monthly" <?php echo isset($event['event_time_option']) && trim($event['event_time_option']) == "monthly" ? 'checked' : '';?> >Monthly
										  </label>
										</div>
										<div class="form-check-inline disabled">
										  <label class="form-check-label">
											<input type="radio" class="form-check-input event_time_option" name="event_time_option" value="selected_date" <?php echo isset($event['event_time_option']) && $event['event_time_option']=='selected_date' ? 'checked' : '';?> >Selected date
										  </label>
										</div>	
										<small id="error_event_time_option" class="form-text form-error text-danger"><?php echo isset($validation['event_time_option']) ? $validation['event_time_option'] : '' ?></small>
								</div>
                               
							</div>
							
							
								<div class="table-responsive">
									<table class="table table-striped table-bordered mb-0">
										<tbody class="more_product">
										
												<?php if(empty($event['event_timing'])) { ?>
																<tr class="event_timing">
																	<td>			
																		<div class="input-group">	
																			<input type="text" class="form-control datepicker" name="event_date[]" placeholder="Event start date" autocomplete="off" value="" data-provide="datepicker" data-date-autoclose="true" >
																			<small id="error_event_date" class="form-text form-error text-danger"><?php echo isset($validation['event_date']) ? $validation['event_date'] : '' ?></small>																	
																		</div>
																	</td>
																	<td>
																		<div class="form-group mb-0">
																			<div class="input-group">
																				<input type="text" name="start_time[]" class="form-control clockpicker" timeinputtype="from" timeinputposition="0" value="" placeholder="HH:MM"  data-placement="top" data-align="top" data-autoclose="true">
																				<div class="input-group-append">
																					<span class="input-group-text">To</span>
																				</div>
																				<input type="text" name="end_time[]" class="form-control clockpicker" timeinputtype="to" timeinputposition="0" value="" placeholder="HH:MM"  data-placement="top" data-align="top" data-autoclose="true">
																			</div>
																		</div>
																	</td>
																	<td class="add_more_button" style="display:none">
																		<div class="form-group">
																			<button type="button" class="add_event_time btn btn-success waves-effect waves-light" title="Add more event"><i class="mdi mdi-plus-circle"></i></button>
																		</div>
																	</td>
																</tr>
												<?php } else { $i=0; foreach($event['event_timing'] as $event_time){ ?>
																<tr class="<?= $i==0 ? 'event_timing' : 'event_timing_new'; ?>" >
																	<td>			
																		<div class="input-group">	
																			<input type="text" class="form-control datepicker" name="event_date[]" placeholder="Event start date" autocomplete="off" value="<?php echo isset($event_time['event_date']) ? date('m/d/Y',strtotime($event_time['event_date'])) : '' ?>" data-provide="datepicker" data-date-autoclose="true" >
																			<small id="error_event_date" class="form-text form-error text-danger"><?php echo isset($validation['event_date']) ? $validation['event_date'] : '' ?></small>																	
																		</div>
																	</td>
																	<td>
																		<div class="form-group mb-0">
																			<div class="input-group">
																				<input type="text" name="start_time[]" class="form-control clockpicker" timeinputtype="from" timeinputposition="0" value="<?php echo isset($event_time['start_time']) ? $event_time['start_time'] : '' ?>" placeholder="HH:MM"  data-placement="top" data-align="top" data-autoclose="true">
																				<div class="input-group-append">
																					<span class="input-group-text">To</span>
																				</div>
																				<input type="text" name="end_time[]" class="form-control clockpicker" timeinputtype="to" timeinputposition="0" value="<?php echo isset($event_time['end_time']) ? $event_time['end_time'] : '' ?>" placeholder="HH:MM"  data-placement="top" data-align="top" data-autoclose="true">
																			</div>
																		</div>
																	</td>
																	<?php if($i==0){ ?>
																		<td class="add_more_button" <?php if($event['event_time_option']!= 'selected_date'){ ?> style="display:none" <?php } ?>>
																			<div class="form-group">
																				<button type="button" class="add_event_time btn btn-success waves-effect waves-light" title="Add more event"><i class="mdi mdi-plus-circle"></i></button>
																			</div>
																		</td>
																	<?php } else { ?>
																		 <td>
																			<div class="form-group">
																				<a href="<?= base_url('admin/event/removeEventTime/'.$event_time['event_id'].'/'.$event_time['id']); ?>" onclick="return confirm('Are you sure, you want to delete?')" class="btn btn-danger waves-effect waves-light" title="Remove event time"><i class="mdi mdi-minus-circle"></i></a>
																			</div>
																		</td>
																	<?php } ?>
																</tr>
													<?php  $i++; }} ?>
												</div>											
										</tbody>
									</table>
								</div>
							
								
															
                            <input type="hidden" value="<?php echo isset($event['event_id']) ? $event['event_id'] : '' ?>" name="event_id" />
                           
						    <div class="form-group text-right mb-0 mt-2">
                                <button class="btn btn-primary waves-effect waves-light" type="submit" name="submit_"><i class="fa fa-save"></i> Save</button>
                            </div>
                        </form>
                    </div>
                </div>
				
				<!-- socialForm -->
                <div class="card">
                    <h5 class="card-header"> Social</h5>
                    <div class="card-body">
                        <form role="form" id="socialForm" action="<?php echo $save_social ?>" method="POST">
                            <input type="hidden" value="<?php echo isset($event['event_id']) ? $event['event_id'] : '' ?>" name="event_id" />
                            <div class="form-group row">
                                <div class="col-lg-6 col-12">
                                    <label for="twitter"><i class="fab fa-twitter-square"></i> Twitter</label>
                                    <input type="text" class="form-control" name="twitter" id="twitter" placeholder="http://twitter.com/example" value="<?php echo isset($event['twitter']) ? $event['twitter'] : '' ?>">
                                    <small id="error_twitter" class="form-text form-error text-danger"><?php echo isset($validation['twitter']) ? $validation['twitter'] : '' ?></small>
                                </div>
                                <div class="col-lg-6 col-12">
                                    <label for="youtube"><i class="fab fa-youtube-square"></i> Youtube</label>
                                    <input type="text" class="form-control" name="youtube" id="youtube" placeholder="http://youtube.com/example" value="<?php echo isset($event['youtube']) ? $event['youtube'] : '' ?>">
                                    <small id="error_youtube" class="form-text form-error text-danger"><?php echo isset($validation['youtube']) ? $validation['youtube'] : '' ?></small>
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-lg-6 col-12">
                                    <label for="linkedin"><i class="fab fa-linkedin"></i> LinkedIn</label>
                                    <input type="text" class="form-control" name="linkedin" id="linkedin" placeholder="http://linkedin.com/example" value="<?php echo isset($event['linkedin']) ? $event['linkedin'] : '' ?>">
                                    <small id="error_linkedin" class="form-text form-error text-danger"><?php echo isset($validation['linkedin']) ? $validation['linkedin'] : '' ?></small>
                                </div>
                                <div class="col-lg-6 col-12">
                                    <label for="pinterest"><i class="fab fa-pinterest-square"></i> Pinterest</label>
                                    <input type="text" class="form-control" name="pinterest" id="pinterest" placeholder="http://pinterest.com/example" value="<?php echo isset($event['pinterest']) ? $event['pinterest'] : '' ?>">
                                    <small id="error_pinterest" class="form-text form-error text-danger"><?php echo isset($validation['pinterest']) ? $validation['pinterest'] : '' ?></small>
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-lg-6 col-12">
                                    <label for="facebook"><i class="fab fa-facebook-square"></i> Facebook</label>
                                    <input type="text" class="form-control" name="facebook" id="facebook" placeholder="http://facebook.com/example" value="<?php echo isset($event['facebook']) ? $event['facebook'] : '' ?>">
                                    <small id="error_facebook" class="form-text form-error text-danger"><?php echo isset($validation['facebook']) ? $validation['facebook'] : '' ?></small>
                                </div>
                                <div class="col-lg-6 col-12">
                                    <label for="instagram"><i class="fab fa-instagram"></i> Instagram</label>
                                    <input type="text" class="form-control" name="instagram" id="instagram" placeholder="http://instagram.com/example" value="<?php echo isset($event['instagram']) ? $event['instagram'] : '' ?>">
                                    <small id="error_instagram" class="form-text form-error text-danger"><?php echo isset($validation['instagram']) ? $validation['instagram'] : '' ?></small>
                                </div>
                            </div>
                            <div class="form-group text-right mb-0">
                                <button class="btn btn-primary waves-effect waves-light" type="submit"><i class="fa fa-save"></i> Save</button>
                            </div>
                        </form>
                    </div>
                </div>
				

                <!-- additionalInfoForm -->
                <div class="card">
                    <h5 class="card-header"> Vimeo Code or Additional Info</h5>
                    <div class="card-body">
                        <form role="form" id="additionalInfoForm" action="<?php echo $save_additional ?>" method="POST">
                            <input type="hidden" value="<?php echo isset($event['event_id']) ? $event['event_id'] : '' ?>" name="event_id" />
                            <div class="form-group">
                                <label for="additional_info">Code/Info</label>
                                <textarea class="form-control" rows="3" name="additional_info" id="additional_info"><?php echo isset($event['additional_info']) ? $event['additional_info'] : '' ?></textarea>
                                <small id="error_additional_info" class="form-text form-error text-danger"><?php echo isset($validation['additional_info']) ? $validation['additional_info'] : '' ?></small>
                            </div>
                            <div class="form-group">
                                <label for="image"><i class="fa fa-picture-o"></i> Upload Event Image</label>
                                <!-- <input type="file" class="form-control" id="image" name="image"> -->
                                <input type="file" class="form-control" id="image_" require>
                                <div class="img_crop mt-2">
                                    <div class="row">
                                        <!-- leftbox -->
                                        <div class="box-2 col-6">
                                            <div class="result"></div>
                                            <div class="img-result <?php echo (isset($event['image']) && $event['image'] != '') ? '' : 'd-none' ?>">
                                                <!-- result of crop -->
                                                <img class="cropped img-fluid" src="<?php echo (isset($event['image']) && $event['image'] != '') ? $event['image'] : '';  ?>" alt="Croped image">
                                                <input type="hidden" name="image" value="" class="hidden_image">
                                            </div>
                                        </div>
                                    </div>
                                    <!-- save btn -->
                                    <div class="box mt-1 clearfix">
                                        <!-- save btn -->
                                        <button class="btn btn-info waves-effect waves-light save d-none float-left">Crop Image</button>
                                    </div>
                                </div>
                                <small id="error_hours" class="form-text form-error text-danger"><?php echo isset($validation['hours']) ? $validation['hours'] : '' ?></small>
                            </div>
                            <div class="form-group text-right mb-0">
                                <button class="btn btn-primary waves-effect waves-light" type="submit"><i class="fa fa-save"></i> Save</button>
                            </div>
                        </form>
                    </div>
                </div>
				               
            </div><!-- end col -->
        </div>
        <!-- end row -->
    </div> <!-- container -->

</div> <!-- content -->
<script type="text/javascript">	

    $(document).ready(function () {
		
		/*$('.datepicker').datepicker({
			format: 'mm/dd/yyyy'
		});*/

        ajaxValidation('#generalInfoForm', "<?php echo $validateGeneralInfo ?>");
        ajaxValidation('#locationForm', "<?php echo $validateLocation ?>", true);
		ajaxValidation('#eventdateForm', "<?php echo $validateEventDateInfo ?>");
        
        $('.toggle_help').click(function(){
            if($('.icons-list-demo').hasClass('d-none')){
                $('.icons-list-demo').removeClass('d-none').slideDown('slow');
            }else{
                $('.icons-list-demo').addClass('d-none').slideUp('slow');
            }
        });
		
		$('.event_time_option').change(function(){ 
			var event_time_option = $(this).val();
			$('.add_more_button').hide();
			if(event_time_option == 'selected_date'){
				$('.add_more_button').show();
			}
			else
			{
				$('.event_timing_new').remove();
			}
		});		
		
		$('.add_event_time').click(function(){ 		
			var tr = '<tr class="event_timing_new">'+
						'<td>'+	
							'<div class="input-group">'+
								'<input type="text" class="form-control"  name="event_date[]" placeholder="Event start date" autocomplete="off" data-provide="datepicker" data-date-autoclose="true" >'+								
							'</div>'+
						'</td>'+
						'<td>'+
							'<div class="form-group mb-0">'+
								'<div class="input-group">'+
									'<input type="text" name="start_time[]" class="form-control clockpicker" timeinputtype="from" timeinputposition="0" placeholder="HH:MM"  data-placement="top" data-align="top" data-autoclose="true">'+
									'<div class="input-group-append">'+
										'<span class="input-group-text">To</span>'+
									'</div>'+
									'<input type="text" name="end_time[]" class="form-control clockpicker" timeinputtype="to" timeinputposition="0" placeholder="HH:MM"  data-placement="top" data-align="top" data-autoclose="true">'+
								'</div>'+
							'</div>'+
						'</td>'+
						'<td>'+
							'<div class="form-group">'+
								'<button type="button" class="remove_event_time btn btn-danger waves-effect waves-light" title="Remove event time"><i class="mdi mdi-minus-circle"></i></button>'+
							'</div>'+
						'</td>'+
					'</tr>';		                               
									
			$('.more_product').append(tr);   
		}); 
		
		$('.more_product').delegate('.remove_event_time','click',function()  
		{  
			$(this).closest("tr").remove();
		});

		
		$('select[name=\'country_id\']').on('change', function() {				
			
            $.ajax({
                url: "<?= base_url('admin/event/getState') ?>",
                type: "POST",
                data: { country_id: this.value },
                dataType: 'json',
                beforeSend: function() {
                    $('select[name=\'country_id\']').prop('disabled', true);
                },
                complete: function() {
                    $('select[name=\'country_id\']').prop('disabled', false);
                },
                success: function(json) {
                    //console.log(json);
                    html = '<option value=""> --- Select --- </option>';
                    
                    if (json && json != '') {
                        for (i = 0; i < json.length; i++) {
                            html += '<option value="' + json[i]['id'] + '"';
                            
                            if (json[i]['id'] == '') {
                                html += ' selected="selected"';
                            }
                            
                            html += '>' + json[i]['name'] + '</option>';
                        }
                    } else {
                        html += '<option value="0" selected="selected"> --- None --- </option>';
                    }
                    
                    $('select[name=\'state_id\']').html(html);
                },
                error: function(xhr, ajaxOptions, thrownError) {
                    alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
                }
            });
        });
    });
</script>

<!-- Crop Images -->
<script type="text/javascript">
    // vars
    let result = document.querySelector('.result'),
    img_result = document.querySelector('.img-result'),
    img_w = 200,//document.querySelector('.img-w'),
    img_h = 200, //document.querySelector('.img-h'),
    save = document.querySelector('.save'),
    cropped = document.querySelector('.cropped'),
    hidden_image = document.querySelector('.hidden_image'),
    upload = document.querySelector('#image_'),
    cropper = '';

    // on change show image with crop options
    upload.addEventListener('change', (e) => {
        if (e.target.files.length) {
                // start file reader
            const reader = new FileReader();
            reader.onload = (e)=> {
                if(e.target.result){
                    // create new image
                    let img = document.createElement('img');
                    img.id = 'image';
                    img.src = e.target.result;
                    // clean result before
                    result.innerHTML = '';
                    // append new image
                    result.appendChild(img);
                    // show save btn and options
                    
                    save.classList.remove('d-none');
                    result.classList.remove('d-none');

                    cropped.classList.add('d-none');
                    img_result.classList.add('d-none');

                    // Remove image cropped
                    cropped.src = '';   
                    hidden_image.value = '';

                    
                    // Cropper.setDefaults(aspectRatio : 1/1);
                    // init cropper
                    cropper = new Cropper(img, {
                        aspectRatio: 1/1,
                    });
                }
            };
            reader.readAsDataURL(e.target.files[0]);
        }
    });

    // save on click
    save.addEventListener('click',(e)=>{
        e.preventDefault();
        // get result to data uri
        let imgSrc = cropper.getCroppedCanvas({
            width: img_w.value // input value
        }).toDataURL();
        // remove hide class of img
        cropped.classList.remove('d-none');
        img_result.classList.remove('d-none');

        result.classList.add('d-none');
        save.classList.add('d-none');
        // uploadImg.classList.remove('d-none');
        // show image cropped
        cropped.src = imgSrc;   
        hidden_image.value = imgSrc;           
    });
</script>