<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Settings extends CI_Controller {

	function __construct(){

		parent::__construct();

		$this->load->model('Model_setting');

		// $this->load->model('Model_currency');

		if(!$this->session->userdata(APP_NAME.'_logged_in'))

			redirect('/admin/', 'refresh');

		
		if($this->session->userdata(APP_NAME.'_logged_in')['permission'] != 1){
			$this->session->set_flashdata('error','You dont have permission for this.');
			redirect('/admin/store', 'refresh');
		}
	}

	/**

	 * Index Page for this controller.

	 *

	 * Maps to the following URL

	 * 		http://example.com/index.php/Admin

	 *	- or -

	 * 		http://example.com/index.php/Admin/index

	 *	- or -

	 * Since this controller is set as the default controller in

	 * config/routes.php, it's displayed at http://example.com/

	 *

	 * So any other public methods not prefixed with an underscore will

	 * map to /index.php/Admin/<method_name>

	 * @see https://codeigniter.com/user_guide/general/urls.html

	 */

	public function index(){

		$getAllSetting = $this->Model_setting->getAllSetting();

		$data = $getAllSetting;

		$meta['page_title'] = "Settings";

		$data['page_title'] = "Settings";

				

		$this->load->view('admin/common/header', $meta);

		$this->load->view('admin/settings', $data);

		$this->load->view('admin/common/footer');

	}

  	public function save(){

		$post = $this->input->post();

		// dd()

		$updateSetting = $this->Model_setting->saveSetting($post);

		if($updateSetting){

			$this->session->set_flashdata('success', 'Setting Saved successfully.');

		}else{

			$this->session->set_flashdata('error','Setting Not Saved.');

		}

		redirect('admin/settings','refresh');

	}

}