<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/cropper/2.3.4/cropper.min.css">
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/0.8.1/cropper.min.js"></script>
<style> img { max-width: 100%;  } .cropped { max-width: 125px; } </style>
<div class="content">

    <!-- Start Content-->
    <div class="container-fluid">
        
        <!-- start page title -->
            <?php $this->load->view('admin/common/breadcrumb', true); ?>
        <!-- end page title --> 
            
        <div class="row">
            <div class="col-lg-6 col-12">
                <!-- generalInfoForm -->
                <div class="card">
                    <h5 class="card-header"> Location Information</h5>
                    <div class="card-body">
                        <form role="form" id="generalInfoForm" action="<?php echo $save_generalInfo ?>" method="POST">
                            <input type="hidden" value="<?php echo isset($store['store_id']) ? $store['store_id'] : '' ?>" name="store_id" />
                            <div class="form-group">
                                <label for="user"><i class="fa fa-info-circle"></i> Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="name" id="name" placeholder="Store Name" value="<?php echo isset($store['name']) ? $store['name'] : '' ?>">
                                <small id="error_name" class="form-text form-error text-danger"><?php echo isset($validation['name']) ? $validation['name'] : '' ?></small>
                            </div>
                            <?php if($admin_permission == 1){ ?>
                                <div class="form-group">
                                    <label for="user_id"><i class="fa fa-user"></i> User <span class="text-danger">*</span></label>
                                    <select class="form-control" name="user_id" id="user_id">
                                        <option value="">--- Select User ---</option>
                                        <?php foreach($users as $user){ ?>
                                            <option value="<?php echo $user['admin_id'] ?>" <?php echo $store['user_id'] == $user['admin_id'] ? 'selected' : '' ?>><?php echo $user['name'] ?> (<?php echo $user['permission'] == '1' ? 'Super Admin' : 'Business User' ?>)</option>
                                        <?php } ?>
                                    </select>
                                    <small id="error_user_id" class="form-text form-error text-danger"><?php echo isset($validation['user_id']) ? $validation['user_id'] : '' ?></small>
                                </div>
                            <?php }else{ ?>
                                <input type="hidden"name="user_id" value="<?php echo isset($admin_id) ? $admin_id : '' ?>">
                            <?php } ?>
                            <div class="form-group row">
                                <div class="col-lg-6 col-12">
                                    <label for="email"><i class="fa fa-envelope"></i> Email <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="email" id="email" placeholder="example@example.com" value="<?php echo isset($store['email']) ? $store['email'] : '' ?>">
                                    <small id="error_email" class="form-text form-error text-danger"><?php echo isset($validation['email']) ? $validation['email'] : '' ?></small>
                                </div>
                                <div class="col-lg-6 col-12">
                                    <label for="website"><i class="fa fa-globe"></i> Website <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="website" id="website" placeholder="domain.com" value="<?php echo isset($store['website']) ? $store['website'] : '' ?>">
                                    <small id="error_website" class="form-text form-error text-danger"><?php echo isset($validation['website']) ? $validation['website'] : '' ?></small>
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-lg-6 col-12">
                                    <label for="phone"><i class="fa fa-phone-square"></i> Phone <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="phone" id="phone" placeholder="Phone No" value="<?php echo isset($store['phone']) ? $store['phone'] : '' ?>">
                                    <small id="error_phone" class="form-text form-error text-danger"><?php echo isset($validation['phone']) ? $validation['phone'] : '' ?></small>
                                </div>
                                <div class="col-lg-6 col-12">
                                    <label for="fax"><i class="fa fa-phone-square"></i> Fax</label>
                                    <input type="text" class="form-control" name="fax" id="fax" placeholder="Fax" value="<?php echo isset($store['fax']) ? $store['fax'] : '' ?>">
                                    <small id="error_fax" class="form-text form-error text-danger"><?php echo isset($validation['fax']) ? $validation['fax'] : '' ?></small>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="description">Description</label>
                                <textarea class="form-control" name="description" id="description" placeholder="Store Description" rows="5"><?php echo isset($store['description']) ? $store['description'] : '' ?></textarea>
                                <small id="error_description" class="form-text form-error text-danger"><?php echo isset($validation['description']) ? $validation['description'] : '' ?></small>
                            </div>
                            <div class="form-group">
                                <label for="status">Status</label>
                                <div class="custom-control custom-radio">
                                    <input type="radio" id="active" name="status" value="1" <?php echo isset($store['status']) && $store['status'] == 1 ? 'checked' : '' ?> class="custom-control-input">
                                    <label class="custom-control-label" for="active">Active</label>
                                </div>
                                <div class="custom-control custom-radio">
                                    <input type="radio" id="inactive" name="status" value="0" <?php echo isset($store['status']) && $store['status'] == 0 ? 'checked' : '' ?> class="custom-control-input">
                                    <label class="custom-control-label" for="inactive">Inactive</label>
                                </div>
                                <small id="error_status" class="form-text form-error text-danger"><?php echo isset($validation['status']) ? $validation['status'] : '' ?></small>
                            </div>
                            <div class="form-group text-right mb-0">
                                <button class="btn btn-primary waves-effect waves-light" type="submit" name="submit_"><i class="fa fa-save"></i> Save</button>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- categoryForm -->
                <div class="card">
                    <h5 class="card-header"> Categories & Services</h5>
                    <div class="card-body">
                        <form role="form" id="categoryForm" action="<?php echo $save_categories ?>" method="POST">
                            <label><i class="fa fa-tags"></i> Categories</label>
                            <input type="hidden" value="<?php echo isset($store['store_id']) ? $store['store_id'] : '' ?>" name="store_id" />
                            <div class="form-group row">
                                <?php foreach($categories as $category){ ?>
                                    <div class="col-4">
                                        <div class="checkbox checkbox-primary mb-1">
                                            <input id="category_<?php echo $category['category_id'] ?>" value="<?php echo $category['category_id'] ?>" name="categories[]" type="checkbox" <?php echo isset($store['cats']) && is_array($store['cats']) ? in_array($category['category_id'], $store['cats']) ? 'checked' :  '' : ''?>>

                                            <label for="category_<?php echo $category['category_id'] ?>"> <i class="<?php echo $category['icon'] ?>"></i> <?php echo $category['title'] ?></label>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                            <div class="form-group text-right mb-0">
                                <button class="btn btn-primary waves-effect waves-light" type="submit"><i class="fa fa-save"></i> Save</button>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- socialForm -->
                <div class="card">
                    <h5 class="card-header"> Social</h5>
                    <div class="card-body">
                        <form role="form" id="socialForm" action="<?php echo $save_social ?>" method="POST">
                            <input type="hidden" value="<?php echo isset($store['store_id']) ? $store['store_id'] : '' ?>" name="store_id" />
                            <div class="form-group row">
                                <div class="col-lg-6 col-12">
                                    <label for="twitter"><i class="fab fa-twitter-square"></i> Twitter</label>
                                    <input type="text" class="form-control" name="twitter" id="twitter" placeholder="http://twitter.com/example" value="<?php echo isset($store['twitter']) ? $store['twitter'] : '' ?>">
                                    <small id="error_twitter" class="form-text form-error text-danger"><?php echo isset($validation['twitter']) ? $validation['twitter'] : '' ?></small>
                                </div>
                                <div class="col-lg-6 col-12">
                                    <label for="youtube"><i class="fab fa-youtube-square"></i> Youtube</label>
                                    <input type="text" class="form-control" name="youtube" id="youtube" placeholder="http://youtube.com/example" value="<?php echo isset($store['youtube']) ? $store['youtube'] : '' ?>">
                                    <small id="error_youtube" class="form-text form-error text-danger"><?php echo isset($validation['youtube']) ? $validation['youtube'] : '' ?></small>
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-lg-6 col-12">
                                    <label for="linkedin"><i class="fab fa-linkedin"></i> LinkedIn</label>
                                    <input type="text" class="form-control" name="linkedin" id="linkedin" placeholder="http://linkedin.com/example" value="<?php echo isset($store['linkedin']) ? $store['linkedin'] : '' ?>">
                                    <small id="error_linkedin" class="form-text form-error text-danger"><?php echo isset($validation['linkedin']) ? $validation['linkedin'] : '' ?></small>
                                </div>
                                <div class="col-lg-6 col-12">
                                    <label for="pinterest"><i class="fab fa-pinterest-square"></i> Pinterest</label>
                                    <input type="text" class="form-control" name="pinterest" id="pinterest" placeholder="http://pinterest.com/example" value="<?php echo isset($store['pinterest']) ? $store['pinterest'] : '' ?>">
                                    <small id="error_pinterest" class="form-text form-error text-danger"><?php echo isset($validation['pinterest']) ? $validation['pinterest'] : '' ?></small>
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-lg-6 col-12">
                                    <label for="facebook"><i class="fab fa-facebook-square"></i> Facebook</label>
                                    <input type="text" class="form-control" name="facebook" id="facebook" placeholder="http://facebook.com/example" value="<?php echo isset($store['facebook']) ? $store['facebook'] : '' ?>">
                                    <small id="error_facebook" class="form-text form-error text-danger"><?php echo isset($validation['facebook']) ? $validation['facebook'] : '' ?></small>
                                </div>
                                <div class="col-lg-6 col-12">
                                    <label for="instagram"><i class="fab fa-instagram"></i> Instagram</label>
                                    <input type="text" class="form-control" name="instagram" id="instagram" placeholder="http://instagram.com/example" value="<?php echo isset($store['instagram']) ? $store['instagram'] : '' ?>">
                                    <small id="error_instagram" class="form-text form-error text-danger"><?php echo isset($validation['instagram']) ? $validation['instagram'] : '' ?></small>
                                </div>
                            </div>
                            <div class="form-group text-right mb-0">
                                <button class="btn btn-primary waves-effect waves-light" type="submit"><i class="fa fa-save"></i> Save</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div><!-- end col -->
            
            <!-- locationForm -->
            <div class="col-lg-6 col-12">
                <div class="card">
                    <h5 class="card-header"> Location</h5>
                    <div class="card-body">
                        <form role="form" id="locationForm" action="<?php echo $save_location ?>" method="POST">
                            <input type="hidden" value="<?php echo isset($store['store_id']) ? $store['store_id'] : '' ?>" name="store_id" />
                            <div class="form-group">
                                <label for="address">Address <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="address" id="address" placeholder="Address" value="<?php echo isset($store['address']) ? $store['address'] : '' ?>">
                                <small id="error_address" class="form-text form-error text-danger"><?php echo isset($validation['address']) ? $validation['address'] : '' ?></small>
                            </div>
                            <div class="form-group row">
                                <div class="col-lg-6 col-12">
                                    <label for="city">City/Province (Admin Area Level 2) <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="city" id="city" placeholder="City/Province (Admin Area Level 2)" value="<?php echo isset($store['city']) ? $store['city'] : '' ?>">
                                    <small id="error_city" class="form-text form-error text-danger"><?php echo isset($validation['city']) ? $validation['city'] : '' ?></small>
                                </div>
                                <div class="col-lg-6 col-12">
                                    <label for="state">State/Region (Admin Area Level 1) <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="state" id="state" placeholder="State/Region (Admin Area Level 1)" value="<?php echo isset($store['state']) ? $store['state'] : '' ?>">
                                    <small id="error_state" class="form-text form-error text-danger"><?php echo isset($validation['state']) ? $validation['state'] : '' ?></small>
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-lg-6 col-12">
                                    <label for="postal_code">Postal Code <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="postal_code" id="postal_code" placeholder="Postal Code" value="<?php echo isset($store['postal_code']) ? $store['postal_code'] : '' ?>">
                                    <small id="error_postal_code" class="form-text form-error text-danger"><?php echo isset($validation['postal_code']) ? $validation['postal_code'] : '' ?></small>
                                </div>
                                <div class="col-lg-6 col-12">
                                    <label for="country">Country <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="country" id="country" placeholder="Country" value="<?php echo isset($store['country']) ? $store['country'] : '' ?>">
                                    <small id="error_country" class="form-text form-error text-danger"><?php echo isset($validation['country']) ? $validation['country'] : '' ?></small>
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-lg-6 col-12">
                                    <label for="latitude">Latitude</label>
                                    <input type="text" class="form-control" name="latitude" id="latitude" placeholder="Latitude" value="<?php echo isset($store['latitude']) ? $store['latitude'] : '' ?>">
                                    <small id="error_latitude" class="form-text form-error text-danger"><?php echo isset($validation['latitude']) ? $validation['latitude'] : '' ?></small>
                                </div>
                                <div class="col-lg-6 col-12">
                                    <label for="longitude">Longitude</label>
                                    <input type="text" class="form-control" name="longitude" id="longitude" placeholder="Longitude" value="<?php echo isset($store['longitude']) ? $store['longitude'] : '' ?>">
                                    <small id="error_longitude" class="form-text form-error text-danger"><?php echo isset($validation['longitude']) ? $validation['longitude'] : '' ?></small>
                                </div>
                                <small class="form-text col-12 text-right"><i class="fa fa-leaf mr-1"></i>Leave latitude/longitude values blank to fetch (geocode) on submit.</small>
                            </div>
                            <div class="form-group text-right mb-0">
                                <button class="btn btn-primary waves-effect waves-light" type="submit"><i class="fa fa-save"></i> Save</button>
                            </div>
                        </form>
                    </div>
                </div>
                
                <!-- additionalInfoForm -->
                <div class="card">
                    <h5 class="card-header"> Vimeo Code or Additional Info</h5>
                    <div class="card-body">
                        <form role="form" id="additionalInfoForm" action="<?php echo $save_additional ?>" method="POST">
                            <input type="hidden" value="<?php echo isset($store['store_id']) ? $store['store_id'] : '' ?>" name="store_id" />
                            <div class="form-group">
                                <label for="additional_info">Code/Info</label>
                                <textarea class="form-control" rows="3" name="additional_info" id="additional_info"><?php echo isset($store['additional_info']) ? $store['additional_info'] : '' ?></textarea>
                                <small id="error_additional_info" class="form-text form-error text-danger"><?php echo isset($validation['additional_info']) ? $validation['additional_info'] : '' ?></small>
                            </div>
                            <div class="form-group">
                                <label for="image"><i class="fa fa-picture-o"></i> Upload Store Image</label>
                                <!-- <input type="file" class="form-control" id="image" name="image"> -->
                                <input type="file" class="form-control" id="image_" require>
                                <div class="img_crop mt-2">
                                    <div class="row">
                                        <!-- leftbox -->
                                        <div class="box-2 col-6">
                                            <div class="result"></div>
                                            <div class="img-result <?php echo (isset($store['image']) && $store['image'] != '') ? '' : 'd-none' ?>">
                                                <!-- result of crop -->
                                                <img class="cropped img-fluid" src="<?php echo (isset($store['image']) && $store['image'] != '') ? $store['image'] : '';  ?>" alt="Croped image">
                                                <input type="hidden" name="image" value="" class="hidden_image">
                                            </div>
                                        </div>
                                    </div>
                                    <!-- save btn -->
                                    <div class="box mt-1 clearfix">
                                        <!-- save btn -->
                                        <button class="btn btn-info waves-effect waves-light save d-none float-left">Crop Image</button>
                                    </div>
                                </div>
                                <small id="error_hours" class="form-text form-error text-danger"><?php echo isset($validation['hours']) ? $validation['hours'] : '' ?></small>
                            </div>
                            <div class="form-group text-right mb-0">
                                <button class="btn btn-primary waves-effect waves-light" type="submit"><i class="fa fa-save"></i> Save</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div><!-- end col -->
        </div>
        <!-- end row -->
    </div> <!-- container -->

</div> <!-- content -->
<script type="text/javascript">
    $(document).ready(function () {

        ajaxValidation('#generalInfoForm', "<?php echo $validateGeneralInfo ?>");
        ajaxValidation('#locationForm', "<?php echo $validateLocation ?>", true);

        
        $('.toggle_help').click(function(){
            if($('.icons-list-demo').hasClass('d-none')){
                $('.icons-list-demo').removeClass('d-none').slideDown('slow');
            }else{
                $('.icons-list-demo').addClass('d-none').slideUp('slow');
            }
        });
    });
</script>

<!-- Crop Images -->
<script type="text/javascript">
    // vars
    let result = document.querySelector('.result'),
    img_result = document.querySelector('.img-result'),
    img_w = 200,//document.querySelector('.img-w'),
    img_h = 200, //document.querySelector('.img-h'),
    save = document.querySelector('.save'),
    cropped = document.querySelector('.cropped'),
    hidden_image = document.querySelector('.hidden_image'),
    upload = document.querySelector('#image_'),
    cropper = '';

    // on change show image with crop options
    upload.addEventListener('change', (e) => {
        if (e.target.files.length) {
                // start file reader
            const reader = new FileReader();
            reader.onload = (e)=> {
                if(e.target.result){
                    // create new image
                    let img = document.createElement('img');
                    img.id = 'image';
                    img.src = e.target.result;
                    // clean result before
                    result.innerHTML = '';
                    // append new image
                    result.appendChild(img);
                    // show save btn and options
                    
                    save.classList.remove('d-none');
                    result.classList.remove('d-none');

                    cropped.classList.add('d-none');
                    img_result.classList.add('d-none');

                    // Remove image cropped
                    cropped.src = '';   
                    hidden_image.value = '';

                    
                    // Cropper.setDefaults(aspectRatio : 1/1);
                    // init cropper
                    cropper = new Cropper(img, {
                        aspectRatio: 1/1,
                    });
                }
            };
            reader.readAsDataURL(e.target.files[0]);
        }
    });

    // save on click
    save.addEventListener('click',(e)=>{
        e.preventDefault();
        // get result to data uri
        let imgSrc = cropper.getCroppedCanvas({
            width: img_w.value // input value
        }).toDataURL();
        // remove hide class of img
        cropped.classList.remove('d-none');
        img_result.classList.remove('d-none');

        result.classList.add('d-none');
        save.classList.add('d-none');
        // uploadImg.classList.remove('d-none');
        // show image cropped
        cropped.src = imgSrc;   
        hidden_image.value = imgSrc;           
    });
</script>