<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Model_user extends CI_Model
{
    public function insert($data){
        $admin_id = $this->uuid->v4();
        $adminInsert = array(
            'admin_id' => $admin_id,
            'first_name' => $data['first_name'],
            'last_name' => $data['last_name'],
            'email' => $data['email'],
            'password' => md5($data['password']),
            'role' => $data['role'],
            'permission' => $data['permission'],
            'status' => $data['status'],
            'create_date' => date(DATE_FORMAT_DB)
        );
        $this->db->insert(TBL_ADMIN, $adminInsert);
        return true;
    }
    public function update($data){
        // dd($data);
        $adminInsert = array(
            'first_name' => $data['first_name'],
            'last_name' => $data['last_name'],
            'email' => $data['email'],
            'password' => md5($data['password']),
            'role' => $data['role'],
            'permission' => $data['permission'],
            'status' => $data['status'],
        );
        $this->db->where('admin_id', $data['admin_id']);
        $this->db->update(TBL_ADMIN, $adminInsert);
        return true;
    }
    
    // Admin View Functoins
    public function getListRecord($start,$no_of_rec,$data){
        $this->db->select('*');
        $this->db->from(TBL_ADMIN);
        
        if($data['admin_id'] != ''){
            $this->db->where(TBL_ADMIN.'.admin_id', $data['admin_id']);
        }
        if($data['role'] != ''){
            $this->db->where(TBL_ADMIN.'.role', $data['role']);
        }
        if($data['permission'] != ''){
            $this->db->where(TBL_ADMIN.'.permission', $data['permission']);
        }
        if($data['create_date'] != ''){
            $this->db->where('CAST('.TBL_ADMIN.'.create_date as date)=', date('Y-m-d',strtotime( str_replace('/', '-', $data['create_date']))));
        }
        if($data['status'] != ''){
            $this->db->where(TBL_ADMIN.'.status', $data['status']);
        }
        $this->db->order_by('id', "DESC");
        $this->db->limit($no_of_rec,$start);
        $data = $this->db->get();
        // echo $this->db->last_query(); die;
        return  $data->result_array();
    }
    public function countAllRecord($data){
        $this->db->select('*');
        $this->db->from(TBL_ADMIN);
        
        if($data['admin_id'] != ''){
            $this->db->where(TBL_ADMIN.'.admin_id', $data['admin_id']);
        }
        if($data['role'] != ''){
            $this->db->where(TBL_ADMIN.'.role', $data['role']);
        }
        if($data['permission'] != ''){
            $this->db->where(TBL_ADMIN.'.permission', $data['permission']);
        }
        if($data['create_date'] != ''){
            $this->db->where('CAST('.TBL_ADMIN.'.create_date as date)=', date('Y-m-d',strtotime( str_replace('/', '-', $data['create_date']))));
        }
        if($data['status'] != ''){
            $this->db->where(TBL_ADMIN.'.status', $data['status']);
        }
        return $this->db->count_all_results();
    }
    public function searchAdminByName($name){
        $this->db->select("CONCAT(first_name,' ',last_name) as text, admin_id as id");
        if($name != ''){
            $this->db->like("CONCAT(first_name,' ',last_name)", $name);
        }
        $this->db->from(TBL_ADMIN)->limit(10);
        $data = $this->db->get();
        return  $data->result();
    }
    public function getAdminById($admin_id){
        $this->db->select('*');
        $this->db->where(TBL_ADMIN.'.admin_id', $admin_id);
        $this->db->from(TBL_ADMIN);
        $query = $this->db->get();
        return  $query->row_array();
    }
    public function getAllActiveAdmin(){
        $this->db->select('CONCAT(first_name," ",last_name) as name, admin_id, permission');
        $this->db->from(TBL_ADMIN)->where('status', 1);
        $data = $this->db->get();
        return  $data->result_array();
    }
    public function getAllCategories(){
        $this->db->select('*');
        $this->db->from(TBL_ADMIN)->where('status', 1);
        $data = $this->db->get();
        return  $data->result_array();
    }
    public function remove($admin_id){
        $this->db->where('admin_id', $admin_id);
        $this->db->delete(TBL_ADMIN);
        return true;
    }

}