<?php
session_start();

// Check if the admin is logged in
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: admin_login.php");
    exit();
}

// Database connection
$servername = "localhost";
$username = "emalle5_wdodfm9655";
$password = "wdodfm9655";
$dbname = "emalle5_hixsonpike";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = intval($_POST['id']);
    $action = $_POST['action'];
    $admin_username = $_SESSION['admin_username'];

    // Fetch the pending change
    $stmt = $conn->prepare("SELECT store_id, field, old_value, new_value FROM pending_changes WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $change = $result->fetch_assoc();
        $store_id = $change['store_id'];
        $field = $change['field'];
        $old_value = $change['old_value'];
        $new_value = $change['new_value'];

        if ($action === "approve") {
            // Apply the change to the store table
            $update_stmt = $conn->prepare("UPDATE store SET $field = ? WHERE id = ?");
            $update_stmt->bind_param("ss", $new_value, $store_id);
            $update_stmt->execute();
            $update_stmt->close();

            // Log the change in the change_log table
            $log_stmt = $conn->prepare("INSERT INTO change_log (store_id, field, old_value, new_value, approved_by) VALUES (?, ?, ?, ?, ?)");
            $log_stmt->bind_param("sssss", $store_id, $field, $old_value, $new_value, $admin_username);
            $log_stmt->execute();
            $log_stmt->close();
        }

        // Remove the pending change (approved or rejected)
        $delete_stmt = $conn->prepare("DELETE FROM pending_changes WHERE id = ?");
        $delete_stmt->bind_param("i", $id);
        $delete_stmt->execute();
        $delete_stmt->close();
    }

    $stmt->close();
}

$conn->close();
header("Location: admin_dashboard.php");
exit();
?>
