<?php
session_start();

// Check if the user is logged in
if (!isset($_SESSION['store_id'])) {
    header("Location: login.php");
    exit();
}

// Database connection
$servername = "localhost";
$username = "emalle5_wdodfm9655";
$password = "wdodfm9655";
$dbname = "emalle5_hixsonpike";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$store_id = $_SESSION['store_id'];

// Fetch the current data for the business
$stmt = $conn->prepare("SELECT phone, description, fax, website, email, SPECIAL_OFFER FROM store WHERE id = ?");
$stmt->bind_param("s", $store_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $store = $result->fetch_assoc();
} else {
    echo "No data found for this business.";
    exit();
}

// Fetch the last 10 changes from the change_log table
$log_stmt = $conn->prepare("SELECT field, old_value, new_value, approved_by, change_date FROM change_log WHERE store_id = ? ORDER BY change_date DESC LIMIT 10");
$log_stmt->bind_param("s", $store_id);
$log_stmt->execute();
$change_logs = $log_stmt->get_result();

$stmt->close();
$log_stmt->close();
$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Business Edit</title>
</head>
<body>
    <h2>Edit Your Business Information</h2>
    <form method="post" action="submit_changes.php">
        <label for="phone">Phone:</label>
        <input type="text" name="phone" id="phone" value="<?php echo htmlspecialchars($store['phone']); ?>" required>
        <br>

        <label for="description">Description:</label>
        <textarea name="description" id="description" required><?php echo htmlspecialchars($store['description']); ?></textarea>
        <br>

        <label for="fax">Fax:</label>
        <input type="text" name="fax" id="fax" value="<?php echo htmlspecialchars($store['fax']); ?>">
        <br>

        <label for="website">Website:</label>
        <input type="url" name="website" id="website" value="<?php echo htmlspecialchars($store['website']); ?>">
        <br>

        <label for="email">Email:</label>
        <input type="email" name="email" id="email" value="<?php echo htmlspecialchars($store['email']); ?>" required>
        <br>

        <label for="SPECIAL_OFFER">Special Offer:</label>
        <textarea name="SPECIAL_OFFER" id="SPECIAL_OFFER"><?php echo htmlspecialchars($store['SPECIAL_OFFER']); ?></textarea>
        <br>

        <button type="submit">Submit Changes</button>
    </form>

    <h2>Change History</h2>
    <?php if ($change_logs->num_rows > 0): ?>
        <table border="1">
            <tr>
                <th>Field</th>
                <th>Old Value</th>
                <th>New Value</th>
                <th>Approved By</th>
                <th>Change Date</th>
            </tr>
            <?php while ($log = $change_logs->fetch_assoc()): ?>
                <tr>
                    <td><?php echo htmlspecialchars($log['field']); ?></td>
                    <td><?php echo htmlspecialchars($log['old_value']); ?></td>
                    <td><?php echo htmlspecialchars($log['new_value']); ?></td>
                    <td><?php echo htmlspecialchars($log['approved_by']); ?></td>
                    <td><?php echo htmlspecialchars($log['change_date']); ?></td>
                </tr>
            <?php endwhile; ?>
        </table>
    <?php else: ?>
        <p>No recent changes found.</p>
    <?php endif; ?>
</body>
</html>
