<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Model_event extends CI_Model
{
    public function insertGeneralInfo($data){
        $event_id = $this->uuid->v4();
        $eventInsert = array(
            'event_id' => $event_id,
            'name' => $data['name'],
			'title' => $data['title'],
            'user_id' => $data['user_id'],
            'email' => $data['email'],
            'website' => $data['website'],
            'phone' => $data['phone'],
            'fax' => $data['fax'],
            'status' => $data['status'],
            'description' => $data['description'],
            'create_date' => date(DATE_FORMAT_DB)
        );
        
        $this->db->insert(TBL_EVENT, $eventInsert);
        return $event_id;
    }
    public function updateGeneralInfo($data){
        // dd($data);
        $eventInsert = array(
            'name' => $data['name'],
			'title' => $data['title'],
            'user_id' => $data['user_id'],
            'email' => $data['email'],
            'website' => $data['website'],
            'phone' => $data['phone'],
            'fax' => $data['fax'],
            'status' => $data['status'],
            'description' => $data['description'],
        );
        $this->db->where('event_id', $data['event_id']);
        $this->db->update(TBL_EVENT, $eventInsert);
        return $data['event_id'];
    }
    
    public function updateSocial($data){
        
        $eventInsert = array(
            'twitter' => $data['twitter'],
            'youtube' => $data['youtube'],
            'linkedin' => $data['linkedin'],
            'pinterest' => $data['pinterest'],
            'facebook' => $data['facebook'],
            'instagram' => $data['instagram'],
        );
        $this->db->where('event_id', $data['event_id']);
        $this->db->update(TBL_EVENT, $eventInsert);
        return $data['event_id'];
    }
    public function updateLocation($data){
        $eventInsert = array(
            'address' => $data['address'],
            'city' => $data['city'],
            'state_id' => $data['state_id'],
            'postal_code' => $data['postal_code'],
            'country_id' => $data['country_id'],
            'latitude' => $data['latitude'],
            'longitude' => $data['longitude'],
        );
        $this->db->where('event_id', $data['event_id']);
        $this->db->update(TBL_EVENT, $eventInsert);
        return $data['event_id'];
    }
    
	public function updateEventTime($data){
        
        $this->db->delete(TBL_EVENT_TIME, ['event_id' => $data['event_id']]);
			
			if(isset($data['weekday'])){
				$weekdays = implode(",",$data['weekday']);
			}
			
			if($data['event_time_option'] == 'selected_date'){				
				$data['repeat_interval'] = '';
				$data['no_of_repeat'] = '';
			}
			
			if($data['event_time_option'] == 'daily' || $data['event_time_option'] == 'yearly' || $data['event_time_option'] == 'selected_date'){
				
				$data['repeat_by'] = '';
				$weekdays = '';
			}
			
			if($data['repeat_by'] == 'mode_1'){				
				$weekdays = '';
			}
			
			$eventInsert = array(
				'event_timezone' => $data['event_timezone'],
				'event_time_option' => $data['event_time_option'],
				'repeat_interval' => isset($data['repeat_interval']) ? $data['repeat_interval'] : '',
				'no_of_repeat' => isset($data['no_of_repeat']) ? $data['no_of_repeat'] : '',
				'repeat_by' => isset($data['repeat_by']) ? $data['repeat_by'] : '',
				'repeat_week_days' => isset($data['weekday']) ? $weekdays : '',
			);
			//echo "<pre>";
			//print_r($eventInsert); exit;
			$this->db->where('event_id', $data['event_id']);
			$this->db->update(TBL_EVENT, $eventInsert);
			//echo $this->db->last_query(); die;
					
       for($i=0; $i<count($data['event_date']); $i++){
		   //echo "<pre>"; print_r(date('d-m-Y',strtotime($data['event_date'][$i]))); exit;
		   if($data['event_date'][$i] != '' || $data['start_time'][$i] != '' || $data['end_time'][$i] != ''){
				$eventTime[] = array(
					'event_id' => $data['event_id'],
					'event_date' => date('Y-m-d',strtotime($data['event_date'][$i])),
					'start_time' => $data['start_time'][$i],
					'end_time' => $data['end_time'][$i]
				);
		   }
        }

        $this->db->insert_batch(TBL_EVENT_TIME, $eventTime);
		//echo $this->db->last_query(); die;
        return $data['event_id'];
    }
	
    public function updateAdditionalInfo($data){
        $eventInsert = array(
            'additional_info' => $data['additional_info'],
            'image' => $data['image'],
        );
        $this->db->where('event_id', $data['event_id']);
        $this->db->update(TBL_EVENT, $eventInsert);
        return $data['event_id'];
    }
    public function importCsv($data){
        $this->db->insert_batch(TBL_EVENT, $data);
        return true;
    }
    // Admin View Functoins
    public function getListRecord($start,$no_of_rec,$data){
        $this->db->select('*');
        $this->db->from(TBL_EVENT);
        
        if($data['event_id'] != ''){
            $this->db->where(TBL_EVENT.'.event_id', $data['event_id']);
        }
        if($data['create_date'] != ''){
            $this->db->where('CAST('.TBL_EVENT.'.create_date as date)=', date('Y-m-d',strtotime( str_replace('/', '-', $data['create_date']))));
        }
        if($data['status'] != ''){
            $this->db->where(TBL_EVENT.'.status', $data['status']);
        }
        if(isset($data['user_id']) && $data['user_id'] != ''){
            $this->db->where(TBL_EVENT.'.user_id', $data['user_id']);
        }
        $this->db->order_by('id', "DESC");
        $this->db->limit($no_of_rec,$start);
        $data = $this->db->get();
        // echo $this->db->last_query(); die;
        return  $data->result_array();
    }
    public function countAllRecord($data){
        $this->db->select('*');
        $this->db->from(TBL_EVENT);
        
        if($data['event_id'] != ''){
            $this->db->where(TBL_EVENT.'.event_id', $data['event_id']);
        }
        if($data['create_date'] != ''){
            $this->db->where('CAST('.TBL_EVENT.'.create_date as date)=', date('Y-m-d',strtotime( str_replace('/', '-', $data['create_date']))));
        }
        if($data['status'] != ''){
            $this->db->where(TBL_EVENT.'.status', $data['status']);
        }
        if(isset($data['user_id']) && $data['user_id'] != ''){
            $this->db->where(TBL_EVENT.'.user_id', $data['user_id']);
        }
        return $this->db->count_all_results();
    }
    public function searchEventByName($name, $user_id = ''){
        $this->db->select('name as text, event_id as id');
        if($name != ''){
            $this->db->like(TBL_EVENT.'.name', $name);
        }
        if($user_id != ''){
            $this->db->where(TBL_EVENT.'.user_id', $user_id);
        }
        $this->db->from(TBL_EVENT)->limit(10);
        $data = $this->db->get();
        return  $data->result();
    }

    public function getEventTime($event_id){
        $this->db->select('*');
        $this->db->from(TBL_EVENT_TIME);
        $this->db->where('event_id', $event_id);
        $query = $this->db->get();
        return $query->result_array();
    }
    public function getEventById($event_id){
        // CASE WHEN image_type = 1 THEN image ELSE IF(image != "", CONCAT("'.UPLOAD_URL.'",image), "'.ASSETS_URL.'no-image.jpg") END;
        // $this->db->select('*, image AS _image, CASE WHEN image_type = 1 THEN image ELSE IF(image != "", CONCAT("'.UPLOAD_URL.'",image), "'.ASSETS_URL.'no-image.jpg") END AS image');
        $this->db->select('*, image AS _image, (CASE WHEN image_type = 1 THEN image ELSE IF(image != "", CONCAT("'.UPLOAD_URL.'",image), "'.ASSETS_URL.'no-image.jpg") END) AS image');
        $this->db->where(TBL_EVENT.'.event_id', $event_id);
        $this->db->from(TBL_EVENT);
        $query = $this->db->get();
        $eventInfo = $query->row_array();

        $eventTiming = $this->getEventTime($event_id); 
        $eventInfo['event_timing'] = $eventTiming;
        // dd($eventInfo);
        return  $eventInfo;
    }
    public function getAllActiveEvent(){
        $this->db->select('name, event_id');
        $this->db->from(TBL_EVENT)->where('status', 1);
        $data = $this->db->get();
        return  $data->result_array();
    }
	
	public function copy_event($event_id){
		
		$this->db->select('*');
        $this->db->from(TBL_EVENT)->where('event_id', $event_id);
        $data = $this->db->get();
		$copy_fields = $data->row_array();
		//echo "<pre>"; print_r($copy_fields); exit;
		 
			foreach($copy_fields as $key=>$val) {
					if($key != 'id'){
						if($key == 'event_id') {
							$val = $this->uuid->v4();
						}
						if($key == 'create_date') {
							$val = date(DATE_FORMAT_DB);
						}
						if($key == 'update_date') {
							$val = date(DATE_FORMAT_DB);
						}
						
						$this->db->set($key, $val); 
					}
			}
		
		//insert the new record into table 
		$this->db->insert(TBL_EVENT); 
	
		//echo $this->db->last_query(); die;		
		$last_insert_id = $this->db->insert_id();
		$q = $this->db->get_where(TBL_EVENT, array('id' => $last_insert_id));
		$result = $q->row_array();
		//echo "<pre>"; print_r($result); exit;
		
		$this->db->select('*');
        $this->db->from(TBL_EVENT_TIME)->where('event_id', $event_id);
        $time_data = $this->db->get();
		$time_copy_fields = $time_data->result_array();
		
		if(!empty($time_copy_fields)){
			 foreach ($time_copy_fields as $row){ 
				foreach($row as $key=>$val) { 
					if($key != 'id'){
													
							if($key == 'event_id') {
								$val = $result['event_id'];
							}							
							if($key == 'created_at') {
								$val = date(DATE_FORMAT_DB);
							}
							if($key == 'updated_at') {
								$val = date(DATE_FORMAT_DB);
							}
							
							$this->db->set($key, $val); 
						}
				}
					$this->db->insert(TBL_EVENT_TIME); 
			 }
			 //insert the new record into table 
			
		}	
		
		
		return $result;
		
		
    }
	
    public function remove($event_id){
        $this->db->where('event_id', $event_id);
        $this->db->delete(TBL_EVENT);
		
		$this->db->where('event_id', $event_id);
        $this->db->delete(TBL_EVENT_TIME);
        return true;
    }
	
	public function removeEventTime($event_time_id){
        $this->db->where('id', $event_time_id);
        $this->db->delete(TBL_EVENT_TIME);
        return true;
    }
	
    public function filterEvent($data = array()){

        $limit = RECORD_LIMIT;
		$offset = $limit * ($data['event_page_no']-1); 

        $this->db->select('*, image AS _image, (CASE WHEN image_type = 1 THEN image ELSE IF(image != "", CONCAT("'.UPLOAD_URL.'",image), "'.ASSETS_URL.'no-image.jpg") END) AS image');
        
        if(isset($data['keyword']) && $data['keyword'] != ''){
            $where = '('.TBL_EVENT.'.name LIKE "%'.$data['keyword'].'%" OR '.TBL_EVENT.'.additional_info LIKE "%'.$data['keyword'].'%" OR '.TBL_EVENT.'.description LIKE "%'.$data['keyword'].'%")';
            $this->db->where($where);
        }

        if(isset($data['latitude']) && isset($data['latitude'])){
            /*$this->db->select('ROUND( ( 6373 * acos( cos( radians('.$data['latitude'].') ) * cos( radians( '.TBL_EVENT.'.latitude ) ) * cos( radians( '.TBL_EVENT.'.longitude ) - radians('.$data['longitude'].') ) + sin( radians('.$data['latitude'].') ) * sin( radians( '.TBL_EVENT.'.latitude ) ) ) ), 2) AS distance');*/
            
            $this->db->select('ROUND(( (3959 * acos( cos( radians('.$data['latitude'].') ) * cos( radians( '.TBL_EVENT.'.latitude ) ) * cos( radians( '.TBL_EVENT.'.longitude ) - radians('.$data['longitude'].') ) + sin( radians('.$data['latitude'].') ) * sin( radians( '.TBL_EVENT.'.latitude ) ) ) ) + 30*((3959 * acos( cos( radians('.$data['latitude'].') ) * cos( radians( '.TBL_EVENT.'.latitude ) ) * cos( radians( '.TBL_EVENT.'.longitude ) - radians('.$data['longitude'].') ) + sin( radians('.$data['latitude'].') ) * sin( radians( '.TBL_EVENT.'.latitude ) ) ) ))/100) , 2) AS distance');
                     
            $this->db->having('distance <= ', $data['search_radius']);
            $this->db->order_by('distance', 'ASC');
        }
        /*if(isset($data['search_event_date']) && $data['search_event_date'] != ''){
			$search_date = date('Y-m-d', strtotime($data['search_event_date']));
            $this->db->join(TBL_EVENT_TIME, TBL_EVENT_TIME.'.event_id = '.TBL_EVENT.'.event_id','Left');
            $this->db->where(TBL_EVENT_TIME.'.search_event_date >=', $search_date);
        }*/

        $this->db->from(TBL_EVENT);
        $this->db->where('status', 1);
        $this->db->limit($limit, $offset);
        
        $data = $this->db->get();
		
        return  $data->result_array();
        
    }

    public function countTotalRecord($data = array()){

        $limit = RECORD_LIMIT;
		$this->db->select(TBL_EVENT.'.event_id');
        
        if(isset($data['keyword']) && $data['keyword'] != ''){
            $where = '('.TBL_EVENT.'.name LIKE "%'.$data['keyword'].'%" OR '.TBL_EVENT.'.additional_info LIKE "%'.$data['keyword'].'%" OR '.TBL_EVENT.'.description LIKE "%'.$data['keyword'].'%")';
            $this->db->where($where);
        }

        if(isset($data['latitude']) && isset($data['latitude'])){
            /*$this->db->select('ROUND( ( 6373 * acos( cos( radians('.$data['latitude'].') ) * cos( radians( '.TBL_EVENT.'.latitude ) ) * cos( radians( '.TBL_EVENT.'.longitude ) - radians('.$data['longitude'].') ) + sin( radians('.$data['latitude'].') ) * sin( radians( '.TBL_EVENT.'.latitude ) ) ) ), 2) AS distance');
            $this->db->select('ROUND( (3959 * acos( cos( radians('.$data['latitude'].') ) * cos( radians( '.TBL_EVENT.'.latitude ) ) * cos( radians( '.TBL_EVENT.'.longitude ) - radians('.$data['longitude'].') ) + sin( radians('.$data['latitude'].') ) * sin( radians( '.TBL_EVENT.'.latitude ) ) ) ) , 2) AS distance');*/
            
            $this->db->select('ROUND(( (3959 * acos( cos( radians('.$data['latitude'].') ) * cos( radians( '.TBL_EVENT.'.latitude ) ) * cos( radians( '.TBL_EVENT.'.longitude ) - radians('.$data['longitude'].') ) + sin( radians('.$data['latitude'].') ) * sin( radians( '.TBL_EVENT.'.latitude ) ) ) ) + 30*((3959 * acos( cos( radians('.$data['latitude'].') ) * cos( radians( '.TBL_EVENT.'.latitude ) ) * cos( radians( '.TBL_EVENT.'.longitude ) - radians('.$data['longitude'].') ) + sin( radians('.$data['latitude'].') ) * sin( radians( '.TBL_EVENT.'.latitude ) ) ) ))/100) , 2) AS distance');
            
            $this->db->having('distance <= ', $data['search_radius']);
            $this->db->order_by('distance', 'ASC');
        }
        /*if(isset($data['search_event_date']) && $data['search_event_date'] != ''){
            $this->db->join(TBL_EVENT_TIME, TBL_EVENT_TIME.'.event_id = '.TBL_EVENT.'.event_id','Left');
            $this->db->where(TBL_EVENT_TIME.'.search_event_date >=', $data['search_event_date']);
        }*/

        $this->db->from(TBL_EVENT);
        $this->db->where('status', 1);
        $query = $this->db->get();
		$totalRecord = $query->num_rows();
		$total_pages = ceil($totalRecord / $limit);

		$results = array(
            'total_record' => $totalRecord,
			'event_page_no' => $data['event_page_no'],
			'total_pages' => $total_pages,
        );
        
        return $results;
    }

    public function searchLog($data){
        // dd($data);
        $logInsert = array(
            'category' => isset($data['category_id']) ? $data['category_id'] : '',
            'keyword' => isset($data['keyword']) ? $data['keyword'] : '',
            'location' => isset($data['location']) ? $data['location'] : '',
            'latitude' => isset($data['latitude']) ? $data['latitude'] : '',
            'longitude' => isset($data['longitude']) ? $data['longitude'] : '',
            'created_at' => date(DATE_FORMAT_DB),
            'updated_at' => date(DATE_FORMAT_DB),
        );
        
        $this->db->insert(TBL_SEARCH_LOG, $logInsert);
    }

    /* public function getCurrentStoreStatus($event_id, $timeZone){
        error_reporting(E_ALL);
        ini_set('display_errors', 1);
        if($timeZone != ''){
            date_default_timezone_set($timeZone);
        }else{
            $timeZone = date_default_timezone_get();
            date_default_timezone_set($timeZone);
        }
        
        $dayNum = date('N');
        $this->db->select('*');
        $this->db->from(TBL_EVENT_TIME);
        $this->db->where('event_id', $event_id);
        $this->db->where('day', $dayNum);
        
        $query = $this->db->get();
        $storeTime = $query->row_array();
        // dd($storeTime);
        if($storeTime){
            $times = json_decode($storeTime['time'], true);
            // dd($times);
            $isOpen = false;
            $string = '';
            // $now = strtotime(date('Y-m-d H:i:s'));
            $now = strtotime(date('Y-m-d H:i:s'));
            // echo "<pre>";
            $to_0 = strtotime(date('Y-m-d H:i:s', strtotime($times[0]['to'])));
            // echo "<pre>";
            $from_0 = strtotime(date('Y-m-d H:i:s', strtotime($times[0]['from'])));
        
            if ($from_0 >= $to_0) {
                $from = date('Y-m-d H:i:s', strtotime($times[0]['from']));
                $from_0 = strtotime(date('Y-m-d H:i:s', strtotime($from . ' +1 day')));
                // echo "updated from_0: ".$from_0;
                // die;    
            }
            $to_1 = $times[1]['to'] != '' ? strtotime(date('Y-m-d H:i:s', strtotime($times[1]['to']))) : '';
            $from_1 = $times[1]['from'] != '' ? strtotime(date('Y-m-d H:i:s', strtotime($times[1]['from']))) : '';
            
            // echo $now; die;
            if(($to_0 <= $now && $now <= $from_0) || ($to_1 <= $now && $now <= $from_1)){
                
                if($to_0 <= $now && $now <= $from_0){
                    $isOpen = true;
                    $slot = 1;
                    $string = '<strong class="text-success">Open</strong> | Closes '.date('h:i A', strtotime($times[0]['from']));
                }

                if($to_1 <= $now && $now <= $from_1){
                    $isOpen = true;
                    $slot = 2;
                    $string = '<strong class="text-success">Open</strong> | Closes '.date('h:i A', strtotime($times[1]['from']));
                }
            }else{
                // echo "else";
                if(($from_0 <= $now && $now <= $to_1) && $to_1 != ''){
                    $isOpen == false;
                    $slot = 1;
                    $string = '<strong class="text-danger">Closed</strong> | Opens '.date('h:i A', strtotime($times['1']['to']));
                }else{
                    $isOpen = false;
                    $slot = 2;
                    $getNextDayOpenTime = $this->getStoreNextDayOpenTime($event_id);
                    if($getNextDayOpenTime['to'] == ''){
                        $getNextDayOpenTime = $this->getFirstOpenDay($event_id);
                        $string = '<strong class="text-danger">Closed</strong> | Opens '.date('h:i A', strtotime($getNextDayOpenTime['to']));
                    }else{
                        $string = '<strong class="text-danger">Closed</strong> | Opens '.date('h:i A', strtotime($getNextDayOpenTime['to']));
                    }
                }
            }
        }else{
            $isOpen = false;
            $slot = 2;
            $getNextDayOpenTime = $this->getStoreNextDayOpenTime($event_id);
            if($getNextDayOpenTime['to'] == ''){
                $getNextDayOpenTime = $this->getFirstOpenDay($event_id);

                if($getNextDayOpenTime){
                   $string = '<strong class="text-danger">Closed</strong> | Opens '.date('h:i A', strtotime($getNextDayOpenTime['to']));
                }else{
                    $string = '';
                }
            }else{
                $string = '<strong class="text-danger">Closed</strong> | Opens '.date('h:i A', strtotime($getNextDayOpenTime['to']));
            }
        }
        $result = array(
            'store_time' => $storeTime,
            'isOpen' => $isOpen,
            'message' =>  $string,
            'slot' => $slot
        );  

        return $result;
        
    } */

    public function getCurrentStoreStatus($event_id, $timeZone){
        error_reporting(E_ALL);
        ini_set('display_errors', 1);
        if($timeZone != ''){
            date_default_timezone_set($timeZone);
        }else{
            $timeZone = date_default_timezone_get();
            date_default_timezone_set($timeZone);
        }
        
        $dayNum = date('N');
        $this->db->select('*');
        $this->db->from(TBL_EVENT_TIME);
        $this->db->where('event_id', $event_id);
        $this->db->where('day', $dayNum);
        
        $query = $this->db->get();
        $storeTime = $query->row_array();
        // dd($storeTime);
        if($storeTime){
            $times = json_decode($storeTime['time'], true);

            $isOpen = false;
            $string = '';

            $to = date('h:i A', strtotime($times[0]['to']));
            $from = date('h:i A', strtotime($times[0]['from']));

            $to1 = $times[1]['to'] != '' ? date('h:i A', strtotime($times[1]['to'])) : '';
            $from1 = $times[1]['from'] != '' ? date('h:i A', strtotime($times[1]['from'])) : '';

            $now_his = date('His');
            $from_his = date('His', strtotime($times[0]['from']));
            $to_his = date('His', strtotime($times[0]['to']));

            $to1_his = $times[1]['to'] != '' ? date('His', strtotime($times[1]['to'])) : '';
            $from1_his = $times[1]['from'] != '' ? date('His', strtotime($times[1]['from'])) : '';
            
            
            if ($from_his < $to_his) {
                // if from time is less then to time i.e (11:00 AM/PM to 3:00 AM/PM || 23:00 to 15:00 || )
                if(!($now_his > $from_his && $now_his < $to_his)){
                    $isOpen = true;
                    $slot = 1;
                    $string = '<strong class="text-success open1">Open</strong> | Closes '.$from;
                }else{
                    if($to1 != ''){
                        $isOpen == false;
                        $slot = 1;
                        $string = '<strong class="text-danger open1">Closed</strong> | Opens '.$to1;
                    }else{
                        $isOpen = false;
                        $slot = 2;
                        $string = $this->nextStoreOpenTime($event_id, 1);
                    }
                }
            }else{
                // echo $now; die;
                if(($to_his <= $now_his && $now_his <= $from_his) || ($to1_his <= $now_his && $now_his <= $from1_his)){

                    if($to_his <= $now_his && $now_his <= $from_his){
                        $isOpen = true;
                        $slot = 1;
                        $string = '<strong class="text-success open3">Open</strong> | Closes '.$from;
                    }

                    if($to1_his <= $now_his && $now_his <= $from1_his){
                        $isOpen = true;
                        $slot = 2;
                        $string = '<strong class="text-success open4">Open</strong> | Closes '.$from1;
                    }
                }else{
                    // echo "else";
                    if(($from_his > $now_his && $now_his < $to_his)){
                        $isOpen == false;
                        $slot = 1;
                        $string = '<strong class="text-danger close2">Closed</strong> | Opens '.$to;
                    }else if(($from_his <= $now_his && $now_his <= $to1_his) && $to1_his != ''){
                        $isOpen == false;
                        $slot = 2;
                        $string = '<strong class="text-danger close3">Closed</strong> | Opens '.$to1;
                    }else{
                        $isOpen = false;
                        $slot = 2;
                        $string = $this->nextStoreOpenTime($event_id, 4);
                    }
                }
            }
        }else{
            $isOpen = false;
            $slot = 2;
            $string = $this->nextStoreOpenTime($event_id, 5);
        }
        $result = array(
            'store_time' => $storeTime,
            'isOpen' => $isOpen,
            'message' =>  $string,
            'slot' => $slot
        );  

        return $result;
    }

    public function nextStoreOpenTime($event_id, $closeId){
        $getNextDayOpenTime = $this->getStoreNextDayOpenTime($event_id);
        if($getNextDayOpenTime['to'] == ''){
            $getNextDayOpenTime = $this->getFirstOpenDay($event_id);
			//print_r($getNextDayOpenTime); exit;
            if($getNextDayOpenTime['time']){
				$dayName = $this->getDayName($getNextDayOpenTime['day']);
                $string = '<strong class="text-danger close'.$closeId.'">Closed</strong> | Opens '.$dayName.' '.date('h:i A', strtotime($getNextDayOpenTime['time']['to']));
            }else{
                $string = '';
            }
        }else{
            $string = '<strong class="text-danger close'.$closeId.'">Closed</strong> | Opens '.date('h:i A', strtotime($getNextDayOpenTime['to']));
        }

        return $string;
    }

    public function getFirstOpenDay($event_id){		
		
        $this->db->select('time,day');
        $this->db->from(TBL_EVENT_TIME);
        $this->db->where('event_id', $event_id);
        $this->db->where('slot_1 !=', '');
		//$this->db->where("day BETWEEN $dayNum AND $weekdayNum");

        $this->db->order_by('day', 'ASC');
        $query = $this->db->get();
        $result = $query->result_array();
		//echo $this->db->last_query();exit;
        	$current_time=time();
        if($result){
        	$newResult = array();
			foreach($result as $res){
				$dayName = $this->getDayName($res['day']);
				$time_array = json_decode($res['time'], true); 
				if($time_array[1]['from'] != ''){
					$from_time = $time_array[1]['from'];
				}
				else
				{
					$from_time = $time_array[0]['from'];
				}
				$res['dayDate'] = date('Y-m-d '.$from_time.':00', strtotime('next ' . $dayName));
				$res['timestamp'] = strtotime($res['dayDate']);	
				$res['diff'] = $res['timestamp'] - $current_time;
				$newResult[] = $res;
			}
			
			$arr = array_map(function($v){return $v['diff'];}, $newResult);
			$key = array_keys($arr, min($arr));
			$minKey = $key[0];
			
			$final_array = $newResult[$minKey];
            $time = json_decode($final_array['time'], true); 
		    $day = $final_array['day']; 
		    $time_day = array('time'=>$time[0], 'day'=>$day);
        }
        else
        {
            $time_day = array('time'=>'', 'day'=>'');
        }
        //$startTime = $time[0];

        return $time_day;
    }

    public function getStoreNextDayOpenTime($event_id){
        $dayNum = date('N', strtotime(' +1 day'));
        $this->db->select('time');
        $this->db->from(TBL_EVENT_TIME);
        $this->db->where('event_id', $event_id);
        $this->db->where('day', $dayNum);
        
        $query = $this->db->get();
        $result = $query->row_array();
        // dd($result);
        $time = json_decode($result['time'], true); 
        $startTime = $time[0];
        return $startTime;
    }

    public function checkForStoreHoliday($event_id){
        $this->db->select('*');
        $this->db->from(TBL_EVENT_HOLIDAY);
        $this->db->where('event_id', $event_id);
        $this->db->where('date', date('Y-m-d'));
        
        $query = $this->db->get();
        $holiday = $query->row_array();

        if($holiday){
            $result = array(
                'is_holiday' => true,
                'message' => $holiday['message'],
            );
        }else{
            $result = array(
                'is_holiday' => false,
                'message' => '',
            );
        }

        return $result;
    }
	
	public function getDayName($dayNum){
        $days = [		 
		  1 => 'Monday',
		  2 => 'Tuesday',
		  3 => 'Wednesday',
		  4 => 'Thursday',
		  5 => 'Friday',
		  6 => 'Saturday',
		  7 => 'Sunday'
		];
        return $days[$dayNum];
    }
}