    <div class="content">
        <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/cropper/2.3.4/cropper.min.css">
        <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/0.8.1/cropper.min.js"></script>
        <style>
            img {
                max-width: 100%;
            }
        </style>
        <!-- Start Content-->
        <div class="container-fluid">
            
            <!-- start page title -->
                <?php $this->load->view('admin/common/breadcrumb', true); ?>
            <!-- end page title --> 
            
            <form class="form-horizontal" id="form" role="form" method="POST" action="<?php echo $submit_url ?>">
                <div class="row">
                    <div class="col-12">
                        <div class="card-box">
                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="users">Select user <span class="text-danger">*</span></label>
                                <div class="col-sm-10">
                                    <select class="form-control" name="users" id="users">
                                        <option value="0">All Users</option>
                                        <option value="1">Specific Users</option>
                                        <!-- <option value="2">By Preference</option> -->
                                    </select>
                                    <small id="error_status" class="form-text form-error text-danger"></small>
                                </div>
                            </div>

                            <div class="form-group row specific_user usertype" style="display: none;">
                                <label class="col-sm-2 col-form-label" for="user_filter">Specific user <span class="text-danger">*</span></label>
                                <div class="col-sm-10">
                                    <select class="form-control" name="user_ids[]" id="user_filter" multiple="multiple">
                                    </select>
                                    <small id="error_status" class="form-text form-error text-danger"></small>
                                </div>
                            </div>

                            <!-- <div class="form-group row preference usertype" style="display: none;">
                                <label class="col-sm-2 col-form-label" for="_topic">Topic <span class="text-danger">*</span></label>
                                <div class="col-sm-10">
                                    <div class="form-row">
                                        <div class="form-group col-md-6 mb-0">
                                            <label for="topic" class="col-form-label p-0">Topic</label>
                                            <select class="form-control" name="topic[]" id="topic">
                                                <option value="">--- Select Topic ---</option>
                                                <?php /* foreach ($topics as $key => $topic) { ?>
                                                  <option value="<?php echo $topic['id']; ?>" level="<?php echo $topic['level'] ?>" <?php echo isset($story['topic']) ? in_array($topic['id'], $story['topic']) ? 'selected' : '' : '' ?>><?php echo $topic['title'] ?></option>  
                                                <?php } */?>
                                            </select>
                                        </div>
                                        <div class="form-group col-md-6 mb-0">
                                            <label for="sub_topic" class="col-form-label p-0">Subtopic</label>
                                            <select class="form-control" name="topic[]" id="sub_topic">
                                                <option value="">--- Select Subtopic ---</option>
                                            </select>
                                        </div>
                                        <small id="error_topic" class="form-text form-error text-danger"></small>
                                    </div>
                                </div>
                            </div> -->

                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="notification_type">Notification Type </label>
                                <div class="col-sm-10">
                                    <select class="form-control" name="notification_type" id="notification_type">
                                        <option value="1">Instant Notification</option>
                                        <option value="2">Schedule Notification</option>
                                    </select>
                                    <small id="error_status" class="form-text form-error text-danger"></small>
                                </div>
                            </div>

                            <div class="form-group row required scheduletype" style="display: none;">
                                <label class="col-sm-2 col-form-label" for="message">Schedule</label>
                                <div class="col-sm-10">
                                    <div class="crontime mt-1"></div>
                                    <input type="hidden" value="" class="schedule_time" name="schedule_time" />
                                    <small id="error_message" class="form-text form-error text-danger"></small>
                                </div>
                            </div>

                            <div class="form-group row required">
                                <label class="col-sm-2 col-form-label" for="subject">Subject <span class="text-danger">*</span></label>
                                <div class="col-sm-10">
                                    <input type="text" id="subject" name="subject" class="form-control" placeholder="Subject" value="" />
                                    <small id="error_subject" class="form-text form-error text-danger"></small>
                                </div>
                            </div>

                            <div class="form-group row required">
                                <label class="col-sm-2 col-form-label" for="message">Message <span class="text-danger">*</span></label>
                                <div class="col-sm-10">
                                    <textarea id="message" name="message" class="form-control" placeholder="Message"></textarea>
                                    <small id="error_message" class="form-text form-error text-danger"></small>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="notification_image">Image</label>
                                <div class="col-sm-10">
                                    <input type="file" class="form-control" id="notification_image">
                                    <div class="img_crop mt-2">
                                        <div class="row">
                                            <!-- leftbox -->
                                            <div class="box-2 col-6">
                                                <div class="result"></div>
                                            </div>
                                            <!--rightbox-->
                                            <div class="box-2 col-2 img-result <?php echo isset($story['image']) ? '' : 'd-none' ?> ">
                                                <img class="cropped img-fluid" src="<?php echo isset($story['image']) ? $story['image'] : '' ?>" alt="">
                                                <input type="hidden" name="image" value="" class="hidden_image">
                                            </div>
                                        </div>
                                        <!-- save btn -->
                                        <div class="box mt-1">
                                            <!-- save btn -->
                                            <button class="btn btn-info waves-effect waves-light save d-none">Crop Image</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div> <!-- end card-box -->

                        <div class="form-group text-right mb-3">
                            <button class="btn btn-primary waves-effect waves-light mr-1" type="submit">Submit</button>
                        </div>
                    </div><!-- end col -->
                </div>
            </form>
            <!-- end row -->
        </div> <!-- container -->

    </div> <!-- content -->

    <script type="text/javascript">
        jQuery('#user_filter').select2({
            placeholder: '--- Select User ---',
            ajax: {
              url: '<?php echo base_url('admin/search/usersearch'); ?>',
              dataType: 'json',
              delay: 250,
              processResults: function (data) {
                return {
                  results: data
                };
              },
              cache: true
            }
        });
        jQuery(document).ready(function(e) {
            $('#users').on('change', function() {
               $('.usertype').hide();
               if ( this.value == '1'){
                   $(".specific_user").show();
               }
               if ( this.value == '2'){
                   $(".preference").show();
               }
            });

            $('.crontime').cron({
                onChange: function() {
                    $('.schedule_time').val($(this).cron("value"));
                },           
                useGentleSelect: true 
            }); // apply cron with default options

            $('#notification_type').on('change', function(){
                $('.scheduletype').hide();
                if(this.value == '2'){
                    $('.scheduletype').show();
                }
            });

            /*$('input[name=schedule_type]').on('change', function(){
                $('.datetime').hide();
                if(this.value == 'once'){
                    $('.datetime').show();
                }

                if(this.value == 'always'){
                    $('.time').show();
                }
            }); */
            
            
            if($('#topic option:selected')){
                var selectedTopic = $('#topic option:selected');
                var topic_id = selectedTopic.attr('value');
                var topic_level = selectedTopic.attr('level');
                getSubTopic(topic_id, topic_level, <?php echo isset($story['topic']) ? json_encode($story['topic']) : ''; ?>);
            }
            $('#topic').on('change', function(e) {
                var topic_id = $('option:selected', this).attr('value');
                var topic_level = $('option:selected', this).attr('level');
                $.ajax({
                    context: this,
                    type: "POST",
                    url: "<?php echo base_url('admin/story/getTopic') ?>",
                    data: {level: topic_level, category_id: topic_id },
                    beforeSend: function() {
                        $('.ajax-loader').show();
                    },
                    success: function(response){
                        response = JSON.parse(response);
                        var subTopics = '<option value="" level="">--- Select Option ---</option>';
                        if(response){
                            $.each(response, function(i, item) {
                                subTopics += '<option value="'+item.id+'" level="'+item.level+'">'+item.title+'</option>';
                            });
                        }
                        $('#sub_topic').html(subTopics);

                        $('.ajax-loader').hide();
                    }
                });
            });
        });

        function getSubTopic(topic_id, topic_level, selected_subtopic = '') {
            $.ajax({
                context: this,
                type: "POST",
                url: "<?php echo base_url('admin/story/getTopic') ?>",
                data: {level: topic_level, category_id: topic_id },
                beforeSend: function() {
                    $('.ajax-loader').show();
                },
                success: function(response){
                    response = JSON.parse(response);
                    var subTopics = '<option value="" level="">--- Select Option ---</option>';
                    if(response){
                        $.each(response, function(i, item) {
                            if(selected_subtopic != '' && $.inArray( item.id, selected_subtopic ) == true){
                                subTopics += '<option value="'+item.id+'" level="'+item.level+'" selected>'+item.title+'</option>';
                            }else{
                                subTopics += '<option value="'+item.id+'" level="'+item.level+'">'+item.title+'</option>';
                            }
                        });
                    }
                    $('#sub_topic').html(subTopics);

                    $('.ajax-loader').hide();
                }
            });
        }
    </script>
     <!-- Crop Images -->
    <script type="text/javascript">
        // vars
        let result = document.querySelector('.result'),
        img_result = document.querySelector('.img-result'),
        img_w = 200,//document.querySelector('.img-w'),
        img_h = 200, //document.querySelector('.img-h'),
        save = document.querySelector('.save'),
        cropped = document.querySelector('.cropped'),
        hidden_image = document.querySelector('.hidden_image'),
        upload = document.querySelector('#notification_image'),
        cropper = '';

        // on change show image with crop options
        upload.addEventListener('change', (e) => {
            if (e.target.files.length) {
                    // start file reader
                const reader = new FileReader();
                reader.onload = (e)=> {
                    if(e.target.result){
                        // create new image
                        let img = document.createElement('img');
                        img.id = 'image';
                        img.src = e.target.result;
                        // clean result before
                        result.innerHTML = '';
                        // append new image
                        result.appendChild(img);
                        // show save btn and options
                        save.classList.remove('d-none');
                        // Cropper.setDefaults(aspectRatio : 1/1);
                        // init cropper
                        cropper = new Cropper(img, {
                            aspectRatio: 16/9,
                        });
                    }
                };
                reader.readAsDataURL(e.target.files[0]);
            }
        });

        // save on click
        save.addEventListener('click',(e)=>{
            e.preventDefault();
            // get result to data uri
            let imgSrc = cropper.getCroppedCanvas({
                width: img_w.value // input value
            }).toDataURL();
            // remove hide class of img
            cropped.classList.remove('d-none');
            img_result.classList.remove('d-none');
            // show image cropped
            cropped.src = imgSrc;   
            hidden_image.value = imgSrc;           
        });
    </script>