<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Model_category extends CI_Model
{
    public function insert($data){
        $category_id = $this->uuid->v4();
        $categoryInsert = array(
            'category_id' => $category_id,
            'title' => $data['title'],
            'icon' => $data['icon'],
            'status' => $data['status'],
            'type' => $data['type'],
            'top_category' => isset($data['top_category']) ? $data['top_category'] : 0,
            'image' => $data['image'],
            'create_date' => date(DATE_FORMAT_DB)
        );
        $this->db->insert(TBL_CATEGORY, $categoryInsert);
        return true;
    }
    public function update($data){
        // dd($data);
        $categoryInsert = array(
            'title' => $data['title'],
            'icon' => $data['icon'],
            'status' => $data['status'],
            'type' => $data['type'],
            'top_category' => isset($data['top_category']) ? $data['top_category'] : 0,
            'image' => $data['image'],
        );
        $this->db->where('category_id', $data['category_id']);
        $this->db->update(TBL_CATEGORY, $categoryInsert);
        return true;
    }
    
    // Admin View Functoins
    public function getListRecord($start,$no_of_rec,$data){
        $this->db->select('*');
        $this->db->from(TBL_CATEGORY);
        
        if($data['category_id'] != ''){
            $this->db->where(TBL_CATEGORY.'.category_id', $data['category_id']);
        }
        if($data['create_date'] != ''){
            $this->db->where('CAST('.TBL_CATEGORY.'.create_date as date)=', date('Y-m-d',strtotime( str_replace('/', '-', $data['create_date']))));
        }
        if($data['status'] != ''){
            $this->db->where(TBL_CATEGORY.'.status', $data['status']);
        }
        $this->db->order_by('id', "DESC");
        $this->db->limit($no_of_rec,$start);
        $data = $this->db->get();
        // echo $this->db->last_query(); die;
        return  $data->result_array();
    }
    public function countAllRecord($data){
        $this->db->select('*');
        $this->db->from(TBL_CATEGORY);
        
        if($data['category_id'] != ''){
            $this->db->where(TBL_CATEGORY.'.category_id', $data['category_id']);
        }
        if($data['create_date'] != ''){
            $this->db->where('CAST('.TBL_CATEGORY.'.create_date as date)=', date('Y-m-d',strtotime( str_replace('/', '-', $data['create_date']))));
        }
        if($data['status'] != ''){
            $this->db->where(TBL_CATEGORY.'.status', $data['status']);
        }
        return $this->db->count_all_results();
    }
    public function searchCategoryByName($name){
        $this->db->select('title as text, category_id as id');
        if($name != ''){
            $this->db->like(TBL_CATEGORY.'.title', $name);
        }
        $this->db->from(TBL_CATEGORY)->limit(10);
        $data = $this->db->get();
        return  $data->result();
    }
    public function getCategoryById($category_id){
        $this->db->select('*, IF(image != "", CONCAT("'.UPLOAD_URL.'",image), "'.ASSETS_URL.'no-image.jpg") AS image');
        $this->db->where(TBL_CATEGORY.'.category_id', $category_id);
        $this->db->from(TBL_CATEGORY);
        $query = $this->db->get();
        return  $query->row_array();
    }
    public function getAllActiveCategory(){
        $this->db->select('title as name, category_id, icon, IF(image != "", CONCAT("'.UPLOAD_URL.'",image), "'.ASSETS_URL.'no-image.jpg") AS image');
        $this->db->from(TBL_CATEGORY)->where('status', 1);
        $data = $this->db->get();
        return  $data->result_array();
    }
    
    public function getAllCategories(){
        $this->db->select('*');
        $this->db->from(TBL_CATEGORY)->where('status', 1);
        $data = $this->db->get();
        return  $data->result_array();
    }

    public function getTopCategories(){
        $this->db->select('title as name, category_id, icon, IF(image != "", CONCAT("'.UPLOAD_URL.'",image), "'.ASSETS_URL.'no-image.jpg") AS image');
        $this->db->from(TBL_CATEGORY)->where('status', 1)->where('top_category', 1);
        $data = $this->db->get();
        return  $data->result_array();
    }

    public function remove($category_id){
        $this->db->where('category_id', $category_id);
        $this->db->delete(TBL_CATEGORY);
        return true;
    }
}