<!-- Start Content-->
<div class="container">
    <div class="row">
        <div class="col-12">
        <div class="card mt-2">
            <div class="card-body">
                <h4 class="header-title"><?php echo TITLE_NAME.' | '.$page_title; ?></h4>
                <h6><?php echo date_default_timezone_get() ?></h6>
            </div>
        </div>
        <?php foreach ($records as $key => $record) { ?>
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">URL: <?php echo $record['request_url'] ?></h5>
                    <h6 class="card-subtitle text-muted">Request From: <?php echo $record['request_from'] ?> <code>(Device: <?php echo $record['device_type'] ?>)</code></h6>
                </div>
                <div class="card-body">
                    <ul class="nav nav-tabs">
                        <li class="nav-item">
                            <a href="#request_<?php echo $record['api_log_id'] ?>" data-toggle="tab" aria-expanded="false" class="nav-link active">
                                <span class="d-inline-block d-sm-none"><i class="fas fa-home"></i></span>
                                <span class="d-none d-sm-inline-block">Request</span>   
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="#response_<?php echo $record['api_log_id'] ?>" data-toggle="tab" aria-expanded="true" class="nav-link">
                                <span class="d-inline-block d-sm-none"><i class="far fa-user"></i></span>
                                <span class="d-none d-sm-inline-block">Response</span> 
                            </a>
                        </li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane fade active show" id="request_<?php echo $record['api_log_id'] ?>">
                            <code><script>document.write(JSON.stringify(<?php echo $record['request'] ?>, null, 4))</script></code>
                        </div>
                        <div class="tab-pane fade" id="response_<?php echo $record['api_log_id'] ?>">
                            <code><script>document.write(JSON.stringify(<?php echo $record['response'] ?>, null, 4))</script></code>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
    <!-- end row-->
</div>