<?php
// Server file
class PushNotifications {
	
	public static function notification($apiKey,$data) {
		// For Android
		$message = array(
			'title' => $data['title'],
			'message' => $data['message'],
			'action' => isset($data['action']) ? $data['action'] : '',
			'action_id' => isset($data['action_id']) ? $data['action_id'] : '',
			// 'extra' => isset($data['extra']) ? $data['extra'] : array(),
			'image' => isset($data['image']) ? $data['image'] : '',
		);
		// For iOs
		$notification = array(
			'title' => $data['title'],
			'body'  =>  $data['message'],
			'sound' => 'Default',
			'action'=> isset($data['action']) ? $data['action'] : '',
			'action_id' => isset($data['action_id']) ? $data['action_id'] : '',
			// 'extra' => isset($data['extra']) ? $data['extra'] : array(),
			'image' => isset($data['image']) ? $data['image'] : '',
		);
		$headers = array(
			'Authorization: key=' .$apiKey,
			'Content-Type: application/json'
		);
		$device_token = is_array($data['device_token']) ? $data['device_token'] : array($data['device_token']);
		$fields = array(
			'registration_ids' => $device_token,
			'data' => $message,
			//'notification' => $notification
		);
		// dd($fields);
		return self::useCurl($headers, json_encode($fields), $data['debug']);
	}
	
	
	// Curl 
	private static function useCurl($headers, $fields = null, $debug = false) {
		$url = 'https://fcm.googleapis.com/fcm/send';
		// Open connection
		$ch = curl_init();
		if ($url) {
			// Set the url, number of POST vars, POST data
			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			// Disabling SSL Certificate support temporarly
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4 );
			if ($fields) {
				curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
			}
			// Execute post
			$result = curl_exec($ch);
			if ($result === FALSE) {
				die('Curl failed: ' . curl_error($ch));
			}
			// Close connection
			curl_close($ch);
			if($debug == true){
				print_r($result); die;
			}
			return $result;
		}
    }
}