<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Locator extends CI_Controller {
    function __construct(){
		parent::__construct();
        $this->load->model('Model_category');
        $this->load->model('Model_store');
		$this->load->model('Model_event');
        
		$this->load->model('Model_setting', 'setting');
	}

	// store locator page
	public function index(){
		$get = $this->input->get();

		$data = array();
		// get all cateogories for side menu
		$meta['categories'] = $data['categories'] = $this->Model_category->getAllActiveCategory();
		$data['top_categories'] = $this->Model_category->getTopCategories();

		// when category selected then get category information to dispalyand get store
		if(isset($get['cats'])){
			$getCategory = $this->Model_category->getCategoryById($get['cats']);
			$data['category_info'] = $getCategory;
			$get['category_id'] = $get['cats'];
		}
		// dd($data);
		
		// filter data if available we use to filter store 
		$data['latitude'] = isset($get['latitude']) ? $get['latitude'] : '';
		$data['longitude'] = isset($get['longitude']) ? $get['longitude'] : '';
		$data['postal_code'] = isset($get['postal_code']) ? $get['postal_code'] : '';
		$data['keyword'] = isset($get['keyword']) ? $get['keyword'] : '';
		$data['location'] = isset($get['location']) ? $get['location'] : '';
		$data['category_id'] = isset($get['category_id']) ? $get['category_id'] : '';
		$data['stores'] = array();
		$data['keyword_search'] = false;

		$allSetting = $this->setting->getAllSetting();
		// if user comes here from keyword then only this will apply
		if(count($get) > 2){
			$data['keyword_search'] = true;
			$get['page_no'] = 1;
			$get['search_radius'] = $allSetting['max_search_radius'];
			$data['stores'] = $this->Model_store->filterStore($get);	
			$this->Model_store->searchLog($get);
			
			$get['event_page_no'] = 1;
			$get['search_radius'] = $allSetting['max_search_radius'];
			$data['events'] = $this->Model_event->filterEvent($get);
		}
		
		// get setting value for map default location and zoom
		
		$map_center = json_decode($allSetting['map_center'], true);

		$meta['default_lat'] = $map_center['lat'];
		$meta['default_lng'] = $map_center['lng'];
		$meta['default_zoom'] = $map_center['zoom'];
		$meta['page_class'] = 'locator-page';
		$meta['preloader'] = false;
        // dd($data);
		$this->load->view('frontend/common/header', $meta);
		$this->load->view('frontend/home', $data);
		$this->load->view('frontend/common/footer', $meta);
	}

	
	// search store
	public function findStore(){
		$post = $this->input->post();
		$post['page_no'] = $_GET['page_no'];
		$this->Model_store->searchLog($post);
		$allSetting = $this->setting->getAllSetting();
		$post['search_radius'] = $allSetting['max_search_radius'];
		$stores = $this->Model_store->filterStore($post);
		$totalStore = $this->Model_store->countTotalRecord($post);
		// dd($totalStore);
		$allStores = $todayTime = array();
		foreach ($stores as $key => $store) {
			$cats = $categories = array();
			$storeCategories = $this->Model_store->getStoreCategory($store['store_id']);
	        foreach($storeCategories as $category){
	            $getCategory = $this->Model_category->getCategoryById($category['category_id']);
	            $categories[] = $getCategory;
	            $cats[] = $category['category_id'];
	        }
	        $store['cats'] = $cats;
        	$store['categories'] = $categories;

			$storeTime = $this->Model_store->getStoreTime($store['store_id']);
			$store['all_time'] = $storeTime;

			$timming = $this->Model_store->getCurrentStoreStatus($store['store_id'], $store['store_timezone']);
			$store['timming'] = $timming;

			$holiday = $this->Model_store->checkForStoreHoliday($store['store_id']);
			$store['holiday'] = $holiday;
			$allStores[] = $store;
		}
		// dd($allStores);
		$data['stores'] = $allStores;
		$data['total_store'] = $totalStore; 
		$data['search_radius'] = $allSetting['max_search_radius'];
		// $data['current_page'] = $post['page_no'];
		$viewHtml = $this->load->view('frontend/ajax/locator', $data, true);
		echo json_encode($viewHtml);
	}
	
	
	// search event
	public function findEvent(){
		$post = $this->input->post();
		$post['event_page_no'] = $_GET['event_page_no'];
		$search_event_date = $post['search_event_date'];
		//$this->Model_event->searchLog($post);
		$allSetting = $this->setting->getAllSetting();
		$post['search_radius'] = $allSetting['max_search_radius'];
		$events = $this->Model_event->filterEvent($post);
		$totalEvents = $this->Model_event->countTotalRecord($post);
		// dd($totalEvents);
		$allEvents = array();
		foreach ($events as $key => $event) {
			
			$eventTime = $this->Model_event->getEventTime($event['event_id']);
			//echo "<pre>";
			//print_r($eventTime); exit;
			$event_time_option = $event['event_time_option'];
			if(isset($search_event_date) && $search_event_date != ''){
				$today = date('Y-m-d', strtotime($search_event_date)); 
				$selected_day = date('d', strtotime($search_event_date)); 
			}
			else
			{
				$today = date('Y-m-d'); 
				$selected_day = date('d'); 
			}
						
			$event_start_date = $eventTime[0]['event_date'];
			$event_weekly_end_date = date('Y-m-d', strtotime($event_start_date. ' + 7 days'));
			$event_monthly_end_date = date('Y-m-d', strtotime($event_start_date. ' +1 month'));
			
			if($event_time_option == 'daily' && $today >= $event_start_date){
				$event['start_time'] = date('h:i a', strtotime($eventTime[0]['start_time']));
				$event['end_time'] = date('h:i a', strtotime($eventTime[0]['end_time']));
				$event['selected_Date'] = $today.' '.$eventTime[0]['start_time'];
				$event['selected_day'] = $selected_day;
				$allEvents[] = $event;
				
			}
			else if($event_time_option == 'weekly' && $today > $event_start_date && $today < $event_weekly_end_date){
				
				$event['start_time'] = date('h:i a', strtotime($eventTime[0]['start_time']));
				$event['end_time'] = date('h:i a', strtotime($eventTime[0]['end_time']));
				$event['selected_Date'] = $today.' '.$eventTime[0]['start_time'];
				$event['selected_day'] = $selected_day;
				$allEvents[] = $event;
			}
			else if($event_time_option == 'monthly' && $today > $event_start_date && $today < $event_monthly_end_date){
				
				$event['start_time'] = date('h:i a', strtotime($eventTime[0]['start_time']));
				$event['end_time'] = date('h:i a', strtotime($eventTime[0]['end_time']));
				$event['selected_Date'] = $today.' '.$eventTime[0]['start_time'];
				$event['selected_day'] = $selected_day;
				$allEvents[] = $event;
			}
			else if($event_time_option == 'selected_date') 
			{
				foreach($eventTime as $time){
					$events_start_date = $time['event_date'];
					if($today == $events_start_date){
						$event['start_time'] = date('h:i a', strtotime($time['start_time']));
						$event['end_time'] = date('h:i a', strtotime($time['end_time']));
						$event['selected_Date'] = $today.' '.$time['start_time'];
						$event['selected_day'] = $selected_day;
						$allEvents[] = $event;
					}
					
				}
			}
						
		}
		 //dd($allEvents);		
		$data['events'] = $allEvents;
		$data['total_event'] = $totalEvents; 
		$data['search_radius'] = $allSetting['max_search_radius'];
		// $data['current_page'] = $post['event_page_no'];
		$viewHtml = $this->load->view('frontend/ajax/event_locator', $data, true);
		echo json_encode($viewHtml);
	}
	
	// keyword search page
	public function keyword(){
		$data = array();
		$data['categories'] = $this->Model_category->getAllActiveCategory();
		$this->load->view('frontend/common/header');
		$this->load->view('frontend/keyword', $data);
		$this->load->view('frontend/common/footer');
	}
}
