<?php if(count($stores) == 0 ){ ?>
    <div class="highlight list-group-item no-results-item text-center">
        <p class="list-group-item-text">
            <strong><i class="fa fa-info-circle"></i> No results for this keyword.  We're sad.</strong>
        </p>
        <div>
            <br>Please try another location or keyword.<br><br>Thanks for visiting!
        </div>
        <br><a href="<?php echo base_url() ?>"><strong>Battlefield Parkway</strong></a>
    </div>
<?php }else{ ?>
    <div class="row">
        <?php foreach($stores as $store){ ?>
		<div class="col-sm-6 col-xl-6 stores_list_modal" data-val="<?= $store['id']; ?>" data-image ="<?= $store['image']; ?>"  data-target="#store-info-dialog" data-toggle="modal">							
					<div class="store-box" style="background-image:url(<?= $store['image']; ?>);background-color:#4bb5d8;background-size: cover;background-repeat: no-repeat;height: 100%; min-height: 370px;max-height: 400px;">
						<div class="overlay bg-secondary"></div>
						<div class="store-info">
						    <h4 class="text-uppercase mt-0 mb-0 font-weight-600"><?= $store['name'] ?></h4>
							<span  class="store_time_span"><?php echo $store['address'] ?> <?php echo $store['city'] ?> <?php echo $store['state'] ?> <?php echo $store['postal_code'] ?></span>
							<?php if($store['is_closed'] == '1'){ ?>
                                <span class="store_time_span"><strong class="text-pink">Closed</strong> | <?php echo $store['close_message'] != '' ? $store['close_message'] : 'Temporarily closed' ?></span>
                            <?php }else if($store['holiday']['is_holiday'] == true){ ?>
                                <span class="store_time_span"><strong class="text-pink">Closed</strong> | <?php echo $store['holiday']['message'] != '' ? $store['holiday']['message'] : 'Holiday closed' ?></span>
                            <?php }else{ ?>
                                <span class="store_time_span"><?php echo $store['timming']['message'] ?></span>
                            <?php } ?>	
							<?php if(isset($store['distance'])){ ?>
								<span class="store_distance font-weight-600"><?= $store['distance'] ?> MI</span>
							<?php } ?>							
						<div class="<?= 'store_modal_header_'.$store['id']; ?>" style="display:none;">
						 <div class="store-date-header"><span class="d-flex font-weight-bold font-size-32"><?= date("d"); ?></span><span class="d-flex store-month text-uppercase"><?= date("M"); ?></span></div>
						  <div class="media-body">	
								<h4 class="text-uppercase mt-0 mb-0 font-weight-600"><?= $store['name'] ?></h4>
								<span class="store_distance font-weight-600"><?= $store['distance'] ?> MI</span>
								<?php if($store['is_closed'] == '1'){ ?>
                                <span class="store_time_span"><strong class="text-pink">Closed</strong> | <?php echo $store['close_message'] != '' ? $store['close_message'] : 'Temporarily closed' ?></span>
                            <?php }else if($store['holiday']['is_holiday'] == true){ ?>
                                <span class="store_time_span"><strong class="text-pink">Closed</strong> | <?php echo $store['holiday']['message'] != '' ? $store['holiday']['message'] : 'Holiday closed' ?></span>
                            <?php }else{ ?>
                                <span class="store_time_span"><?php echo $store['timming']['message'] ?></span>
                            <?php } ?>
						  </div>
						  <button aria-hidden="true" data-dismiss="modal" class="close" type="button">×</button>
						 </div>
								  
						<div class="<?= 'store_modal_body_'.$store['id']; ?>" style="display:none;">	
						<?php if($store['additional_info'] != ''){ ?>
								<div class="row">
									<div class="col-12">
										<div class="mt-2 bg-light-grey p-3 rounded"> 
											<div class="media mb-2">
												<div class="mr-3">
													<i class="far fa-handshake"></i>
												</div>
												<div class="media-body">
													<h5 class="font-size-18 mt-0">WELCOME</h5>													
														<div class="lbg_details_content video">
															<?php echo $store['additional_info'] ?>
														</div>													
												</div>
											</div>
										</div>
									</div>
								</div>
								<?php } ?>
							<div class="row">
									<div class="col-12">
										<div class="mt-2 bg-light-grey p-3 rounded"> 
											<div class="media mb-2">
												<div class="mr-3">
													<i class="fas fa-align-justify"></i>
												</div>
												<div class="media-body">
													<h5 class="font-size-18 mt-0">BATTLEFIELD PARKWAY INFO</h5>
													<p class="text-secondary"><?= $store['description']; ?></p>
												</div>
											</div>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-12">
										<div class="mt-2 bg-light-grey p-3 rounded store-body-time-info"> 
											<div class="media mb-2">
												<div class="mr-3">
													<i class="fas fa-clock"></i>
												</div>
												<div class="media-body">
													<h5 class="font-size-18 mt-0">TIME</h5>
													<?php if($store['is_closed'] == '1' || $store['all_time']) {  ?>
													<ul class="timming">
														<?php if($store['is_closed'] == '1'){ ?>
															<li class="today">
																<strong class="text-pink">Closed</strong> | <?php echo $store['close_message'] != '' ? $store['close_message'] : 'Temporarily closed' ?>
															</li>
														<?php }else{ ?>
															<?php foreach ($store['all_time'] as $key => $all_time) { ?>
																<li class="<?php echo $all_time['day'] == date('N') ? "today" : '' ?>">
																	<span class="day_name"> <?php echo date('l', strtotime("Sunday +".$all_time['day']." days")) ?></span>
																	<span class="day_time">
																		<?php if($all_time['day'] == date('N')){ ?>
																			<?php if($store['holiday']['is_holiday'] == true){ ?>
																				Time not available
																			<?php } ?>
																		<?php } ?> 
																			<?php $times = json_decode($all_time['time'], true); ?>
																			<?php foreach ($times as $key => $time) { ?>
																				<?php if($time['to'] != '' && $time['from'] != ''){ ?>
																					<div><?php echo date('h:i A', strtotime($time['to'])).' - '.date('h:i A', strtotime($time['from'])) ?></div>
																				<?php } ?>
																			<?php } ?>
																		<?php //} ?>
																	</span>
																</li>
															<?php } } ?>	
													</ul>
													<?php } else { ?>
														<p class="text-secondary">Time not available</p>
													<?php } ?>
												</div>
											</div>
										</div>
									</div>																	
								</div>
								
								
								
								<div class="row">
									<div class="col-6 pr-2">
										<div class="mt-2 bg-light-grey p-3 rounded store-body-time-info"> 
											<div class="media mb-2">
												<div class="mr-3">
													<i class="fas fa-map-marker-alt"></i>
												</div>
												<div class="media-body">
													<h5 class="font-size-18 mt-0">LOCATION / <a class="text-dark" href="https://<?php echo $store['website'] ?>" target="_blank"><u>WEBSITE LINK</u></a></h5>													                        
													<p class="text-secondary"><?php echo $store['address'] ?> <?php echo $store['city'] ?> <?php echo $store['state'] ?> <?php echo $store['postal_code'] ?></p>
												</div>
											</div>
										</div>
									</div>	
									<div class="col-6 pl-2">
										<div class="mt-2 bg-light-grey p-3 rounded"> 
											<div class="media mb-2">
												<div class="mr-3">
													<i class="fas fa-location-arrow"></i>
												</div>
												<div class="media-body pb-3">
													<h5 class="font-size-18 mt-0">DIRECTIONS</h5>
													<ul class="direction-links" role="menu">
														<li class="d-block"><a class="text-secondary" onclick="newWindowOpen('https://www.google.com/maps/dir/?api=1&destination=<?php echo $store['latitude'] ?>,<?php echo $store['longitude'] ?>')" href="javascript:void(0)" id="google_dir"><i class="fa fa-external-link"></i> Google Maps Directions</a></li>
														<li class="d-block"><a class="text-secondary" onclick="newWindowOpen('https://www.bing.com/maps?rtp=~pos.<?php echo $store['latitude'] ?>_<?php echo $store['longitude'] ?>')" href="javascript:void(0)"><i class="fa fa-external-link"></i> Bing Maps Directions</a></li>
													</ul>
												</div>
											</div>
										</div>
									</div>
								</div>
								<?php if($store['twitter'] != '' || $store['youtube'] != '' || $store['linkedin'] != '' || $store['pinterest'] != '' || $store['facebook'] != ''){ ?>
								<div class="row">
									<div class="col-12">
										<div class="mt-2 bg-light-grey p-3 rounded"> 
											<div class="media mb-2">
												<div class="mr-3">
													<i class="fab fa-rocketchat"></i>
												</div>
												<div class="media-body">
													<h5 class="font-size-18 mt-0">SOCIAL LINKS</h5>
													<ul class="social-network social-circle">
													<?php if($store['twitter'] != ''){ ?>
														<li class="list-inline-item">
															<a href="javascript: void(0);" class="icoTwitter"><i class="fab fa-twitter"></i></a>
														</li>
													<?php } ?>
													<?php if($store['youtube'] != ''){ ?>
														<li class="list-inline-item">
															<a href="javascript: void(0);" class="icoYoutube"><i class="fab fa-youtube"></i></a>
														</li>
													<?php } ?>
													<?php if($store['linkedin'] != ''){ ?>
														<li class="list-inline-item">
															<a href="javascript: void(0);" class="icoLinkedin"><i class="fab fa-linkedin-in"></i></a>
														</li>
													<?php } ?>  
													<?php if($store['pinterest'] != ''){ ?>
														<li class="list-inline-item">
															<a href="javascript: void(0);" class="icoPinterest"><i class="fab fa-pinterest-p"></i></a>
														</li>
													<?php } ?>
													<?php if($store['facebook'] != ''){ ?>
														<li class="list-inline-item">
															<a href="javascript: void(0);" class="icoFacebook"><i class="fab fa-facebook-f"></i></a>
														</li>
													<?php } ?>
													</ul>
												</div>
											</div>
										</div>
									</div>
								</div>
								<?php } ?>
								<?php if($store['categories']){ ?>	
								<div class="row">
									<div class="col-12">
										<div class="mt-2 bg-light-grey p-3 rounded"> 
											<div class="media mb-2">
												<div class="mr-3">
													<i class="fas fa-tags"></i>
												</div>
												<div class="media-body">
													<h5 class="font-size-18 mt-0">CATEGORIES</h5>														
														<ul class="direction-links" role="menu">
															<?php foreach($store['categories'] as $category){ ?>
																<li class="d-block"><i class="<?php echo $category['icon'] ?>"></i> <?php echo $category['title'] ?></li>															
															<?php } ?>
														</ul>														
												</div>
											</div>
										</div>
									</div>
								</div>
								<?php } ?>
								<div class="row">
									<div class="col-12">
										<div class="mt-2 bg-light-grey p-3 rounded"> 
											<div class="media mb-2">
												<div class="mr-3">
													<i class="far fa-address-card"></i>
												</div>
												<div class="media-body">
													<h5 class="font-size-18 mt-0">CONTACT</h5>
													<?php if($store['phone'] != ''){ ?>
														<a href="tel:<?php echo $store['phone'] ?>" class="phone link d-block text-secondary"><i class="fa fa-phone-square"></i> <?php echo $store['phone'] ?></a>
													<?php } ?>

													<?php if($store['fax'] != ''){ ?>
														<a href="tel:<?php echo $store['fax'] ?>" class="fax link d-block text-secondary"><i class="fa fa-print"></i> <?php echo $store['fax'] ?></a>
													<?php } ?>  

													<?php if($store['email'] != ''){ ?>
														<a href="mailto:<?php echo $store['email'] ?>" class="email link d-block text-secondary"><i class="fa fa-envelope"></i> <?php echo $store['email'] ?></a>
													<?php } ?>
												</div>
											</div>
										</div>
									</div>
								</div>		
								
							</div>
								
						
						</div> <!-- gallery info -->
						
					</div> <!-- end store-box -->
				</div> <!-- end col -->
			
			
			
        <?php } ?>
    </div>
     <div class="result-options text-center">
	 <div class="store_loader mt-3" style="display:none">
        <img src="<?= base_url('assets/images/loader.gif')?>" style="width:50px;">
    </div>
    </div>
<?php } ?>