<!-- Start Content-->
<div class="container-fluid">
    
    <!-- start page title -->
            <?php $this->load->view('admin/common/breadcrumb', true); ?>
    <!-- end page title --> 

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="form-group row">
                        <div class="col-12 col-sm-3 col-md-3 col-lg-3">
                            <label for="category_id">By Category Name</label>
                            <select class="form-control select2 filter" id="category_id"></select>
                        </div>                        
                        <div class="col-12 col-sm-3 col-md-3 col-lg-3">
                            <label for="category">By Status</label>
                            <select class="form-control select2 filter" id="status_filter">
                                <option value="">Select Status</option>
                                <option value="0">Inactive</option>
                                <option value="1">Active</option>
                            </select>
                        </div>
                        <div class="col-12 col-sm-3 col-md-3 col-lg-3">
                            <label for="category">By Create Date</label>
                            <div class="input-group">
                                <input type="text" class="form-control filter datepicker"  id="date_filter" autocomplete="off">
                                <div class="input-group-append">
                                    <span class="input-group-text"><i class="ti-calendar"></i></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 col-sm-3 col-md-3 col-lg-3 mt-3">
                            <button class="btn btn-primary waves-effect waves-light" id="clear_filter">Clear Filters</button>
                        </div>
                    </div>
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-6">
                            <h4 class="header-title mb-4">
                                <?php echo $page_title; ?>
                            </h4>
                        </div>
                        <div class="col-6">
                            <a class="btn btn-primary waves-effect waves-light float-right" href="<?php echo base_url('admin/category/create') ?>">Add Category</a>
                        </div>
                    </div>
                    <table id="list-table" class="table dt-responsive nowrap">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Status</th>
                                <th>Create Date</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                    </table>
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>
    <!-- end row-->
</div>

<script type="text/javascript">
    
    jQuery('#category_id').select2({
        placeholder: '--- Select Category Name ---',
        ajax: {
          url: '<?php echo base_url('admin/category/searchCategoryByName'); ?>',
          dataType: 'json',
          delay: 250,
          processResults: function (data) {
            return {
              results: data
            };
          },
          cache: true
        }
    });

    $(document).on("change", ".filter", function(event) {  
        var ajaxdata = { 
            "category_id": $('#category_id').val(),
            "create_date": $('#date_filter').val(),
            "status": $('#status_filter').val(),
        };
        displayDataTableReport("#list-table", '<?php echo $ajax_data_url; ?>', ajaxdata);
    });
    jQuery(document).ready(function(e) {
        var ajaxdata = { 
            "category_id": $('#category_id').val(),
            "create_date": $('#date_filter').val(),
            "status": $('#status_filter').val(),
        };

        displayDataTableReport("#list-table", '<?php echo $ajax_data_url; ?>', ajaxdata);
        $('.datepicker').datepicker({
            autoclose: true,
            todayHighlight: true,
            format: 'dd/mm/yyyy'
        });

        $('#clear_filter').click(function(){
            location.reload(true);
        });
    });

</script>
