<?php
/*=================================================================================
			API Log Helpler
==================================================================================*/
if ( ! function_exists('request_log_file'))
{
	function request_log_file($data, $response){
		$actual_link = "http://".$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
        //Write action to txt log
		$log  = "Request From: ".$_SERVER['REMOTE_ADDR'].' - '.date("F j, Y, g:i a").PHP_EOL.
				"Device Type : ".$_SERVER['HTTP_USER_AGENT'].PHP_EOL.
                "Request Url: ".$actual_link.PHP_EOL.
                "Request: ".json_encode($data).PHP_EOL.
                "Response: ".json_encode($response).PHP_EOL.
                "-------------------------".PHP_EOL;
        file_put_contents(LOG_PATH.'/log_'.date("j.n.Y").'.txt', $log, FILE_APPEND);
	}
}
if ( ! function_exists('request_log'))
{
	function request_log($data, $response){
		$protocol = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off') ? 'https://' : 'http://';
		$ci =& get_instance();
		$ci->load->database();
		$data = array(
			'request_from' => $_SERVER['REMOTE_ADDR'].' - '.date("F j, Y, g:i a"),
			'request_url' => $protocol.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'],
			'device_type' => $_SERVER['HTTP_USER_AGENT'],
			'request' => json_encode($data),
			'response' => json_encode($response),
			'date' => date('y-m-d H:i:s')
		);
		$insertLog = $ci->db->insert('api_log', $data);
	}
}
if ( ! function_exists('getLogo'))
{
	function getLogo(){
		$ci =& get_instance();
		$ci->load->database();
		$query = $ci->db->select('*')->from(TBL_SETTING)->where('name', 'site_logo')->get()->row_array();
		
		return $query['value'];
	}
}
if ( ! function_exists('time_elapsed_string'))
{
	function time_elapsed_string($datetime, $full = false) {
		$now = new DateTime;
		$ago = new DateTime($datetime);
		$diff = $now->diff($ago);
		$diff->w = floor($diff->d / 7);
		$diff->d -= $diff->w * 7;
		$string = array(
			'y' => 'year',
			'm' => 'month',
			'w' => 'week',
			'd' => 'day',
			'h' => 'hour',
			'i' => 'minute',
			's' => 'second',
		);
		foreach ($string as $k => &$v) {
			if ($diff->$k) {
				$v = $diff->$k . ' ' . $v . ($diff->$k > 1 ? 's' : '');
			} else {
				unset($string[$k]);
			}
		}
		if (!$full) $string = array_slice($string, 0, 1);
		return $string ? implode(', ', $string) . ' ago' : 'just now';
	}
}
if ( ! function_exists('encryption'))
{
	function encryption($code){
		return base64_encode(time().'|'.$code.'|'.time());
	}
}
if ( ! function_exists('decryption'))
{
	function decryption($code){
		$codeEncrypted = explode('|', base64_decode($code));
		return $codeEncrypted[1];
	}
}
if ( ! function_exists('dd'))
{
	function dd($data, $exit = true){
		echo "<pre>"; 
			print_r($data);
		echo "</pre>";
		if($exit){
			die;
		}
	}
}
if ( ! function_exists('base64ToImage'))
{
	function base64ToImage($base64imageString, $folderPath){
		$uploadPath = UPLOAD_PATH.$folderPath;
		
		if (!is_dir($uploadPath)) {
			mkdir($uploadPath, 0777, TRUE);
		}
		$image_parts = str_replace('data:image/png;base64,', '', $base64imageString);
		$image_base64 = base64_decode($image_parts);
		// create file name
		$fileName = date('YmdHis'). '.png';
		$file = $uploadPath . $fileName;
		// store path in DB
		$image = $fileName;
		$uploadImage = file_put_contents($file, $image_base64);
		$imageToStore = $folderPath.$image;
		return $imageToStore;
	}
}
