<?php
/**
 * Server Diagnostic Script for Coupon Form Issue
 * 
 * Upload this as a separate file (e.g., server_test.php) in your /public/ directory
 * Access it at: https://ringgoldroad.com/server_test.php
 */

header('Content-Type: text/html; charset=UTF-8');
?>
<!DOCTYPE html>
<html>
<head>
    <title>Server Diagnostic Test</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .test { margin: 10px 0; padding: 10px; border: 1px solid #ccc; }
        .pass { background: #d4edda; border-color: #c3e6cb; }
        .fail { background: #f8d7da; border-color: #f5c6cb; }
        .info { background: #d1ecf1; border-color: #bee5eb; }
        pre { background: #f8f9fa; padding: 10px; overflow-x: auto; }
        form { margin: 10px 0; }
    </style>
</head>
<body>
    <h1>Server Diagnostic Test</h1>
    
    <?php
    
    // Test 1: Basic PHP and Server Info
    echo '<div class="test info">';
    echo '<h3>Test 1: Server Environment</h3>';
    echo '<strong>PHP Version:</strong> ' . PHP_VERSION . '<br>';
    echo '<strong>Server Software:</strong> ' . ($_SERVER['SERVER_SOFTWARE'] ?? 'Unknown') . '<br>';
    echo '<strong>Document Root:</strong> ' . $_SERVER['DOCUMENT_ROOT'] . '<br>';
    echo '<strong>Current Script:</strong> ' . $_SERVER['SCRIPT_NAME'] . '<br>';
    echo '<strong>Request Method:</strong> ' . $_SERVER['REQUEST_METHOD'] . '<br>';
    echo '<strong>Request URI:</strong> ' . $_SERVER['REQUEST_URI'] . '<br>';
    echo '</div>';
    
    // Test 2: POST Request Test
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        echo '<div class="test pass">';
        echo '<h3>✓ POST Request Received Successfully</h3>';
        echo '<strong>POST Data:</strong><br>';
        echo '<pre>' . print_r($_POST, true) . '</pre>';
        echo '<strong>Raw Input:</strong><br>';
        echo '<pre>' . file_get_contents('php://input') . '</pre>';
        echo '</div>';
    } else {
        echo '<div class="test info">';
        echo '<h3>Test 2: POST Request Test</h3>';
        echo '<p>Submit the form below to test POST functionality:</p>';
        echo '<form method="post" action="' . $_SERVER['PHP_SELF'] . '">';
        echo '<input type="hidden" name="test_field" value="test_value">';
        echo '<input type="text" name="sample_input" value="Sample data" placeholder="Test input">';
        echo '<button type="submit">Test POST Request</button>';
        echo '</form>';
        echo '</div>';
    }
    
    // Test 3: URL Rewriting and htaccess
    echo '<div class="test info">';
    echo '<h3>Test 3: URL Rewriting Test</h3>';
    if (function_exists('apache_get_modules')) {
        $modules = apache_get_modules();
        $mod_rewrite = in_array('mod_rewrite', $modules);
        echo '<strong>mod_rewrite enabled:</strong> ' . ($mod_rewrite ? 'Yes' : 'No') . '<br>';
    } else {
        echo '<strong>Apache modules:</strong> Cannot determine (not running Apache or no access)<br>';
    }
    
    // Test if .htaccess is working
    $htaccess_test = file_exists('.htaccess');
    echo '<strong>.htaccess file exists:</strong> ' . ($htaccess_test ? 'Yes' : 'No') . '<br>';
    
    if ($htaccess_test) {
        echo '<strong>.htaccess content preview:</strong><br>';
        $htaccess_content = file_get_contents('.htaccess');
        echo '<pre>' . htmlspecialchars(substr($htaccess_content, 0, 500)) . '...</pre>';
    }
    echo '</div>';
    
    // Test 4: CodeIgniter Route Simulation
    echo '<div class="test info">';
    echo '<h3>Test 4: Route Pattern Tests</h3>';
    echo '<p>Testing various URL patterns that might be blocked:</p>';
    
    $test_urls = [
        'business/test',
        'business/coupons/test', 
        'business/coupons/create',
        'test/simple/path'
    ];
    
    foreach ($test_urls as $url) {
        $url_id = md5($url);
        echo '<p><strong>' . $url . ':</strong> ';
        echo '<a href="#" onclick="testUrl(\'' . $url . '\', \'' . $url_id . '\'); return false;">Test GET</a> | ';
        echo '<a href="#" onclick="testPostUrl(\'' . $url . '\', \'' . $url_id . '\'); return false;">Test POST</a>';
        echo ' <span id="result_' . $url_id . '"></span></p>';
    }
    echo '</div>';
    
    // Test 5: Security Headers and Restrictions
    echo '<div class="test info">';
    echo '<h3>Test 5: Security Headers</h3>';
    $headers = getallheaders();
    if ($headers) {
        echo '<pre>' . print_r($headers, true) . '</pre>';
    } else {
        echo 'Cannot retrieve headers<br>';
    }
    echo '</div>';
    
    // Test 6: File Permissions
    echo '<div class="test info">';
    echo '<h3>Test 6: File System Tests</h3>';
    $test_file = 'test_write_' . time() . '.txt';
    $write_test = file_put_contents($test_file, 'test');
    echo '<strong>Can write files:</strong> ' . ($write_test ? 'Yes' : 'No') . '<br>';
    if ($write_test) {
        unlink($test_file);
    }
    
    echo '<strong>Current directory:</strong> ' . getcwd() . '<br>';
    echo '<strong>Directory writable:</strong> ' . (is_writable('.') ? 'Yes' : 'No') . '<br>';
    echo '</div>';
    
    // Test 7: CodeIgniter Specific Tests
    echo '<div class="test info">';
    echo '<h3>Test 7: CodeIgniter Framework Test</h3>';
    
    // Check if we can include CodeIgniter
    $ci_path = '../app/Controllers/Business/Coupons.php';
    echo '<strong>Coupons controller file exists:</strong> ' . (file_exists($ci_path) ? 'Yes' : 'No') . '<br>';
    
    if (file_exists($ci_path)) {
        echo '<strong>Controller file readable:</strong> ' . (is_readable($ci_path) ? 'Yes' : 'No') . '<br>';
        echo '<strong>Controller file size:</strong> ' . filesize($ci_path) . ' bytes<br>';
    }
    
    // Test session functionality
    if (!session_id()) session_start();
    $_SESSION['test'] = 'working';
    echo '<strong>Session test:</strong> ' . ($_SESSION['test'] === 'working' ? 'Working' : 'Failed') . '<br>';
    echo '</div>';
    
    ?>
    
    <script>
    function testUrl(url, urlId) {
        const fullUrl = window.location.origin + '/' + url;
        fetch(fullUrl, {method: 'GET'})
            .then(response => {
                const element = document.getElementById('result_' + urlId);
                if (element) {
                    element.innerHTML = 'GET: ' + response.status + ' ' + response.statusText;
                    element.style.color = response.ok ? 'green' : 'red';
                }
            })
            .catch(error => {
                const element = document.getElementById('result_' + urlId);
                if (element) {
                    element.innerHTML = 'GET: Error - ' + error.message;
                    element.style.color = 'red';
                }
            });
    }
    
    function testPostUrl(url, urlId) {
        const fullUrl = window.location.origin + '/' + url;
        fetch(fullUrl, {
            method: 'POST',
            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: 'test=data'
        })
            .then(response => {
                const element = document.getElementById('result_' + urlId);
                if (element) {
                    const existing = element.innerHTML;
                    element.innerHTML = existing + ' | POST: ' + response.status + ' ' + response.statusText;
                }
            })
            .catch(error => {
                const element = document.getElementById('result_' + urlId);
                if (element) {
                    const existing = element.innerHTML;
                    element.innerHTML = existing + ' | POST: Error - ' + error.message;
                }
            });
    }
    </script>
    
    <div class="test info">
        <h3>Instructions</h3>
        <p>1. Save the results of all tests above</p>
        <p>2. Click the "Test GET" and "Test POST" links to test different URL patterns</p>
        <p>3. Pay special attention to any 403 Forbidden errors on specific patterns</p>
        <p>4. If you see patterns that work vs. patterns that don't, that indicates server-level blocking</p>
        <p>5. Use this information when contacting your hosting provider</p>
    </div>
    
</body>
</html>