<?php
/**
 * Add Tools Link to Admin Navigation
 * Save this file as: public/add_tools_nav.php
 * Access it via: yourdomain.com/add_tools_nav.php
 * DELETE THIS FILE after running!
 */

// Security check - you might want to add your own security here
if (!isset($_GET['confirm']) || $_GET['confirm'] !== 'yes') {
    ?>
    <!DOCTYPE html>
    <html>
    <head>
        <title>Add Tools Navigation</title>
        <style>
            body { font-family: Arial, sans-serif; padding: 40px; background: #f5f5f5; }
            .container { max-width: 600px; margin: 0 auto; background: white; padding: 30px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
            h1 { color: #333; }
            .btn { display: inline-block; padding: 10px 20px; background: #667eea; color: white; text-decoration: none; border-radius: 5px; margin-top: 20px; }
            .btn:hover { background: #5a67d8; }
            .warning { background: #fff3cd; border: 1px solid #ffeaa7; padding: 15px; border-radius: 5px; margin: 20px 0; }
            .success { background: #d4edda; border: 1px solid #c3e6cb; padding: 15px; border-radius: 5px; margin: 20px 0; }
            .error { background: #f8d7da; border: 1px solid #f5c6cb; padding: 15px; border-radius: 5px; margin: 20px 0; }
            code { background: #f8f9fa; padding: 2px 5px; border-radius: 3px; }
        </style>
    </head>
    <body>
        <div class="container">
            <h1>Add Tools Link to Admin Navigation</h1>
            <p>This script will add the Tools navigation link to your admin dashboard.</p>
            
            <div class="warning">
                <strong>⚠️ Important:</strong> This script will modify your admin view files. A backup will be created.
            </div>
            
            <p>The script will:</p>
            <ul>
                <li>Add a "Tools" link to the admin navigation menu</li>
                <li>Create a backup of the modified file</li>
                <li>Only update the dashboard.php file</li>
            </ul>
            
            <a href="?confirm=yes" class="btn">Run Script</a>
        </div>
    </body>
    </html>
    <?php
    exit;
}

// Script execution starts here
?>
<!DOCTYPE html>
<html>
<head>
    <title>Adding Tools Navigation</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 40px; background: #f5f5f5; }
        .container { max-width: 800px; margin: 0 auto; background: white; padding: 30px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        h1 { color: #333; }
        .success { background: #d4edda; border: 1px solid #c3e6cb; padding: 15px; border-radius: 5px; margin: 20px 0; color: #155724; }
        .error { background: #f8d7da; border: 1px solid #f5c6cb; padding: 15px; border-radius: 5px; margin: 20px 0; color: #721c24; }
        .info { background: #d1ecf1; border: 1px solid #bee5eb; padding: 15px; border-radius: 5px; margin: 20px 0; color: #0c5460; }
        pre { background: #f8f9fa; padding: 15px; border-radius: 5px; overflow-x: auto; }
        .btn { display: inline-block; padding: 10px 20px; background: #28a745; color: white; text-decoration: none; border-radius: 5px; margin-top: 10px; }
        .btn-danger { background: #dc3545; }
        .btn:hover { opacity: 0.9; }
    </style>
</head>
<body>
    <div class="container">
        <h1>Adding Tools Navigation Link</h1>
        
        <?php
        $dashboardFile = '../app/Views/admin/dashboard.php';
        $backupFile = '../app/Views/admin/dashboard_backup_' . date('Y-m-d_His') . '.php';
        
        // Check if dashboard file exists
        if (!file_exists($dashboardFile)) {
            ?>
            <div class="error">
                <strong>Error:</strong> Dashboard file not found at: <code><?php echo $dashboardFile; ?></code>
            </div>
            <?php
            exit;
        }
        
        // Read the dashboard file
        $content = file_get_contents($dashboardFile);
        
        // Check if Tools link already exists
        if (strpos($content, '/admin/tools') !== false) {
            ?>
            <div class="info">
                <strong>Info:</strong> The Tools link already exists in the navigation. No changes needed.
            </div>
            <a href="/admin/tools" class="btn">Go to Tools</a>
            <?php
            exit;
        }
        
        // Create backup
        if (copy($dashboardFile, $backupFile)) {
            ?>
            <div class="success">
                <strong>✓ Backup created:</strong> <?php echo basename($backupFile); ?>
            </div>
            <?php
        } else {
            ?>
            <div class="error">
                <strong>Error:</strong> Could not create backup. Please check file permissions.
            </div>
            <?php
            exit;
        }
        
        // Find and replace - add Tools link after Categories
        $toolsLink = '                <a href="/admin/tools">
                    <i class="fas fa-tools"></i> Tools
                </a>';
        
        // Look for the categories link and add tools after it
        $pattern = '/(<a href="\/admin\/categories".*?<\/a>)/s';
        $replacement = '$1' . "\n" . $toolsLink;
        
        $newContent = preg_replace($pattern, $replacement, $content, 1, $count);
        
        if ($count > 0) {
            // Write the updated content
            if (file_put_contents($dashboardFile, $newContent)) {
                ?>
                <div class="success">
                    <strong>✓ Success!</strong> The Tools link has been added to the admin navigation.
                </div>
                
                <div class="info">
                    <strong>What was added:</strong>
                    <pre><?php echo htmlspecialchars($toolsLink); ?></pre>
                </div>
                
                <p>You can now access the Tools section from the admin navigation menu.</p>
                
                <a href="/admin/tools" class="btn">Go to Tools</a>
                <a href="/admin/dashboard" class="btn">Go to Dashboard</a>
                
                <div class="error" style="margin-top: 30px;">
                    <strong>⚠️ Security Warning:</strong> Please delete this script file now!
                    <br><br>
                    <code>Delete: public/add_tools_nav.php</code>
                </div>
                <?php
            } else {
                ?>
                <div class="error">
                    <strong>Error:</strong> Could not write to dashboard file. Please check file permissions.
                </div>
                <?php
            }
        } else {
            ?>
            <div class="error">
                <strong>Error:</strong> Could not find the navigation section in the dashboard file. 
                The file structure may be different than expected.
            </div>
            
            <div class="info">
                <strong>Manual Solution:</strong> Add this code after the Categories link in your dashboard.php:
                <pre><?php echo htmlspecialchars($toolsLink); ?></pre>
            </div>
            <?php
        }
        ?>
        
        <div class="info" style="margin-top: 30px;">
            <strong>Direct Access:</strong> You can always access Tools directly at: 
            <a href="/admin/tools">/admin/tools</a>
        </div>
    </div>
</body>
</html>