<?php if (isset($store)) : ?>
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
<div class="modal-header text-white" style="background-color: rgb(75, 181, 216);">
  <div class="d-flex flex-column">
    <h4 class="modal-title text-uppercase fw-bold mb-1"><?php echo esc($store['name']); ?></h4>
    <small class="text-white">
      <?php if (!empty($store['distance'])) : ?>
        <?= number_format($store['distance'], 2) ?> MI |
      <?php endif; ?>
      
      <?php if (isset($store['is_closed']) && $store['is_closed'] == '1') : ?>
        <span class="badge bg-danger me-2">
          <i class="fas fa-bed"></i> CLOSED
        </span>
        <?php 
        // Show natural language next opening instead of generic close message
        $nextOpenMsg = $store['next_open'] ?? 'Hours not available';
        echo $nextOpenMsg;
        ?>
      <?php elseif (isset($store['holiday']['is_holiday']) && $store['holiday']['is_holiday']) : ?>
        <span class="badge bg-warning text-dark me-2">
          <i class="fas fa-calendar-times"></i> HOLIDAY
        </span>
        <?= !empty($store['holiday']['message']) ? esc($store['holiday']['message']) : 'Holiday closed'; ?>
      <?php else : ?>
        <?php
        // Display real-time status with proper badges
        $statusMessage = $store['timming']['message'] ?? '';
        if (strpos($statusMessage, 'Open') !== false && strpos($statusMessage, 'Closing Soon') === false) {
          echo '<span class="badge bg-success me-2"><i class="fas fa-check-circle"></i> OPEN</span>';
          echo '<strong class="text-success">' . esc($statusMessage) . '</strong>';
        } elseif (strpos($statusMessage, 'Closing Soon') !== false) {
          echo '<span class="badge bg-warning text-dark me-2"><i class="fas fa-exclamation-triangle"></i> CLOSING SOON</span>';
          echo '<strong class="text-warning">' . esc($statusMessage) . '</strong>';
        } else {
          echo '<span class="badge bg-danger me-2"><i class="fas fa-bed"></i> CLOSED</span>';
          // Show natural language next opening
          $nextOpenMsg = $store['next_open'] ?? 'Hours not available';
          echo '<strong class="text-muted">' . esc($nextOpenMsg) . '</strong>';
        }
        ?>
      <?php endif; ?>
    </small>
  </div>
  <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
</div>

<div class="modal-body">
  <?php if (!empty($store['image'])) : ?>
    <div class="mb-3">
      <img src="<?= esc($store['image']) ?>" class="img-fluid rounded w-100" alt="Store Image">
    </div>
  <?php endif; ?>

  <div class="mb-3 p-3 bg-light rounded">
    <h5><i class="fas fa-handshake me-2"></i>Welcome</h5>
    
    <?php 
    // Check if additional_info contains a Vimeo video ID (numeric)
    $vimeoId = null;
    $welcomeText = '';
    
    if (!empty($store['additional_info'])) {
      $additionalInfo = trim($store['additional_info']);
      
      // Check if it's purely numeric (Vimeo ID)
      if (is_numeric($additionalInfo)) {
        $vimeoId = $additionalInfo;
      } 
      // Check if it contains a Vimeo URL and extract ID
      elseif (preg_match('/(?:vimeo\.com\/|player\.vimeo\.com\/video\/)(\d+)/', $additionalInfo, $matches)) {
        $vimeoId = $matches[1];
      }
      // Check if it's just the ID with some extra text
      elseif (preg_match('/(\d{8,})/', $additionalInfo, $matches)) {
        $vimeoId = $matches[1];
        // Keep any non-numeric text as welcome message
        $welcomeText = trim(preg_replace('/\d{8,}/', '', $additionalInfo));
      }
      else {
        // No video ID found, treat as welcome text
        $welcomeText = $additionalInfo;
      }
    }
    ?>
    
    <?php if ($vimeoId) : ?>
      <div class="mb-3">
        <div class="ratio ratio-16x9">
          <iframe 
            src="https://player.vimeo.com/video/<?= esc($vimeoId) ?>?badge=0&amp;autopause=0&amp;player_id=0&amp;app_id=58479" 
            frameborder="0" 
            allow="autoplay; fullscreen; picture-in-picture; clipboard-write; encrypted-media; web-share" 
            title="Welcome Video"
            class="rounded">
          </iframe>
        </div>
      </div>
    <?php endif; ?>
    
    <?php if (!empty($welcomeText)) : ?>
      <div><?= nl2br(esc($welcomeText)) ?></div>
    <?php endif; ?>
  </div>

  <?php if (!empty($store['coupon'])) : ?>
    <div class="mb-3 p-3 bg-success bg-opacity-10 border border-success rounded">
      <h5><i class="fas fa-ticket-alt me-2 text-success"></i>Special Offer!</h5>
      <div class="d-flex align-items-center mb-2">
        <span class="badge bg-success fs-5 me-3"><?= esc($store['coupon']['discount_display']) ?></span>
        <h6 class="mb-0 fw-bold"><?= esc($store['coupon']['title']) ?></h6>
      </div>
      <p class="mb-2"><?= esc($store['coupon']['description']) ?></p>
      <?php if ($store['coupon']['minimum_purchase']) : ?>
        <p class="mb-2 small"><strong>Minimum Purchase:</strong> $<?= number_format($store['coupon']['minimum_purchase'], 2) ?></p>
      <?php endif; ?>
      <div class="d-flex justify-content-between align-items-center">
        <small class="text-muted">
          Valid until <?= date('M d, Y', strtotime($store['coupon']['expires_at'])) ?>
          <?php if ($store['coupon']['days_remaining'] <= 7) : ?>
            <span class="badge bg-warning text-dark ms-2">
              <i class="fas fa-clock"></i> <?= $store['coupon']['days_remaining'] ?> days left
            </span>
          <?php endif; ?>
        </small>
        <?php /* Commented out until usage tracking is implemented
        <?php if (isset($store['coupon']['usage_remaining']) && $store['coupon']['usage_remaining'] !== null) : ?>
          <small class="text-muted">
            <i class="fas fa-users"></i> <?= $store['coupon']['usage_remaining'] ?> uses left
          </small>
        <?php endif; ?>
        */ ?>
      </div>
    </div>
  <?php endif; ?>

  <?php if (!empty($store['active_jobs'])) : ?>
    <div class="mb-3 p-3 bg-primary bg-opacity-10 border border-primary rounded">
      <h5><i class="fas fa-briefcase me-2 text-primary"></i>Now Hiring!</h5>
      <?php foreach ($store['active_jobs'] as $index => $job) : ?>
        <div class="job-item <?= $index > 0 ? 'mt-3 pt-3 border-top' : '' ?>">
          <div class="d-flex justify-content-between align-items-start mb-2">
            <div class="flex-grow-1">
              <h6 class="mb-1 fw-bold"><?= esc($job['title']) ?></h6>
              <div class="d-flex gap-2 mb-2">
                <span class="badge bg-primary"><?= esc($job['employment_type_display']) ?></span>
                <span class="badge bg-success"><?= esc($job['salary_display']) ?></span>
              </div>
            </div>
            <small class="text-muted">Posted <?= esc($job['posted_date']) ?></small>
          </div>
          
          <p class="mb-2 text-muted small">
            <?= esc(strlen($job['description']) > 150 ? substr($job['description'], 0, 150) . '...' : $job['description']) ?>
          </p>
          
          <div class="d-flex align-items-center">
            <small class="text-muted">
              <i class="fas fa-envelope me-1"></i>
              <?= esc($job['contact_method_display']) ?>
            </small>
            <?php if ($job['contact_method'] === 'online' && !empty($job['contact_value'])) : ?>
              <a href="<?= esc($job['contact_value']) ?>" target="_blank" class="btn btn-sm btn-primary ms-auto">
                <i class="fas fa-external-link-alt me-1"></i> Apply Now
              </a>
            <?php endif; ?>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  <?php endif; ?>

  <div class="mb-3 p-3 bg-light rounded">
    <h5><i class="fas fa-info-circle me-2"></i>About</h5>
    <div class="text-muted"><?= $store['description'] ?></div>
  </div>

  <?php if (!empty($store['all_time'])) : ?>
    <?php 
    // Check if business is closing soon (extract from status message)
    $statusMessage = $store['timming']['message'] ?? '';
    $isClosingSoon = (strpos($statusMessage, 'Closing Soon') !== false);
    $tableClass = $isClosingSoon ? 'table-warning' : '';
    ?>
    <div class="mb-3 p-3 bg-light rounded">
      <h5><i class="fas fa-clock me-2"></i>Hours of Operation
        <?php if ($isClosingSoon) : ?>
          <small class="badge bg-warning text-dark ms-2">
            <i class="fas fa-exclamation-triangle"></i> Closing Soon
          </small>
        <?php endif; ?>
      </h5>
      
      <div class="table-responsive">
        <table class="table table-sm mb-0 <?= $tableClass ?>">
          <thead class="table-dark">
            <tr>
              <th scope="col" style="width: 30%;">Day</th>
              <th scope="col">Hours</th>
            </tr>
          </thead>
          <tbody>
            <?php 
            $currentDay = date('N'); // 1 = Monday, 7 = Sunday
            $dayNames = [
              1 => 'Monday', 2 => 'Tuesday', 3 => 'Wednesday', 4 => 'Thursday',
              5 => 'Friday', 6 => 'Saturday', 7 => 'Sunday'
            ];
            $rowIndex = 0;
            ?>
            <?php foreach ($store['all_time'] as $time) : ?>
              <?php 
              $isToday = ($time['day'] == $currentDay);
              $dayName = $dayNames[$time['day']] ?? 'Unknown';
              $rowClass = '';
              
              // Check if this day is closed (no valid time slots)
              $timeSlots = json_decode($time['time'], true);
              $isDayClosed = empty($timeSlots) || !array_filter($timeSlots, function($slot) {
                return !empty($slot['to']) && !empty($slot['from']);
              });
              
              if ($isToday) {
                if ($isDayClosed) {
                  $rowClass = 'table-secondary fw-bold'; // Gray for closed today
                } else {
                  $rowClass = $isClosingSoon ? 'table-danger fw-bold' : 'table-primary fw-bold';
                }
              } else {
                if ($isDayClosed) {
                  $rowClass = ($rowIndex % 2 == 0) ? 'table-secondary bg-opacity-50' : 'table-secondary bg-opacity-25';
                } else {
                  $rowClass = ($rowIndex % 2 == 0) ? 'table-light' : '';
                }
              }
              $rowIndex++;
              ?>
              <tr class="<?= $rowClass ?>">
                <td class="<?= $isToday ? 'fw-bold' : '' ?> <?= $isDayClosed ? 'text-muted' : '' ?>">
                  <?= $dayName ?>
                  <?php if ($isToday) : ?>
                    <?php if ($isDayClosed) : ?>
                      <small class="badge bg-secondary ms-1">Closed Today</small>
                    <?php else : ?>
                      <small class="badge bg-<?= $isClosingSoon ? 'danger' : 'primary' ?> ms-1">Today</small>
                    <?php endif; ?>
                  <?php endif; ?>
                </td>
                <td class="<?= $isToday ? 'fw-bold' : '' ?> <?= $isDayClosed ? 'text-muted fst-italic' : '' ?>">
                  <?php
                  // Use the new formatted display text if available, otherwise fall back to old logic
                  if (isset($time['display_text'])) {
                    // Check if there are multiple time slots (breaks)
                    $timeSlots = json_decode($time['time'], true);
                    if (!empty($timeSlots) && count($timeSlots) > 1) {
                      // Multiple slots - display on separate lines with break note
                      $hasMultipleSlots = false;
                      foreach ($timeSlots as $index => $slot) {
                        if (!empty($slot['to']) && !empty($slot['from'])) {
                          if ($hasMultipleSlots) {
                            echo '<br><small class="text-muted fst-italic">(Reopens at time below)</small><br>';
                          }
                          echo '<strong>' . date('g:i A', strtotime($slot['to'])) . ' - ' . date('g:i A', strtotime($slot['from'])) . '</strong>';
                          $hasMultipleSlots = true;
                        }
                      }
                    } else {
                      // Single slot or using display_text
                      echo esc($time['display_text']);
                    }
                  } else {
                    // Fallback to old formatting for backward compatibility
                    $timeSlots = json_decode($time['time'], true);
                    if (!empty($timeSlots)) {
                      if (count($timeSlots) > 1) {
                        // Multiple slots - display on separate lines
                        $hasMultipleSlots = false;
                        foreach ($timeSlots as $slot) {
                          if (!empty($slot['to']) && !empty($slot['from'])) {
                            if ($hasMultipleSlots) {
                              echo '<br><small class="text-muted fst-italic">(Reopens at time below)</small><br>';
                            }
                            echo '<strong>' . date('g:i A', strtotime($slot['to'])) . ' - ' . date('g:i A', strtotime($slot['from'])) . '</strong>';
                            $hasMultipleSlots = true;
                          }
                        }
                      } else {
                        // Single slot
                        $displayTimes = [];
                        foreach ($timeSlots as $slot) {
                          if (!empty($slot['to']) && !empty($slot['from'])) {
                            $displayTimes[] = date('g:i A', strtotime($slot['to'])) . ' - ' . date('g:i A', strtotime($slot['from']));
                          }
                        }
                        echo !empty($displayTimes) ? implode(', ', $displayTimes) : 'Closed';
                      }
                    } else {
                      echo '<span class="badge bg-secondary"><i class="fas fa-bed"></i> Closed</span>';
                    }
                  }
                  ?>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  <?php endif; ?>

  <?php if (!empty($store['moreHours'])) : ?>
    <?php foreach ($store['moreHours'] as $serviceName => $hours) : ?>
      <?php 
      // Check if this service is closing soon by checking status message for service name
      $statusMessage = $store['timming']['message'] ?? '';
      $isServiceClosingSoon = (strpos($statusMessage, 'Closing Soon') !== false && strpos($statusMessage, $serviceName) !== false);
      $tableClass = $isServiceClosingSoon ? 'table-warning' : '';
      ?>
      <div class="mb-3 p-3 bg-light rounded">
        <h5><i class="fas fa-clock me-2"></i><?= esc($serviceName) ?> Hours
          <?php if ($isServiceClosingSoon) : ?>
            <small class="badge bg-warning text-dark ms-2">
              <i class="fas fa-exclamation-triangle"></i> Closing Soon
            </small>
          <?php endif; ?>
        </h5>
        
        <div class="table-responsive">
          <table class="table table-sm mb-0 <?= $tableClass ?>">
            <thead class="table-dark">
              <tr>
                <th scope="col" style="width: 30%;">Day</th>
                <th scope="col">Hours</th>
              </tr>
            </thead>
            <tbody>
              <?php 
              $currentDay = date('N');
              $dayNames = [
                1 => 'Monday', 2 => 'Tuesday', 3 => 'Wednesday', 4 => 'Thursday',
                5 => 'Friday', 6 => 'Saturday', 7 => 'Sunday'
              ];
              $rowIndex = 0;
              ?>
              <?php foreach ($hours as $dayNum => $dayData) : ?>
                <?php 
                $isToday = ($dayNum == $currentDay);
                $dayName = $dayNames[$dayNum] ?? 'Unknown';
                $rowClass = '';
                
                // Check if this service day is closed
                $isDayClosed = empty($dayData['time']) || !array_filter($dayData['time'], function($slot) {
                  return !empty($slot['to']) && !empty($slot['from']);
                });
                
                if ($isToday) {
                  if ($isDayClosed) {
                    $rowClass = 'table-secondary fw-bold'; // Gray for closed today
                  } else {
                    $rowClass = $isServiceClosingSoon ? 'table-danger fw-bold' : 'table-primary fw-bold';
                  }
                } else {
                  if ($isDayClosed) {
                    $rowClass = ($rowIndex % 2 == 0) ? 'table-secondary bg-opacity-50' : 'table-secondary bg-opacity-25';
                  } else {
                    $rowClass = ($rowIndex % 2 == 0) ? 'table-light' : '';
                  }
                }
                $rowIndex++;
                ?>
                <tr class="<?= $rowClass ?>">
                  <td class="<?= $isToday ? 'fw-bold' : '' ?> <?= $isDayClosed ? 'text-muted' : '' ?>">
                    <?= $dayName ?>
                    <?php if ($isToday) : ?>
                      <?php if ($isDayClosed) : ?>
                        <small class="badge bg-secondary ms-1">Closed Today</small>
                      <?php else : ?>
                        <small class="badge bg-<?= $isServiceClosingSoon ? 'danger' : 'primary' ?> ms-1">Today</small>
                      <?php endif; ?>
                    <?php endif; ?>
                  </td>
                  <td class="<?= $isToday ? 'fw-bold' : '' ?> <?= $isDayClosed ? 'text-muted fst-italic' : '' ?>">
                    <?php
                    // Use the new formatted display text if available
                    if (isset($dayData['display_text'])) {
                      // Check if there are multiple time slots for this service
                      if (!empty($dayData['time']) && count($dayData['time']) > 1) {
                        // Multiple slots - display on separate lines with break note
                        $hasMultipleSlots = false;
                        foreach ($dayData['time'] as $slot) {
                          if (!empty($slot['to']) && !empty($slot['from'])) {
                            if ($hasMultipleSlots) {
                              echo '<br><small class="text-muted fst-italic">(Reopens at time below)</small><br>';
                            }
                            echo '<strong>' . date('g:i A', strtotime($slot['to'])) . ' - ' . date('g:i A', strtotime($slot['from'])) . '</strong>';
                            $hasMultipleSlots = true;
                          }
                        }
                      } else {
                        // Single slot or using display_text
                        echo esc($dayData['display_text']);
                      }
                    } else {
                      // Fallback to old formatting for backward compatibility
                      if (!empty($dayData['time'])) {
                        if (count($dayData['time']) > 1) {
                          // Multiple slots - display on separate lines
                          $hasMultipleSlots = false;
                          foreach ($dayData['time'] as $slot) {
                            if (!empty($slot['to']) && !empty($slot['from'])) {
                              if ($hasMultipleSlots) {
                                echo '<br><small class="text-muted fst-italic">(Reopens at time below)</small><br>';
                              }
                              echo '<strong>' . date('g:i A', strtotime($slot['to'])) . ' - ' . date('g:i A', strtotime($slot['from'])) . '</strong>';
                              $hasMultipleSlots = true;
                            }
                          }
                        } else {
                          // Single slot
                          $displayTimes = [];
                          foreach ($dayData['time'] as $slot) {
                            if (!empty($slot['to']) && !empty($slot['from'])) {
                              $displayTimes[] = date('g:i A', strtotime($slot['to'])) . ' - ' . date('g:i A', strtotime($slot['from']));
                            }
                          }
                          echo !empty($displayTimes) ? implode(', ', $displayTimes) : 'Closed';
                        }
                      } else {
                        echo 'Closed';
                      }
                    }
                    ?>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>
    <?php endforeach; ?>
  <?php endif; ?>

  <div class="row">
    <div class="col-md-6">
      <div class="mb-3 p-3 bg-light rounded">
        <h5><i class="fas fa-map-marker-alt me-2"></i>Location / <a href="https://<?= $store['website'] ?>" target="_blank"><u>Website</u></a></h5>
        <p><?= esc($store['address']) ?>, <?= esc($store['city']) ?> <?= esc($store['state']) ?> <?= esc($store['postal_code']) ?></p>
      </div>
    </div>
    <div class="col-md-6">
      <div class="mb-3 p-3 bg-light rounded">
        <h5><i class="fas fa-location-arrow me-2"></i>Directions</h5>
        <ul class="list-unstyled">
          <li><a href="https://www.google.com/maps/dir/?api=1&destination=<?= $store['latitude'] ?>,<?= $store['longitude'] ?>" target="_blank"><i class="fas fa-external-link-alt"></i> Google Maps</a></li>
          <li><a href="https://www.bing.com/maps?rtp=~pos.<?= $store['latitude'] ?>_<?= $store['longitude'] ?>" target="_blank"><i class="fas fa-external-link-alt"></i> Bing Maps</a></li>
        </ul>
      </div>
    </div>
  </div>

  <div class="mb-3 p-3 bg-light rounded">
    <h5><i class="fas fa-address-card me-2"></i>Contact</h5>
    <?php if (!empty($store['phone'])) : ?>
      <p><a href="tel:<?= $store['phone'] ?>"><i class="fas fa-phone"></i> <?= $store['phone'] ?></a></p>
    <?php endif; ?>
    <?php if (!empty($store['fax'])) : ?>
      <p><i class="fas fa-print"></i> <?= $store['fax'] ?></p>
    <?php endif; ?>
    <?php if (!empty($store['email'])) : ?>
      <p><a href="mailto:<?= $store['email'] ?>"><i class="fas fa-envelope"></i> <?= $store['email'] ?></a></p>
    <?php endif; ?>
  </div>
</div>
<?php endif; ?>