<?php
// Image path logic
$imagePath = base_url('assets/images/no-image.jpg'); // Default fallback

if (!empty($store['image'])) {
    if (isset($store['image_type']) && $store['image_type'] == '1') {
        $imagePath = $store['image']; // External image
    } else {
        $imagePath = base_url('uploads/stores/' . $store['image']); // Local image
    }
}

// Status logic with safety checks
$openStatus = isset($store['open_status']) ? $store['open_status'] : 'Unknown';
$nextOpen = isset($store['next_open']) ? $store['next_open'] : null;

// Distance with safety check
$distance = null;
if (isset($store['distance']) && is_numeric($store['distance'])) {
    $distance = number_format((float)$store['distance'], 2);
}

// Business status check
$isBusinessOpen = ($openStatus !== 'Closed' && $openStatus !== 'Unknown');

// Coupon check with safety
$hasCoupon = (isset($store['has_active_coupon']) && $store['has_active_coupon']);

// Job posting check with safety
$hasJobs = (isset($store['has_active_jobs']) && $store['has_active_jobs']);

// Super simple gradient: open or closed, nothing else
$gradientClass = $isBusinessOpen ? 'gradient-open' : 'gradient-closed';

// Store ID for modal
$storeId = isset($store['id']) ? $store['id'] : (isset($store['store_id']) ? $store['store_id'] : '');
?>

<div class="col-12 col-md-4 col-xl-3 stores_list_modal mb-4"
     data-val="<?= esc($storeId) ?>"
     data-image="<?= esc($imagePath) ?>"
     data-bs-toggle="modal"
     data-bs-target="#store-info-dialog">

  <div class="appstore-card">
    <!-- Hero Section -->
    <div class="card-hero <?= $gradientClass ?>" 
         style="background-image: url('<?= esc($imagePath) ?>');">
      
      <!-- Status Badge (Top Left) -->
      <div class="status-badge-container">
        <?php if ($isBusinessOpen): ?>
          <div class="status-badge status-open">
            <i class="fas fa-check-circle"></i>
            OPEN NOW
          </div>
        <?php else: ?>
          <div class="status-badge status-closed">
            <i class="fas fa-clock"></i>
            CLOSED
          </div>
        <?php endif; ?>
      </div>

      <!-- Distance Badge (Top Right) -->
      <?php if ($distance): ?>
        <div class="distance-badge">
          <i class="fas fa-location-arrow"></i>
          <?= $distance ?> MI
        </div>
      <?php endif; ?>

      <!-- Deal Badge -->
      <?php if ($hasCoupon): ?>
        <div class="deal-badge">
          <i class="fas fa-ticket-alt"></i>
          DEAL READY
        </div>
      <?php endif; ?>

      <!-- Jobs Badge -->
      <?php if ($hasJobs): ?>
        <div class="jobs-badge">
          <i class="fas fa-briefcase"></i>
          NOW HIRING
        </div>
      <?php endif; ?>

      <!-- Hero Content -->
      <div class="card-hero-content">
        <h3 class="business-name"><?= esc($store['name']) ?></h3>
      </div>
    </div>

    <!-- Info Section -->
    <div class="card-info">
      <div class="business-details">
        <div class="business-icon">
          <img src="https://ringgoldroad.com/assets/images/weblogo.png" alt="Ringgold Road" class="platform-logo">
        </div>
        <div class="business-meta">
          <div class="business-location">
            <?= esc($store['city']) ?>, <?= esc($store['state']) ?>
          </div>
          <div class="business-address">
            <?= esc($store['address']) ?>
          </div>
        </div>
        <div class="action-button">
          <div class="visit-btn">
            <span>See<br>Inside!</span>
            <i class="fas fa-arrow-right"></i>
          </div>
        </div>
      </div>

      <!-- Next Open Info for Closed Businesses -->
      <?php if (!$isBusinessOpen && $nextOpen): ?>
        <div class="next-open-info">
          <i class="fas fa-clock"></i>
          <?= esc($nextOpen) ?>
        </div>
      <?php endif; ?>
    </div>
  </div>
</div>

<style>
/* Prevent horizontal scroll on mobile */
* {
  box-sizing: border-box;
}

.appstore-card {
  max-width: 100%;
  overflow: hidden;
}

/* App Store Card Styling */
.appstore-card {
  background: white;
  border-radius: 20px;
  overflow: hidden;
  box-shadow: 0 8px 30px rgba(0, 0, 0, 0.12);
  transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
  cursor: pointer;
  position: relative;
}

.appstore-card:hover {
  transform: translateY(-8px);
  box-shadow: 0 20px 50px rgba(0, 0, 0, 0.25);
}

/* Hero Section */
.card-hero {
  position: relative;
  height: 260px;
  background-size: cover;
  background-position: center center;
  background-repeat: no-repeat;
  display: flex;
  flex-direction: column;
  justify-content: flex-end;
  padding: 20px;
  overflow: hidden;
}

/* Super Simple Gradients */
.gradient-open::before {
  content: '';
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background: linear-gradient(135deg, rgba(5, 150, 105, 0.15) 0%, rgba(4, 120, 87, 0.35) 100%);
  z-index: 1;
}

.gradient-closed::before {
  content: '';
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background: linear-gradient(135deg, rgba(96, 125, 139, 0.2) 0%, rgba(69, 90, 100, 0.4) 100%);
  z-index: 1;
}

.card-hero > * {
  position: relative;
  z-index: 2;
}

/* Status Badge (Top Left) */
.status-badge-container {
  position: absolute;
  top: 15px;
  left: 15px;
  z-index: 3;
}

.status-badge {
  background: rgba(255, 255, 255, 0.95);
  backdrop-filter: blur(10px);
  padding: 8px 12px;
  border-radius: 20px;
  font-size: 11px;
  font-weight: 700;
  text-transform: uppercase;
  letter-spacing: 0.5px;
  display: flex;
  align-items: center;
  gap: 6px;
  box-shadow: 0 4px 15px rgba(0, 0, 0, 0.15);
}

.status-open {
  color: #047857;
  border: 1px solid rgba(5, 150, 105, 0.3);
}

.status-closed {
  color: #d32f2f;
  border: 1px solid rgba(244, 67, 54, 0.3);
}

/* Distance Badge (Top Right) */
.distance-badge {
  position: absolute;
  top: 15px;
  right: 15px;
  z-index: 3;
  background: rgba(0, 0, 0, 0.7);
  backdrop-filter: blur(10px);
  color: white;
  padding: 8px 12px;
  border-radius: 20px;
  font-size: 11px;
  font-weight: 600;
  display: flex;
  align-items: center;
  gap: 6px;
  box-shadow: 0 4px 15px rgba(0, 0, 0, 0.3);
}

/* Deal Badge */
.deal-badge {
  position: absolute;
  top: 60px;
  right: 15px;
  z-index: 3;
  background: #28a745;
  color: white;
  padding: 8px 12px;
  border-radius: 20px;
  font-size: 11px;
  font-weight: 700;
  text-transform: uppercase;
  letter-spacing: 0.5px;
  display: flex;
  align-items: center;
  gap: 6px;
  box-shadow: 0 4px 15px rgba(40, 167, 69, 0.3);
}

/* Jobs Badge */
.jobs-badge {
  position: absolute;
  top: 105px;
  right: 15px;
  z-index: 3;
  background: #007bff;
  color: white;
  padding: 8px 12px;
  border-radius: 20px;
  font-size: 11px;
  font-weight: 700;
  text-transform: uppercase;
  letter-spacing: 0.5px;
  display: flex;
  align-items: center;
  gap: 6px;
  box-shadow: 0 4px 15px rgba(0, 123, 255, 0.3);
}

/* Card Hero Content */
.card-hero-content {
  margin-top: auto;
  text-align: center;
  /* Move the content area higher up */
  padding-bottom: 30px;
}

.business-name {
  color: white;
  font-size: 24px;
  font-weight: 800;
  line-height: 1.2;
  margin: 0;
  text-shadow: 0 2px 10px rgba(0, 0, 0, 0.8);
  hyphens: none;
  /* Remove the ellipsis overflow */
  white-space: normal;
  overflow: visible;
  text-overflow: unset;
  /* Remove any background */
  background: none;
  padding: 0;
  /* Better positioning */
  margin-bottom: 20px;
}

/* Info Section */
.card-info {
  background: #1a1a1a;
  padding: 16px 20px;
  color: white;
}

.business-details {
  display: flex;
  align-items: center;
  gap: 12px;
}

.business-icon {
  width: 40px;
  height: 40px;
  background: rgba(255, 255, 255, 0.1);
  border-radius: 12px;
  display: flex;
  align-items: center;
  justify-content: center;
  flex-shrink: 0;
  padding: 3px;
}

.platform-logo {
  width: 100%;
  height: 100%;
  object-fit: contain;
}

.business-meta {
  flex: 1;
  min-width: 0;
}

.business-location {
  color: white;
  font-size: 14px;
  font-weight: 600;
  margin-bottom: 2px;
}

.business-address {
  color: rgba(255, 255, 255, 0.7);
  font-size: 12px;
  line-height: 1.3;
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
}

.action-button {
  flex-shrink: 0;
}

.visit-btn {
  background: rgba(255, 255, 255, 0.15);
  backdrop-filter: blur(10px);
  border: 1px solid rgba(255, 255, 255, 0.2);
  color: white;
  padding: 10px 16px;
  border-radius: 20px;
  font-size: 13px;
  font-weight: 600;
  display: flex;
  align-items: center;
  gap: 6px;
  transition: all 0.3s ease;
}

.visit-btn:hover {
  background: rgba(255, 255, 255, 0.25);
  transform: scale(1.05);
}

.next-open-info {
  margin-top: 12px;
  padding: 8px 12px;
  background: rgba(255, 255, 255, 0.1);
  border-radius: 12px;
  font-size: 12px;
  color: rgba(255, 255, 255, 0.8);
  display: flex;
  align-items: center;
  gap: 8px;
}

/* Mobile Responsiveness */
@media (max-width: 768px) {
  .appstore-card {
    max-width: 100%;
    margin: 0 auto;
  }
  
  .card-hero {
    height: 220px;
    padding: 15px;
    max-width: 100%;
  }
  
  .business-name {
    font-size: 20px;
    word-wrap: break-word;
    overflow-wrap: break-word;
  }
  
  .status-badge, .distance-badge {
    padding: 6px 10px;
    font-size: 10px;
    max-width: fit-content;
  }
  
  .deal-badge, .jobs-badge {
    padding: 6px 10px;
    font-size: 10px;
    max-width: fit-content;
  }
  
  .jobs-badge {
    top: 95px;
  }
  
  .card-info {
    padding: 14px 16px;
    max-width: 100%;
    overflow: hidden;
  }
  
  .business-details {
    gap: 10px;
    flex-wrap: nowrap;
  }
  
  .business-meta {
    min-width: 0;
    flex: 1;
  }
  
  .business-address {
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
    max-width: 100%;
  }
  
  .business-icon {
    width: 36px;
    height: 36px;
    padding: 2px;
    flex-shrink: 0;
  }
  
  .visit-btn {
    padding: 8px 12px;
    font-size: 12px;
    flex-shrink: 0;
    white-space: nowrap;
  }
}

@media (max-width: 576px) {
  .appstore-card {
    margin: 0 auto;
    max-width: 100%;
  }
  
  .card-hero {
    height: 200px;
    padding: 12px;
    max-width: 100%;
  }
  
  .business-name {
    font-size: 18px;
    word-wrap: break-word;
    overflow-wrap: break-word;
    hyphens: auto;
  }
  
  .jobs-badge {
    top: 90px;
    right: 12px;
    max-width: calc(100% - 24px);
  }
  
  .deal-badge {
    top: 55px;
    right: 12px;
    max-width: calc(100% - 24px);
  }
  
  .status-badge-container {
    top: 12px;
    left: 12px;
    max-width: calc(50% - 18px);
  }
  
  .distance-badge {
    top: 12px;
    right: 12px;
    max-width: calc(50% - 18px);
  }
  
  .business-details {
    flex-wrap: nowrap;
    overflow: hidden;
  }
  
  .visit-btn {
    font-size: 11px;
    padding: 6px 10px;
  }
}

/* Hover Effects */
@media (min-width: 769px) {
  .appstore-card:hover .business-name {
    transform: translateY(-2px);
  }
  
  .appstore-card:hover .visit-btn {
    background: rgba(255, 255, 255, 0.3);
    border-color: rgba(255, 255, 255, 0.4);
  }
  
  .appstore-card:hover .deal-badge {
    transform: scale(1.02);
  }
  
  .appstore-card:hover .jobs-badge {
    transform: scale(1.02);
  }
}
</style>