<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>

<!-- Background video section with search + tabs -->
<div class="video-background-holder site-blocks-cover" data-aos="fade" data-stellar-background-ratio="0.5">
  <div class="video-background-overlay"></div>
  <video poster="<?= base_url('assets/images/background.png') ?>" playsinline autoplay muted loop>
    <source src="<?= base_url('assets/video/RRSH.mp4') ?>" type="video/mp4">
    <p class="warning">Your browser does not support HTML5 video.</p>
  </video>
  <div class="video-background-content container h-100">
    <div class="d-flex h-100 text-center align-items-center">
      <div class="col-md-12">
        <div class="row justify-content-center mb-4">
          <div class="col-md-12 text-center">
            <h1 data-aos="fade-up"><span class="typed-words"></span></h1>
            <p data-aos="fade-up" data-aos-delay="100">Welcome to Athens & McMinn County!</p>
            <p id="location-status" class="text-white small mt-2" data-aos="fade-up" data-aos-delay="200">
              Finding your location...
            </p>
          </div>
        </div>
        <ul class="nav nav-tabs justify-content-center mb-3" id="searchTabs" role="tablist" data-aos="fade-up" data-aos-delay="300">
          <li class="nav-item"><a class="nav-link active" data-category="" href="#" role="tab">All</a></li>
          <li class="nav-item"><a class="nav-link" data-category="top" href="#" role="tab">Top Picks</a></li>
          <li class="nav-item"><a class="nav-link" data-category="restaurants" href="#" role="tab">Restaurants</a></li>
          <li class="nav-item"><a class="nav-link" data-category="services" href="#" role="tab">Services</a></li>
        </ul>
        <div class="form-search-wrap mb-4" data-aos="fade-up" data-aos-delay="400">
          <form id="searchForm" method="GET" action="#">
            <div class="row align-items-center">
              <div class="col-md-12">
                <input type="text" id="searchInput" class="form-control form-control-lg" placeholder="Search for services or businesses...">
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>

<div id="store-results" class="site-section site-section-sm bg-light">
  <div class="container">
    <div class="row" id="store-list"></div>
    <div id="no-results-message" class="text-center text-muted my-5" style="display: none;">
      <h5>No results for this keyword. We're sad.</h5>
      <p>Please try another location or keyword.<br>Thanks for visiting!</p>
    </div>
    <div class="text-center mt-4" id="loader" style="display: none;">
      <img src="<?= base_url('assets/images/loader.gif') ?>" alt="Loading..." style="width: 50px; height: 50px; opacity: 0.6;" />
    </div>
  </div>
</div>

<!-- Modal for Store Profile -->
<div class="modal fade" id="store-info-dialog" tabindex="-1" aria-labelledby="storeInfoLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-dark text-white position-relative">
        <h5 class="modal-title w-100 text-center mb-0 fw-bold" id="storeInfoLabel">Store Profile</h5>
        <button type="button" class="close text-white position-absolute" style="top: 10px; right: 10px; font-size: 1.5rem; opacity: 1; z-index: 1050;" id="customModalCloseBtn">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body position-relative">
        <div id="modal-store-content">
          <p class="text-center">Loading...</p>
        </div>
      </div>
    </div>
  </div>
</div>

<script>
  document.addEventListener('DOMContentLoaded', function () {
    document.querySelector('.typed-words').textContent = "Explore Local Favorites";

    let page = 1;
    let loading = false;
    let currentCategory = '';

    const defaultLat = 35.4420;
    const defaultLng = -84.5927;

    function reverseGeocode(lat, lng) {
      fetch(`https://nominatim.openstreetmap.org/reverse?format=jsonv2&lat=${lat}&lon=${lng}`)
        .then(response => response.json())
        .then(data => {
          let address = data.address;
          let concise = address.road || address.neighbourhood || address.suburb || address.city || address.town || address.state || data.display_name;
          document.getElementById('location-status').textContent = `Showing results near ${concise}`;
        })
        .catch(() => {
          document.getElementById('location-status').textContent = `Showing results near you: (${lat.toFixed(4)}, ${lng.toFixed(4)})`;
        });
    }

    if (navigator.geolocation) {
      navigator.geolocation.getCurrentPosition(function (position) {
        window.lastKnownLat = position.coords.latitude;
        window.lastKnownLng = position.coords.longitude;
        reverseGeocode(window.lastKnownLat, window.lastKnownLng);
        loadMoreStores();
      }, function () {
        window.lastKnownLat = defaultLat;
        window.lastKnownLng = defaultLng;
        document.getElementById('location-status').textContent =
          "Location unavailable — showing nearby businesses by IP.";
        loadMoreStores();
      });
    } else {
      window.lastKnownLat = defaultLat;
      window.lastKnownLng = defaultLng;
      document.getElementById('location-status').textContent =
        "Geolocation not supported by this browser.";
      loadMoreStores();
    }

    function loadMoreStores(reset = false) {
      if (loading) return;
      loading = true;
      const loader = document.getElementById('loader');
      const noResults = document.getElementById('no-results-message');
      loader.style.display = 'block';
      if (noResults) noResults.style.display = 'none';

      if (reset) {
        page = 1;
        document.getElementById('store-list').innerHTML = '';
      }

      const lat = window?.lastKnownLat || defaultLat;
      const lng = window?.lastKnownLng || defaultLng;
      const keyword = document.getElementById('searchInput').value;

      const formData = new URLSearchParams();
      formData.append('lat', lat);
      formData.append('lng', lng);
      formData.append('keyword', keyword);
      formData.append('category', currentCategory);

      fetch('<?= base_url('ajax/locator') ?>?page=' + page, {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: formData.toString()
      })
      .then(response => response.text())
      .then(html => {
        const storeList = document.getElementById('store-list');
        if (html.trim() === '') {
          if (noResults) noResults.style.display = 'block';
        } else {
          storeList.insertAdjacentHTML('beforeend', html);
          if (noResults) noResults.style.display = 'none';
          page++;
        }
        loader.style.display = 'none';
        loading = false;
      })
      .catch(error => {
        console.error('Failed to fetch store cards:', error);
        loader.style.display = 'none';
        loading = false;
      });
    }

    window.addEventListener('scroll', () => {
      if ((window.innerHeight + window.scrollY) >= document.body.offsetHeight - 300) {
        loadMoreStores();
      }
    });

    document.getElementById('searchInput').addEventListener('keyup', function (e) {
      if (e.key === 'Enter') {
        loadMoreStores(true);
      }
    });

    document.getElementById('searchForm').addEventListener('submit', function (e) {
      e.preventDefault();
      loadMoreStores(true);
    });

    document.querySelectorAll('#searchTabs .nav-link').forEach(tab => {
      tab.addEventListener('click', function (e) {
        e.preventDefault();
        document.querySelectorAll('#searchTabs .nav-link').forEach(el => el.classList.remove('active'));
        this.classList.add('active');
        currentCategory = this.getAttribute('data-category');
        loadMoreStores(true);
      });
    });

    document.addEventListener('click', function (e) {
      const card = e.target.closest('.stores_list_modal');
      if (card) {
        const storeId = card.getAttribute('data-val');
        const modalContent = document.getElementById('modal-store-content');
        modalContent.innerHTML = '<p class="text-center">Loading...</p>';

        fetch('<?= base_url('ajax/store_details') ?>', {
          method: 'POST',
          headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
          body: 'id=' + encodeURIComponent(storeId)
        })
        .then(response => response.text())
        .then(html => {
          modalContent.innerHTML = html;
          const modalEl = document.getElementById('store-info-dialog');
          const modal = new bootstrap.Modal(modalEl);
          modal.show();

          const btn = document.getElementById('customModalCloseBtn');
          if (btn) {
            btn.onclick = function () {
              modal.hide();
            };
          }
        })
        .catch(error => {
          modalContent.innerHTML = '<p class="text-danger text-center">Failed to load store details.</p>';
          console.error('Modal load error:', error);
        });
      }
    });
  });
</script>

<?= $this->endSection() ?>

