<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Change Request Needs Revision</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background-color: #ffc107; color: #212529; padding: 20px; text-align: center; border-radius: 8px 8px 0 0; }
        .content { background-color: #f8f9fa; padding: 30px; border-radius: 0 0 8px 8px; }
        .button { display: inline-block; background-color: #007bff; color: white; padding: 12px 24px; text-decoration: none; border-radius: 5px; margin: 10px 0; }
        .button:hover { background-color: #0056b3; }
        .warning-box { background-color: #fff3cd; border: 1px solid #ffeaa7; color: #856404; padding: 20px; border-radius: 5px; margin: 20px 0; }
        .admin-notes { background-color: #fff; border-left: 4px solid #ffc107; padding: 20px; margin: 20px 0; }
        .requested-changes { background-color: white; padding: 15px; border: 1px solid #dee2e6; border-radius: 5px; margin: 15px 0; }
        .field-change { padding: 8px 0; border-bottom: 1px solid #eee; }
        .field-name { font-weight: bold; color: #495057; }
        .old-value { color: #6c757d; text-decoration: line-through; }
        .new-value { color: #007bff; }
        .footer { text-align: center; padding: 20px; font-size: 12px; color: #6c757d; }
    </style>
</head>
<body>
    <div class="header">
        <h1>⚠️ Request Needs Revision</h1>
        <p>Athens McMinn Business Directory</p>
    </div>
    
    <div class="content">
        <h2>Hello <?= esc($user['first_name']) ?>!</h2>
        
        <div class="warning-box">
            <h3>Your change request needs some adjustments</h3>
            <p>We've reviewed your change request for <strong><?= esc($request['store_name']) ?></strong>, and we need you to make some revisions before we can approve it.</p>
        </div>

        <div class="admin-notes">
            <h3>📝 What needs to be changed:</h3>
            <p><?= nl2br(esc($admin_notes)) ?></p>
        </div>

        <?php if (!empty($field_changes)): ?>
        <div class="requested-changes">
            <h3>Your Original Requested Changes</h3>
            <p style="font-size: 14px; color: #6c757d;">For reference, here's what you originally submitted:</p>
            <?php foreach ($field_changes as $field => $change): ?>
                <div class="field-change">
                    <div class="field-name"><?= esc(ucfirst(str_replace('_', ' ', $field))) ?>:</div>
                    <?php if (!empty($change['old'])): ?>
                        <div class="old-value">Previous: <?= esc($change['old']) ?></div>
                    <?php endif; ?>
                    <div class="new-value">Requested: <?= esc($change['new']) ?></div>
                </div>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>

        <h3>Next Steps</h3>
        <p>Please review the feedback above and submit a new change request with the requested adjustments.</p>

        <p style="margin: 30px 0;">
            <a href="<?= esc($edit_url) ?>" class="button">Submit New Request</a>
        </p>
        
        <p style="margin: 20px 0;">
            <a href="<?= esc($dashboard_url) ?>">View your dashboard</a> to see all your change requests.
        </p>
        
        <p style="font-size: 14px; color: #6c757d;">
            Questions about this feedback? Contact us at support@ringgoldroad.com
        </p>
    </div>
    
    <div class="footer">
        <p>Athens McMinn Business Directory</p>
        <p>We're here to help you keep your business information accurate!</p>
    </div>
</body>
</html>