<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Change Request Approved</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background-color: #28a745; color: white; padding: 20px; text-align: center; border-radius: 8px 8px 0 0; }
        .content { background-color: #f8f9fa; padding: 30px; border-radius: 0 0 8px 8px; }
        .button { display: inline-block; background-color: #007bff; color: white; padding: 12px 24px; text-decoration: none; border-radius: 5px; margin: 10px 0; }
        .button:hover { background-color: #0056b3; }
        .success-box { background-color: #d4edda; border: 1px solid #c3e6cb; color: #155724; padding: 20px; border-radius: 5px; margin: 20px 0; }
        .changes-applied { background-color: white; padding: 15px; border: 1px solid #dee2e6; border-radius: 5px; margin: 15px 0; }
        .field-change { padding: 8px 0; border-bottom: 1px solid #eee; }
        .field-name { font-weight: bold; color: #495057; }
        .new-value { color: #28a745; font-weight: bold; }
        .admin-note { background-color: #e7f3ff; border-left: 4px solid #007bff; padding: 15px; margin: 15px 0; }
        .footer { text-align: center; padding: 20px; font-size: 12px; color: #6c757d; }
    </style>
</head>
<body>
    <div class="header">
        <h1>✅ Request Approved!</h1>
        <p>Athens McMinn Business Directory</p>
    </div>
    
    <div class="content">
        <h2>Hello <?= esc($user['first_name']) ?>!</h2>
        
        <div class="success-box">
            <h3>Great news! Your change request has been approved.</h3>
            <p>Your updates to <strong><?= esc($request['store_name']) ?></strong> are now live on the Athens McMinn Business Directory.</p>
        </div>

        <?php if (!empty($field_changes)): ?>
        <div class="changes-applied">
            <h3>Changes Applied</h3>
            <?php foreach ($field_changes as $field => $change): ?>
                <div class="field-change">
                    <div class="field-name"><?= esc(ucfirst(str_replace('_', ' ', $field))) ?>:</div>
                    <div class="new-value"><?= esc($change['new']) ?></div>
                </div>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>

        <?php if (!empty($admin_notes)): ?>
        <div class="admin-note">
            <h4>Admin Notes</h4>
            <p><?= esc($admin_notes) ?></p>
        </div>
        <?php endif; ?>

        <p>Your business information is now updated and visible to customers searching the directory.</p>

        <p style="margin: 30px 0;">
            <a href="<?= esc($dashboard_url) ?>" class="button">View Dashboard</a>
        </p>
        
        <h3>What's Next?</h3>
        <ul>
            <li>View your updated business profile in the directory</li>
            <li>Submit additional change requests anytime through your dashboard</li>
            <li>Keep your business information current for better customer visibility</li>
        </ul>
        
        <p style="font-size: 14px; color: #6c757d;">
            Questions? Contact us at support@ringgoldroad.com
        </p>
    </div>
    
    <div class="footer">
        <p>Athens McMinn Business Directory</p>
        <p>Thank you for keeping your business information up to date!</p>
    </div>
</body>
</html>