<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= esc($title) ?> - Business Portal</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            min-height: 100vh;
            padding-top: 20px;
        }
        
        .onboarding-container {
            max-width: 800px;
            margin: 0 auto;
            padding: 2rem;
        }
        
        .onboarding-header {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            text-align: center;
        }
        
        .step-indicator {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 1rem;
            margin-bottom: 2rem;
        }
        
        .step-circle {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 700;
            font-size: 1.1rem;
            position: relative;
        }
        
        .step-circle.active {
            background: #10b981;
            color: white;
            box-shadow: 0 0 0 4px rgba(16, 185, 129, 0.2);
        }
        
        .step-circle.completed {
            background: #059669;
            color: white;
        }
        
        .step-circle.upcoming {
            background: #e5e7eb;
            color: #9ca3af;
        }
        
        .step-connector {
            width: 60px;
            height: 3px;
            background: #e5e7eb;
            border-radius: 2px;
        }
        
        .step-connector.completed {
            background: #10b981;
        }
        
        .page-title {
            font-size: 2rem;
            font-weight: 700;
            color: #1f2937;
            margin-bottom: 0.5rem;
        }
        
        .page-subtitle {
            color: #6b7280;
            font-size: 1.1rem;
            margin-bottom: 0;
        }
        
        .form-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 2.5rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }
        
        .form-section {
            margin-bottom: 2.5rem;
        }
        
        .section-title {
            font-size: 1.25rem;
            font-weight: 600;
            color: #1f2937;
            margin-bottom: 1.5rem;
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }
        
        .section-icon {
            width: 40px;
            height: 40px;
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white;
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.2rem;
        }
        
        .friendly-description {
            background: #f0fdf4;
            border: 1px solid #bbf7d0;
            border-radius: 12px;
            padding: 1.25rem;
            margin-bottom: 2rem;
            color: #14532d;
        }
        
        .friendly-description h5 {
            color: #15803d;
            font-weight: 600;
            margin-bottom: 0.75rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .form-group {
            margin-bottom: 1.5rem;
        }
        
        .form-label {
            font-weight: 600;
            color: #374151;
            margin-bottom: 0.5rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .form-label .required {
            color: #dc2626;
            font-size: 1.2rem;
        }
        
        .form-label .optional {
            color: #6b7280;
            font-size: 0.8rem;
            font-weight: 400;
            background: #f3f4f6;
            padding: 0.2rem 0.5rem;
            border-radius: 12px;
        }
        
        .form-control {
            border: 2px solid #e5e7eb;
            border-radius: 10px;
            padding: 0.875rem 1rem;
            font-size: 1rem;
            transition: all 0.3s ease;
        }
        
        .form-control:focus {
            border-color: #10b981;
            box-shadow: 0 0 0 3px rgba(16, 185, 129, 0.1);
        }
        
        .help-text {
            font-size: 0.875rem;
            color: #6b7280;
            margin-top: 0.5rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .char-counter {
            font-size: 0.8rem;
            color: #6b7280;
            margin-top: 0.25rem;
            text-align: right;
        }
        
        .navigation-buttons {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 3rem;
            padding-top: 2rem;
            border-top: 2px solid #f3f4f6;
        }
        
        .btn-primary-custom {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white;
            border: none;
            padding: 0.875rem 2rem;
            border-radius: 10px;
            font-weight: 600;
            font-size: 1rem;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 0.75rem;
        }
        
        .btn-primary-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(16, 185, 129, 0.3);
            color: white;
        }
        
        .btn-secondary-custom {
            background: #f9fafb;
            color: #374151;
            border: 2px solid #e5e7eb;
            padding: 0.875rem 2rem;
            border-radius: 10px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.75rem;
            transition: all 0.3s ease;
        }
        
        .btn-secondary-custom:hover {
            background: #f3f4f6;
            border-color: #d1d5db;
            color: #374151;
            text-decoration: none;
        }
        
        .skip-note {
            background: #fffbeb;
            border: 1px solid #fed7aa;
            border-radius: 10px;
            padding: 1rem;
            margin-top: 1.5rem;
            color: #92400e;
            font-size: 0.9rem;
            text-align: center;
        }
        
        .alert {
            border-radius: 12px;
            padding: 1rem 1.5rem;
            margin-bottom: 1.5rem;
            border: none;
        }
        
        .alert-success {
            background: #f0fdf4;
            border-left: 4px solid #10b981;
            color: #14532d;
        }
        
        .alert-danger {
            background: #fef2f2;
            border-left: 4px solid #ef4444;
            color: #991b1b;
        }
        
        @media (max-width: 768px) {
            .onboarding-container {
                padding: 1rem;
            }
            
            .form-card {
                padding: 1.5rem;
            }
            
            .step-indicator {
                gap: 0.5rem;
            }
            
            .step-connector {
                width: 40px;
            }
            
            .navigation-buttons {
                flex-direction: column;
                gap: 1rem;
            }
            
            .btn-primary-custom,
            .btn-secondary-custom {
                width: 100%;
                justify-content: center;
            }
        }
    </style>
</head>
<body>
    <div class="onboarding-container">
        <!-- Header with Progress -->
        <div class="onboarding-header">
            <div class="step-indicator">
                <div class="step-circle active">1</div>
                <div class="step-connector"></div>
                <div class="step-circle upcoming">2</div>
                <div class="step-connector"></div>
                <div class="step-circle upcoming">3</div>
                <div class="step-connector"></div>
                <div class="step-circle upcoming">4</div>
            </div>
            
            <h1 class="page-title">Tell Us About Your Business</h1>
            <p class="page-subtitle">Let's start with the basics so customers can find and contact you</p>
        </div>

        <!-- Flash Messages -->
        <?php if (session()->getFlashdata('success')): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle me-2"></i>
                <?= session()->getFlashdata('success') ?>
            </div>
        <?php endif; ?>

        <?php if (session()->getFlashdata('error')): ?>
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-circle me-2"></i>
                <?= session()->getFlashdata('error') ?>
            </div>
        <?php endif; ?>

        <?php if (session()->getFlashdata('validation')): ?>
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-triangle me-2"></i>
                <strong>Please fix these items:</strong>
                <ul class="mb-0 mt-2">
                    <?php foreach (session()->getFlashdata('validation') as $error): ?>
                        <li><?= esc($error) ?></li>
                    <?php endforeach; ?>
                </ul>
            </div>
        <?php endif; ?>

        <form method="post" action="/business/onboarding/step1" class="form-card">
            <?= csrf_field() ?>
            
            <!-- Friendly Introduction -->
            <div class="friendly-description">
                <h5><i class="fas fa-lightbulb"></i> What We're Doing Here</h5>
                <p class="mb-0">
                    We'll help you create a complete business profile that customers can find when they search for local businesses. 
                    Just fill in what you know - you can always add more details later!
                </p>
            </div>

            <!-- Basic Business Information -->
            <div class="form-section">
                <h3 class="section-title">
                    <div class="section-icon">
                        <i class="fas fa-store"></i>
                    </div>
                    Essential Business Details
                </h3>
                
                <div class="row">
                    <div class="col-md-8">
                        <div class="form-group">
                            <label for="name" class="form-label">
                                Business Name <span class="required">*</span>
                            </label>
                            <input type="text" 
                                   class="form-control" 
                                   id="name" 
                                   name="name" 
                                   value="<?= old('name', esc($store['name'] ?? $saved_data['name'] ?? '')) ?>" 
                                   placeholder="Enter your business name as customers know it"
                                   required>
                            <div class="help-text">
                                <i class="fas fa-info-circle"></i>
                                This is how your business will appear in search results
                            </div>
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <label for="description" class="form-label">
                        What Does Your Business Do? <span class="optional">optional</span>
                    </label>
                    <textarea class="form-control" 
                              id="description" 
                              name="description" 
                              rows="4" 
                              maxlength="1000" 
                              placeholder="Describe your business in a way that helps customers understand what you offer..."><?= old('description', esc($store['description'] ?? $saved_data['description'] ?? '')) ?></textarea>
                    <div class="char-counter">
                        <span id="descriptionCount">0</span>/1000 characters
                    </div>
                    <div class="help-text">
                        <i class="fas fa-heart"></i>
                        Help customers understand why they should choose you
                    </div>
                </div>
            </div>

            <!-- Contact Information -->
            <div class="form-section">
                <h3 class="section-title">
                    <div class="section-icon">
                        <i class="fas fa-phone"></i>
                    </div>
                    How Can Customers Reach You?
                </h3>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="phone" class="form-label">
                                Phone Number <span class="optional">optional</span>
                            </label>
                            <input type="tel" 
                                   class="form-control" 
                                   id="phone" 
                                   name="phone" 
                                   value="<?= old('phone', esc($store['phone'] ?? $saved_data['phone'] ?? '')) ?>" 
                                   placeholder="(423) 555-0123">
                            <div class="help-text">
                                <i class="fas fa-mobile-alt"></i>
                                The main number customers should call
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="email" class="form-label">
                                Business Email <span class="optional">optional</span>
                            </label>
                            <input type="email" 
                                   class="form-control" 
                                   id="email" 
                                   name="email" 
                                   value="<?= old('email', esc($store['email'] ?? $saved_data['email'] ?? '')) ?>" 
                                   placeholder="info@yourbusiness.com">
                            <div class="help-text">
                                <i class="fas fa-envelope"></i>
                                For customer inquiries and questions
                            </div>
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <label for="website" class="form-label">
                        Website <span class="optional">optional</span>
                    </label>
                    <input type="url" 
                           class="form-control" 
                           id="website" 
                           name="website" 
                           value="<?= old('website', esc($store['website'] ?? $saved_data['website'] ?? '')) ?>" 
                           placeholder="https://www.yourbusiness.com">
                    <div class="help-text">
                        <i class="fas fa-globe"></i>
                        Your business website (we'll add https:// if you forget it)
                    </div>
                </div>
            </div>

            <!-- Location Information -->
            <div class="form-section">
                <h3 class="section-title">
                    <div class="section-icon">
                        <i class="fas fa-map-marker-alt"></i>
                    </div>
                    Where Are You Located?
                </h3>
                
                <div class="form-group">
                    <label for="address" class="form-label">
                        Street Address <span class="optional">optional</span>
                    </label>
                    <input type="text" 
                           class="form-control" 
                           id="address" 
                           name="address" 
                           value="<?= old('address', esc($store['address'] ?? $saved_data['address'] ?? '')) ?>" 
                           placeholder="123 Main Street">
                    <div class="help-text">
                        <i class="fas fa-location-arrow"></i>
                        Include suite or unit numbers if applicable
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="city" class="form-label">
                                City <span class="optional">optional</span>
                            </label>
                            <input type="text" 
                                   class="form-control" 
                                   id="city" 
                                   name="city" 
                                   value="<?= old('city', esc($store['city'] ?? $saved_data['city'] ?? '')) ?>" 
                                   placeholder="Your City">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="state" class="form-label">
                                State <span class="optional">optional</span>
                            </label>
                            <input type="text" 
                                   class="form-control" 
                                   id="state" 
                                   name="state" 
                                   value="<?= old('state', esc($store['state'] ?? $saved_data['state'] ?? '')) ?>" 
                                   placeholder="TN" 
                                   maxlength="2"
                                   style="text-transform: uppercase;">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="postal_code" class="form-label">
                                Zip Code <span class="optional">optional</span>
                            </label>
                            <input type="text" 
                                   class="form-control" 
                                   id="postal_code" 
                                   name="postal_code" 
                                   value="<?= old('postal_code', esc($store['postal_code'] ?? $saved_data['postal_code'] ?? '')) ?>" 
                                   placeholder="37415">
                        </div>
                    </div>
                </div>
            </div>

            <div class="skip-note">
                <i class="fas fa-info-circle"></i>
                <strong>Remember:</strong> You can skip any optional fields and add them later. 
                Only your business name is required to continue.
            </div>

            <!-- Navigation -->
            <div class="navigation-buttons">
                <a href="/business/dashboard" class="btn-secondary-custom">
                    <i class="fas fa-arrow-left"></i> Back to Dashboard
                </a>
                
                <button type="submit" class="btn-primary-custom">
                    Continue to Hours Setup <i class="fas fa-arrow-right"></i>
                </button>
            </div>
        </form>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Character counter for description
        const descriptionTextarea = document.getElementById('description');
        const descriptionCounter = document.getElementById('descriptionCount');
        
        function updateDescriptionCounter() {
            const count = descriptionTextarea.value.length;
            descriptionCounter.textContent = count;
            
            if (count > 800) {
                descriptionCounter.style.color = '#dc2626';
            } else if (count > 600) {
                descriptionCounter.style.color = '#d97706';
            } else {
                descriptionCounter.style.color = '#6b7280';
            }
        }
        
        descriptionTextarea.addEventListener('input', updateDescriptionCounter);
        updateDescriptionCounter(); // Initialize counter
        
        // Auto-uppercase state field
        document.getElementById('state').addEventListener('input', function(e) {
            e.target.value = e.target.value.toUpperCase();
        });
        
        // Auto-add https:// to website if missing
        document.getElementById('website').addEventListener('blur', function() {
            let value = this.value.trim();
            if (value && !value.match(/^https?:\/\//)) {
                this.value = 'https://' + value;
            }
        });
    </script>
</body>
</html>