<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= esc($title) ?> - Business Portal</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.10/index.global.min.css" rel="stylesheet">
    <style>
        body {
            background: #f7fafc;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body.has-business-header {
            padding-top: 70px;
        }
        
        .jobs-container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 2rem;
        }
        
        .page-header {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white;
            padding: 2rem;
            border-radius: 16px;
            margin-bottom: 2rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }
        
        .page-header h1 {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
        }
        
        .stats-row {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1rem;
            margin-bottom: 2rem;
        }
        
        .stat-card {
            background: white;
            padding: 1.5rem;
            border-radius: 12px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            text-align: center;
        }
        
        .stat-value {
            font-size: 2rem;
            font-weight: 700;
            color: #2d3748;
        }
        
        .stat-label {
            color: #718096;
            font-size: 0.875rem;
            font-weight: 600;
        }
        
        .active-jobs-card {
            background: white;
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            border: 2px solid #10b981;
        }
        
        .job-badge {
            display: inline-block;
            background: #10b981;
            color: white;
            padding: 0.5rem 1rem;
            border-radius: 8px;
            font-weight: 700;
            font-size: 1.25rem;
            margin-bottom: 1rem;
        }
        
        .job-item {
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            padding: 1.5rem;
            margin-bottom: 1rem;
            background: #f9fafb;
        }
        
        .job-item:last-child {
            margin-bottom: 0;
        }
        
        .job-header {
            display: flex;
            justify-content: between;
            align-items: flex-start;
            margin-bottom: 1rem;
        }
        
        .job-title {
            font-size: 1.25rem;
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 0.5rem;
        }
        
        .job-meta {
            display: flex;
            gap: 1rem;
            flex-wrap: wrap;
            margin-bottom: 1rem;
        }
        
        .job-meta-item {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            font-size: 0.875rem;
            color: #4a5568;
        }
        
        .job-description {
            color: #718096;
            margin-bottom: 1rem;
            line-height: 1.5;
        }
        
        .job-actions {
            display: flex;
            gap: 0.75rem;
            flex-wrap: wrap;
        }
        
        .calendar-section {
            background: white;
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }
        
        .section-title {
            font-size: 1.5rem;
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 1.5rem;
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }
        
        #calendar {
            max-width: 100%;
            margin: 0 auto;
        }
        
        .fc-toolbar-title {
            font-size: 1.5rem !important;
            font-weight: 600 !important;
        }
        
        .fc-button-primary {
            background: #10b981 !important;
            border-color: #10b981 !important;
        }
        
        .fc-button-primary:hover {
            background: #059669 !important;
            border-color: #059669 !important;
        }
        
        .fc-event {
            cursor: pointer;
            padding: 0.25rem 0.5rem;
            border-radius: 4px;
        }
        
        .expiring-section {
            background: white;
            border-radius: 16px;
            padding: 2rem;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }
        
        .expiring-job {
            border-left: 4px solid #f59e0b;
            padding-left: 1rem;
            margin-bottom: 1rem;
        }
        
        .btn-create-job {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white;
            border: none;
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .btn-create-job:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(16, 185, 129, 0.3);
            color: white;
            text-decoration: none;
        }
        
        .btn-create-job:disabled {
            opacity: 0.6;
            cursor: not-allowed;
        }
        
        .no-jobs-message {
            text-align: center;
            padding: 3rem;
            color: #718096;
        }
        
        .no-jobs-message i {
            font-size: 4rem;
            color: #e2e8f0;
            margin-bottom: 1rem;
        }
        
        .modal-header {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white;
        }
        
        .modal-header .btn-close {
            filter: brightness(0) invert(1);
        }
        
        .expiry-warning {
            background: #fef3c7;
            border: 1px solid #fbbf24;
            color: #92400e;
            padding: 0.5rem 1rem;
            border-radius: 6px;
            font-size: 0.875rem;
        }
        
        .limit-notice {
            background: #dbeafe;
            border: 1px solid #3b82f6;
            color: #1e40af;
            padding: 1rem;
            border-radius: 8px;
            margin-bottom: 1rem;
        }
        
        @media (max-width: 768px) {
            .jobs-container {
                padding: 1rem;
            }
            
            .page-header {
                padding: 1.5rem;
            }
            
            .stats-row {
                grid-template-columns: 1fr 1fr;
            }
            
            .job-header {
                flex-direction: column;
                align-items: flex-start;
            }
            
            .job-actions {
                flex-direction: column;
            }
        }
    </style>
</head>
<body class="has-business-header">
    <?php include(APPPATH . 'Views/business/partials/header.php'); ?>

    <div class="jobs-container">
        <!-- Page Header -->
        <div class="page-header">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1>Manage Job Postings</h1>
                    <p class="mb-0">Post open positions and attract local talent</p>
                </div>
                <?php if ($stats['active'] < 3): ?>
                    <a href="/business/jobs/create" class="btn-create-job">
                        <i class="fas fa-plus-circle"></i> Post New Job
                    </a>
                <?php else: ?>
                    <button class="btn-create-job" disabled title="Maximum 3 active jobs allowed">
                        <i class="fas fa-exclamation-triangle"></i> Limit Reached (3/3)
                    </button>
                <?php endif; ?>
            </div>
        </div>

        <?php if (session()->getFlashdata('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="fas fa-check-circle me-2"></i>
                <?= session()->getFlashdata('success') ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <?php if (session()->getFlashdata('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-circle me-2"></i>
                <?= session()->getFlashdata('error') ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <!-- Active Job Limit Notice -->
        <?php if ($stats['active'] >= 3): ?>
            <div class="limit-notice">
                <i class="fas fa-info-circle me-2"></i>
                <strong>Job Posting Limit Reached:</strong> You have 3 active job postings (the maximum allowed). 
                To post a new job, you'll need to deactivate or delete an existing posting first.
            </div>
        <?php endif; ?>

        <!-- Statistics -->
        <div class="stats-row">
            <div class="stat-card">
                <div class="stat-value"><?= $stats['total'] ?></div>
                <div class="stat-label">Total Job Postings</div>
            </div>
            <div class="stat-card">
                <div class="stat-value text-success"><?= $stats['active'] ?></div>
                <div class="stat-label">Currently Active</div>
            </div>
            <div class="stat-card">
                <div class="stat-value text-warning"><?= $stats['expiring_soon'] ?></div>
                <div class="stat-label">Expiring Soon</div>
            </div>
            <div class="stat-card">
                <div class="stat-value text-muted"><?= $stats['expired'] ?></div>
                <div class="stat-label">Expired</div>
            </div>
        </div>

        <!-- Current Active Jobs -->
        <?php if (!empty($active_jobs)): ?>
        <div class="active-jobs-card">
            <h3 class="section-title">
                <i class="fas fa-briefcase"></i>
                Active Job Postings (<?= count($active_jobs) ?>/3)
            </h3>
            <?php foreach ($active_jobs as $job): ?>
                <div class="job-item">
                    <div class="job-header">
                        <div class="flex-grow-1">
                            <div class="job-title"><?= esc($job['title']) ?></div>
                            <div class="job-meta">
                                <div class="job-meta-item">
                                    <i class="fas fa-clock"></i>
                                    <?= esc($job['employment_type_display']) ?>
                                </div>
                                <div class="job-meta-item">
                                    <i class="fas fa-dollar-sign"></i>
                                    <?= esc($job['salary_display']) ?>
                                </div>
                                <div class="job-meta-item">
                                    <i class="fas fa-envelope"></i>
                                    <?= esc($job['contact_method_display']) ?>
                                </div>
                                <?php if ($job['days_until_expiration'] !== null): ?>
                                    <div class="job-meta-item <?= $job['days_until_expiration'] <= 7 ? 'text-warning' : '' ?>">
                                        <i class="fas fa-calendar-alt"></i>
                                        <?php if ($job['days_until_expiration'] <= 0): ?>
                                            Expires today
                                        <?php elseif ($job['days_until_expiration'] == 1): ?>
                                            Expires tomorrow
                                        <?php else: ?>
                                            Expires in <?= $job['days_until_expiration'] ?> days
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="job-description">
                                <?= esc(substr($job['description'], 0, 200)) ?><?= strlen($job['description']) > 200 ? '...' : '' ?>
                            </div>
                        </div>
                    </div>
                    <div class="job-actions">
                        <a href="/business/jobs/edit/<?= $job['id'] ?>" class="btn btn-primary btn-sm">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <a href="/business/jobs/preview/<?= $job['id'] ?>" class="btn btn-secondary btn-sm">
                            <i class="fas fa-eye"></i> Preview
                        </a>
                        <?php if ($job['days_until_expiration'] <= 7): ?>
                            <button class="btn btn-success btn-sm" onclick="renewJob(<?= $job['id'] ?>)">
                                <i class="fas fa-refresh"></i> Renew (30 days)
                            </button>
                        <?php endif; ?>
                        <button class="btn btn-outline-danger btn-sm" onclick="toggleJob(<?= $job['id'] ?>, 0)">
                            <i class="fas fa-pause"></i> Deactivate
                        </button>
                    </div>
                    <?php if ($job['days_until_expiration'] <= 7): ?>
                        <div class="expiry-warning mt-2">
                            <i class="fas fa-exclamation-triangle me-1"></i>
                            This job posting expires in <?= $job['days_until_expiration'] ?> days
                        </div>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>

        <!-- Calendar View -->
        <div class="calendar-section">
            <h3 class="section-title">
                <i class="fas fa-calendar-alt"></i>
                Job Posting Calendar
            </h3>
            <div id="calendar"></div>
        </div>

        <!-- Expiring Jobs -->
        <?php if (!empty($expiring_jobs)): ?>
        <div class="expiring-section">
            <h3 class="section-title">
                <i class="fas fa-clock"></i>
                Jobs Expiring Soon
            </h3>
            <?php foreach ($expiring_jobs as $job): ?>
                <?php $formatted = $this->jobModel->formatJobDisplay($job); ?>
                <div class="expiring-job">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <h5><?= esc($job['title']) ?></h5>
                            <p class="text-muted mb-1"><?= esc($formatted['employment_type_display']) ?> • <?= esc($formatted['salary_display']) ?></p>
                            <p class="mb-0">
                                <small>Expires: <?= $formatted['expires_at_formatted'] ?></small>
                            </p>
                        </div>
                        <div>
                            <button class="btn btn-sm btn-success me-2" onclick="renewJob(<?= $job['id'] ?>)">
                                <i class="fas fa-refresh"></i> Renew
                            </button>
                            <a href="/business/jobs/edit/<?= $job['id'] ?>" class="btn btn-sm btn-outline-primary">
                                <i class="fas fa-edit"></i>
                            </a>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>

        <?php if ($stats['total'] == 0): ?>
        <div class="expiring-section">
            <div class="no-jobs-message">
                <i class="fas fa-briefcase"></i>
                <h4>No Job Postings Yet</h4>
                <p>Start attracting local talent by posting your first job opening!</p>
                <a href="/business/jobs/create" class="btn-create-job">
                    <i class="fas fa-plus-circle"></i> Post Your First Job
                </a>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <!-- Job Detail Modal -->
    <div class="modal fade" id="jobModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Job Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body" id="jobModalBody">
                    <!-- Content loaded via JavaScript -->
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <a href="#" id="editJobBtn" class="btn btn-primary">Edit Job</a>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.10/index.global.min.js"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize calendar
        var calendarEl = document.getElementById('calendar');
        var calendar = new FullCalendar.Calendar(calendarEl, {
            initialView: 'dayGridMonth',
            headerToolbar: {
                left: 'prev,next today',
                center: 'title',
                right: 'dayGridMonth,listMonth'
            },
            events: <?= $calendar_events ?>,
            eventClick: function(info) {
                // Show job details
                showJobDetails(info.event.id);
            },
            eventDidMount: function(info) {
                // Add tooltip
                info.el.setAttribute('title', info.event.extendedProps.description);
            }
        });
        calendar.render();
    });

    // Show job details in modal
    function showJobDetails(jobId) {
        fetch('/business/jobs/details/' + jobId)
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    var job = data.job;
                    var html = `
                        <div class="mb-3">
                            <span class="badge bg-success fs-6">${job.employment_type_display}</span>
                            <span class="badge bg-primary fs-6 ms-2">${job.salary_display}</span>
                        </div>
                        <h4>${job.title}</h4>
                        <p>${job.description}</p>
                        <hr>
                        <p><strong>Contact Method:</strong><br>
                        ${job.contact_method_display}</p>
                        <p><strong>Posted:</strong> ${job.created_at_formatted}</p>
                        <p><strong>Expires:</strong> ${job.expires_at_formatted}</p>
                        ${job.times_renewed > 0 ? `<p><strong>Times Renewed:</strong> ${job.times_renewed}</p>` : ''}
                        <p><strong>Status:</strong> 
                        ${job.is_active ? '<span class="badge bg-success">Active</span>' : '<span class="badge bg-secondary">Inactive</span>'}</p>
                        ${job.days_until_expiration > 0 && job.days_until_expiration <= 7 ? 
                            `<div class="alert alert-warning mt-3 mb-0">
                                <i class="fas fa-exclamation-triangle"></i> Expires in ${job.days_until_expiration} days
                            </div>` : ''}
                    `;
                    
                    document.getElementById('jobModalBody').innerHTML = html;
                    document.getElementById('editJobBtn').href = '/business/jobs/edit/' + jobId;
                    
                    var modal = new bootstrap.Modal(document.getElementById('jobModal'));
                    modal.show();
                }
            })
            .catch(error => {
                console.error('Error fetching job details:', error);
            });
    }

    // Toggle job status
    function toggleJob(jobId, status) {
        fetch('/business/jobs/toggle/' + jobId, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert(data.message || 'Failed to update job status');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred');
        });
    }

    // Renew job posting
    function renewJob(jobId) {
        if (confirm('Renew this job posting for another 30 days?')) {
            fetch('/business/jobs/renew/' + jobId, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-Requested-With': 'XMLHttpRequest'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert(data.message);
                    location.reload();
                } else {
                    alert(data.message || 'Failed to renew job posting');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('An error occurred');
            });
        }
    }
    </script>
</body>
</html>