<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>New Message - <?= esc($case['case_number']) ?></title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; margin: 0; padding: 0; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%); color: white; padding: 20px; border-radius: 8px 8px 0 0; }
        .content { background: #f8f9fa; padding: 20px; border-radius: 0 0 8px 8px; }
        .case-number { font-family: 'Courier New', monospace; font-size: 16px; font-weight: bold; }
        .message-box { background: white; border-left: 4px solid #3b82f6; padding: 15px; margin: 15px 0; border-radius: 6px; }
        .customer-info { background: #e0f2fe; padding: 10px; border-radius: 4px; margin: 10px 0; }
        .action-button { background: #3b82f6; color: white; padding: 12px 24px; text-decoration: none; border-radius: 6px; display: inline-block; margin: 10px 0; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>New Customer Message</h2>
            <div class="case-number">Case: <?= esc($case['case_number']) ?></div>
        </div>
        
        <div class="content">
            <p><strong><?= esc($case['customer_name'] ?: 'Your customer') ?> has replied to their feedback case.</strong></p>
            
            <div class="customer-info">
                <strong>Customer:</strong> <?= esc($case['customer_name'] ?: 'Anonymous') ?><br>
                <strong>Contact:</strong> <?= esc($case['customer_contact']) ?>
            </div>
            
            <div class="message-box">
                <h4>New Message:</h4>
                <p><?= nl2br(esc($message['message'])) ?></p>
                <small>Sent: <?= $message['created_at_formatted'] ?></small>
            </div>
            
            <p>Responding promptly shows your commitment to customer service and can help resolve their concerns effectively.</p>
            
            <a href="<?= base_url('business/feedback/case/' . $case['case_id']) ?>" class="action-button">
                Reply to Customer
            </a>
            
            <p><small>Case Status: <strong><?= ucfirst(str_replace('_', ' ', $case['status'])) ?></strong></small></p>
        </div>
    </div>
</body>
</html>

