<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= esc($title) ?> - Business Portal</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css" rel="stylesheet">
    <style>
        body {
            background: #f7fafc;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body.has-business-header {
            padding-top: 70px;
        }
        
        .form-container {
            max-width: 800px;
            margin: 0 auto;
            padding: 2rem;
        }
        
        .form-card {
            background: white;
            border-radius: 16px;
            padding: 2.5rem;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }
        
        .form-header {
            margin-bottom: 2rem;
            padding-bottom: 1.5rem;
            border-bottom: 2px solid #e9ecef;
        }
        
        .form-header h2 {
            font-size: 1.75rem;
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 0.5rem;
        }
        
        .form-header p {
            color: #718096;
            margin-bottom: 0;
        }
        
        .form-section {
            margin-bottom: 2rem;
        }
        
        .section-title {
            font-size: 1.25rem;
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .form-label {
            font-weight: 600;
            color: #4a5568;
            margin-bottom: 0.5rem;
        }
        
        .form-text {
            color: #718096;
            font-size: 0.875rem;
        }
        
        .discount-type-selector {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
            gap: 1rem;
            margin-bottom: 1.5rem;
        }
        
        .discount-type-option {
            position: relative;
        }
        
        .discount-type-option input[type="radio"] {
            position: absolute;
            opacity: 0;
        }
        
        .discount-type-label {
            display: block;
            padding: 1rem;
            border: 2px solid #e2e8f0;
            border-radius: 8px;
            text-align: center;
            cursor: pointer;
            transition: all 0.2s ease;
        }
        
        .discount-type-option input[type="radio"]:checked + .discount-type-label {
            border-color: #667eea;
            background: #f3f4ff;
            color: #667eea;
        }
        
        .discount-type-label i {
            font-size: 1.5rem;
            margin-bottom: 0.5rem;
            display: block;
        }
        
        .preview-section {
            background: #f8f9ff;
            border: 2px dashed #667eea;
            border-radius: 12px;
            padding: 1.5rem;
            margin-top: 2rem;
        }
        
        .preview-title {
            font-size: 1.1rem;
            font-weight: 600;
            color: #667eea;
            margin-bottom: 1rem;
        }
        
        .preview-coupon {
            background: white;
            border: 2px solid #10b981;
            border-radius: 8px;
            padding: 1.5rem;
            text-align: center;
        }
        
        .preview-discount {
            font-size: 2rem;
            font-weight: 700;
            color: #10b981;
            margin-bottom: 0.5rem;
        }
        
        .btn-primary-custom {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 0.75rem 2rem;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .btn-primary-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.3);
            color: white;
        }
        
        .date-input-group {
            position: relative;
        }
        
        .date-input-group i {
            position: absolute;
            right: 1rem;
            top: 50%;
            transform: translateY(-50%);
            color: #718096;
            pointer-events: none;
        }
        
        .alert-info-custom {
            background: #e0f2fe;
            border: 1px solid #0284c7;
            color: #075985;
            padding: 1rem;
            border-radius: 8px;
            margin-bottom: 1.5rem;
        }
        
        @media (max-width: 768px) {
            .form-container {
                padding: 1rem;
            }
            
            .form-card {
                padding: 1.5rem;
            }
            
            .discount-type-selector {
                grid-template-columns: 1fr 1fr;
            }
        }
    </style>
</head>
<body class="has-business-header">
    <?php include(APPPATH . 'Views/business/partials/header.php'); ?>

    <div class="form-container">
        <!-- DEBUG: Cache test - File version <?= date('Y-m-d H:i:s') ?> -->
        <div class="form-card">
            <div class="form-header">
                <h2>
                    <i class="fas fa-ticket-alt me-2"></i>
                    <?= $is_edit ? 'Edit Coupon' : 'Create New Coupon' ?>
                </h2>
                <p>Design an attractive offer to bring in more customers</p>
                <!-- DEBUG: Current timestamp: <?= time() ?> -->
            </div>

            <?php if (session()->getFlashdata('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="fas fa-exclamation-circle me-2"></i>
                    <?= session()->getFlashdata('error') ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if (session()->getFlashdata('validation')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    <div>
                        <strong>Please fix the following errors:</strong>
                        <ul class="mb-0 mt-1">
                            <?php foreach (session()->getFlashdata('validation') as $error): ?>
                                <li><?= esc($error) ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if (session()->getFlashdata('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="fas fa-check-circle me-2"></i>
                    <?= session()->getFlashdata('success') ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

          <div class="alert-info-custom">
   <i class="fas fa-info-circle me-2"></i>
   <strong>Important:</strong> Only one coupon can be active at a time. Creating an overlapping active coupon will automatically deactivate any existing ones.
</div>

<form method="post" id="couponForm" action="<?= $is_edit ? '/business/coupons/edit/' . $coupon['id'] : '/business/coupons/create' ?>">
   <?= csrf_field() ?>
                <!-- Discount Type Section -->
                <div class="form-section">
                    <h3 class="section-title">
                        <i class="fas fa-percentage"></i>
                        Discount Type
                    </h3>
                    
                    <div class="discount-type-selector">
                        <div class="discount-type-option">
                            <input type="radio" id="type_percentage" name="discount_type" value="percentage" 
                                   <?= old('discount_type', $coupon['discount_type'] ?? 'percentage') === 'percentage' ? 'checked' : '' ?>>
                            <label for="type_percentage" class="discount-type-label">
                                <i class="fas fa-percentage"></i>
                                <div>Percentage Off</div>
                            </label>
                        </div>
                        
                        <div class="discount-type-option">
                            <input type="radio" id="type_fixed" name="discount_type" value="fixed_amount" 
                                   <?= old('discount_type', $coupon['discount_type'] ?? '') === 'fixed_amount' ? 'checked' : '' ?>>
                            <label for="type_fixed" class="discount-type-label">
                                <i class="fas fa-dollar-sign"></i>
                                <div>Fixed Amount</div>
                            </label>
                        </div>
                        
                        <div class="discount-type-option">
                            <input type="radio" id="type_bogo" name="discount_type" value="bogo" 
                                   <?= old('discount_type', $coupon['discount_type'] ?? '') === 'bogo' ? 'checked' : '' ?>>
                            <label for="type_bogo" class="discount-type-label">
                                <i class="fas fa-gift"></i>
                                <div>Buy One Get One</div>
                            </label>
                        </div>
                        
                        <div class="discount-type-option">
                            <input type="radio" id="type_free" name="discount_type" value="free_item" 
                                   <?= old('discount_type', $coupon['discount_type'] ?? '') === 'free_item' ? 'checked' : '' ?>>
                            <label for="type_free" class="discount-type-label">
                                <i class="fas fa-star"></i>
                                <div>Free Item</div>
                            </label>
                        </div>
                    </div>

                    <div class="row" id="discountValueSection">
                        <div class="col-md-6">
                            <label for="discount_value" class="form-label">Discount Value <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <span class="input-group-text" id="valuePrefix">%</span>
                                <input type="number" class="form-control" id="discount_value" name="discount_value" 
                                       value="<?= old('discount_value', $coupon['discount_value'] ?? '') ?>" 
                                       step="0.01" min="0" max="100" required>
                            </div>
                            <div class="form-text" id="valueHelp">Enter percentage between 0 and 100</div>
                        </div>
                        
                        <div class="col-md-6">
                            <label for="minimum_purchase" class="form-label">Minimum Purchase Amount</label>
                            <div class="input-group">
                                <span class="input-group-text">$</span>
                                <input type="number" class="form-control" id="minimum_purchase" name="minimum_purchase" 
                                       value="<?= old('minimum_purchase', $coupon['minimum_purchase'] ?? '') ?>" 
                                       step="0.01" min="0">
                            </div>
                            <div class="form-text">Leave blank for no minimum</div>
                        </div>
                    </div>
                </div>

                <!-- Coupon Details Section -->
                <div class="form-section">
                    <h3 class="section-title">
                        <i class="fas fa-info-circle"></i>
                        Coupon Details
                    </h3>
                    
                    <div class="mb-3">
                        <label for="title" class="form-label">Coupon Title <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="title" name="title" 
                               value="<?= old('title', $coupon['title'] ?? '') ?>" 
                               placeholder="e.g., Weekend Special, Holiday Sale" required>
                        <div class="form-text">A catchy title to grab attention</div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="description" class="form-label">Description <span class="text-danger">*</span></label>
                        <textarea class="form-control" id="description" name="description" rows="3" 
                                  placeholder="Describe what the coupon offers and any special conditions" 
                                  required 
                                  minlength="10"
                                  value="<?= old('description', $coupon['description'] ?? '') ?>"><?= old('description', $coupon['description'] ?? '') ?></textarea>
                        <div class="form-text">
                            Clear description helps customers understand the offer (minimum 10 characters)
                            <span class="char-counter">
                                <span id="descriptionCount">0</span>/10 minimum
                            </span>
                        </div>
                    </div>
                </div>

                <!-- Validity Period Section -->
                <div class="form-section">
                    <h3 class="section-title">
                        <i class="fas fa-calendar-alt"></i>
                        Validity Period
                    </h3>
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="starts_at" class="form-label">Start Date <span class="text-danger">*</span></label>
                            <div class="date-input-group">
                                <input type="text" class="form-control datepicker" id="starts_at" name="starts_at" 
                                       value="<?= old('starts_at', $coupon['starts_at'] ?? '') ?>" required>
                                <i class="fas fa-calendar"></i>
                            </div>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <label for="expires_at" class="form-label">Expiration Date <span class="text-danger">*</span></label>
                            <div class="date-input-group">
                                <input type="text" class="form-control datepicker" id="expires_at" name="expires_at" 
                                       value="<?= old('expires_at', $coupon['expires_at'] ?? '') ?>" required>
                                <i class="fas fa-calendar"></i>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Usage Limits Section -->
                <div class="form-section">
                    <h3 class="section-title">
                        <i class="fas fa-users"></i>
                        Usage Limits
                    </h3>
                    
                    <div class="row">
                        <?php /* Commented out until usage tracking is implemented
                        <div class="col-md-6 mb-3">
                            <label for="usage_limit" class="form-label">Maximum Uses</label>
                            <input type="number" class="form-control" id="usage_limit" name="usage_limit" 
                                   value="<?= old('usage_limit', $coupon['usage_limit'] ?? '') ?>" 
                                   min="0">
                            <div class="form-text">Leave blank for unlimited uses</div>
                        </div>
                        */ ?>
                        
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Status</label>
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1"
                                       <?= old('is_active', $coupon['is_active'] ?? 1) ? 'checked' : '' ?>>
                                <label class="form-check-label" for="is_active">
                                    Active (visible to customers when dates are valid)
                                </label>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Preview Section -->
                <div class="preview-section">
                    <div class="preview-title">
                        <i class="fas fa-eye me-2"></i>
                        Live Preview
                    </div>
                    <div class="preview-coupon">
                        <div class="preview-discount" id="previewDiscount">20% OFF</div>
                        <h4 id="previewTitle">Your Coupon Title</h4>
                        <p id="previewDescription">Your coupon description will appear here</p>
                        <small class="text-muted" id="previewValidity">Valid: Start Date - End Date</small>
                    </div>
                </div>

                <!-- Form Actions -->
                <div class="mt-4 d-flex gap-2">
                    <button type="submit" class="btn btn-primary-custom">
                        <i class="fas fa-save me-2"></i>
                        <?= $is_edit ? 'Update Coupon' : 'Create Coupon' ?>
                    </button>
                    <a href="<?= base_url('business/coupons') ?>" class="btn btn-secondary">
                        <i class="fas fa-times me-2"></i>
                        Cancel
                    </a>
                </div>
            </form>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // DEBUG: Log form action URL
        const form = document.getElementById('couponForm');
        console.log('DEBUG: Form action URL:', form.action);
        console.log('DEBUG: Form action ATTRIBUTE:', form.getAttribute('action'));
        console.log('DEBUG: Base URL:', '<?= base_url() ?>');
        console.log('DEBUG: Expected URL:', '/business/coupons/create');
        console.log('DEBUG: File version timestamp:', '<?= date("Y-m-d H:i:s") ?>');
        console.log('DEBUG: PHP time():', '<?= time() ?>');
        
        // Add form submit handler for debugging
        form.addEventListener('submit', function(e) {
            console.log('Form being submitted to:', this.action);
            console.log('Form method:', this.method);
            console.log('Form data:', new FormData(this));
        });
        // Initialize date pickers
        flatpickr('.datepicker', {
            dateFormat: 'Y-m-d',
            minDate: 'today',
            allowInput: true
        });

        // Handle discount type changes
        const discountTypes = document.querySelectorAll('input[name="discount_type"]');
        const valueSection = document.getElementById('discountValueSection');
        const valuePrefix = document.getElementById('valuePrefix');
        const valueInput = document.getElementById('discount_value');
        const valueHelp = document.getElementById('valueHelp');

        function updateDiscountFields() {
            const selectedType = document.querySelector('input[name="discount_type"]:checked').value;
            
            switch(selectedType) {
                case 'percentage':
                    valueSection.style.display = 'flex';
                    valuePrefix.textContent = '%';
                    valueInput.max = 100;
                    valueInput.required = true;
                    valueHelp.textContent = 'Enter percentage between 0 and 100';
                    break;
                case 'fixed_amount':
                    valueSection.style.display = 'flex';
                    valuePrefix.textContent = '$';
                    valueInput.max = '';
                    valueInput.required = true;
                    valueHelp.textContent = 'Enter dollar amount off';
                    break;
                case 'bogo':
                case 'free_item':
                    valueSection.style.display = 'none';
                    valueInput.required = false;
                    valueInput.value = '1'; // Default value for these types
                    break;
            }
            updatePreview();
        }

        discountTypes.forEach(radio => {
            radio.addEventListener('change', updateDiscountFields);
        });

        // Live preview updates
        function updatePreview() {
            const type = document.querySelector('input[name="discount_type"]:checked').value;
            const value = document.getElementById('discount_value').value;
            const title = document.getElementById('title').value;
            const description = document.getElementById('description').value;
            const startDate = document.getElementById('starts_at').value;
            const endDate = document.getElementById('expires_at').value;

            // Update discount display
            let discountText = '';
            switch(type) {
                case 'percentage':
                    discountText = value ? `${value}% OFF` : 'DISCOUNT';
                    break;
                case 'fixed_amount':
                    discountText = value ? `$${parseFloat(value).toFixed(2)} OFF` : 'DISCOUNT';
                    break;
                case 'bogo':
                    discountText = 'BUY ONE GET ONE';
                    break;
                case 'free_item':
                    discountText = 'FREE ITEM';
                    break;
            }
            document.getElementById('previewDiscount').textContent = discountText;

            // Update other fields
            document.getElementById('previewTitle').textContent = title || 'Your Coupon Title';
            document.getElementById('previewDescription').textContent = description || 'Your coupon description will appear here';
            
            if (startDate && endDate) {
                const start = new Date(startDate).toLocaleDateString('en-US', { month: 'short', day: 'numeric', year: 'numeric' });
                const end = new Date(endDate).toLocaleDateString('en-US', { month: 'short', day: 'numeric', year: 'numeric' });
                document.getElementById('previewValidity').textContent = `Valid: ${start} - ${end}`;
            }
        }

        // Add event listeners for preview updates and validation
        document.getElementById('discount_value').addEventListener('input', updatePreview);
        document.getElementById('title').addEventListener('input', updatePreview);
        document.getElementById('description').addEventListener('input', function() {
            updatePreview();
            updateDescriptionCounter();
        });
        document.getElementById('starts_at').addEventListener('change', updatePreview);
        document.getElementById('expires_at').addEventListener('change', updatePreview);

        // Description character counter and validation
        function updateDescriptionCounter() {
            const textarea = document.getElementById('description');
            const counter = document.getElementById('descriptionCount');
            const count = textarea.value.length;
            counter.textContent = count;
            
            // Visual feedback for validation
            if (count < 10) {
                counter.style.color = '#e53e3e';
                textarea.classList.add('is-invalid');
                textarea.classList.remove('is-valid');
            } else {
                counter.style.color = '#10b981';
                textarea.classList.remove('is-invalid');
                textarea.classList.add('is-valid');
            }
        }

        // Form submission validation
        document.getElementById('couponForm').addEventListener('submit', function(e) {
            const description = document.getElementById('description').value;
            if (description.length < 10) {
                e.preventDefault();
                alert('Description must be at least 10 characters long.');
                document.getElementById('description').focus();
                return false;
            }
        });

        // Initialize on load
        updateDiscountFields();
        updatePreview();
    });
    </script>
</body>
</html>