<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?></title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            color: #333;
        }

        .admin-header {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.2);
            padding: 1rem 0;
            position: sticky;
            top: 0;
            z-index: 100;
            box-shadow: 0 2px 20px rgba(0, 0, 0, 0.1);
        }

        .nav-container {
            max-width: 1400px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 2rem;
        }

        .nav-brand {
            font-size: 1.5rem;
            font-weight: 700;
            color: #4a5568;
            text-decoration: none;
        }

        .nav-links {
            display: flex;
            gap: 0;
        }

        .nav-links a {
            color: #4a5568;
            text-decoration: none;
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            transition: all 0.3s ease;
            font-weight: 500;
            position: relative;
        }

        .nav-links a:hover {
            background: rgba(102, 126, 234, 0.1);
            color: #667eea;
        }

        .nav-links a.active {
            background: #667eea;
            color: white;
            box-shadow: 0 2px 10px rgba(102, 126, 234, 0.3);
        }

        .user-menu {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .user-info {
            font-size: 0.9rem;
            color: #666;
        }

        .logout-btn {
            background: #e53e3e;
            color: white;
            padding: 0.5rem 1rem;
            border-radius: 6px;
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .logout-btn:hover {
            background: #c53030;
            transform: translateY(-1px);
        }

        .main-container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 2rem;
        }

        .page-header {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .page-title {
            font-size: 2.5rem;
            font-weight: 700;
            color: #2d3748;
            margin-bottom: 0.5rem;
        }

        .page-subtitle {
            color: #718096;
            font-size: 1.1rem;
        }

        .search-panel {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .search-grid {
            display: grid;
            grid-template-columns: 2fr 1fr 1fr 1fr auto auto;
            gap: 1.5rem;
            align-items: end;
        }

        .form-group {
            position: relative;
        }

        .form-label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 600;
            color: #4a5568;
            font-size: 0.9rem;
        }

        .form-input, .form-select {
            width: 100%;
            padding: 0.875rem 1rem;
            border: 2px solid #e2e8f0;
            border-radius: 10px;
            font-size: 1rem;
            transition: all 0.3s ease;
            background: white;
        }

        .form-input:focus, .form-select:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .search-input {
            padding-left: 3rem;
        }

        .search-icon {
            position: absolute;
            left: 1rem;
            top: 50%;
            transform: translateY(-50%);
            color: #a0aec0;
            font-size: 1.1rem;
        }

        .btn {
            padding: 0.875rem 1.5rem;
            border: none;
            border-radius: 10px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            transition: all 0.3s ease;
            cursor: pointer;
            font-size: 0.95rem;
        }

        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
        }

        .btn-secondary {
            background: #f7fafc;
            color: #4a5568;
            border: 2px solid #e2e8f0;
        }

        .btn-secondary:hover {
            background: #edf2f7;
            border-color: #cbd5e0;
        }

        .stores-container {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 2rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .stores-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 1rem;
        }

        .stores-table th {
            background: #f8fafc;
            padding: 1rem;
            text-align: left;
            font-weight: 600;
            color: #4a5568;
            border-bottom: 2px solid #e2e8f0;
            font-size: 0.9rem;
        }

        .stores-table td {
            padding: 1rem;
            border-bottom: 1px solid #e2e8f0;
            vertical-align: top;
        }

        .stores-table tr:hover {
            background: rgba(102, 126, 234, 0.02);
        }

        .store-name {
            font-weight: 600;
            color: #2d3748;
            font-size: 1.1rem;
            margin-bottom: 0.25rem;
        }

        .store-address {
            color: #718096;
            font-size: 0.9rem;
        }

        .category-badges {
            display: flex;
            flex-wrap: wrap;
            gap: 0.25rem;
            margin-top: 0.5rem;
        }

        .category-badge {
            background: #bee3f8;
            color: #2b6cb0;
            padding: 0.25rem 0.5rem;
            border-radius: 12px;
            font-size: 0.75rem;
            font-weight: 600;
        }

        .no-categories {
            color: #ed8936;
            font-size: 0.8rem;
            font-style: italic;
        }

        .status-badge {
            padding: 0.375rem 0.75rem;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .status-open {
            background: #c6f6d5;
            color: #22543d;
        }

        .status-closed {
            background: #fed7d7;
            color: #742a2a;
        }

        .status-closing-soon {
            background: #fef5e7;
            color: #975a16;
        }

        .status-no-hours {
            background: #e2e8f0;
            color: #4a5568;
        }

        .action-buttons {
            display: flex;
            gap: 0.5rem;
        }

        .btn-sm {
            padding: 0.5rem 0.75rem;
            font-size: 0.8rem;
            border-radius: 6px;
        }

        .btn-view {
            background: #4299e1;
            color: white;
        }

        .btn-edit {
            background: #38a169;
            color: white;
        }

        .btn-hours {
            background: #ed8936;
            color: white;
        }

        .btn-sm:hover {
            transform: translateY(-1px);
            opacity: 0.9;
        }

        .pagination {
            margin-top: 2rem;
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 1rem;
        }

        .pagination-info {
            color: #718096;
            font-size: 0.9rem;
        }

        .pagination-nav {
            display: flex;
            gap: 0.5rem;
        }

        .alert {
            padding: 1rem 1.5rem;
            border-radius: 10px;
            margin-bottom: 1.5rem;
            border-left: 4px solid;
            font-weight: 500;
        }

        .alert-success {
            background: #f0fff4;
            border-color: #38a169;
            color: #22543d;
        }

        .alert-error {
            background: #fffaf0;
            border-color: #e53e3e;
            color: #742a2a;
        }

        @media (max-width: 1200px) {
            .search-grid {
                grid-template-columns: 1fr 1fr;
                gap: 1rem;
            }
        }

        @media (max-width: 768px) {
            .main-container {
                padding: 1rem;
            }
            
            .search-grid {
                grid-template-columns: 1fr;
            }
            
            .stores-table {
                font-size: 0.9rem;
            }
            
            .action-buttons {
                flex-direction: column;
            }
        }
    
    .btn-danger {
    background: #dc3545;
    color: white;
}

.btn-danger:hover {
    background: #c82333;
    transform: translateY(-1px);
}

.btn-info {
    background: #17a2b8;
    color: white;
}

.btn-info:hover {
    background: #138496;
}

.modal-content {
    border-radius: 16px;
}

.danger-zone {
    border: 2px solid #dc3545;
    border-radius: 8px;
    padding: 1rem;
    margin-top: 1rem;
    background: #fff5f5;
}
    
    </style>
</head>
<body>
    <header class="admin-header">
        <div class="nav-container">
            <a href="/admin/dashboard" class="nav-brand">
                <i class="fas fa-store"></i> Business Directory Admin
            </a>
            
            <nav class="nav-links">
                <a href="/admin/dashboard">
                    <i class="fas fa-tachometer-alt"></i> Dashboard
                </a>
                <a href="/admin/stores" class="active">
                    <i class="fas fa-building"></i> Stores
                </a>
                <a href="/admin/hours">
                    <i class="fas fa-clock"></i> Hours
                </a>
                <a href="/admin/categories">
                    <i class="fas fa-tags"></i> Categories
                </a>
                <a href="/admin/settings">
                    <i class="fas fa-cog"></i> Settings
                </a>
            </nav>
            
            <div class="user-menu">
                <div class="user-info">
                    <i class="fas fa-user-circle"></i>
                    <?= session()->get('admin_name') ?>
                </div>
                <a href="/admin/logout" class="logout-btn">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
            </div>
        </div>
    </header>

    <main class="main-container">
        <div class="page-header">
            <h1 class="page-title">
                <i class="fas fa-building"></i> Store Management
            </h1>
            <p class="page-subtitle">
                Manage your business directory with <?= number_format($pagination['total']) ?> locations
            </p>
        </div>

        <?php if (session()->getFlashdata('success')): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i>
                <?= session()->getFlashdata('success') ?>
            </div>
        <?php endif; ?>

        <?php if (session()->getFlashdata('error')): ?>
            <div class="alert alert-error">
                <i class="fas fa-exclamation-triangle"></i>
                <?= session()->getFlashdata('error') ?>
            </div>
        <?php endif; ?>

        <div class="search-panel">
            <form method="get">
                <div class="search-grid">
                    <div class="form-group">
                        <label class="form-label">
                            <i class="fas fa-search"></i> Search Businesses
                        </label>
                        <div style="position: relative;">
                            <i class="fas fa-search search-icon"></i>
                            <input type="text" name="search" value="<?= esc($search) ?>" 
                                   class="form-input search-input"
                                   placeholder="Business name, address, city, phone number...">
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">
                            <i class="fas fa-filter"></i> Status Filter
                        </label>
                        <select name="status" class="form-select">
                            <option value="">All Statuses</option>
                            <option value="active" <?= $statusFilter === 'active' ? 'selected' : '' ?>>
                                Active Businesses
                            </option>
                            <option value="inactive" <?= $statusFilter === 'inactive' ? 'selected' : '' ?>>
                                Inactive Businesses
                            </option>
                            <option value="closed" <?= $statusFilter === 'closed' ? 'selected' : '' ?>>
                                Temporarily Closed
                            </option>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">
                            <i class="fas fa-tags"></i> Category Filter
                        </label>
                        <select name="category" class="form-select">
                            <option value="">All Categories</option>
                            <?php foreach ($categories as $category): ?>
                                <option value="<?= esc($category['category_id']) ?>" 
                                        <?= $categoryFilter === $category['category_id'] ? 'selected' : '' ?>>
                                    <?= esc($category['title']) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">
                            <i class="fas fa-map-marker-alt"></i> Location
                        </label>
                        <select name="city" class="form-select">
                            <option value="">All Cities</option>
                            <!-- Add dynamic city options here -->
                        </select>
                    </div>
                    
                    <div>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-search"></i> Search
                        </button>
                    </div>
                    
                    <div>
                        <a href="/admin/stores" class="btn btn-secondary">
                            <i class="fas fa-times"></i> Clear
                        </a>
                    </div>
                </div>
            </form>
        </div>

        <div class="stores-container">
            <?php if (!empty($stores)): ?>
                <table class="stores-table">
                    <thead>
                        <tr>
                            <th>Business Information</th>
                            <th>Categories</th>
                            <th>Contact</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($stores as $store): ?>
                            <tr>
                                <td>
                                    <div class="store-name"><?= esc($store['name']) ?></div>
                                    <div class="store-address">
                                        <i class="fas fa-map-marker-alt"></i>
                                        <?= esc($store['address']) ?>, <?= esc($store['city']) ?>, <?= esc($store['state']) ?>
                                    </div>
                                </td>
                                
                                <td>
                                    <?php if (!empty($store['categories'])): ?>
                                        <div class="category-badges">
                                            <?php 
                                            $categoryList = explode(', ', $store['categories']);
                                            foreach ($categoryList as $category): 
                                            ?>
                                                <span class="category-badge"><?= esc($category) ?></span>
                                            <?php endforeach; ?>
                                        </div>
                                        <div style="font-size: 0.8rem; color: #666; margin-top: 0.25rem;">
                                            <?= $store['category_count'] ?> categories
                                        </div>
                                    <?php else: ?>
                                        <div class="no-categories">
                                            <i class="fas fa-exclamation-triangle"></i> No categories assigned
                                        </div>
                                    <?php endif; ?>
                                </td>
                                
                                <td>
                                    <?php if (!empty($store['phone'])): ?>
                                        <div><i class="fas fa-phone"></i> <?= esc($store['phone']) ?></div>
                                    <?php endif; ?>
                                    <?php if (!empty($store['email'])): ?>
                                        <div><i class="fas fa-envelope"></i> <?= esc($store['email']) ?></div>
                                    <?php endif; ?>
                                    <?php if (!empty($store['website'])): ?>
                                        <div><i class="fas fa-globe"></i> <a href="<?= esc($store['website']) ?>" target="_blank">Website</a></div>
                                    <?php endif; ?>
                                </td>
                                
                                <td>
                                    <?php if ($store['status'] == 1): ?>
                                        <?php if ($store['is_closed'] == 1): ?>
                                            <div class="status-badge status-closed">
                                                <i class="fas fa-door-closed"></i> Temporarily Closed
                                            </div>
                                        <?php else: ?>
                                            <div class="status-badge status-open">
                                                <i class="fas fa-check-circle"></i> Active
                                            </div>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <div class="status-badge status-no-hours">
                                            <i class="fas fa-times-circle"></i> Inactive
                                        </div>
                                    <?php endif; ?>
                                </td>
                                
                                <td>
    <div class="action-buttons">
        <a href="/admin/stores/view/<?= $store['id'] ?>" 
           class="btn btn-view btn-sm" title="View Details">
            <i class="fas fa-eye"></i>
        </a>
        <a href="/admin/stores/edit/<?= $store['id'] ?>" 
           class="btn btn-edit btn-sm" title="Edit Store">
            <i class="fas fa-edit"></i>
        </a>
        <a href="/admin/hours/store/<?= $store['store_id'] ?>" 
           class="btn btn-hours btn-sm" title="Manage Hours">
            <i class="fas fa-clock"></i>
        </a>
        <button class="btn btn-info btn-sm" onclick="testGoogleApi('<?= $store['store_id'] ?>')" title="Test Google API">
            <i class="fas fa-search"></i>
        </button>
        <button class="btn btn-danger btn-sm" onclick="confirmDelete('<?= $store['store_id'] ?>', '<?= esc($store['name']) ?>')" title="Delete Business">
            <i class="fas fa-trash"></i>
        </button>
    </div>
</td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>

                <!-- Pagination -->
                <?php if ($pagination['total_pages'] > 1): ?>
                    <div class="pagination">
                        <div class="pagination-info">
                            Showing <?= (($pagination['current_page'] - 1) * $pagination['per_page']) + 1 ?>-<?= min($pagination['current_page'] * $pagination['per_page'], $pagination['total']) ?> 
                            of <?= number_format($pagination['total']) ?> businesses
                        </div>
                        
                        <div class="pagination-nav">
                            <?php
                            $queryParams = [];
                            if (!empty($search)) $queryParams[] = 'search=' . urlencode($search);
                            if (!empty($statusFilter)) $queryParams[] = 'status=' . urlencode($statusFilter);
                            if (!empty($categoryFilter)) $queryParams[] = 'category=' . urlencode($categoryFilter);
                            $queryString = !empty($queryParams) ? '&' . implode('&', $queryParams) : '';
                            ?>
                            
                            <?php if ($pagination['current_page'] > 1): ?>
                                <a href="?page=1<?= $queryString ?>" class="btn btn-secondary btn-sm">
                                    <i class="fas fa-angle-double-left"></i> First
                                </a>
                                <a href="?page=<?= $pagination['current_page'] - 1 ?><?= $queryString ?>" class="btn btn-secondary btn-sm">
                                    <i class="fas fa-angle-left"></i> Previous
                                </a>
                            <?php endif; ?>

                            <span class="btn btn-primary btn-sm">
                                Page <?= $pagination['current_page'] ?> of <?= $pagination['total_pages'] ?>
                            </span>

                            <?php if ($pagination['current_page'] < $pagination['total_pages']): ?>
                                <a href="?page=<?= $pagination['current_page'] + 1 ?><?= $queryString ?>" class="btn btn-secondary btn-sm">
                                    Next <i class="fas fa-angle-right"></i>
                                </a>
                                <a href="?page=<?= $pagination['total_pages'] ?><?= $queryString ?>" class="btn btn-secondary btn-sm">
                                    Last <i class="fas fa-angle-double-right"></i>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
            <?php else: ?>
                <div style="text-align: center; padding: 4rem; color: #718096;">
                    <i class="fas fa-search" style="font-size: 3rem; margin-bottom: 1rem; opacity: 0.5;"></i>
                    <h3 style="margin-bottom: 0.5rem;">No businesses found</h3>
                    <p><?= !empty($search) ? 'Try adjusting your search criteria or clearing filters.' : 'No businesses are currently in the database.' ?></p>
                    <?php if (!empty($categoryFilter)): ?>
                        <p style="margin-top: 0.5rem;">
                            Currently filtering by category. <a href="/admin/stores" style="color: #667eea;">Show all businesses</a>
                        </p>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </main>
<!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header bg-danger text-white">
                    <h5 class="modal-title">
                        <i class="fas fa-exclamation-triangle"></i> Delete Business
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="danger-zone">
                        <h6 class="text-danger"><i class="fas fa-warning"></i> Permanent Deletion Warning</h6>
                        <p class="mb-3">You are about to permanently delete <strong id="businessNameToDelete"></strong> from the system.</p>
                        
                        <p class="mb-2"><strong>This action will remove:</strong></p>
                        <ul class="mb-3">
                            <li>The business listing</li>
                            <li>All configured hours and schedules</li>
                            <li>All hour types and exceptions</li>
                            <li>Category assignments</li>
                            <li>Schedule templates</li>
                        </ul>
                        
                        <p class="text-danger mb-0"><strong>This action cannot be undone!</strong></p>
                    </div>
                    
                    <div class="mt-3">
                        <label class="form-label">Type <code>DELETE</code> to confirm:</label>
                        <input type="text" class="form-control" id="confirmDeleteInput" placeholder="Type DELETE to confirm">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-danger" id="confirmDeleteBtn" disabled onclick="executeDeletion()">
                        <i class="fas fa-trash"></i> Permanently Delete Business
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Google API Test Modal -->
    <div class="modal fade" id="apiTestModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">
                        <i class="fas fa-search"></i> Google Places API Test Results
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div id="apiTestResults">Testing...</div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    let businessToDelete = null;

    function confirmDelete(storeId, businessName) {
        businessToDelete = storeId;
        document.getElementById('businessNameToDelete').textContent = businessName;
        document.getElementById('confirmDeleteInput').value = '';
        document.getElementById('confirmDeleteBtn').disabled = true;
        
        new bootstrap.Modal(document.getElementById('deleteModal')).show();
    }

    document.getElementById('confirmDeleteInput').addEventListener('input', function() {
        const input = this.value.trim();
        const deleteBtn = document.getElementById('confirmDeleteBtn');
        deleteBtn.disabled = input !== 'DELETE';
    });

    async function executeDeletion() {
        if (!businessToDelete) return;
        
        try {
            const deleteBtn = document.getElementById('confirmDeleteBtn');
            deleteBtn.disabled = true;
            deleteBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Deleting...';
            
            const response = await fetch('/admin/stores/delete-business', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: new URLSearchParams({ store_id: businessToDelete })
            });
            
            const data = await response.json();
            
            if (data.success) {
                const row = document.querySelector(`tr[data-store-id="${businessToDelete}"]`);
                if (row) row.remove();
                
                bootstrap.Modal.getInstance(document.getElementById('deleteModal')).hide();
                showFlashMessage(data.message, 'success');
                businessToDelete = null;
            } else {
                showFlashMessage('Failed to delete business: ' + data.message, 'danger');
            }
            
        } catch (error) {
            console.error('Delete error:', error);
            showFlashMessage('Failed to delete business: ' + error.message, 'danger');
        } finally {
            const deleteBtn = document.getElementById('confirmDeleteBtn');
            deleteBtn.disabled = false;
            deleteBtn.innerHTML = '<i class="fas fa-trash"></i> Permanently Delete Business';
        }
    }

    async function testGoogleApi(storeId) {
        const modal = new bootstrap.Modal(document.getElementById('apiTestModal'));
        modal.show();
        
        document.getElementById('apiTestResults').innerHTML = `
            <div class="text-center">
                <div class="spinner-border" role="status"></div>
                <p class="mt-2">Testing Google Places API for Store ID: ${storeId}...</p>
            </div>
        `;
        
        try {
            const response = await fetch(`/admin/hours-import/test-google-api/${storeId}`);
            const data = await response.json();
            
            if (data.error) {
                document.getElementById('apiTestResults').innerHTML = `
                    <div class="alert alert-danger">
                        <h6>API Test Failed</h6>
                        <p>${data.error}</p>
                    </div>
                `;
                return;
            }
            
            let resultsHtml = `
                <div class="mb-3">
                    <h6>Business: ${data.business.name}</h6>
                    <p class="text-muted">${data.business.address}, ${data.business.city}, ${data.business.state}</p>
                </div>
                <div class="alert alert-info">
                    <strong>Search Results:</strong> ${data.search_count} places found
                </div>
            `;
            
            if (data.debug_results && data.debug_results.length > 0) {
                data.debug_results.forEach((result, index) => {
                    const hasHours = result.has_opening_hours || result.has_current_opening_hours;
                    const hoursColor = hasHours ? 'success' : 'danger';
                    const hoursText = hasHours ? 'Hours Available' : 'No Hours Data';
                    
                    resultsHtml += `
                        <div class="card mb-3">
                            <div class="card-header d-flex justify-content-between">
                                <strong>${result.place_name}</strong>
                                <span class="badge bg-${hoursColor}">${hoursText}</span>
                            </div>
                            <div class="card-body">
                                <p><strong>Address:</strong> ${result.formatted_address}</p>
                                <p><strong>Business Status:</strong> ${result.business_status}</p>
                                <p><strong>API Fields:</strong> opening_hours: ${result.has_opening_hours ? '✅' : '❌'}, current_opening_hours: ${result.has_current_opening_hours ? '✅' : '❌'}</p>
                            </div>
                        </div>
                    `;
                });
            }
            
            document.getElementById('apiTestResults').innerHTML = resultsHtml;
            
        } catch (error) {
            document.getElementById('apiTestResults').innerHTML = `
                <div class="alert alert-danger">
                    <h6>Test Failed</h6>
                    <p>Failed to test Google Places API: ${error.message}</p>
                </div>
            `;
        }
    }

    function showFlashMessage(message, type) {
        const alertHtml = `
            <div class="alert alert-${type} alert-dismissible fade show">
                <i class="fas fa-${type === 'success' ? 'check-circle' : 'exclamation-circle'}"></i> ${message}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        `;
        
        // Add to page (you may need to adjust this selector based on your layout)
        const container = document.querySelector('.main-container');
        container.insertAdjacentHTML('afterbegin', alertHtml);
    }
    </script>
</body>
</html>
</body>
</html>