<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?></title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            color: #333;
        }

        .admin-header {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.2);
            padding: 1rem 0;
            position: sticky;
            top: 0;
            z-index: 100;
            box-shadow: 0 2px 20px rgba(0, 0, 0, 0.1);
        }

        .nav-container {
            max-width: 1400px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 2rem;
        }

        .nav-brand {
            font-size: 1.5rem;
            font-weight: 700;
            color: #4a5568;
            text-decoration: none;
        }

        .nav-links {
            display: flex;
            gap: 0;
        }

        .nav-links a {
            color: #4a5568;
            text-decoration: none;
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            transition: all 0.3s ease;
            font-weight: 500;
        }

        .nav-links a:hover {
            background: rgba(102, 126, 234, 0.1);
            color: #667eea;
        }

        .nav-links a.active {
            background: #667eea;
            color: white;
            box-shadow: 0 2px 10px rgba(102, 126, 234, 0.3);
        }

        .user-menu {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .user-info {
            font-size: 0.9rem;
            color: #666;
        }

        .logout-btn {
            background: #e53e3e;
            color: white;
            padding: 0.5rem 1rem;
            border-radius: 6px;
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .logout-btn:hover {
            background: #c53030;
            transform: translateY(-1px);
        }

        .main-container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 2rem;
        }

        .dashboard-header {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            text-align: center;
        }

        .dashboard-title {
            font-size: 3rem;
            font-weight: 700;
            color: #2d3748;
            margin-bottom: 0.5rem;
        }

        .dashboard-subtitle {
            color: #718096;
            font-size: 1.2rem;
        }

        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1.5rem;
            margin-bottom: 2rem;
        }

        .stat-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 2rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-left: 4px solid;
            transition: all 0.3s ease;
        }

        .stat-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 12px 40px rgba(0, 0, 0, 0.15);
        }

        .stat-card.primary { border-left-color: #667eea; }
        .stat-card.success { border-left-color: #38a169; }
        .stat-card.warning { border-left-color: #ed8936; }
        .stat-card.danger { border-left-color: #e53e3e; }
        .stat-card.info { border-left-color: #4299e1; }

        .stat-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1rem;
        }

        .stat-label {
            font-size: 0.85rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            color: #718096;
        }

        .stat-icon {
            font-size: 2rem;
            opacity: 0.3;
        }

        .stat-value {
            font-size: 2.5rem;
            font-weight: 700;
            color: #2d3748;
        }

        .stat-meta {
            font-size: 0.8rem;
            color: #666;
            margin-top: 0.5rem;
        }

        .management-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
            gap: 2rem;
            margin-bottom: 2rem;
        }

        .management-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 2rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            transition: all 0.3s ease;
            position: relative;
            min-height: 220px;
            display: flex;
            flex-direction: column;
        }

        .management-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 12px 40px rgba(0, 0, 0, 0.15);
        }

        .card-title {
            font-size: 1.25rem;
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .card-description {
            color: #718096;
            margin-bottom: 1.5rem;
            flex-grow: 1;
            line-height: 1.5;
        }

        .card-actions {
            display: flex;
            gap: 0.75rem;
            flex-wrap: wrap;
            margin-top: auto;
        }

        .btn {
            padding: 0.75rem 1.25rem;
            border: none;
            border-radius: 8px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            transition: all 0.3s ease;
            cursor: pointer;
            font-size: 0.9rem;
            white-space: nowrap;
            flex: 1;
            justify-content: center;
            min-width: 0;
        }

        .btn:hover {
            transform: translateY(-1px);
            text-decoration: none;
        }

        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
        }

        .btn-primary:hover {
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
            color: white;
        }

        .btn-secondary {
            background: #f7fafc;
            color: #4a5568;
            border: 2px solid #e2e8f0;
        }

        .btn-secondary:hover {
            background: #edf2f7;
            color: #4a5568;
        }

        .btn-success {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            color: white;
            box-shadow: 0 4px 15px rgba(40, 167, 69, 0.3);
        }

        .btn-success:hover {
            box-shadow: 0 6px 20px rgba(40, 167, 69, 0.4);
            color: white;
        }

        .alert {
            padding: 1rem 1.5rem;
            border-radius: 10px;
            margin-bottom: 2rem;
            border-left: 4px solid;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .alert-warning {
            background: #fffaf0;
            border-color: #ed8936;
            color: #975a16;
        }

        .alert-info {
            background: #ebf8ff;
            border-color: #4299e1;
            color: #2b6cb0;
        }

        .recent-activity {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 2rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .activity-title {
            font-size: 1.25rem;
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 1.5rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .activity-list {
            list-style: none;
        }

        .activity-item {
            padding: 1rem;
            border-bottom: 1px solid #e2e8f0;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .activity-item:last-child {
            border-bottom: none;
        }

        .activity-info {
            flex: 1;
        }

        .activity-name {
            font-weight: 600;
            color: #2d3748;
        }

        .activity-meta {
            font-size: 0.8rem;
            color: #666;
            margin-top: 0.25rem;
        }

        .activity-time {
            font-size: 0.8rem;
            color: #a0aec0;
        }

        .badge {
            padding: 0.25rem 0.5rem;
            border-radius: 12px;
            font-size: 0.7rem;
            font-weight: 600;
            text-transform: uppercase;
            background: #28a745;
            color: white;
            margin-left: 0.5rem;
        }

        @media (max-width: 768px) {
            .main-container {
                padding: 1rem;
            }
            
            .stats-grid {
                grid-template-columns: 1fr;
            }
            
            .management-grid {
                grid-template-columns: 1fr;
            }
            
            .dashboard-title {
                font-size: 2rem;
            }
            
            .card-actions {
                flex-direction: column;
            }
            
            .btn {
                flex: none;
            }
        }
    </style>
</head>
<body>
    <header class="admin-header">
        <div class="nav-container">
            <a href="/admin/dashboard" class="nav-brand">
                <i class="fas fa-store"></i> Business Directory Admin
            </a>
            
            <nav class="nav-links">
                <a href="/admin/dashboard" class="active">
                    <i class="fas fa-tachometer-alt"></i> Dashboard
                </a>
                <a href="/admin/stores">
                    <i class="fas fa-building"></i> Stores
                </a>
                <a href="/admin/hours">
                    <i class="fas fa-clock"></i> Hours
                </a>
                <a href="/admin/categories">
                    <i class="fas fa-tags"></i> Categories
                </a>
                <a href="/admin/tools">
                    <i class="fas fa-tools"></i> Tools
                </a>
            </nav>
            
            <div class="user-menu">
                <div class="user-info">
                    <i class="fas fa-user-circle"></i>
                    <?= session()->get('admin_name') ?: 'Admin' ?>
                </div>
                <a href="/admin/logout" class="logout-btn">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
            </div>
        </div>
    </header>

    <main class="main-container">
        <div class="dashboard-header">
            <h1 class="dashboard-title">
                <i class="fas fa-tachometer-alt"></i> Admin Dashboard
            </h1>
            <p class="dashboard-subtitle">
                Manage your business directory with comprehensive tools and analytics
            </p>
        </div>

        <!-- System Health Alerts -->
        <?php if (isset($error)): ?>
            <div class="alert alert-warning">
                <i class="fas fa-exclamation-triangle"></i>
                System Warning: <?= esc($error) ?>
            </div>
        <?php endif; ?>

        <?php if ($systemHealth['total_issues'] > 0): ?>
            <div class="alert alert-info">
                <i class="fas fa-info-circle"></i>
                System needs attention: <?= $systemHealth['total_issues'] ?> items need configuration
                <a href="/admin/categories/assignments" style="margin-left: 1rem; color: #2b6cb0; text-decoration: underline;">
                    View Details
                </a>
            </div>
        <?php endif; ?>

        <!-- Statistics Grid -->
        <div class="stats-grid">
            <div class="stat-card primary">
                <div class="stat-header">
                    <div class="stat-label">Total Businesses</div>
                    <i class="fas fa-building stat-icon"></i>
                </div>
                <div class="stat-value"><?= number_format($stats['total_stores']) ?></div>
                <div class="stat-meta">
                    <?= number_format($stats['active_stores']) ?> active, 
                    <?= number_format($stats['closed_stores']) ?> temporarily closed
                </div>
            </div>

            <div class="stat-card success">
                <div class="stat-header">
                    <div class="stat-label">Category Coverage</div>
                    <i class="fas fa-tags stat-icon"></i>
                </div>
                <div class="stat-value"><?= number_format($stats['category_coverage']) ?>%</div>
                <div class="stat-meta">
                    <?= number_format($stats['stores_with_categories']) ?> of <?= number_format($stats['total_stores']) ?> businesses categorized
                </div>
            </div>

            <div class="stat-card info">
                <div class="stat-header">
                    <div class="stat-label">Hours Configured</div>
                    <i class="fas fa-clock stat-icon"></i>
                </div>
                <div class="stat-value"><?= number_format($stats['stores_with_hours']) ?></div>
                <div class="stat-meta">
                    Businesses with operating hours set
                </div>
            </div>

            <div class="stat-card warning">
                <div class="stat-header">
                    <div class="stat-label">Active Categories</div>
                    <i class="fas fa-folder-open stat-icon"></i>
                </div>
                <div class="stat-value"><?= number_format($stats['active_categories']) ?></div>
                <div class="stat-meta">
                    Of <?= number_format($stats['total_categories']) ?> total categories
                </div>
            </div>
        </div>

        <!-- Management Cards -->
        <div class="management-grid">
            <div class="management-card">
                <h3 class="card-title">
                    <i class="fas fa-building"></i> Manage Businesses
                </h3>
                <p class="card-description">
                    Edit, approve, or delete business records. View detailed information and manage business profiles.
                </p>
                <div class="card-actions">
                    <a href="/admin/stores" class="btn btn-primary">
                        <i class="fas fa-building"></i> View All Stores
                    </a>
                    <a href="/admin/stores?status=inactive" class="btn btn-secondary">
                        <i class="fas fa-exclamation-triangle"></i> Need Attention
                    </a>
                </div>
            </div>

            <div class="management-card">
                <h3 class="card-title">
                    <i class="fas fa-tags"></i> Category Management
                </h3>
                <p class="card-description">
                    Organize businesses by categories. Create new categories and assign businesses for better organization.
                </p>
                <div class="card-actions">
                    <a href="/admin/categories" class="btn btn-primary">
                        <i class="fas fa-tags"></i> Manage Categories
                    </a>
                    <a href="/admin/categories/assignments" class="btn btn-secondary">
                        <i class="fas fa-link"></i> Assignments
                    </a>
                </div>
            </div>

            <div class="management-card">
                <h3 class="card-title">
                    <i class="fas fa-clock"></i> Business Hours
                </h3>
                <p class="card-description">
                    Configure operating hours for businesses. Set up schedules, exceptions, and holiday hours.
                </p>
                <div class="card-actions">
                    <a href="/admin/hours" class="btn btn-primary">
                        <i class="fas fa-clock"></i> Manage Hours
                    </a>
                    <a href="/admin/hours?filter=no-hours" class="btn btn-secondary">
                        <i class="fas fa-plus"></i> Setup Hours
                    </a>
                </div>
            </div>

            <div class="management-card">
                <h3 class="card-title">
                    <i class="fas fa-download"></i> Hours Import Tool
                    <span class="badge">New</span>
                </h3>
                <p class="card-description">
                    Automatically import accurate business hours from Google Places API. Save time by bulk importing hours for multiple businesses.
                </p>
                <div class="card-actions">
                    <a href="/admin/hours-import" class="btn btn-success">
                        <i class="fas fa-download"></i> Import Hours
                    </a>
                    <a href="/admin/hours-import?filter=needs-hours" class="btn btn-secondary">
                        <i class="fas fa-search"></i> Find Businesses
                    </a>
                </div>
            </div>

            <div class="management-card">
                <h3 class="card-title">
                    <i class="fas fa-briefcase"></i> Job Postings
                </h3>
                <p class="card-description">
                    Monitor job postings across all businesses. Review active listings and manage content quality.
                </p>
                <div class="card-actions">
                    <a href="/admin/jobs" class="btn btn-primary">
                        <i class="fas fa-briefcase"></i> View All Jobs
                    </a>
                    <a href="/admin/jobs?filter=expiring" class="btn btn-secondary">
                        <i class="fas fa-clock"></i> Expiring Soon
                    </a>
                </div>
            </div>

            <div class="management-card">
                <h3 class="card-title">
                    <i class="fas fa-tools"></i> System Tools
                </h3>
                <p class="card-description">
                    Access verification tools, data management utilities, and system configuration options.
                </p>
                <div class="card-actions">
                    <a href="/verification" class="btn btn-primary">
                        <i class="fas fa-tools"></i> Verification Tool
                    </a>
                    <a href="/file-usage/report" class="btn btn-secondary">
                        <i class="fas fa-chart-bar"></i> System Reports
                    </a>
                </div>
            </div>
        </div>

        <!-- Recent Activity -->
        <?php if (!empty($recentUpdates)): ?>
        <div class="recent-activity">
            <h3 class="activity-title">
                <i class="fas fa-history"></i> Recent Activity
            </h3>
            <ul class="activity-list">
                <?php foreach (array_slice($recentUpdates, 0, 8) as $update): ?>
                <li class="activity-item">
                    <div class="activity-info">
                        <div class="activity-name"><?= esc($update['name']) ?></div>
                        <div class="activity-meta">
                            <i class="fas fa-map-marker-alt"></i> <?= esc($update['city']) ?>, <?= esc($update['state']) ?>
                            <?php if ($update['category_count'] > 0): ?>
                                • <i class="fas fa-tags"></i> <?= $update['category_count'] ?> categories
                            <?php else: ?>
                                • <span style="color: #ed8936;"><i class="fas fa-exclamation-triangle"></i> No categories</span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="activity-time">
                        <?= date('M j, g:i A', strtotime($update['update_date'])) ?>
                    </div>
                </li>
                <?php endforeach; ?>
            </ul>
        </div>
        <?php endif; ?>
    </main>
</body>
</html>