<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?></title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            color: #333;
        }

        .admin-header {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.2);
            padding: 1rem 0;
            position: sticky;
            top: 0;
            z-index: 100;
            box-shadow: 0 2px 20px rgba(0, 0, 0, 0.1);
        }

        .nav-container {
            max-width: 1400px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 2rem;
        }

        .nav-brand {
            font-size: 1.5rem;
            font-weight: 700;
            color: #4a5568;
            text-decoration: none;
        }

        .nav-links {
            display: flex;
            gap: 0;
        }

        .nav-links a {
            color: #4a5568;
            text-decoration: none;
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            transition: all 0.3s ease;
            font-weight: 500;
        }

        .nav-links a:hover {
            background: rgba(102, 126, 234, 0.1);
            color: #667eea;
        }

        .nav-links a.active {
            background: #667eea;
            color: white;
            box-shadow: 0 2px 10px rgba(102, 126, 234, 0.3);
        }

        .user-menu {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .user-info {
            font-size: 0.9rem;
            color: #666;
        }

        .logout-btn {
            background: #e53e3e;
            color: white;
            padding: 0.5rem 1rem;
            border-radius: 6px;
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .logout-btn:hover {
            background: #c53030;
            transform: translateY(-1px);
        }

        .main-container {
            max-width: 1000px;
            margin: 0 auto;
            padding: 2rem;
        }

        .breadcrumb {
            background: rgba(255, 255, 255, 0.9);
            backdrop-filter: blur(10px);
            border-radius: 10px;
            padding: 1rem 1.5rem;
            margin-bottom: 2rem;
            font-size: 0.9rem;
        }

        .breadcrumb a {
            color: #667eea;
            text-decoration: none;
        }

        .breadcrumb a:hover {
            text-decoration: underline;
        }

        .page-header {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            text-align: center;
        }

        .page-title {
            font-size: 2.5rem;
            font-weight: 700;
            color: #2d3748;
            margin-bottom: 0.5rem;
        }

        .page-subtitle {
            color: #718096;
            font-size: 1.1rem;
        }

        .form-container {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 2rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            max-width: 600px;
            margin: 0 auto;
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        .form-label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 600;
            color: #4a5568;
            font-size: 0.9rem;
        }

        .form-input, .form-select, .form-textarea {
            width: 100%;
            padding: 0.875rem 1rem;
            border: 2px solid #e2e8f0;
            border-radius: 10px;
            font-size: 1rem;
            transition: all 0.3s ease;
            background: white;
        }

        .form-input:focus, .form-select:focus, .form-textarea:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .checkbox-group {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 1rem;
            background: white;
            border-radius: 10px;
            border: 2px solid #e2e8f0;
            transition: all 0.3s ease;
        }

        .checkbox-group:has(input:checked) {
            border-color: #667eea;
            background: rgba(102, 126, 234, 0.05);
        }

        .checkbox-group input[type="checkbox"] {
            width: 18px;
            height: 18px;
            cursor: pointer;
        }

        .checkbox-group label {
            font-weight: 500;
            cursor: pointer;
            margin: 0;
        }

        .icon-selector {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(60px, 1fr));
            gap: 0.5rem;
            max-height: 200px;
            overflow-y: auto;
            padding: 1rem;
            background: white;
            border: 2px solid #e2e8f0;
            border-radius: 10px;
        }

        .icon-option {
            display: flex;
            flex-direction: column;
            align-items: center;
            padding: 0.5rem;
            border-radius: 8px;
            cursor: pointer;
            transition: all 0.3s ease;
            font-size: 0.7rem;
            text-align: center;
            border: 2px solid transparent;
        }

        .icon-option:hover {
            background: #f7fafc;
            border-color: #e2e8f0;
        }

        .icon-option.selected {
            background: #667eea;
            color: white;
            border-color: #667eea;
        }

        .icon-option i {
            font-size: 1.5rem;
            margin-bottom: 0.25rem;
        }

        .icon-preview {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            padding: 1rem;
            background: #f8fafc;
            border-radius: 8px;
            margin-top: 0.5rem;
            border: 2px solid #e2e8f0;
        }

        .icon-preview-icon {
            width: 40px;
            height: 40px;
            background: white;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.2rem;
            color: #667eea;
            border: 1px solid #e2e8f0;
        }

        .btn {
            padding: 0.875rem 1.5rem;
            border: none;
            border-radius: 10px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            transition: all 0.3s ease;
            cursor: pointer;
            font-size: 0.95rem;
        }

        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
        }

        .btn-secondary {
            background: #f7fafc;
            color: #4a5568;
            border: 2px solid #e2e8f0;
        }

        .btn-secondary:hover {
            background: #edf2f7;
            border-color: #cbd5e0;
        }

        .form-actions {
            display: flex;
            gap: 1rem;
            justify-content: flex-end;
            margin-top: 2rem;
            padding-top: 1.5rem;
            border-top: 2px solid #e2e8f0;
        }

        .alert {
            padding: 1rem 1.5rem;
            border-radius: 10px;
            margin-bottom: 1.5rem;
            border-left: 4px solid;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .alert-success {
            background: #f0fff4;
            border-color: #38a169;
            color: #22543d;
        }

        .alert-error {
            background: #fffaf0;
            border-color: #e53e3e;
            color: #742a2a;
        }

        .help-text {
            font-size: 0.8rem;
            color: #718096;
            margin-top: 0.25rem;
        }

        @media (max-width: 768px) {
            .main-container {
                padding: 1rem;
            }
            
            .icon-selector {
                grid-template-columns: repeat(auto-fill, minmax(50px, 1fr));
            }
            
            .form-actions {
                flex-direction: column;
            }
        }
    </style>
</head>
<body>
    <header class="admin-header">
        <div class="nav-container">
            <a href="/admin/dashboard" class="nav-brand">
                <i class="fas fa-store"></i> Business Directory Admin
            </a>
            
            <nav class="nav-links">
                <a href="/admin/dashboard">
                    <i class="fas fa-tachometer-alt"></i> Dashboard
                </a>
                <a href="/admin/stores">
                    <i class="fas fa-building"></i> Stores
                </a>
                <a href="/admin/hours">
                    <i class="fas fa-clock"></i> Hours
                </a>
                <a href="/admin/categories" class="active">
                    <i class="fas fa-tags"></i> Categories
                </a>
                <a href="/admin/settings">
                    <i class="fas fa-cog"></i> Settings
                </a>
            </nav>
            
            <div class="user-menu">
                <div class="user-info">
                    <i class="fas fa-user-circle"></i>
                    <?= session()->get('admin_name') ?>
                </div>
                <a href="/admin/logout" class="logout-btn">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
            </div>
        </div>
    </header>

    <main class="main-container">
        <div class="breadcrumb">
            <i class="fas fa-home"></i>
            <a href="/admin/dashboard">Dashboard</a> /
            <a href="/admin/categories">Categories</a> /
            <?= isset($category) ? 'Edit' : 'Create' ?>
        </div>

        <div class="page-header">
            <h1 class="page-title">
                <i class="fas fa-<?= isset($category) ? 'edit' : 'plus' ?>"></i>
                <?= isset($category) ? 'Edit Category' : 'Create New Category' ?>
            </h1>
            <p class="page-subtitle">
                <?= isset($category) ? 'Update category information' : 'Add a new category to organize businesses' ?>
            </p>
        </div>

        <?php if (session()->getFlashdata('success')): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i> <?= session()->getFlashdata('success') ?>
            </div>
        <?php endif; ?>

        <?php if (session()->getFlashdata('error')): ?>
            <div class="alert alert-error">
                <i class="fas fa-exclamation-circle"></i> <?= session()->getFlashdata('error') ?>
            </div>
        <?php endif; ?>

        <form method="post" class="form-container">
            <?= csrf_field() ?>
            
            <div class="form-group">
                <label class="form-label" for="title">Category Name *</label>
                <input type="text" id="title" name="title" class="form-input" 
                       value="<?= isset($category) ? esc($category['title']) : '' ?>" 
                       placeholder="e.g., Restaurants, Auto Repair, Healthcare" required>
                <div class="help-text">Enter a clear, descriptive name for this category</div>
            </div>

            <div class="form-group">
                <label class="form-label" for="icon">Category Icon</label>
                <input type="hidden" id="selected-icon" name="icon" 
                       value="<?= isset($category) ? esc($category['icon']) : 'fa fa-tag' ?>">
                
                <div class="icon-preview" id="icon-preview">
                    <div class="icon-preview-icon">
                        <i id="preview-icon" class="<?= isset($category) ? esc($category['icon']) : 'fa fa-tag' ?>"></i>
                    </div>
                    <div>
                        <strong>Selected Icon:</strong> <span id="preview-text"><?= isset($category) ? esc($category['icon']) : 'fa fa-tag' ?></span>
                    </div>
                </div>
                
                <div class="icon-selector">
                    <?php 
                    $icons = [
                        'fa fa-home' => 'Home',
                        'fa fa-building' => 'Building', 
                        'fa fa-store' => 'Store',
                        'fa fa-shopping-cart' => 'Shopping',
                        'fa fa-cutlery' => 'Restaurant',
                        'fa fa-car' => 'Automotive',
                        'fa fa-wrench' => 'Repair',
                        'fa fa-medkit' => 'Healthcare',
                        'fa fa-graduation-cap' => 'Education',
                        'fa fa-money' => 'Finance',
                        'fa fa-legal' => 'Legal',
                        'fa fa-paint-brush' => 'Art',
                        'fa fa-music' => 'Entertainment',
                        'fa fa-camera' => 'Photography',
                        'fa fa-laptop' => 'Technology',
                        'fa fa-leaf' => 'Garden',
                        'fa fa-heart' => 'Health',
                        'fa fa-paw' => 'Pets',
                        'fa fa-gas-pump' => 'Gas Station',
                        'fa fa-bed' => 'Hotels',
                        'fa fa-utensils' => 'Food',
                        'fa fa-shopping-bag' => 'Retail',
                        'fa fa-tools' => 'Services',
                        'fa fa-tag' => 'General'
                    ];
                    
                    foreach ($icons as $iconClass => $iconName): 
                        $isSelected = (isset($category) && $category['icon'] === $iconClass) || (!isset($category) && $iconClass === 'fa fa-tag');
                    ?>
                        <div class="icon-option <?= $isSelected ? 'selected' : '' ?>" 
                             onclick="selectIcon('<?= $iconClass ?>', '<?= $iconName ?>')">
                            <i class="<?= $iconClass ?>"></i>
                            <span><?= $iconName ?></span>
                        </div>
                    <?php endforeach; ?>
                </div>
                <div class="help-text">Choose an icon that represents this category</div>
            </div>

            <div class="form-group">
                <label class="form-label" for="status">Status</label>
                <select id="status" name="status" class="form-select">
                    <option value="1" <?= (!isset($category) || $category['status'] == 1) ? 'selected' : '' ?>>Active</option>
                    <option value="0" <?= (isset($category) && $category['status'] == 0) ? 'selected' : '' ?>>Inactive</option>
                </select>
                <div class="help-text">Only active categories will be visible to users</div>
            </div>

            <div class="form-group">
                <div class="checkbox-group">
                    <input type="checkbox" id="top_category" name="top_category" value="1" 
                           <?= (isset($category) && $category['top_category'] == 1) ? 'checked' : '' ?>>
                    <label for="top_category">Featured Category</label>
                </div>
                <div class="help-text">Featured categories appear prominently in search filters</div>
            </div>

            <div class="form-actions">
                <a href="/admin/categories" class="btn btn-secondary">
                    <i class="fas fa-times"></i> Cancel
                </a>
                
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-<?= isset($category) ? 'save' : 'plus' ?>"></i>
                    <?= isset($category) ? 'Update Category' : 'Create Category' ?>
                </button>
            </div>
        </form>
    </main>

    <script>
        function selectIcon(iconClass, iconName) {
            // Remove selected class from all icons
            document.querySelectorAll('.icon-option').forEach(option => {
                option.classList.remove('selected');
            });
            
            // Add selected class to clicked icon
            event.currentTarget.classList.add('selected');
            
            // Update hidden input
            document.getElementById('selected-icon').value = iconClass;
            
            // Update preview
            document.getElementById('preview-icon').className = iconClass;
            document.getElementById('preview-text').textContent = iconClass;
        }
    </script>
</body>
</html>