<?php

namespace App\Models;

use CodeIgniter\Model;

class AdminModel extends Model
{
    protected $table = 'admin';
    protected $primaryKey = 'id';

    protected $allowedFields = [
        'admin_id',
        'name',
        'first_name', 
        'last_name',
        'email',
        'password',
        'role',
        'permission',
        'phone',
        'status',
        'otp'
    ];

    protected $returnType = 'array';
    protected $useTimestamps = true;
    protected $createdField = 'create_date';
    protected $updatedField = 'update_date';

    /**
     * Validate admin login credentials
     */
    public function validateLogin($username, $password)
    {
        // Find admin by email (primary) or admin_id or name
        $builder = $this->builder();
        $admin = $builder->groupStart()
                        ->where('email', $username)
                        ->orWhere('admin_id', $username)
                        ->orWhere('name', $username)
                        ->groupEnd()
                        ->where('status', 1)
                        ->get()
                        ->getRowArray();

        if ($admin) {
            // Check password format and validate
            if (substr($admin['password'], 0, 4) === '$2y$') {
                // Bcrypt hash
                return password_verify($password, $admin['password']) ? $admin : false;
            } else {
                // MD5 hash
                return (md5($password) === $admin['password']) ? $admin : false;
            }
        }

        return false;
    }
}