<?php
namespace App\Controllers;
use CodeIgniter\Controller;

class HomeController extends Controller
{
    public function index()
    {
        return view('frontend/home');
    }
    
   public function fileUsage()
{
    // Include the tracker
    require_once APPPATH . 'Config/RuntimeTracker.php';
    
    // Handle clear request safely
    if (isset($_GET['clear'])) {
        try {
            \App\Config\RuntimeFileTracker::clearLog();
            // Redirect to avoid the clear parameter staying in URL
            return redirect()->to('/file-usage/report')->with('message', 'Log cleared successfully!');
        } catch (Exception $e) {
            return "Error clearing log: " . $e->getMessage();
        }
    }
    
    $report = \App\Config\RuntimeFileTracker::getUsageReport();
    
    // Simple HTML output
    $html = '<!DOCTYPE html><html><head><title>File Usage Report</title>';
    $html .= '<style>
        body { font-family: Arial, sans-serif; margin: 20px; background: #f5f5f5; }
        .container { max-width: 1200px; margin: 0 auto; background: white; padding: 20px; border-radius: 8px; }
        .section { margin: 20px 0; padding: 15px; border: 1px solid #ddd; border-radius: 5px; background: #f9f9f9; }
        .file-list { max-height: 400px; overflow-y: auto; }
        .freq-high { color: green; font-weight: bold; }
        .freq-medium { color: orange; }
        .freq-low { color: red; }
        table { width: 100%; border-collapse: collapse; }
        th, td { padding: 8px; text-align: left; border-bottom: 1px solid #ddd; }
        th { background: #f0f0f0; }
        .clear-btn { background: red; color: white; padding: 10px; border: none; border-radius: 5px; cursor: pointer; margin: 10px 0; }
        .refresh-btn { background: blue; color: white; padding: 10px; border: none; border-radius: 5px; cursor: pointer; margin: 10px 0; }
        .success { color: green; font-weight: bold; padding: 10px; background: #d4edda; border-radius: 5px; }
    </style></head><body>';
    
    $html .= '<div class="container">';
    $html .= '<h1>Runtime File Usage Report</h1>';
    
    // Show success message if log was cleared
    if (session('message')) {
        $html .= '<div class="success">' . session('message') . '</div>';
    }
    
    $html .= '<p><strong>Total requests tracked:</strong> ' . $report['total_requests'] . '</p>';
    $html .= '<p><strong>Unique files used:</strong> ' . count($report['unique_files']) . '</p>';
    
    $html .= '<button class="clear-btn" onclick="if(confirm(\'Clear usage log?\')) window.location.href=\'?clear=1\'">Clear Log</button>';
    $html .= '<button class="refresh-btn" onclick="window.location.reload()">Refresh Report</button>';
    
    // Only show tables if there's data
    if ($report['total_requests'] > 0) {
        // File frequency table
        $html .= '<div class="section">';
        $html .= '<h2>File Usage Frequency</h2>';
        $html .= '<p>Files are color-coded: <span class="freq-high">Green = Frequently Used (5+ times)</span>, <span class="freq-medium">Orange = Occasionally Used (2-4 times)</span>, <span class="freq-low">Red = Rarely Used (1 time)</span></p>';
        $html .= '<table><tr><th>File</th><th>Times Used</th><th>Status</th></tr>';
        
        foreach ($report['file_frequency'] as $file => $count) {
            $status = '';
            $class = '';
            if ($count >= 5) {
                $status = 'Frequently Used';
                $class = 'freq-high';
            } elseif ($count >= 2) {
                $status = 'Occasionally Used';
                $class = 'freq-medium';
            } else {
                $status = 'Rarely Used - Potential for removal';
                $class = 'freq-low';
            }
            
            $html .= "<tr><td>{$file}</td><td class='{$class}'>{$count}</td><td class='{$class}'>{$status}</td></tr>";
        }
        
        $html .= '</table></div>';
        
        // Recent requests
        $html .= '<div class="section">';
        $html .= '<h2>Recent Requests</h2>';
        $html .= '<table><tr><th>Time</th><th>URL</th><th>Method</th><th>Files Loaded</th><th>Execution Time</th></tr>';
        
        foreach (array_reverse($report['recent_requests']) as $request) {
            $html .= "<tr>";
            $html .= "<td>{$request['timestamp']}</td>";
            $html .= "<td>{$request['url']}</td>";
            $html .= "<td>{$request['method']}</td>";
            $html .= "<td>{$request['file_count']} files</td>";
            $html .= "<td>{$request['execution_time']}</td>";
            $html .= "</tr>";
        }
        
        $html .= '</table></div>';
    } else {
        $html .= '<div class="section">';
        $html .= '<p>No usage data yet. Browse your website and come back to see the results!</p>';
        $html .= '</div>';
    }
    
    // Instructions
    $html .= '<div class="section">';
    $html .= '<h2>How to Use This Report</h2>';
    $html .= '<ol>';
    $html .= '<li>Browse your website normally - visit different pages, use the store locator, etc.</li>';
    $html .= '<li>Come back to this report and refresh it to see updated usage data</li>';
    $html .= '<li>Files marked in <span class="freq-low">red</span> are rarely used and might be safe to remove</li>';
    $html .= '<li>Files marked in <span class="freq-high">green</span> are actively used and should be kept</li>';
    $html .= '<li>Always backup before deleting any files!</li>';
    $html .= '</ol>';
    $html .= '</div>';
    
    $html .= '</div></body></html>';
    
    return $html;
}
}