<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\AdminModel;

class Auth extends BaseController
{
    public function login()
    {
        helper(['form']);

        // Redirect if already logged in
        if (session()->get('admin_logged_in')) {
            return redirect()->to('/admin/dashboard');
        }

        // Handle login submission
        if ($this->request->getPost()) {
            $username = trim($this->request->getPost('username'));
            $password = trim($this->request->getPost('password'));

            if (empty($username) || empty($password)) {
                return view('admin/login', ['error' => 'Username and password are required']);
            }

            $adminModel = new AdminModel();
            $admin = $adminModel->validateLogin($username, $password);

            if ($admin) {
                // Set session
                session()->set([
                    'admin_logged_in' => true,
                    'admin_id' => $admin['id'],
                    'admin_name' => $admin['name'] ?: $admin['first_name'] . ' ' . $admin['last_name'],
                    'admin_email' => $admin['email']
                ]);

                return redirect()->to('/admin/dashboard');
            } else {
                return view('admin/login', ['error' => 'Invalid credentials']);
            }
        }

        return view('admin/login');
    }

    public function logout()
    {
        session()->destroy();
        return redirect()->to('/admin/login');
    }
}