<?php
/**
 * Test Import Script
 * /public/import/test_import.php
 */

define('IMPORT_ACCESS', true);

require_once 'config.php';
require_once 'classes/ImportLogger.php';
require_once 'classes/DatabaseConnection.php';

echo "<h2>OutScraper Import System Test</h2>\n";

try {
    // Test database connection
    echo "<h3>1. Testing Database Connection</h3>\n";
    $logger = new ImportLogger(true);
    $db = new DatabaseConnection($logger);
    echo "<p style='color: green'>✓ Database connection successful</p>\n";
    
    // Test timezone cache
    echo "<h3>2. Testing Timezone Cache</h3>\n";
    $timezones = $db->getTimezoneList();
    echo "<p>Loaded " . count($timezones) . " timezones</p>\n";
    
    // Test specific timezone lookups
    $testTimezones = ['America/New_York', 'America/Chicago', 'America/Los_Angeles', 'Invalid/Timezone'];
    foreach ($testTimezones as $tz) {
        $id = $db->getTimezoneId($tz);
        $color = ($tz === 'Invalid/Timezone') ? 'orange' : 'blue';
        echo "<p style='color: {$color}'>{$tz} → ID: {$id}</p>\n";
    }
    
    // Test table validation
    echo "<h3>3. Testing Database Tables</h3>\n";
    if ($db->validateDatabase()) {
        echo "<p style='color: green'>✓ All required tables accessible</p>\n";
    } else {
        echo "<p style='color: red'>✗ Database validation failed</p>\n";
    }
    
    // Show configuration
    echo "<h3>4. Configuration Check</h3>\n";
    echo "<p><strong>Database:</strong> " . DB_CONFIG['database'] . "</p>\n";
    echo "<p><strong>Batch Size:</strong> " . IMPORT_SETTINGS['batch_size'] . "</p>\n";
    echo "<p><strong>Default Timezone ID:</strong> " . IMPORT_SETTINGS['default_timezone_id'] . "</p>\n";
    echo "<p><strong>State Mappings:</strong> " . count(STATE_ABBREVIATIONS) . " states configured</p>\n";
    
    echo "<h3>5. Ready for Import</h3>\n";
    echo "<p style='color: green'>✓ System ready for OutScraper data import</p>\n";
    echo "<p><strong>Next steps:</strong></p>\n";
    echo "<ul>\n";
    echo "<li>Upload your OutScraper XLSX file</li>\n";
    echo "<li>Run: <code>php import_outscraper.php your_file.xlsx</code></li>\n";
    echo "<li>Monitor the log file for detailed progress</li>\n";
    echo "</ul>\n";
    
} catch (Exception $e) {
    echo "<p style='color: red'>✗ Test failed: " . htmlspecialchars($e->getMessage()) . "</p>\n";
}
?>