<?php
// Create this as debug_request.php in your /public directory

echo "<h1>Apache Request Debug</h1>";
echo "<pre>";

echo "=== SERVER VARIABLES ===\n";
echo "REQUEST_URI: " . ($_SERVER['REQUEST_URI'] ?? 'NOT SET') . "\n";
echo "SCRIPT_NAME: " . ($_SERVER['SCRIPT_NAME'] ?? 'NOT SET') . "\n";
echo "PHP_SELF: " . ($_SERVER['PHP_SELF'] ?? 'NOT SET') . "\n";
echo "DOCUMENT_ROOT: " . ($_SERVER['DOCUMENT_ROOT'] ?? 'NOT SET') . "\n";
echo "HTTP_HOST: " . ($_SERVER['HTTP_HOST'] ?? 'NOT SET') . "\n";
echo "REQUEST_METHOD: " . ($_SERVER['REQUEST_METHOD'] ?? 'NOT SET') . "\n";
echo "QUERY_STRING: " . ($_SERVER['QUERY_STRING'] ?? 'NOT SET') . "\n";

echo "\n=== PATH INFO ===\n";
echo "Current working directory: " . getcwd() . "\n";
echo "Script filename: " . ($_SERVER['SCRIPT_FILENAME'] ?? 'NOT SET') . "\n";
echo "Realpath of script: " . realpath(__FILE__) . "\n";

echo "\n=== REWRITE VARIABLES ===\n";
foreach ($_SERVER as $key => $value) {
    if (strpos($key, 'REDIRECT_') === 0 || strpos($key, 'REWRITE_') === 0) {
        echo "$key: $value\n";
    }
}

echo "\n=== ALL $_GET VARIABLES ===\n";
print_r($_GET);

echo "\n=== CHECKING FILE ACCESS ===\n";
$indexPath = __DIR__ . '/index.php';
echo "Index.php path: $indexPath\n";
echo "Index.php exists: " . (file_exists($indexPath) ? 'YES' : 'NO') . "\n";
echo "Index.php readable: " . (is_readable($indexPath) ? 'YES' : 'NO') . "\n";

echo "</pre>";
?>