<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>BestCall Badge Test Page</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
            background-color: #f5f5f5;
        }
        .test-container {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            margin-bottom: 30px;
        }
        h1 {
            color: #333;
            text-align: center;
        }
        h2 {
            color: #0066cc;
            border-bottom: 2px solid #0066cc;
            padding-bottom: 10px;
        }
        .badge-demo {
            text-align: center;
            padding: 20px;
            border: 2px dashed #ccc;
            border-radius: 10px;
            background-color: #fafafa;
        }
        .instructions {
            background-color: #e8f4fd;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
        }
        .code-block {
            background-color: #f8f9fa;
            border: 1px solid #e9ecef;
            border-radius: 4px;
            padding: 15px;
            font-family: 'Courier New', monospace;
            font-size: 14px;
            margin: 10px 0;
            overflow-x: auto;
        }
        .status {
            padding: 10px;
            border-radius: 5px;
            margin: 10px 0;
            font-weight: bold;
        }
        .error {
            background-color: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        .success {
            background-color: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        .info {
            background-color: #d1ecf1;
            color: #0c5460;
            border: 1px solid #bee5eb;
        }
    </style>
</head>
<body>
    <h1>🏅 BestCall Badge Widget Test Page</h1>
    
    <div class="test-container">
        <h2>📋 Test Instructions</h2>
        <div class="instructions">
            <p><strong>To test the badge:</strong></p>
            <ol>
                <li>Upload <code>badge.js</code> to <code>/public/badge.js</code></li>
                <li>Upload <code>badge-verify.php</code> to <code>/public/api/badge-verify.php</code></li>
                <li>Replace <code>TEST_FORM_ID</code> below with a real formID from your database</li>
                <li>Reload this page</li>
            </ol>
        </div>
        
        <div class="code-block">
            &lt;script src="https://bestcallhvac.com/public/badge.js" data-form-id="<strong>32158</strong>"&gt;&lt;/script&gt;
        </div>
    </div>

    <div class="test-container">
        <h2>🎯 Live Badge Demo</h2>
        <div class="badge-demo">
            <p><strong>Your badge should appear below:</strong></p>
            
            <!-- REPLACE TEST_FORM_ID WITH A REAL FORM ID FROM YOUR DATABASE -->
            <script src="https://bestcallhvac.com/public/badge.js" data-form-id="32158"></script>
            
            <p style="margin-top: 20px; font-size: 12px; color: #666;">
                If no badge appears, check browser console for errors (F12)
            </p>
        </div>
    </div>

    <div class="test-container">
        <h2>🔧 Troubleshooting</h2>
        
        <div class="info">
            <strong>Expected Behavior:</strong><br>
            • Spinning badge with your two PNG images<br>
            • Today's date below the badge<br>
            • FormID displayed<br>
            • "Verify Live" text<br>
            • Badge is clickable
        </div>
        
        <div class="error">
            <strong>If badge doesn't appear:</strong><br>
            • Check browser console (F12) for JavaScript errors<br>
            • Verify formID exists in your database<br>
            • Ensure API file is uploaded correctly<br>
            • Check server error logs
        </div>
        
        <h3>Manual API Test</h3>
        <p>You can test the API directly by visiting:</p>
        <div class="code-block">
            POST: https://bestcallhvac.com/public/api/badge-verify.php<br>
            Body: {"formId":"TEST_FORM_ID","domain":"localhost"}
        </div>
        
        <p>Expected response for valid formID:</p>
        <div class="code-block">
            {"valid":true,"message":"Badge verified successfully","formId":"TEST_FORM_ID","domain":"localhost","timestamp":"2025-08-26 12:00:00"}
        </div>
    </div>

    <div class="test-container">
        <h2>📝 Customer Embedding Instructions</h2>
        <p>Once working, customers can embed the badge with just one line:</p>
        <div class="code-block">
            &lt;script src="https://bestcallhvac.com/public/badge.js" data-form-id="<strong>THEIR_FORM_ID</strong>"&gt;&lt;/script&gt;
        </div>
    </div>

    <script>
        // Add some debugging info to console
        console.log('BestCall Badge Test Page Loaded');
        console.log('Current domain:', window.location.hostname);
        console.log('Check above for any badge loading errors');
        
        // Listen for any JavaScript errors
        window.addEventListener('error', function(e) {
            console.error('Page Error:', e.error);
        });
    </script>
</body>
</html>