const base_url = document.getElementById('store_event_info_js').getAttribute('base_url')

 $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
      var activated_tab = e.target // activated tab
      var previous_tab = e.relatedTarget // previous tab
      if(activated_tab.id === 'business_tab') {
		  $('#store_list').addClass('active show');
		  $('#event_list').removeClass('active show');
        $('#store_list').css('display', 'block');
        $('#event_list').css('display', 'none');
      };
      if(activated_tab.id === 'event_tab') {
		  $('#store_list').removeClass('active show');
		  $('#event_list').addClass('active show');
        $('#store_list').css('display', 'none');
        $('#event_list').css('display', 'block');
      }      
    });

$(function() {
        // from getLocation function we get users default GPS location  
        getLocation('#loc-form');
});
        
    $(document).ready(function(){
		$('.datepicker').datepicker({
			format: 'mm/dd/yyyy',
			startDate: 'd',
			autoclose: true,
			todayHighlight: true,
		});
	$('.datepicker').datepicker("setDate", new Date());

	//Store search functions//
	//======================//
	
        // when user type location string then using below function we get users lat-lng 
        $('#form_location').on('change', function(){
            //addr_search();
            $('.store_detail').html('');
            $('.loc-result-set').css('opacity', 1);
        });
        
         // on search btn click get user's location and filter store  
        $('.search-btn').on('click', function (e) {
            $('.ajax-loader').show();			
            if($('#form_location').val() == ''){
                errorTost("Enter Location to find store", 'top-center');
                $('.ajax-loader').hide();
                return false;
            }
			addr_search();
        });
    });

	var store_page_no = 1;
    var isStoreDataLoading = true;
	var isStoreLoading = false;
	
	var event_page_no = 1;
    var isEventDataLoading = true;
	var isEventLoading = false;
		
    // filter store  ?>
    function findStore(page_no = 1){
        $.ajax({
            context: this,
            type: "POST",
			url: `${base_url}locator/findStore/?page_no=${page_no}`,
            data: $('#loc-form').serialize(),
            beforeSend: function () {
                $('.ajax-loader').show();
            },
            success: function (response) {
                // e.preventDefault();
                response = JSON.parse(response);
				//console.log(response);
				if (response.store_info.total_record > 0){
					isStoreLoading = false;
					isStoreDataLoading = true;
				}
                $('.loc-result-set').html(response.viewHtml);
                $('.ajax-loader').hide();
            }
        });
    }

    // Get single store detail on clicking on view store btn  ?>
    function getStoreDetail(store_id){
        $.ajax({
            context: this,
            type: "POST",
			url: `${base_url}locator/storeDetail`,
            data: { store_id: store_id },
            beforeSend: function () {
                $('.ajax-loader').show();
            },
            success: function (response) {
				$('.store_detail').html();
                response = JSON.parse(response);
                $('.loc-result-set').css('opacity', 0);
                $('.store_detail').html(response);
                $('.ajax-loader').hide();
            }
        });
    }		
        		
		$(window).scroll(function () {
			var storeScrollPosition = Math.ceil($(".video-background-content").height() + $(".loc-result-set").height());				
			var eventScrollPosition = Math.ceil($(".video-background-content").height() + $(".event-loc-result-set").height());
			
					if(Math.ceil($(window).scrollTop() >= storeScrollPosition - 300)) {
						if (isStoreLoading == false) {
							isStoreLoading = true;
							store_page_no++;
							if (isStoreDataLoading) {
								loadMoreStores(store_page_no);
							}
						}
					}
					
					if(Math.ceil($(window).scrollTop() >= eventScrollPosition - 500)) {
						
						if (isEventLoading == false) {
							isEventLoading = true;
							event_page_no++;
							if (isEventDataLoading) {
								loadMoreEvents(event_page_no);
							}
						}
					}
		});
	
        function loadMoreStores(store_page_no){
			  $.ajax({
				context: this,
				type: "POST",
				url: `${base_url}locator/findStore/?page_no=${store_page_no}`,
				data: $('#loc-form').serialize(),
				beforeSend: function () {
					$('.store_loader').show();
				},
				success: function (response) {
					// e.preventDefault();
					isStoreLoading = false;
					response = JSON.parse(response);
					console.log(response);
					//alert(response.length);
					if (response.store_info.total_record == 0 || response.store_info.page_no > response.store_info.total_pages) {
						isStoreDataLoading = false;
						$('.store_loader').hide();
						return;
					}
					
					$('.store_loader').hide();
					$('.loc-result-set').append(response.viewHtml).show('slow');	
				}				
			});		
        }
	
	//Event search functions//
	//======================//
	$(document).ready(function(){
	 // when user type location string then using below function we get users lat-lng ?>
        $('#event_form_location').on('change', function(){
            //addr_search();
            $('.events_detail').html('');
            $('.event-loc-result-set').css('opacity', 1);
        });
        
     // on search btn click get user's location and filter store  ?>
        $('.event-search-btn').on('click', function (e) {
            $('.ajax-loader').show();			
            if($('#event_form_location').val() == ''){
                errorTost("Enter Location to find event", 'top-center');
                $('.ajax-loader').hide();
                return false;
            }
			event_addr_search();
        });
    });

	
   // filter events  ?>
    function findEvent(event_page_no = 1){
        $.ajax({
            context: this,
            type: "POST",
			url: `${base_url}locator/findEvent/?event_page_no=${event_page_no}`,
            data: $('#event-loc-form').serialize(),
            beforeSend: function () {
                $('.ajax-loader').show();
            },
            success: function (response) {
                // e.preventDefault();
                response = JSON.parse(response);
				if (response.event_info.total_record > 0){
					isEventLoading = false;
					isEventDataLoading = true;
				}
                $('.event-loc-result-set').html(response.viewHtml);
                $('.ajax-loader').hide();
            }
        });
    }
	
	function loadMoreEvents(event_page_no){
			  $.ajax({
				context: this,
				type: "POST",
				url: `${base_url}locator/findEvent/?event_page_no=${event_page_no}`,
				data: $('#event-loc-form').serialize(),
				beforeSend: function () {
					$('.event_loader').show();
				},
				success: function (response) {
					// e.preventDefault();
					isEventLoading = false;
					response = JSON.parse(response);
					console.log(response);
					//alert(response.length);
					if (response.event_info.total_record == 0 || response.event_info.page_no > response.event_info.total_pages) {
						isEventDataLoading = false;
						$('.event_loader').hide();
						return;
					}
					
					$('.event_loader').hide();
					$('.event-loc-result-set').append(response.viewHtml).show('slow');	
				}				
			});		
        }
	
	function Timer(fn, t) {
		var timerObj = setInterval(fn, t);

		this.stop = function() {
			if (timerObj) {
				clearInterval(timerObj);
				timerObj = null;
			}
			return this;
		}

		// start timer using current settings (if it's not already running)
		this.start = function() {
			if (!timerObj) {
				this.stop();
				timerObj = setInterval(fn, t);
			}
			return this;
		}

		// start with new or original interval, stop current interval
		this.reset = function(newT = t) {
			t = newT;
			return this.stop().start();
		}
	}
	
	var timeVarClass = '';
	var timeVarDay = '';
	var store_timer = '';
	//Countdown for Event
	function event_countdown(countdown_class, eventDate, selectedDay){
		console.log(Intl.DateTimeFormat().resolvedOptions().timeZone);					
			//alert(timeVarClass);
			//alert(selectedDay);
		if(timeVarClass !='' && timeVarClass != countdown_class && timeVarDay != '' && timeVarDay != selectedDay){			
			store_timer.stop();	
		}
		
		timeVarClass = countdown_class;
		timeVarDay = selectedDay;
		// Set the date we're counting down to
		var countDownDate = new Date(eventDate).getTime();
		// Update the count down every 1 second
		window["store"+countdown_class] = new Timer(function() {
			// Get today's date and time
			  var now = new Date().getTime();
				
			  // Find the distance between now and the count down date
			  distance = countDownDate - now;
				
			  // Time calculations for days, hours, minutes and seconds
			  var days = Math.floor(distance / (1000 * 60 * 60 * 24));
			  var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
			  var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
			  var seconds = Math.floor((distance % (1000 * 60)) / 1000);
				
			if(	days == 0){
				var timer = "OPENS IN : " + hours + "h " + minutes + "m " + seconds + "s ";
			}
			else {
				var timer = "OPENS IN : " + days + "d " + hours + "h " + minutes + "m " + seconds + "s ";
			}
				
			  
			  $("."+countdown_class).text(timer);
			  // If the count down is over, write some text 
			  if (distance < 0) {
				//clearInterval(x);
				store_timer.stop();	
				$("."+countdown_class).text("");
			  }
			}, 1000);
		
		store_timer	= window["store"+countdown_class];	
	}
			
		 $(document).on('click', '.stores_list_modal', function() { 
			//alert($(this).data("val"));
			var storeID = $(this).data("val");
			var store_modal_header = $(".store_modal_header_"+storeID).html();
			var store_modal_body = $(".store_modal_body_"+storeID).html();
			var store_popup_image = $(this).data("image"); 
			
			$(".store-modal .modal-header").html(store_modal_header);
			$(".store-body-info").html(store_modal_body);
			if(store_popup_image){
				$(".store-popup-image").attr("src", store_popup_image);
			}
			
		});
		
		$(document).on('click', '.events_list_modal', function() { 
			//alert($(this).data("val"));
			var eventID = $(this).data("val");
			var event_modal_header = $(".event_modal_header_"+eventID).html();
			var event_modal_body = $(".event_modal_body_"+eventID).html();
			var event_popup_image = $(this).data("image"); 
			
			$(".event-modal .modal-header").html(event_modal_header);
			$(".event-body-info").html(event_modal_body);
			if(event_popup_image){
				$(".event-popup-image").attr("src", event_popup_image);
			}
			
		});
	
    function newWindowOpen(url) {
      window.open(url, "_blank", "toolbar=yes,scrollbars=yes,resizable=yes,top=500,left=500,width=600,height=600");
    }


$(document).on('click', '.category-filter', function(e) {
  e.preventDefault();

  const catId = $(this).data('category-id');
  $('#category_id').val(catId);
  $('input[name="page_no"]').val(1);
  $('.loc-result-set').empty();

  // Trigger existing AJAX load function
  if (typeof getResultsByGPS === 'function') {
    getResultsByGPS();
  }
});
