<?php if (!empty($stores) && is_array($stores)): ?>
    <?php foreach ($stores as $store): ?>
        <div class="col-sm-6 col-xl-6 stores_list_modal mb-4"
             data-val="<?= esc($store['id']) ?>"
             data-image="<?= esc($store['image']) ?>"
             data-bs-toggle="modal"
             data-bs-target="#store-info-dialog">

            <div class="store-box rounded shadow-sm overflow-hidden"
                 style="background-image: url('<?= esc($store['image']) ?>');
                        background-size: cover;
                        background-position: center;
                        min-height: 370px;
                        max-height: 400px;
                        position: relative;">

                <div class="overlay bg-secondary" style="opacity: 0.5; position: absolute; width: 100%; height: 100%;"></div>

                <div class="store-info position-absolute text-white p-3" style="bottom: 0; z-index: 2;">
                    <h4 class="text-uppercase m-0 fw-bold"><?= esc($store['name']) ?></h4>
                    <div class="store_time_span small">
                        <?= esc($store['address']) ?> <?= esc($store['city']) ?> <?= esc($store['state']) ?> <?= esc($store['postal_code']) ?>
                    </div>
                    <?php if (!empty($store['distance'])): ?>
                        <div class="store_time_span small fw-bold"><?= esc($store['distance']) ?> MI</div>
                    <?php endif; ?>
                    <?php if (!empty($store['is_closed']) && $store['is_closed'] == '1'): ?>
                        <div class="store_time_span small text-danger">Closed: <?= esc($store['close_message']) ?></div>
                    <?php endif; ?>
                </div>

            </div>
        </div>
    <?php endforeach; ?>
<?php else: ?>
    <div class="col-12 text-center text-muted py-5">
        <i class="fa fa-info-circle fa-2x d-block mb-2"></i>
        <strong>No results found. Please try a different keyword or location.</strong>
    </div>
<?php endif; ?>
