<!-- Sticky Header - Always Visible -->
<header class="sticky-header" id="stickyHeader">
    <div class="container-fluid">
        <div class="sticky-content">
            <!-- Sticky Logo -->
            <div class="sticky-logo">
                <a href="/" title="Return to home">
                    <img src="https://bestcallhvac.com/weblogo.png" alt="BestCall">
                </a>
            </div>
            
            <!-- Compact Keyword Search -->
            <div class="sticky-search">
                <form id="sticky-search-form" class="sticky-form">
                    <div class="sticky-input-group">
                        <button type="button" class="search-action-btn sticky-crosshairs" title="Use my location">
                            <i class="fas fa-crosshairs"></i>
                        </button>
                        <input type="text" 
                               id="sticky_search_input" 
                               class="sticky-input" 
                               placeholder="Search any keyword / name..."
                               autocomplete="off">
                        <button type="button" class="input-clear-btn" id="sticky-clear-btn" style="display: none;" title="Clear search">
                            <i class="fas fa-times"></i>
                        </button>
                        <button type="submit" class="search-action-btn sticky-search-btn">
                            <i class="fas fa-search"></i>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</header>

<style>
/* Enhanced Sticky Header Styles */
.sticky-header {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    background: rgba(255, 255, 255, 0.85); /* More transparent */
    backdrop-filter: blur(15px); /* Enhanced blur effect */
    -webkit-backdrop-filter: blur(15px); /* Safari support */
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15); /* Enhanced bottom shadow */
    z-index: 1000;
    transform: translateY(0);
    transition: all 0.3s ease;
    padding: 0.75rem 0; /* Slightly reduced padding */
    border-bottom: 1px solid rgba(255, 255, 255, 0.3); /* Subtle border */
}

/* Hover effect for more visibility */
.sticky-header:hover {
    background: rgba(255, 255, 255, 0.95);
    backdrop-filter: blur(20px);
    -webkit-backdrop-filter: blur(20px);
    box-shadow: 0 6px 25px rgba(0, 0, 0, 0.2);
}

.sticky-content {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 2rem;
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 1rem;
}

.sticky-logo img {
    height: 90px; /* Slightly smaller for more elegant look */
    transition: var(--transition);
    filter: drop-shadow(0 2px 4px rgba(0,0,0,0.1)); /* Subtle logo shadow */
}

.sticky-logo a {
    text-decoration: none;
    display: inline-block;
    transition: var(--transition);
}

.sticky-logo a:hover {
    transform: scale(1.05);
}

.sticky-search {
    flex: 1;
    max-width: 450px; /* Slightly wider for better UX */
    margin: 0 auto;
}

.sticky-input-group {
    display: flex;
    background: rgba(255, 255, 255, 0.9); /* Semi-transparent background */
    border: 2px solid rgba(233, 236, 239, 0.8); /* Semi-transparent border */
    border-radius: var(--border-radius);
    overflow: hidden;
    transition: var(--transition);
    position: relative;
    align-items: stretch;
    backdrop-filter: blur(10px);
    -webkit-backdrop-filter: blur(10px);
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1); /* Input shadow */
}

.sticky-input-group:focus-within {
    border-color: var(--primary-color);
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.15), 0 4px 15px rgba(0, 0, 0, 0.15);
    background: rgba(255, 255, 255, 0.98); /* More opaque when focused */
}

.sticky-crosshairs,
.sticky-search-btn {
    padding: 0.875rem 1.25rem;
    border: none;
    cursor: pointer;
    transition: var(--transition);
    display: flex;
    align-items: center;
    justify-content: center;
    min-width: 60px;
    flex-shrink: 0;
    box-sizing: border-box;
    min-height: 48px;
    font-size: 0.95rem;
}

.sticky-crosshairs {
    background: var(--primary-color);
    color: white;
}

.sticky-crosshairs:hover {
    background: var(--secondary-color);
    transform: scale(1.05);
}

.sticky-search-btn {
    padding: 0.875rem 1.5rem;
    background: var(--primary-color);
    color: white;
    min-width: 65px;
}

.sticky-search-btn:hover {
    background: var(--secondary-color);
    transform: scale(1.05);
}

.sticky-input {
    flex: 1;
    padding: 0.875rem 1.25rem;
    border: none;
    outline: none;
    font-size: 1rem;
    min-height: 48px;
    background: transparent;
    color: var(--dark-color);
    font-weight: 500;
}

.sticky-input::placeholder {
    color: #666;
    opacity: 0.8;
    font-weight: 400;
}

.sticky-input:focus::placeholder {
    opacity: 0.5;
}

/* Clear button positioning for sticky header */
.sticky-input-group .input-clear-btn {
    position: absolute;
    right: 75px; /* Adjusted for sticky header button width */
    top: 50%;
    transform: translateY(-50%);
    background: var(--danger-color);
    color: white;
    border: none;
    border-radius: 50%;
    width: 22px;
    height: 22px;
    cursor: pointer;
    transition: var(--transition);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 11px;
    z-index: 10;
}

.sticky-input-group .input-clear-btn:hover {
    background: #c82333;
    transform: translateY(-50%) scale(1.1);
}

/* Enhanced transparency effects */
@media (min-width: 768px) {
    .sticky-header {
        background: rgba(255, 255, 255, 0.8); /* More transparent on desktop */
    }
    
    .sticky-header:hover {
        background: rgba(255, 255, 255, 0.92);
    }
}

/* Mobile Responsiveness */
@media (max-width: 768px) {
    .sticky-logo {
        display: none; /* Hide logo on mobile for more space */
    }
    
    .sticky-content {
        justify-content: center;
        gap: 0;
        padding: 0 0.75rem;
    }
    
    .sticky-search {
        width: 100%;
        max-width: 100%;
        margin: 0;
    }
    
    .sticky-crosshairs,
    .sticky-search-btn {
        padding: 0.75rem 1rem;
        min-width: 50px;
        font-size: 0.9rem;
        min-height: 44px;
    }
    
    .sticky-input {
        padding: 0.75rem 1rem;
        font-size: 16.1px !important; /* Just above iOS zoom threshold */
        min-height: 44px;
    }
    
    .sticky-header {
        padding: 0.5rem 0;
        background: rgba(255, 255, 255, 0.9); /* Less transparent on mobile */
    }
    
    .sticky-input-group .input-clear-btn {
        right: 60px; /* Adjusted for mobile button width */
        width: 20px;
        height: 20px;
        font-size: 10px;
    }
}

@media (max-width: 576px) {
    .sticky-crosshairs,
    .sticky-search-btn {
        padding: 0.625rem 0.875rem;
        min-width: 45px;
        font-size: 0.85rem;
        min-height: 42px;
    }
    
    .sticky-input {
        padding: 0.625rem 0.875rem;
        font-size: 0.9rem;
        min-height: 42px;
    }
    
    .sticky-input-group .input-clear-btn {
        right: 55px;
        width: 18px;
        height: 18px;
        font-size: 9px;
    }
}

/* Smooth scroll offset to account for sticky header */
html {
    scroll-padding-top: 120px;
}
</style>