<?php

namespace App\Controllers\Frontend;

use App\Controllers\BaseController;
use App\Models\StoreModel;
use CodeIgniter\HTTP\ResponseInterface;

class StoreLocatorController extends BaseController
{
    public function index()
    {
        if (!$this->request->isAJAX()) {
            return $this->response->setStatusCode(ResponseInterface::HTTP_BAD_REQUEST)->setBody('Invalid request');
        }

        $latitude  = $this->request->getPost('latitude');
        $longitude = $this->request->getPost('longitude');
        $keyword   = $this->request->getPost('keyword');
        $page      = (int) $this->request->getPost('page_no', 1);
        $limit     = 10;
        $offset    = ($page - 1) * $limit;

        $storeModel = new StoreModel();
        $stores = $storeModel->getNearbyStores($latitude, $longitude, $keyword, $limit, $offset);

        $html = '';
        foreach ($stores as $store) {
            $html .= view('frontend/components/store_card', ['store' => $store]);
        }

        return $this->response->setJSON(['html' => $html]);
    }
}
