<?php
$this->extend('layouts/feedback'); 
?>
<?php $this->section('content'); ?>

<!-- Sticky Header -->
<header class="sticky-header visible" id="stickyHeader">
    <div class="container-fluid">
        <div class="sticky-content">
            <div class="sticky-logo">
                <a href="/" title="Return to home">
                    <img src="https://ringgoldroad.com/assets/images/weblogo.png" alt="Ringgold Road">
                </a>
            </div>
        </div>
    </div>
</header>

<!-- Main Content -->
<div class="feedback-success-page">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-12 col-md-8 col-lg-6">
                
                <!-- Success Message -->
                <div class="success-container">
                    <div class="success-icon">
                        <i class="fas fa-heart"></i>
                    </div>
                    
                    <h1 class="success-title">Thank You!</h1>
                    <p class="success-subtitle">We're thrilled you had a positive experience with <strong><?= esc($store['name']) ?></strong></p>
                    
                    <!-- Google Review Invitation -->
                    <?php if (!empty($store['google_review_url'])): ?>
                        <div class="review-section">
                            <h3>Help Other Customers Find <?= esc($store['name']) ?></h3>
                            <p>Would you mind sharing your positive experience online? Your review helps other customers discover great local businesses.</p>
                            
                            <div class="review-actions">
                                <form method="post" action="<?= base_url('feedback/accept-google-review') ?>" class="d-inline">
                                    <?= csrf_field() ?>
                                    <input type="hidden" name="feedback_id" value="<?= esc($feedback_id) ?>">
                                    <button type="submit" class="btn btn-review btn-lg">
                                        <i class="fas fa-star"></i>
                                        <span>Share Your Experience</span>
                                        <i class="fas fa-external-link-alt"></i>
                                    </button>
                                </form>
                                
                                <button type="button" class="btn btn-secondary btn-lg" onclick="skipReview()">
                                    <span>Not Right Now</span>
                                </button>
                            </div>
                        </div>
                    <?php else: ?>
                        <!-- No Google URL configured -->
                        <div class="no-review-section">
                            <p>Your feedback helps <?= esc($store['name']) ?> continue providing excellent service.</p>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Additional Message -->
                <div class="additional-info">
                    <div class="info-card">
                        <h4><i class="fas fa-handshake me-2"></i>Your Feedback Matters</h4>
                        <p>Your positive feedback helps local businesses thrive and helps other customers make informed decisions. Thank you for taking the time to share your experience!</p>
                    </div>
                </div>

                <!-- Return to Directory -->
                <div class="return-section">
                    <a href="<?= base_url() ?>" class="btn btn-outline-primary">
                        <i class="fas fa-arrow-left me-2"></i>
                        Back to Business Directory
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
/* Variables */
:root {
    --primary-color: #667eea;
    --google-color: #4285f4;
    --success-color: #28a745;
    --heart-color: #e74c3c;
    --light-gray: #f8f9fa;
    --border-radius: 12px;
    --transition: all 0.3s ease;
}

/* Page Layout */
.feedback-success-page {
    min-height: 100vh;
    background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
    padding: 80px 0 40px 0;
}

/* Sticky Header */
.sticky-header {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    background: white;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    z-index: 1000;
    padding: 1rem 0;
}

.sticky-content {
    display: flex;
    align-items: center;
    justify-content: center;
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 1rem;
}

.sticky-logo img {
    height: 60px;
    transition: var(--transition);
}

.sticky-logo a:hover {
    transform: scale(1.05);
}

/* Success Container */
.success-container {
    background: white;
    border-radius: 20px;
    padding: 3rem 2rem;
    text-align: center;
    box-shadow: 0 10px 40px rgba(0,0,0,0.15);
    margin-bottom: 2rem;
    position: relative;
    overflow: hidden;
}

.success-container::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 6px;
    background: linear-gradient(90deg, var(--heart-color) 0%, var(--google-color) 100%);
}

/* Success Icon */
.success-icon {
    margin-bottom: 1.5rem;
    position: relative;
}

.success-icon i {
    font-size: 4rem;
    color: var(--heart-color);
    animation: heartbeat 2s ease-in-out infinite;
}

@keyframes heartbeat {
    0% { transform: scale(1); }
    14% { transform: scale(1.1); }
    28% { transform: scale(1); }
    42% { transform: scale(1.1); }
    70% { transform: scale(1); }
}

/* Success Text */
.success-title {
    font-size: 2.5rem;
    font-weight: 800;
    color: #333;
    margin-bottom: 1rem;
}

.success-subtitle {
    font-size: 1.2rem;
    color: #666;
    margin-bottom: 2rem;
    line-height: 1.6;
}

/* Review Section */
.review-section {
    border-top: 2px dashed #e9ecef;
    padding-top: 2rem;
    margin-top: 2rem;
}

.review-section h3 {
    color: #333;
    font-size: 1.4rem;
    font-weight: 700;
    margin-bottom: 1rem;
}

.review-section p {
    color: #666;
    font-size: 1.1rem;
    line-height: 1.6;
    margin-bottom: 2rem;
}

/* Review Actions */
.review-actions {
    display: flex;
    flex-direction: column;
    gap: 1rem;
    align-items: center;
}

.btn-review {
    background: var(--google-color);
    border: none;
    color: white;
    padding: 1rem 2rem;
    border-radius: var(--border-radius);
    font-size: 1.1rem;
    font-weight: 600;
    transition: var(--transition);
    display: flex;
    align-items: center;
    gap: 0.75rem;
    min-width: 280px;
    justify-content: center;
    position: relative;
    overflow: hidden;
}

.btn-review:hover {
    background: #3367d6;
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(66, 133, 244, 0.3);
    color: white;
}

.btn-review:active {
    transform: translateY(0);
}

.btn-review .fas {
    font-size: 1.1rem;
}

.btn-review .fa-external-link-alt {
    font-size: 0.9rem;
    opacity: 0.8;
}

.btn-secondary {
    background: transparent;
    border: 2px solid #6c757d;
    color: #6c757d;
    padding: 0.75rem 1.5rem;
    border-radius: var(--border-radius);
    font-size: 1rem;
    font-weight: 500;
    transition: var(--transition);
    min-width: 200px;
}

.btn-secondary:hover {
    background: #6c757d;
    color: white;
}

/* No Review Section */
.no-review-section {
    border-top: 2px dashed #e9ecef;
    padding-top: 2rem;
    margin-top: 2rem;
}

.no-review-section p {
    color: #666;
    font-size: 1.1rem;
    line-height: 1.6;
    margin: 0;
}

/* Additional Info */
.additional-info {
    margin-bottom: 2rem;
}

.info-card {
    background: rgba(255, 255, 255, 0.95);
    border-radius: var(--border-radius);
    padding: 1.5rem;
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    text-align: center;
}

.info-card h4 {
    color: #333;
    font-size: 1.2rem;
    font-weight: 600;
    margin-bottom: 1rem;
    display: flex;
    align-items: center;
    justify-content: center;
}

.info-card p {
    color: #666;
    line-height: 1.6;
    margin: 0;
}

/* Return Section */
.return-section {
    text-align: center;
}

.btn-outline-primary {
    border: 2px solid white;
    color: white;
    background: transparent;
    padding: 0.75rem 1.5rem;
    border-radius: var(--border-radius);
    font-weight: 600;
    transition: var(--transition);
    text-decoration: none;
    display: inline-flex;
    align-items: center;
}

.btn-outline-primary:hover {
    background: white;
    color: var(--primary-color);
    transform: translateY(-2px);
    text-decoration: none;
}

/* Mobile Responsiveness */
@media (max-width: 768px) {
    .feedback-success-page {
        padding: 70px 15px 30px 15px;
    }
    
    .success-container {
        padding: 2rem 1.5rem;
    }
    
    .success-title {
        font-size: 2rem;
    }
    
    .success-subtitle {
        font-size: 1.1rem;
    }
    
    .review-section h3 {
        font-size: 1.2rem;
    }
    
    .btn-review {
        min-width: 100%;
        font-size: 1rem;
    }
    
    .btn-secondary {
        min-width: 100%;
    }
    
    .review-actions {
        gap: 0.75rem;
    }
}

@media (max-width: 480px) {
    .success-container {
        padding: 1.5rem 1rem;
    }
    
    .success-icon i {
        font-size: 3rem;
    }
    
    .success-title {
        font-size: 1.8rem;
    }
    
    .btn-google {
        padding: 0.875rem 1.5rem;
        font-size: 0.95rem;
    }
}

/* Loading Animation for Google Button */
.btn-google.loading {
    pointer-events: none;
}

.btn-google.loading span {
    opacity: 0;
}

.btn-google.loading::after {
    content: '';
    position: absolute;
    width: 20px;
    height: 20px;
    border: 2px solid transparent;
    border-top: 2px solid white;
    border-radius: 50%;
    animation: spin 1s linear infinite;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}
</style>

<script>
function skipReview() {
    // Smooth transition to the return section
    document.querySelector('.return-section').scrollIntoView({ 
        behavior: 'smooth' 
    });
    
    // Optional: Show a brief thank you message
    const skipBtn = event.target;
    const originalText = skipBtn.innerHTML;
    skipBtn.innerHTML = '<i class="fas fa-check me-2"></i>Thank you!';
    skipBtn.disabled = true;
    
    setTimeout(() => {
        skipBtn.innerHTML = originalText;
        skipBtn.disabled = false;
    }, 2000);
}

// Handle Google review button click
document.addEventListener('DOMContentLoaded', function() {
    const googleBtn = document.querySelector('.btn-google');
    
    if (googleBtn) {
        googleBtn.addEventListener('click', function() {
            this.classList.add('loading');
            this.disabled = true;
        });
    }
});
</script>

<?php $this->endSection(); ?>