<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Business Hours - <?= esc($store['name'] ?? 'Your Business') ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: #f7fafc;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body.has-business-header {
            padding-top: 70px;
        }
        
        .hours-container {
            max-width: 1000px;
            margin: 0 auto;
            padding: 2rem;
        }
        
        .page-header {
            background: white;
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            border-left: 4px solid #667eea;
        }
        
        .page-title {
            font-size: 2rem;
            font-weight: 700;
            color: #2d3748;
            margin-bottom: 0.5rem;
        }
        
        .page-subtitle {
            color: #718096;
            font-size: 1.1rem;
        }
        
        .hours-notice {
            background: #f0f4ff;
            border: 1px solid #cbd5e0;
            border-radius: 12px;
            padding: 1.5rem;
            margin-bottom: 2rem;
            display: flex;
            align-items: start;
            gap: 1rem;
        }
        
        .hours-notice i {
            color: #667eea;
            font-size: 1.5rem;
            margin-top: 0.25rem;
        }
        
        .hours-section {
            background: white;
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }
        
        .section-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1.5rem;
            padding-bottom: 1rem;
            border-bottom: 2px solid #e9ecef;
        }
        
        .section-title {
            font-size: 1.3rem;
            font-weight: 600;
            color: #2d3748;
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }
        
        .hour-type-badge {
            background: #667eea;
            color: white;
            padding: 0.25rem 0.75rem;
            border-radius: 20px;
            font-size: 0.75rem;
            font-weight: 600;
            text-transform: uppercase;
        }
        
        .day-schedule {
            border: 2px solid #e9ecef;
            border-radius: 12px;
            padding: 1rem;
            margin-bottom: 1rem;
            transition: all 0.3s ease;
        }
        
        .day-schedule:hover {
            border-color: #cbd5e0;
            background: #f8f9fa;
        }
        
        .day-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1rem;
        }
        
        .day-name {
            font-weight: 600;
            color: #2d3748;
            font-size: 1.1rem;
        }
        
        .closed-toggle {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .form-check-input {
            width: 20px;
            height: 20px;
            cursor: pointer;
        }
        
        .time-slots {
            display: grid;
            grid-template-columns: 1fr auto 1fr;
            gap: 1rem;
            align-items: center;
        }
        
        .time-slot {
            display: flex;
            flex-direction: column;
            gap: 0.75rem;
        }
        
        .time-input-group {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .time-input {
            max-width: 150px;
        }
        
        .time-separator {
            color: #a0aec0;
            font-weight: 600;
            text-align: center;
            padding-top: 1.5rem;
        }
        
        .form-control:disabled {
            background: #f7fafc;
            cursor: not-allowed;
        }
        
        .add-split-shift {
            font-size: 0.875rem;
            color: #667eea;
            cursor: pointer;
            display: inline-flex;
            align-items: center;
            gap: 0.25rem;
            margin-top: 0.5rem;
        }
        
        .add-split-shift:hover {
            color: #5a67d8;
            text-decoration: underline;
        }
        
        .quick-actions {
            background: #f8f9fa;
            border-radius: 12px;
            padding: 1.5rem;
            margin-bottom: 2rem;
        }
        
        .quick-actions h5 {
            font-size: 1.1rem;
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 1rem;
        }
        
        .quick-action-buttons {
            display: flex;
            flex-wrap: wrap;
            gap: 0.75rem;
        }
        
        .quick-btn {
            background: white;
            border: 2px solid #e2e8f0;
            color: #4a5568;
            padding: 0.5rem 1rem;
            border-radius: 8px;
            font-size: 0.875rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .quick-btn:hover {
            border-color: #667eea;
            color: #667eea;
            background: #f0f4ff;
        }
        
        .btn-primary-custom {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 0.75rem 2rem;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .btn-primary-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.3);
            color: white;
        }
        
        .btn-secondary-custom {
            background: #f7fafc;
            color: #4a5568;
            border: 2px solid #e2e8f0;
            padding: 0.75rem 2rem;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .btn-secondary-custom:hover {
            background: #edf2f7;
            color: #4a5568;
            border-color: #cbd5e0;
        }
        
        .action-buttons {
            display: flex;
            gap: 1rem;
            justify-content: flex-end;
            margin-top: 2rem;
        }
        
        .help-text {
            font-size: 0.875rem;
            color: #718096;
            margin-top: 0.25rem;
        }
        
        .current-status {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.5rem 1rem;
            border-radius: 8px;
            font-weight: 600;
            font-size: 0.875rem;
        }
        
        .status-open {
            background: #d4f1e4;
            color: #276749;
        }
        
        .status-closed {
            background: #fef2f2;
            color: #991b1b;
        }
        
        @media (max-width: 768px) {
            .hours-container {
                padding: 1rem;
            }
            
            .hours-section {
                padding: 1.5rem;
            }
            
            .time-slots {
                grid-template-columns: 1fr;
                gap: 0.5rem;
            }
            
            .time-separator {
                display: none;
            }
            
            .action-buttons {
                flex-direction: column;
            }
            
            .btn-primary-custom, .btn-secondary-custom {
                width: 100%;
                justify-content: center;
            }
        }
    </style>
</head>
<body class="has-business-header">
    <?php include(APPPATH . 'Views/business/partials/header.php'); ?>

    <div class="hours-container">
        <div class="page-header">
            <h1 class="page-title">Business Hours</h1>
            <p class="page-subtitle">Keep your hours accurate so customers know when you're open</p>
        </div>

        <?php if (!empty($error)): ?>
        <div class="alert alert-danger">
            <i class="fas fa-exclamation-triangle"></i> <?= esc($error) ?>
        </div>
        <?php endif; ?>

        <?php if (!empty($success)): ?>
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i> <?= esc($success) ?>
        </div>
        <?php endif; ?>

        <div class="hours-notice">
            <i class="fas fa-info-circle"></i>
            <div>
                <h5 style="margin-bottom: 0.5rem; color: #2d3748;">Important Information About Hours</h5>
                <ul class="mb-0" style="padding-left: 1.25rem;">
                    <li>All changes to your hours require admin approval before going live</li>
                    <li>Your current hours will remain active until changes are approved</li>
                    <li>You'll receive an email notification when your changes are approved</li>
                    <li>For immediate changes (emergencies), please contact admin directly</li>
                </ul>
            </div>
        </div>

        <form method="post" action="/business/profile/hours" id="hoursForm">
            <?= csrf_field() ?>

            <?php if (empty($hours) || count($hours) == 0): ?>
                <div class="alert alert-info">
                    <i class="fas fa-clock"></i> No hours have been configured for your business yet. Please contact admin to set up your initial hours.
                </div>
            <?php else: ?>
                <?php foreach ($hours as $hourType => $schedule): ?>
                    <div class="hours-section">
                        <div class="section-header">
                            <h2 class="section-title">
                                <i class="fas fa-clock"></i>
                                <?= esc($hourType) ?>
                            </h2>
                            <?php if (isset($schedule[1]['affects_status']) && $schedule[1]['affects_status']): ?>
                                <span class="hour-type-badge">Affects Open Status</span>
                            <?php endif; ?>
                        </div>

                        <div class="quick-actions">
                            <h5>Quick Actions</h5>
                            <div class="quick-action-buttons">
                                <button type="button" class="quick-btn" onclick="setWeekdayHours('<?= $hourType ?>')">
                                    <i class="fas fa-briefcase"></i> Standard Weekday Hours
                                </button>
                                <button type="button" class="quick-btn" onclick="setWeekendClosed('<?= $hourType ?>')">
                                    <i class="fas fa-calendar-times"></i> Closed Weekends
                                </button>
                                <button type="button" class="quick-btn" onclick="setSameAllWeek('<?= $hourType ?>')">
                                    <i class="fas fa-copy"></i> Same Hours All Week
                                </button>
                            </div>
                        </div>

                        <?php 
                        $days = [
                            1 => 'Monday', 2 => 'Tuesday', 3 => 'Wednesday', 
                            4 => 'Thursday', 5 => 'Friday', 6 => 'Saturday', 7 => 'Sunday'
                        ];
                        ?>

                        <?php foreach ($days as $dayNum => $dayName): ?>
                            <?php $dayData = $schedule[$dayNum] ?? null; ?>
                            <div class="day-schedule" data-hour-type="<?= $hourType ?>" data-day="<?= $dayNum ?>">
                                <div class="day-header">
                                    <span class="day-name"><?= $dayName ?></span>
                                    <div class="closed-toggle">
                                        <label class="form-check-label" for="closed_<?= $hourType ?>_<?= $dayNum ?>">
                                            Closed
                                        </label>
                                        <input type="checkbox" 
                                               class="form-check-input closed-checkbox" 
                                               id="closed_<?= $hourType ?>_<?= $dayNum ?>"
                                               name="hours[<?= $hourType ?>][<?= $dayNum ?>][is_closed]"
                                               value="1"
                                               <?= ($dayData && $dayData['is_closed']) ? 'checked' : '' ?>
                                               onchange="toggleDayHours(this)">
                                    </div>
                                </div>

                                <div class="time-slots" <?= ($dayData && $dayData['is_closed']) ? 'style="display: none;"' : '' ?>>
                                    <div class="time-slot">
                                        <div class="time-input-group">
                                            <label class="form-label mb-0">Open:</label>
                                            <input type="time" 
                                                   class="form-control time-input" 
                                                   name="hours[<?= $hourType ?>][<?= $dayNum ?>][slot_1_open]"
                                                   value="<?= $dayData ? substr($dayData['slot_1_open'] ?? '', 0, 5) : '' ?>">
                                        </div>
                                        <div class="time-input-group">
                                            <label class="form-label mb-0">Close:</label>
                                            <input type="time" 
                                                   class="form-control time-input" 
                                                   name="hours[<?= $hourType ?>][<?= $dayNum ?>][slot_1_close]"
                                                   value="<?= $dayData ? substr($dayData['slot_1_close'] ?? '', 0, 5) : '' ?>">
                                        </div>
                                    </div>

                                    <div class="time-separator">
                                        <i class="fas fa-arrows-alt-h"></i>
                                    </div>

                                    <div class="time-slot">
                                        <div class="time-input-group">
                                            <label class="form-label mb-0">Reopen:</label>
                                            <input type="time" 
                                                   class="form-control time-input" 
                                                   name="hours[<?= $hourType ?>][<?= $dayNum ?>][slot_2_open]"
                                                   value="<?= $dayData ? substr($dayData['slot_2_open'] ?? '', 0, 5) : '' ?>">
                                        </div>
                                        <div class="time-input-group">
                                            <label class="form-label mb-0">Close:</label>
                                            <input type="time" 
                                                   class="form-control time-input" 
                                                   name="hours[<?= $hourType ?>][<?= $dayNum ?>][slot_2_close]"
                                                   value="<?= $dayData ? substr($dayData['slot_2_close'] ?? '', 0, 5) : '' ?>">
                                        </div>
                                        <div class="help-text">
                                            Optional: Use for split shifts (e.g., lunch break)
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endforeach; ?>

                <div class="action-buttons">
                    <a href="/business/dashboard" class="btn btn-secondary-custom">
                        <i class="fas fa-times"></i> Cancel
                    </a>
                    <button type="submit" class="btn btn-primary-custom">
                        <i class="fas fa-save"></i> Submit Hours for Approval
                    </button>
                </div>
            <?php endif; ?>
        </form>

        <!-- Holiday/Special Hours Notice -->
        <div class="hours-section">
            <h3 style="font-size: 1.2rem; font-weight: 600; color: #2d3748; margin-bottom: 1rem;">
                <i class="fas fa-calendar-alt" style="color: #667eea; margin-right: 0.5rem;"></i>
                Holiday & Special Hours
            </h3>
            <p style="color: #718096;">
                For temporary changes like holidays or special events, please contact the admin directly. 
                They can set up one-time exceptions that won't affect your regular schedule.
            </p>
            <p style="color: #718096; margin-bottom: 0;">
                <i class="fas fa-phone"></i> Admin Contact: (423) 555-0123 or 
                <a href="mailto:admin@ringgoldroad.com" style="color: #667eea;">admin@ringgoldroad.com</a>
            </p>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Toggle day hours when closed checkbox is changed
        function toggleDayHours(checkbox) {
            const daySchedule = checkbox.closest('.day-schedule');
            const timeSlots = daySchedule.querySelector('.time-slots');
            const timeInputs = daySchedule.querySelectorAll('input[type="time"]');
            
            if (checkbox.checked) {
                timeSlots.style.display = 'none';
                timeInputs.forEach(input => {
                    input.value = '';
                    input.required = false;
                });
            } else {
                timeSlots.style.display = 'grid';
                // Set default hours if empty
                const slot1Open = timeInputs[0];
                const slot1Close = timeInputs[1];
                if (!slot1Open.value && !slot1Close.value) {
                    slot1Open.value = '09:00';
                    slot1Close.value = '17:00';
                }
            }
        }

        // Quick action: Set standard weekday hours (9-5 Mon-Fri)
        function setWeekdayHours(hourType) {
            const schedules = document.querySelectorAll(`[data-hour-type="${hourType}"]`);
            
            schedules.forEach((schedule, index) => {
                const dayNum = index + 1;
                const closedCheckbox = schedule.querySelector('.closed-checkbox');
                const timeInputs = schedule.querySelectorAll('input[type="time"]');
                
                if (dayNum <= 5) { // Monday-Friday
                    closedCheckbox.checked = false;
                    toggleDayHours(closedCheckbox);
                    timeInputs[0].value = '09:00';
                    timeInputs[1].value = '17:00';
                    timeInputs[2].value = '';
                    timeInputs[3].value = '';
                } else { // Weekend
                    closedCheckbox.checked = true;
                    toggleDayHours(closedCheckbox);
                }
            });
        }

        // Quick action: Set weekends closed
        function setWeekendClosed(hourType) {
            const schedules = document.querySelectorAll(`[data-hour-type="${hourType}"]`);
            
            schedules.forEach((schedule, index) => {
                const dayNum = index + 1;
                if (dayNum >= 6) { // Saturday & Sunday
                    const closedCheckbox = schedule.querySelector('.closed-checkbox');
                    closedCheckbox.checked = true;
                    toggleDayHours(closedCheckbox);
                }
            });
        }

        // Quick action: Copy Monday's hours to all days
        function setSameAllWeek(hourType) {
            const schedules = document.querySelectorAll(`[data-hour-type="${hourType}"]`);
            const mondaySchedule = schedules[0];
            const mondayInputs = mondaySchedule.querySelectorAll('input[type="time"]');
            const mondayClosed = mondaySchedule.querySelector('.closed-checkbox').checked;
            
            schedules.forEach((schedule, index) => {
                if (index === 0) return; // Skip Monday
                
                const closedCheckbox = schedule.querySelector('.closed-checkbox');
                const timeInputs = schedule.querySelectorAll('input[type="time"]');
                
                closedCheckbox.checked = mondayClosed;
                toggleDayHours(closedCheckbox);
                
                if (!mondayClosed) {
                    timeInputs[0].value = mondayInputs[0].value;
                    timeInputs[1].value = mondayInputs[1].value;
                    timeInputs[2].value = mondayInputs[2].value;
                    timeInputs[3].value = mondayInputs[3].value;
                }
            });
        }

        // Form validation
        document.getElementById('hoursForm').addEventListener('submit', function(e) {
            let hasValidHours = false;
            const schedules = document.querySelectorAll('.day-schedule');
            
            schedules.forEach(schedule => {
                const closedCheckbox = schedule.querySelector('.closed-checkbox');
                if (!closedCheckbox.checked) {
                    const openTime = schedule.querySelector('input[name*="slot_1_open"]').value;
                    const closeTime = schedule.querySelector('input[name*="slot_1_close"]').value;
                    
                    if (openTime && closeTime) {
                        hasValidHours = true;
                    }
                }
            });
            
            if (!hasValidHours) {
                e.preventDefault();
                alert('Please set hours for at least one day, or mark all days as closed.');
                return false;
            }
            
            // Show loading state
            const submitBtn = e.target.querySelector('button[type="submit"]');
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Submitting...';
        });
    </script>
</body>
</html>