<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Business Profile - <?= esc($store['name'] ?? 'Your Business') ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: #f7fafc;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body.has-business-header {
            padding-top: 70px;
        }
        
        .profile-container {
            max-width: 1000px;
            margin: 0 auto;
            padding: 2rem;
        }
        
        .page-header {
            background: white;
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            border-left: 4px solid #667eea;
        }
        
        .page-title {
            font-size: 2rem;
            font-weight: 700;
            color: #2d3748;
            margin-bottom: 0.5rem;
        }
        
        .page-subtitle {
            color: #718096;
            font-size: 1.1rem;
        }
        
        .approval-notice {
            background: #f0f4ff;
            border: 1px solid #cbd5e0;
            border-radius: 12px;
            padding: 1.5rem;
            margin-bottom: 2rem;
            display: flex;
            align-items: start;
            gap: 1rem;
        }
        
        .approval-notice i {
            color: #667eea;
            font-size: 1.5rem;
            margin-top: 0.25rem;
        }
        
        .profile-section {
            background: white;
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }
        
        .section-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1.5rem;
            padding-bottom: 1rem;
            border-bottom: 2px solid #e9ecef;
        }
        
        .section-title {
            font-size: 1.3rem;
            font-weight: 600;
            color: #2d3748;
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }
        
        .section-description {
            color: #718096;
            font-size: 0.9rem;
            margin-bottom: 1.5rem;
            padding: 1rem;
            background: #f8f9fa;
            border-radius: 8px;
            border-left: 3px solid #667eea;
        }
        
        .form-label {
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 0.5rem;
        }
        
        .form-label.required::after {
            content: " *";
            color: #e53e3e;
        }
        
        .form-control {
            border: 2px solid #e2e8f0;
            border-radius: 8px;
            padding: 0.75rem 1rem;
            transition: all 0.3s ease;
        }
        
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }
        
        .input-group-text {
            background: #f7fafc;
            border: 2px solid #e2e8f0;
            border-right: none;
            color: #667eea;
            font-weight: 600;
        }
        
        .input-group .form-control {
            border-left: none;
        }
        
        .char-counter {
            font-size: 0.8rem;
            color: #718096;
            margin-top: 0.25rem;
        }
        
        .help-text {
            font-size: 0.875rem;
            color: #718096;
            margin-top: 0.25rem;
        }
        
        .btn-primary-custom {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 0.75rem 2rem;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .btn-primary-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.3);
            color: white;
        }
        
        .btn-secondary-custom {
            background: #f7fafc;
            color: #4a5568;
            border: 2px solid #e2e8f0;
            padding: 0.75rem 2rem;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .btn-secondary-custom:hover {
            background: #edf2f7;
            color: #4a5568;
            border-color: #cbd5e0;
        }
        
        .action-buttons {
            display: flex;
            gap: 1rem;
            justify-content: flex-end;
            margin-top: 2rem;
        }
        
        .alert-custom {
            border-radius: 12px;
            padding: 1rem 1.5rem;
            margin-bottom: 1.5rem;
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }
        
        .alert-success-custom {
            background: #f0fff4;
            border: 1px solid #9ae6b4;
            color: #276749;
        }
        
        .alert-danger-custom {
            background: #fff5f5;
            border: 1px solid #feb2b2;
            color: #742a2a;
        }
        
        .alert-warning-custom {
            background: #fffbeb;
            border: 1px solid #fbbf24;
            color: #92400e;
        }
        
        .social-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 1.5rem;
        }
        
        .social-icon {
            width: 20px;
            text-align: center;
        }
        
        @media (max-width: 768px) {
            .profile-container {
                padding: 1rem;
            }
            
            .profile-section {
                padding: 1.5rem;
            }
            
            .action-buttons {
                flex-direction: column;
            }
            
            .btn-primary-custom, .btn-secondary-custom {
                width: 100%;
                justify-content: center;
            }
            
            .social-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body class="has-business-header">
    <?php include(APPPATH . 'Views/business/partials/header.php'); ?>

    <div class="profile-container">
        <div class="page-header">
            <h1 class="page-title">Edit Business Profile</h1>
            <p class="page-subtitle">Update your business information to help customers find and connect with you</p>
        </div>

        <?php if (!empty($success)): ?>
        <div class="alert-custom alert-success-custom">
            <i class="fas fa-check-circle"></i>
            <?= esc($success) ?>
        </div>
        <?php endif; ?>

        <?php if (!empty($error)): ?>
        <div class="alert-custom alert-danger-custom">
            <i class="fas fa-exclamation-triangle"></i>
            <?= esc($error) ?>
        </div>
        <?php endif; ?>

        <?php if (!empty($validation)): ?>
        <div class="alert-custom alert-danger-custom">
            <i class="fas fa-exclamation-triangle"></i>
            <div>
                <strong>Please fix the following errors:</strong>
                <ul class="mb-0 mt-1">
                    <?php foreach ($validation as $error): ?>
                        <li><?= esc($error) ?></li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>
        <?php endif; ?>

        <?php if ($has_pending): ?>
        <div class="alert-custom alert-warning-custom">
            <i class="fas fa-clock"></i>
            <div>
                <strong>Pending Changes:</strong> You have changes awaiting admin approval. 
                <a href="/business/dashboard/change-requests" class="text-decoration-none fw-bold">View pending requests</a>
            </div>
        </div>
        <?php endif; ?>

        <div class="approval-notice">
            <i class="fas fa-info-circle"></i>
            <div>
                <h5 style="margin-bottom: 0.5rem; color: #2d3748;">Important: Admin Approval Required</h5>
                <ul class="mb-0" style="padding-left: 1.25rem;">
                    <li>All changes require admin approval before going live on your business listing</li>
                    <li>Your current information remains visible until changes are approved</li>
                    <li>You'll receive notification when your changes are reviewed</li>
                    <li>For urgent updates, contact admin directly</li>
                </ul>
            </div>
        </div>

        <form method="post" action="/business/profile/edit" id="profileForm">
            <?= csrf_field() ?>

            <!-- Basic Business Information -->
            <div class="profile-section">
                <div class="section-header">
                    <h2 class="section-title">
                        <i class="fas fa-building"></i>
                        Basic Information
                    </h2>
                </div>
                
                <div class="section-description">
                    <strong>Essential details</strong> that help customers identify and contact your business.
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="name" class="form-label required">Business Name</label>
                            <input type="text" 
                                   class="form-control" 
                                   id="name" 
                                   name="name" 
                                   value="<?= old('name', esc($store['name'] ?? '')) ?>" 
                                   required
                                   maxlength="255">
                            <div class="help-text">Your official business name as customers know it</div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="phone" class="form-label">Phone Number</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="fas fa-phone"></i></span>
                                <input type="tel" 
                                       class="form-control" 
                                       id="phone" 
                                       name="phone" 
                                       value="<?= old('phone', esc($store['phone'] ?? '')) ?>" 
                                       placeholder="(555) 123-4567"
                                       maxlength="20">
                            </div>
                            <div class="help-text">Main number customers should call</div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="email" class="form-label">Business Email</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="fas fa-envelope"></i></span>
                                <input type="email" 
                                       class="form-control" 
                                       id="email" 
                                       name="email" 
                                       value="<?= old('email', esc($store['email'] ?? '')) ?>" 
                                       placeholder="info@yourbusiness.com"
                                       maxlength="255">
                            </div>
                            <div class="help-text">Public email for customer inquiries</div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="website" class="form-label">Website</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="fas fa-globe"></i></span>
                                <input type="url" 
                                       class="form-control" 
                                       id="website" 
                                       name="website" 
                                       value="<?= old('website', esc($store['website'] ?? '')) ?>" 
                                       placeholder="https://www.yourbusiness.com"
                                       maxlength="255">
                            </div>
                            <div class="help-text">Your business website (include https://)</div>
                        </div>
                    </div>
                </div>

                <div class="mb-3">
                    <label for="description" class="form-label">Business Description</label>
                    <textarea class="form-control" 
                              id="description" 
                              name="description" 
                              rows="4" 
                              maxlength="1000" 
                              placeholder="Describe your business, services, and what makes you special..."><?= old('description', esc($store['description'] ?? '')) ?></textarea>
                    <div class="char-counter">
                        <span id="descriptionCount">0</span>/1000 characters
                    </div>
                    <div class="help-text">Help customers understand what you do and why they should choose you</div>
                </div>
            </div>

            <!-- Location Information -->
            <div class="profile-section">
                <div class="section-header">
                    <h2 class="section-title">
                        <i class="fas fa-map-marker-alt"></i>
                        Location
                    </h2>
                </div>
                
                <div class="section-description">
                    <strong>Your physical address</strong> helps customers find you and appears in search results.
                </div>

                <div class="mb-3">
                    <label for="address" class="form-label">Street Address</label>
                    <input type="text" 
                           class="form-control" 
                           id="address" 
                           name="address" 
                           value="<?= old('address', esc($store['address'] ?? '')) ?>" 
                           placeholder="123 Main Street"
                           maxlength="255">
                    <div class="help-text">Complete street address including suite/unit numbers</div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="city" class="form-label">City</label>
                            <input type="text" 
                                   class="form-control" 
                                   id="city" 
                                   name="city" 
                                   value="<?= old('city', esc($store['city'] ?? '')) ?>" 
                                   placeholder="Your City"
                                   maxlength="100">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="mb-3">
                            <label for="state" class="form-label">State</label>
                            <input type="text" 
                                   class="form-control" 
                                   id="state" 
                                   name="state" 
                                   value="<?= old('state', esc($store['state'] ?? '')) ?>" 
                                   placeholder="TN" 
                                   maxlength="2"
                                   style="text-transform: uppercase;">
                            <div class="help-text">2-letter state code</div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="mb-3">
                            <label for="postal_code" class="form-label">Zip Code</label>
                            <input type="text" 
                                   class="form-control" 
                                   id="postal_code" 
                                   name="postal_code" 
                                   value="<?= old('postal_code', esc($store['postal_code'] ?? '')) ?>" 
                                   placeholder="12345"
                                   maxlength="10">
                        </div>
                    </div>
                </div>
            </div>

            <!-- Social Media & Online Presence -->
            <div class="profile-section">
                <div class="section-header">
                    <h2 class="section-title">
                        <i class="fas fa-share-alt"></i>
                        Social Media & Online Presence
                    </h2>
                </div>
                
                <div class="section-description">
                    <strong>Connect your social accounts</strong> to help customers find and follow you online. Only add accounts you actively use.
                </div>

                <div class="social-grid">
                    <div class="mb-3">
                        <label for="facebook" class="form-label">
                            <i class="fab fa-facebook social-icon" style="color: #1877f2;"></i>
                            Facebook
                        </label>
                        <input type="url" 
                               class="form-control" 
                               id="facebook" 
                               name="facebook" 
                               value="<?= old('facebook', esc($store['facebook'] ?? '')) ?>" 
                               placeholder="https://facebook.com/yourbusiness"
                               maxlength="255">
                    </div>

                    <div class="mb-3">
                        <label for="instagram" class="form-label">
                            <i class="fab fa-instagram social-icon" style="color: #e4405f;"></i>
                            Instagram
                        </label>
                        <input type="url" 
                               class="form-control" 
                               id="instagram" 
                               name="instagram" 
                               value="<?= old('instagram', esc($store['instagram'] ?? '')) ?>" 
                               placeholder="https://instagram.com/yourbusiness"
                               maxlength="255">
                    </div>

                    <div class="mb-3">
                        <label for="x_twitter" class="form-label">
                            <i class="fab fa-x-twitter social-icon" style="color: #000000;"></i>
                            X (Twitter)
                        </label>
                        <input type="url" 
                               class="form-control" 
                               id="x_twitter" 
                               name="x_twitter" 
                               value="<?= old('x_twitter', esc($store['x_twitter'] ?? '')) ?>" 
                               placeholder="https://x.com/yourbusiness"
                               maxlength="255">
                    </div>

                    <div class="mb-3">
                        <label for="linkedin" class="form-label">
                            <i class="fab fa-linkedin social-icon" style="color: #0a66c2;"></i>
                            LinkedIn
                        </label>
                        <input type="url" 
                               class="form-control" 
                               id="linkedin" 
                               name="linkedin" 
                               value="<?= old('linkedin', esc($store['linkedin'] ?? '')) ?>" 
                               placeholder="https://linkedin.com/company/yourbusiness"
                               maxlength="255">
                    </div>

                    <div class="mb-3">
                        <label for="youtube" class="form-label">
                            <i class="fab fa-youtube social-icon" style="color: #ff0000;"></i>
                            YouTube
                        </label>
                        <input type="url" 
                               class="form-control" 
                               id="youtube" 
                               name="youtube" 
                               value="<?= old('youtube', esc($store['youtube'] ?? '')) ?>" 
                               placeholder="https://youtube.com/@yourbusiness"
                               maxlength="255">
                    </div>

                    <div class="mb-3">
                        <label for="tiktok" class="form-label">
                            <i class="fab fa-tiktok social-icon" style="color: #000000;"></i>
                            TikTok
                        </label>
                        <input type="url" 
                               class="form-control" 
                               id="tiktok" 
                               name="tiktok" 
                               value="<?= old('tiktok', esc($store['tiktok'] ?? '')) ?>" 
                               placeholder="https://tiktok.com/@yourbusiness"
                               maxlength="255">
                    </div>

                    <div class="mb-3">
                        <label for="snapchat" class="form-label">
                            <i class="fab fa-snapchat social-icon" style="color: #fffc00;"></i>
                            Snapchat
                        </label>
                        <input type="url" 
                               class="form-control" 
                               id="snapchat" 
                               name="snapchat" 
                               value="<?= old('snapchat', esc($store['snapchat'] ?? '')) ?>" 
                               placeholder="https://snapchat.com/add/yourbusiness"
                               maxlength="255">
                    </div>

                    <div class="mb-3">
                        <label for="nextdoor" class="form-label">
                            <i class="fas fa-home social-icon" style="color: #00b246;"></i>
                            Nextdoor
                        </label>
                        <input type="url" 
                               class="form-control" 
                               id="nextdoor" 
                               name="nextdoor" 
                               value="<?= old('nextdoor', esc($store['nextdoor'] ?? '')) ?>" 
                               placeholder="https://nextdoor.com/pages/yourbusiness"
                               maxlength="255">
                    </div>
                </div>
            </div>

            <!-- Directory Listings -->
            <div class="profile-section">
                <div class="section-header">
                    <h2 class="section-title">
                        <i class="fas fa-star"></i>
                        Directory Listings
                    </h2>
                </div>
                
                <div class="section-description">
                    <strong>Link to your profiles</strong> on major business directories to help customers find reviews and additional information.
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="google_business" class="form-label">
                                <i class="fab fa-google social-icon" style="color: #4285f4;"></i>
                                Google Business
                            </label>
                            <input type="url" 
                                   class="form-control" 
                                   id="google_business" 
                                   name="google_business" 
                                   value="<?= old('google_business', esc($store['google_business'] ?? '')) ?>" 
                                   placeholder="https://g.page/yourbusiness"
                                   maxlength="255">
                            <div class="help-text">Your Google My Business profile link</div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="yelp" class="form-label">
                                <i class="fab fa-yelp social-icon" style="color: #d32323;"></i>
                                Yelp
                            </label>
                            <input type="url" 
                                   class="form-control" 
                                   id="yelp" 
                                   name="yelp" 
                                   value="<?= old('yelp', esc($store['yelp'] ?? '')) ?>" 
                                   placeholder="https://yelp.com/biz/yourbusiness"
                                   maxlength="255">
                            <div class="help-text">Your Yelp business page</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Video Content -->
            <div class="profile-section">
                <div class="section-header">
                    <h2 class="section-title">
                        <i class="fas fa-video"></i>
                        Welcome Video
                    </h2>
                </div>
                
                <div class="section-description">
                    <strong>Add a Vimeo video</strong> to welcome customers and showcase your business. Enter only the video ID number (e.g., "123456789").
                </div>

                <div class="mb-3">
                    <label for="additional_info" class="form-label">Vimeo Video ID</label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="fab fa-vimeo-v"></i></span>
                        <input type="text" 
                               class="form-control" 
                               id="additional_info" 
                               name="additional_info" 
                               value="<?= old('additional_info', esc($store['additional_info'] ?? '')) ?>" 
                               placeholder="123456789"
                               maxlength="500">
                    </div>
                    <div class="help-text">
                        You can enter either:
                        <br>• Just the video ID: <strong>123456789</strong>
                        <br>• Or the full Vimeo URL: <strong>https://vimeo.com/123456789</strong>
                        <br>The system will automatically extract the ID from either format.
                    </div>
                </div>
            </div>

            <div class="action-buttons">
                <a href="/business/dashboard" class="btn btn-secondary-custom">
                    <i class="fas fa-times"></i> Cancel
                </a>
                <button type="submit" class="btn btn-primary-custom" id="submitBtn">
                    <i class="fas fa-paper-plane"></i> Submit for Approval
                </button>
            </div>
        </form>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Character counter for description
        const descriptionTextarea = document.getElementById('description');
        const descriptionCounter = document.getElementById('descriptionCount');
        
        function updateDescriptionCounter() {
            const count = descriptionTextarea.value.length;
            descriptionCounter.textContent = count;
            
            if (count > 900) {
                descriptionCounter.style.color = '#e53e3e';
            } else if (count > 750) {
                descriptionCounter.style.color = '#dd6b20';
            } else {
                descriptionCounter.style.color = '#718096';
            }
        }
        
        descriptionTextarea.addEventListener('input', updateDescriptionCounter);
        updateDescriptionCounter(); // Initialize counter
        
        // Auto-uppercase state field
        document.getElementById('state').addEventListener('input', function(e) {
            e.target.value = e.target.value.toUpperCase();
        });
        
        // Form submission handling
        document.getElementById('profileForm').addEventListener('submit', function(e) {
            const submitBtn = document.getElementById('submitBtn');
            
            // Show loading state
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Submitting...';
            
            // Re-enable after a delay in case of validation errors
            setTimeout(() => {
                submitBtn.disabled = false;
                submitBtn.innerHTML = '<i class="fas fa-paper-plane"></i> Submit for Approval';
            }, 5000);
        });
        
        // URL field helpers - add https:// if missing
        const urlFields = ['website', 'facebook', 'instagram', 'x_twitter', 'linkedin', 'youtube', 'tiktok', 'snapchat', 'google_business', 'yelp', 'nextdoor'];
        
        urlFields.forEach(fieldName => {
            const field = document.getElementById(fieldName);
            if (field) {
                field.addEventListener('blur', function() {
                    let value = this.value.trim();
                    if (value && !value.match(/^https?:\/\//)) {
                        this.value = 'https://' + value;
                    }
                });
            }
        });
    </script>
</body>
</html>