<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= esc($title) ?> - Business Portal</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            min-height: 100vh;
            padding-top: 20px;
        }
        
        .onboarding-container {
            max-width: 900px;
            margin: 0 auto;
            padding: 2rem;
        }
        
        .onboarding-header {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            text-align: center;
        }
        
        .step-indicator {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 1rem;
            margin-bottom: 2rem;
        }
        
        .step-circle {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 700;
            font-size: 1.1rem;
            position: relative;
        }
        
        .step-circle.completed {
            background: #059669;
            color: white;
        }
        
        .step-connector.completed {
            width: 60px;
            height: 3px;
            background: #10b981;
            border-radius: 2px;
        }
        
        .page-title {
            font-size: 2rem;
            font-weight: 700;
            color: #1f2937;
            margin-bottom: 0.5rem;
        }
        
        .page-subtitle {
            color: #6b7280;
            font-size: 1.1rem;
            margin-bottom: 0;
        }
        
        .form-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 2.5rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }
        
        .friendly-description {
            background: #f0fdf4;
            border: 1px solid #bbf7d0;
            border-radius: 12px;
            padding: 1.25rem;
            margin-bottom: 2rem;
            color: #14532d;
        }
        
        .friendly-description h5 {
            color: #15803d;
            font-weight: 600;
            margin-bottom: 0.75rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .completion-option {
            border: 2px solid #e5e7eb;
            border-radius: 12px;
            padding: 1.5rem;
            margin-bottom: 1.5rem;
            cursor: pointer;
            transition: all 0.3s ease;
            background: white;
            text-decoration: none;
            color: inherit;
            display: block;
        }
        
        .completion-option:hover {
            border-color: #10b981;
            background: #f0fdf4;
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(16, 185, 129, 0.15);
            text-decoration: none;
            color: inherit;
        }
        
        .option-header {
            display: flex;
            align-items: center;
            gap: 1rem;
            margin-bottom: 0.75rem;
        }
        
        .option-icon {
            width: 50px;
            height: 50px;
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
        }
        
        .option-title {
            font-size: 1.2rem;
            font-weight: 700;
            color: #1f2937;
        }
        
        .option-description {
            color: #6b7280;
            margin-bottom: 0;
            line-height: 1.5;
        }
        
        .completion-callout {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 12px;
            padding: 1.5rem;
            margin-top: 2rem;
            text-align: center;
        }
        
        .completion-callout h4 {
            color: white;
            font-weight: 700;
            margin-bottom: 0.5rem;
        }
        
        .completion-callout p {
            opacity: 0.9;
            margin-bottom: 0;
        }
        
        .alert {
            border-radius: 12px;
            padding: 1rem 1.5rem;
            margin-bottom: 1.5rem;
            border: none;
        }
        
        .alert-success {
            background: #f0fdf4;
            border-left: 4px solid #10b981;
            color: #14532d;
        }
        
        .alert-danger {
            background: #fef2f2;
            border-left: 4px solid #ef4444;
            color: #991b1b;
        }
        
        @media (max-width: 768px) {
            .onboarding-container {
                padding: 1rem;
            }
            
            .form-card {
                padding: 1.5rem;
            }
        }
    </style>
</head>
<body>
    <div class="onboarding-container">
        <!-- Header with Progress -->
        <div class="onboarding-header">
            <div class="step-indicator">
                <div class="step-circle completed">
                    <i class="fas fa-check"></i>
                </div>
                <div class="step-connector completed"></div>
                <div class="step-circle completed">
                    <i class="fas fa-check"></i>
                </div>
                <div class="step-connector completed"></div>
                <div class="step-circle completed">
                    <i class="fas fa-check"></i>
                </div>
            </div>
            
            <h1 class="page-title">Congratulations! Setup Complete</h1>
            <p class="page-subtitle">Your business profile is now live and ready for customers to find</p>
        </div>

        <!-- Flash Messages -->
        <?php if (session()->getFlashdata('success')): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle me-2"></i>
                <?= session()->getFlashdata('success') ?>
            </div>
        <?php endif; ?>

        <?php if (session()->getFlashdata('error')): ?>
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-circle me-2"></i>
                <?= session()->getFlashdata('error') ?>
            </div>
        <?php endif; ?>

        <div class="form-card">
            <!-- Completion Summary -->
            <div class="friendly-description">
                <h5><i class="fas fa-check-circle"></i> Your Business Profile is Live!</h5>
                <p class="mb-0">
                    You've successfully completed the setup process. Your business information is now entered, or updated. Here's what you can do next:
                </p>
            </div>

            <!-- Three Options -->
            <div class="completion-options">
                <!-- Option 1: Job Center -->
                <a href="/business/jobs" class="completion-option">
                    <div class="option-header">
                        <div class="option-icon">
                            <i class="fas fa-briefcase"></i>
                        </div>
                        <div class="option-title">Visit Job Center</div>
                    </div>
                    <div class="option-description">
                        Post job openings to find local talent and help your business grow. Reach qualified candidates in your area.
                    </div>
                </a>

                <!-- Option 2: Dashboard -->
                <a href="/business/dashboard" class="completion-option">
                    <div class="option-header">
                        <div class="option-icon">
                            <i class="fas fa-tachometer-alt"></i>
                        </div>
                        <div class="option-title">Go to Dashboard</div>
                    </div>
                    <div class="option-description">
                        Manage your business profile, update hours, create promotions, and access all your business tools.
                    </div>
                </a>

                <!-- Option 3: Live Preview -->
                <a href="/" target="_blank" class="completion-option">
    <div class="option-header">
        <div class="option-icon">
            <i class="fas fa-home"></i>
        </div>
        <div class="option-title">Return to Main Site</div>
    </div>
    <div class="option-description">
        Return HOME to see updates and more local business discovery!
    </div>
</a>
            </div>

            <div class="completion-callout">
                <h4><i class="fas fa-star"></i> What You've Accomplished</h4>
                <p>✓ Business profile created &nbsp; ✓ Hours configured &nbsp; ✓ Ready for customers</p>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>