<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Messages - Follow-Up <?= esc($case['case_number']) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: #f7fafc;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body.has-business-header {
            padding-top: 70px;
        }
        
        .messaging-container {
            max-width: 1000px;
            margin: 0 auto;
            padding: 2rem;
            height: calc(100vh - 110px);
            display: flex;
            flex-direction: column;
        }
        
        .case-header {
            background: white;
            border-radius: 16px 16px 0 0;
            padding: 1.5rem 2rem;
            border-bottom: 2px solid #f1f3f4;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }
        
        .case-header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .case-info h4 {
            font-size: 1.3rem;
            font-weight: 700;
            color: #fd7e14;
            font-family: 'Courier New', monospace;
            margin-bottom: 0.5rem;
        }
        
        .case-info p {
            margin: 0;
            color: #6b7280;
        }
        
        .case-status {
            display: flex;
            align-items: center;
            gap: 1rem;
        }
        
        .status-badge {
            padding: 0.5rem 1rem;
            border-radius: 8px;
            font-size: 0.875rem;
            font-weight: 600;
            text-transform: uppercase;
        }
        
        .status-badge.open {
            background: #fef3c7;
            color: #92400e;
        }
        
        .status-badge.in-progress {
            background: #dbeafe;
            color: #1e40af;
        }
        
        .status-badge.resolved {
            background: #d4f1e4;
            color: #276749;
        }
        
        .status-badge.closed {
            background: #f3f4f6;
            color: #4b5563;
        }
        
        .back-link {
            color: #fd7e14;
            text-decoration: none;
            font-weight: 600;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .back-link:hover {
            color: #e55a00;
            text-decoration: none;
        }
        
        .messages-section {
            background: white;
            flex: 1;
            display: flex;
            flex-direction: column;
            min-height: 0;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }
        
        .messages-header {
            padding: 1rem 2rem;
            border-bottom: 1px solid #e5e7eb;
            background: #f9fafb;
        }
        
        .messages-header h5 {
            margin: 0;
            color: #374151;
            font-weight: 600;
        }
        
        .messages-container {
            flex: 1;
            overflow-y: auto;
            padding: 1rem 2rem;
            background: #fafafa;
            background-image: radial-gradient(circle at 1px 1px, rgba(0,0,0,0.03) 1px, transparent 0);
            background-size: 20px 20px;
        }
        
        .message-group {
            margin-bottom: 2rem;
        }
        
        .message-group.business {
            text-align: right;
        }
        
        .message-group.customer {
            text-align: left;
        }
        
        .message-group.system {
            text-align: center;
        }
        
        .message-bubble {
            display: inline-block;
            max-width: 70%;
            padding: 1rem 1.25rem;
            border-radius: 18px;
            margin-bottom: 0.5rem;
            position: relative;
            word-wrap: break-word;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        
        .message-group.business .message-bubble {
            background: linear-gradient(135deg, #fd7e14 0%, #e55a00 100%);
            color: white;
            border-bottom-right-radius: 6px;
        }
        
        .message-group.customer .message-bubble {
            background: white;
            color: #374151;
            border: 1px solid #e5e7eb;
            border-bottom-left-radius: 6px;
        }
        
        .message-group.system .message-bubble {
            background: #f3f4f6;
            color: #6b7280;
            font-style: italic;
            font-size: 0.875rem;
            border-radius: 12px;
            max-width: 80%;
        }
        
        .message-content {
            line-height: 1.5;
            margin-bottom: 0.5rem;
        }
        
        .message-time {
            font-size: 0.75rem;
            opacity: 0.8;
            display: block;
        }
        
        .message-group.business .message-time {
            color: rgba(255, 255, 255, 0.9);
        }
        
        .message-group.customer .message-time {
            color: #9ca3af;
        }
        
        .message-group.system .message-time {
            color: #6b7280;
        }
        
        .sender-avatar {
            width: 32px;
            height: 32px;
            border-radius: 50%;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            font-size: 0.875rem;
            font-weight: 600;
            margin-bottom: 0.5rem;
        }
        
        .message-group.business .sender-avatar {
            background: #e55a00;
            color: white;
            float: right;
            margin-left: 0.75rem;
        }
        
        .message-group.customer .sender-avatar {
            background: #e5e7eb;
            color: #374151;
            float: left;
            margin-right: 0.75rem;
        }
        
        .typing-indicator {
            display: none;
            text-align: left;
            margin-bottom: 1rem;
        }
        
        .typing-bubble {
            background: white;
            border: 1px solid #e5e7eb;
            border-radius: 18px;
            border-bottom-left-radius: 6px;
            padding: 1rem 1.25rem;
            display: inline-block;
            max-width: 100px;
        }
        
        .typing-dots {
            display: flex;
            gap: 4px;
            align-items: center;
        }
        
        .typing-dot {
            width: 8px;
            height: 8px;
            border-radius: 50%;
            background: #9ca3af;
            animation: typingAnimation 1.4s infinite ease-in-out;
        }
        
        .typing-dot:nth-child(2) {
            animation-delay: 0.2s;
        }
        
        .typing-dot:nth-child(3) {
            animation-delay: 0.4s;
        }
        
        @keyframes typingAnimation {
            0%, 60%, 100% {
                transform: translateY(0);
                opacity: 0.4;
            }
            30% {
                transform: translateY(-10px);
                opacity: 1;
            }
        }
        
        .message-input-section {
            background: white;
            border-top: 1px solid #e5e7eb;
            padding: 1.5rem 2rem;
            border-radius: 0 0 16px 16px;
        }
        
        .message-input-disabled {
            background: #f9fafb;
            text-align: center;
            padding: 2rem;
            color: #6b7280;
        }
        
        .input-form {
            display: flex;
            gap: 1rem;
            align-items: flex-end;
        }
        
        .input-wrapper {
            flex: 1;
            position: relative;
        }
        
        .message-input {
            width: 100%;
            border: 2px solid #e5e7eb;
            border-radius: 24px;
            padding: 0.75rem 1rem;
            resize: none;
            outline: none;
            transition: all 0.3s ease;
            font-family: inherit;
            font-size: 0.875rem;
            line-height: 1.4;
            max-height: 120px;
            min-height: 44px;
        }
        
        .message-input:focus {
            border-color: #fd7e14;
            box-shadow: 0 0 0 3px rgba(253, 126, 20, 0.1);
        }
        
        .char-counter {
            position: absolute;
            bottom: -20px;
            right: 12px;
            font-size: 0.75rem;
            color: #9ca3af;
        }
        
        .send-button {
            background: #fd7e14;
            color: white;
            border: none;
            border-radius: 50%;
            width: 44px;
            height: 44px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: all 0.3s ease;
            flex-shrink: 0;
        }
        
        .send-button:hover:not(:disabled) {
            background: #e55a00;
            transform: scale(1.05);
        }
        
        .send-button:disabled {
            background: #d1d5db;
            cursor: not-allowed;
            transform: none;
        }
        
        .quick-actions {
            display: flex;
            gap: 0.5rem;
            margin-bottom: 1rem;
            flex-wrap: wrap;
        }
        
        .quick-action-btn {
            background: #f3f4f6;
            color: #4b5563;
            border: 1px solid #d1d5db;
            padding: 0.5rem 1rem;
            border-radius: 20px;
            font-size: 0.75rem;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .quick-action-btn:hover {
            background: #e5e7eb;
            border-color: #9ca3af;
        }
        
        .status-actions {
            display: flex;
            gap: 1rem;
            margin-top: 1rem;
            flex-wrap: wrap;
        }
        
        .status-btn {
            padding: 0.5rem 1rem;
            border: none;
            border-radius: 6px;
            font-size: 0.875rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .status-btn.mark-progress {
            background: #dbeafe;
            color: #1e40af;
        }
        
        .status-btn.mark-resolved {
            background: #d4f1e4;
            color: #276749;
        }
        
        .status-btn.mark-closed {
            background: #f3f4f6;
            color: #4b5563;
        }
        
        .status-btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        
        .message-date-separator {
            text-align: center;
            margin: 2rem 0 1rem;
            position: relative;
        }
        
        .date-separator-line {
            height: 1px;
            background: #e5e7eb;
            position: relative;
        }
        
        .date-separator-text {
            background: #fafafa;
            color: #6b7280;
            padding: 0.5rem 1rem;
            font-size: 0.75rem;
            font-weight: 600;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
        }
        
        .scroll-to-bottom {
            position: fixed;
            bottom: 160px;
            right: 50px;
            background: #fd7e14;
            color: white;
            border: none;
            border-radius: 50%;
            width: 48px;
            height: 48px;
            display: none;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            box-shadow: 0 4px 12px rgba(253, 126, 20, 0.3);
            transition: all 0.3s ease;
        }
        
        .scroll-to-bottom:hover {
            transform: scale(1.1);
        }
        
        .unread-indicator {
            background: #dc3545;
            color: white;
            border-radius: 12px;
            padding: 0.25rem 0.5rem;
            font-size: 0.7rem;
            font-weight: 600;
            position: absolute;
            top: -8px;
            right: -8px;
        }
        
        @media (max-width: 768px) {
            .messaging-container {
                padding: 1rem;
                height: calc(100vh - 90px);
            }
            
            .case-header {
                padding: 1rem;
            }
            
            .case-header-content {
                flex-direction: column;
                align-items: flex-start;
                gap: 1rem;
            }
            
            .messages-container {
                padding: 1rem;
            }
            
            .message-input-section {
                padding: 1rem;
            }
            
            .message-bubble {
                max-width: 85%;
            }
            
            .quick-actions {
                justify-content: center;
            }
            
            .status-actions {
                justify-content: center;
            }
            
            .scroll-to-bottom {
                bottom: 140px;
                right: 20px;
            }
        }
    </style>
</head>
<body class="has-business-header">
    <?php include(APPPATH . 'Views/business/partials/header.php'); ?>

    <div class="messaging-container">
        <!-- Case Header -->
        <div class="case-header">
            <div class="case-header-content">
                <div class="case-info">
                    <h4><?= esc($case['case_number']) ?></h4>
                    <p>
                        <a href="/business/feedback/case/<?= $case['case_id'] ?>" class="back-link">
                            <i class="fas fa-arrow-left"></i> Back to Follow-Up Details
                        </a>
                    </p>
                </div>
                <div class="case-status">
                    <div class="status-badge <?= $case['status'] ?>">
                        <?= ucfirst(str_replace('_', ' ', $case['status'])) ?>
                    </div>
                    <div>
                        <strong><?= esc($case['customer_name'] ?: 'Anonymous Customer') ?></strong><br>
                        <small class="text-muted"><?= $case['created_at_formatted'] ?></small>
                    </div>
                </div>
            </div>
        </div>

        <!-- Messages Section -->
        <div class="messages-section">
            <div class="messages-header">
                <h5>
                    <i class="fas fa-comments me-2"></i>
                    Conversation
                    <?php if ($unread_count > 0): ?>
                        <span class="unread-indicator"><?= $unread_count ?> new</span>
                    <?php endif; ?>
                </h5>
            </div>

            <div class="messages-container" id="messagesContainer">
                <?php if (empty($messages)): ?>
                    <div class="message-group system">
                        <div class="message-bubble">
                            <div class="message-content">
                                This conversation was started when the customer submitted their feedback. 
                                Send your first message to begin resolving their concern.
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <?php 
                    $currentDate = null;
                    foreach ($messages as $message): 
                        $messageDate = date('Y-m-d', strtotime($message['created_at']));
                        
                        // Show date separator for new days
                        if ($currentDate !== $messageDate):
                            $currentDate = $messageDate;
                    ?>
                        <div class="message-date-separator">
                            <div class="date-separator-line">
                                <span class="date-separator-text">
                                    <?= date('F j, Y', strtotime($message['created_at'])) ?>
                                </span>
                            </div>
                        </div>
                    <?php endif; ?>

                    <div class="message-group <?= $message['sender_type'] ?>" data-message-id="<?= $message['message_id'] ?>">
                        <?php if ($message['sender_type'] !== 'system'): ?>
                            <div class="sender-avatar">
                                <?php if ($message['sender_type'] === 'business'): ?>
                                    <i class="fas fa-user-tie"></i>
                                <?php else: ?>
                                    <i class="fas fa-user"></i>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                        
                        <div class="message-bubble">
                            <div class="message-content">
                                <?= nl2br(esc($message['message'])) ?>
                            </div>
                            <div class="message-time">
                                <?= $message['created_at_formatted'] ?>
                                <?php if ($message['sender_type'] === 'business'): ?>
                                    <i class="fas fa-check ms-1" title="Sent"></i>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                <?php endif; ?>

                <!-- Typing Indicator -->
                <div class="typing-indicator" id="typingIndicator">
                    <div class="sender-avatar">
                        <i class="fas fa-user"></i>
                    </div>
                    <div class="typing-bubble">
                        <div class="typing-dots">
                            <div class="typing-dot"></div>
                            <div class="typing-dot"></div>
                            <div class="typing-dot"></div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Message Input -->
            <?php if ($case['status'] !== 'closed'): ?>
                <div class="message-input-section">
                    <!-- Quick Actions -->
                    <div class="quick-actions">
                        <button type="button" class="quick-action-btn" onclick="insertQuickResponse('acknowledge')">
                            Thank you for following up
                        </button>
                        <button type="button" class="quick-action-btn" onclick="insertQuickResponse('investigating')">
                            I'm looking into this
                        </button>
                        <button type="button" class="quick-action-btn" onclick="insertQuickResponse('resolved')">
                            This should be resolved now
                        </button>
                        <button type="button" class="quick-action-btn" onclick="insertQuickResponse('followup')">
                            How are things now?
                        </button>
                    </div>

                    <form id="messageForm" class="input-form">
                        <div class="input-wrapper">
                            <textarea 
                                class="message-input" 
                                id="messageInput" 
                                placeholder="Type your message..."
                                maxlength="2000"
                                rows="1"></textarea>
                            <div class="char-counter">
                                <span id="charCount">0</span>/2000
                            </div>
                        </div>
                        <button type="submit" class="send-button" id="sendButton" disabled>
                            <i class="fas fa-paper-plane"></i>
                        </button>
                    </form>

                    <!-- Status Actions -->
                    <div class="status-actions">
                        <?php if ($case['status'] === 'open'): ?>
                            <button type="button" class="status-btn mark-progress" onclick="updateCaseStatus('in_progress')">
                                <i class="fas fa-play me-1"></i> Mark In Progress
                            </button>
                        <?php endif; ?>
                        
                        <?php if ($case['status'] === 'in_progress'): ?>
                            <button type="button" class="status-btn mark-resolved" onclick="updateCaseStatus('resolved')">
                                <i class="fas fa-check me-1"></i> Mark Resolved
                            </button>
                        <?php endif; ?>
                        
                        <?php if ($case['status'] === 'resolved'): ?>
                            <button type="button" class="status-btn mark-closed" onclick="updateCaseStatus('closed')">
                                <i class="fas fa-times-circle me-1"></i> Please Close Follow-Up
                            </button>
                        <?php endif; ?>
                    </div>
                </div>
            <?php else: ?>
                <div class="message-input-disabled">
                    <i class="fas fa-lock me-2"></i>
                    This follow-up has been closed. No further messages can be sent.
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Scroll to Bottom Button -->
    <button class="scroll-to-bottom" id="scrollToBottom">
        <i class="fas fa-arrow-down"></i>
    </button>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        const caseId = '<?= $case['case_id'] ?>';
        const messagesContainer = document.getElementById('messagesContainer');
        const messageInput = document.getElementById('messageInput');
        const charCount = document.getElementById('charCount');
        const sendButton = document.getElementById('sendButton');
        const scrollToBottomBtn = document.getElementById('scrollToBottom');
        
        let lastMessageId = <?= !empty($messages) ? end($messages)['message_id'] : 0 ?>;
        let isAtBottom = true;
        let typingTimeout;

        // Auto-resize textarea
        messageInput.addEventListener('input', function() {
            this.style.height = 'auto';
            this.style.height = Math.min(this.scrollHeight, 120) + 'px';
            
            // Update character count
            const count = this.value.length;
            charCount.textContent = count;
            
            // Enable/disable send button
            sendButton.disabled = count === 0 || count > 2000;
            
            // Character count color
            if (count > 1800) {
                charCount.style.color = '#dc3545';
            } else if (count > 1500) {
                charCount.style.color = '#f59e0b';
            } else {
                charCount.style.color = '#9ca3af';
            }
        });

        // Send message on Enter (Shift+Enter for new line)
        messageInput.addEventListener('keydown', function(e) {
            if (e.key === 'Enter' && !e.shiftKey) {
                e.preventDefault();
                document.getElementById('messageForm').dispatchEvent(new Event('submit'));
            }
        });

        // Handle form submission
        document.getElementById('messageForm').addEventListener('submit', function(e) {
            e.preventDefault();
            sendMessage();
        });

        // Send message function
        function sendMessage() {
            const message = messageInput.value.trim();
            if (!message || message.length > 2000) return;

            const formData = new FormData();
            formData.append('case_id', caseId);
            formData.append('message', message);
            formData.append('csrf_token', '<?= csrf_hash() ?>');

            // Disable input while sending
            messageInput.disabled = true;
            sendButton.disabled = true;
            sendButton.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';

            fetch('/business/feedback/send-message', {
                method: 'POST',
                body: formData,
                headers: {
                    'X-Requested-With': 'XMLHttpRequest'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Add message to UI immediately for better UX
                    addMessageToUI({
                        message_id: data.message_id,
                        message: message,
                        sender_type: 'business',
                        created_at_formatted: 'Just now'
                    });
                    
                    // Clear input
                    messageInput.value = '';
                    messageInput.style.height = 'auto';
                    charCount.textContent = '0';
                    
                    // Scroll to bottom
                    scrollToBottom();
                    
                    // Update last message ID
                    lastMessageId = data.message_id;
                } else {
                    alert('Failed to send message: ' + (data.message || 'Unknown error'));
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Failed to send message. Please try again.');
            })
            .finally(() => {
                // Re-enable input
                messageInput.disabled = false;
                sendButton.disabled = false;
                sendButton.innerHTML = '<i class="fas fa-paper-plane"></i>';
                messageInput.focus();
            });
        }

        // Add message to UI
        function addMessageToUI(message) {
            const messageGroup = document.createElement('div');
            messageGroup.className = `message-group ${message.sender_type}`;
            messageGroup.setAttribute('data-message-id', message.message_id);
            
            messageGroup.innerHTML = `
                <div class="sender-avatar">
                    <i class="fas fa-user-tie"></i>
                </div>
                <div class="message-bubble">
                    <div class="message-content">${message.message.replace(/\n/g, '<br>')}</div>
                    <div class="message-time">
                        ${message.created_at_formatted}
                        <i class="fas fa-check ms-1" title="Sent"></i>
                    </div>
                </div>
            `;
            
            messagesContainer.appendChild(messageGroup);
        }

        // Quick response insertion
        function insertQuickResponse(type) {
            const responses = {
                'acknowledge': 'Thank you for following up on this. ',
                'investigating': 'I\'m looking into this issue and will get back to you shortly. ',
                'resolved': 'This issue should be resolved now. Please let me know if you\'re still experiencing any problems. ',
                'followup': 'How are things going now? Has this been resolved to your satisfaction? '
            };
            
            if (responses[type]) {
                const currentValue = messageInput.value;
                const newValue = currentValue ? currentValue + ' ' + responses[type] : responses[type];
                messageInput.value = newValue;
                messageInput.dispatchEvent(new Event('input'));
                messageInput.focus();
            }
        }

        // Scroll to bottom
        function scrollToBottom() {
            messagesContainer.scrollTop = messagesContainer.scrollHeight;
        }

        // Handle scroll events
        messagesContainer.addEventListener('scroll', function() {
            const { scrollTop, scrollHeight, clientHeight } = this;
            isAtBottom = scrollTop + clientHeight >= scrollHeight - 50;
            
            // Show/hide scroll to bottom button
            if (isAtBottom) {
                scrollToBottomBtn.style.display = 'none';
            } else {
                scrollToBottomBtn.style.display = 'flex';
            }
        });

        // Scroll to bottom button click
        scrollToBottomBtn.addEventListener('click', scrollToBottom);

        // Update case status
        function updateCaseStatus(status) {
            const statusTexts = {
                'in_progress': 'Mark this follow-up as in progress?',
                'resolved': 'Mark this follow-up as resolved?',
                'closed': 'Close this follow-up permanently? This action cannot be undone.'
            };
            
            if (confirm(statusTexts[status])) {
                fetch('/business/feedback/update-case-status', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    body: JSON.stringify({
                        case_id: caseId,
                        status: status,
                        csrf_token: '<?= csrf_hash() ?>'
                    })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        location.reload();
                    } else {
                        alert(data.message || 'Failed to update case status');
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('An error occurred while updating the case');
                });
            }
        }

        // Poll for new messages
        function pollForNewMessages() {
            fetch(`/business/feedback/poll-messages/${caseId}?last_id=${lastMessageId}`, {
                headers: {
                    'X-Requested-With': 'XMLHttpRequest'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success && data.messages.length > 0) {
                    data.messages.forEach(message => {
                        if (message.sender_type === 'customer') {
                            addMessageToUI(message);
                            lastMessageId = Math.max(lastMessageId, message.message_id);
                        }
                    });
                    
                    // Auto-scroll if user is at bottom
                    if (isAtBottom) {
                        scrollToBottom();
                    }
                }
            })
            .catch(error => {
                console.error('Polling error:', error);
            });
        }

        // Initialize page
        document.addEventListener('DOMContentLoaded', function() {
            // Scroll to bottom initially
            scrollToBottom();
            
            // Focus message input
            messageInput.focus();
            
            // Start polling for new messages every 5 seconds
            setInterval(pollForNewMessages, 5000);
            
            // Mark messages as read
            fetch('/business/feedback/mark-messages-read', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-Requested-With': 'XMLHttpRequest'
                },
                body: JSON.stringify({
                    case_id: caseId,
                    csrf_token: '<?= csrf_hash() ?>'
                })
            });
        });
    </script>
</body>
</html>