<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Unresponded Customer Cases - Action Required</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; margin: 0; padding: 0; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: linear-gradient(135deg, #fbbf24 0%, #f59e0b 100%); color: #92400e; padding: 20px; border-radius: 8px 8px 0 0; }
        .content { background: #fffbeb; padding: 20px; border-radius: 0 0 8px 8px; border: 1px solid #fbbf24; }
        .case-item { background: white; border-radius: 6px; padding: 15px; margin: 15px 0; border-left: 4px solid #dc3545; }
        .case-number { font-family: 'Courier New', monospace; font-weight: bold; color: #fd7e14; }
        .time-overdue { color: #dc3545; font-weight: bold; }
        .action-button { background: #dc3545; color: white; padding: 10px 20px; text-decoration: none; border-radius: 6px; display: inline-block; margin: 5px 0; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>⚠️ Customer Cases Need Your Response</h2>
            <p>The following cases have been waiting for more than 24 hours</p>
        </div>
        
        <div class="content">
            <p><strong>Quick response to customer concerns helps maintain your reputation and can turn negative experiences into positive ones.</strong></p>
            
            <?php foreach ($overdue_cases as $case): ?>
                <div class="case-item">
                    <div class="case-number"><?= esc($case['case_number']) ?></div>
                    <p><strong>Customer:</strong> <?= esc($case['customer_name'] ?: 'Anonymous') ?><br>
                    <strong>Scores:</strong> <?= $case['satisfaction_score'] ?>/10 satisfaction, <?= $case['nps_score'] ?>/10 NPS<br>
                    <strong>Waiting:</strong> <span class="time-overdue"><?= $case['hours_waiting'] ?> hours</span></p>
                    
                    <?php if ($case['feedback_comment']): ?>
                        <p><em>"<?= esc(substr($case['feedback_comment'], 0, 100)) ?><?= strlen($case['feedback_comment']) > 100 ? '...' : '' ?>"</em></p>
                    <?php endif; ?>
                    
                    <a href="<?= base_url('business/feedback/case/' . $case['case_id']) ?>" class="action-button">
                        Respond Now
                    </a>
                </div>
            <?php endforeach; ?>
            
            <p><strong>Response Tips:</strong></p>
            <ul>
                <li>Acknowledge their concern sincerely</li>
                <li>Ask for specific details about what went wrong</li>
                <li>Offer a concrete resolution when possible</li>
                <li>Follow up to ensure satisfaction</li>
            </ul>
        </div>
    </div>
</body>
</html>
