<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?? 'Complete Your Profile' ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .profile-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.2);
            padding: 40px;
            width: 100%;
            max-width: 600px;
        }
        .header-section {
            text-align: center;
            margin-bottom: 30px;
        }
        .logo-img {
            max-width: 200px;
            height: auto;
            margin-bottom: 20px;
        }
        .welcome-message {
            background: #f0f4ff;
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 30px;
            text-align: center;
            border: 1px solid #e0e7ff;
        }
        .welcome-message h5 {
            color: #667eea;
            margin-bottom: 10px;
            font-weight: 600;
        }
        .progress-indicator {
            display: flex;
            justify-content: center;
            margin-bottom: 30px;
        }
        .progress-step {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            background: #e2e8f0;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 10px;
            position: relative;
            font-weight: 600;
            font-size: 0.875rem;
            color: #718096;
        }
        .progress-step.active {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        .progress-step.completed {
            background: #48bb78;
            color: white;
        }
        .progress-line {
            position: absolute;
            width: 100px;
            height: 2px;
            background: #e2e8f0;
            left: 30px;
            top: 14px;
        }
        .form-control {
            border-radius: 10px;
            padding: 12px 20px;
            border: 2px solid #e9ecef;
            transition: all 0.3s ease;
        }
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
        }
        .form-label {
            font-weight: 600;
            color: #4a5568;
            margin-bottom: 0.5rem;
        }
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 10px;
            padding: 12px 30px;
            font-weight: 600;
            width: 100%;
            transition: all 0.3s ease;
        }
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
        }
        .alert {
            border-radius: 10px;
        }
        .info-note {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 15px;
            margin-top: 20px;
            font-size: 0.875rem;
            color: #718096;
            text-align: center;
        }
        .info-note i {
            color: #667eea;
            margin-right: 0.5rem;
        }
        .required {
            color: #e53e3e;
            margin-left: 0.25rem;
        }
    </style>
</head>
<body>
    <div class="profile-card">
        <div class="header-section">
            <img src="https://ringgoldroad.com/assets/images/weblogo.png" alt="Ringgold Road" class="logo-img">
            <h3 class="fw-bold text-dark"><?= $title ?? 'Complete Your Profile' ?></h3>
            <p class="text-muted">Almost there! We just need a few more details.</p>
        </div>

        <div class="progress-indicator">
            <div class="progress-step completed">1</div>
            <div class="progress-line"></div>
            <div class="progress-step active">2</div>
            <div class="progress-line"></div>
            <div class="progress-step">3</div>
        </div>

        <div class="welcome-message">
            <h5>Welcome to Your Business Portal!</h5>
            <p class="mb-0">This contact information is for administrative purposes only. It will not be published on your profile and will not be used for marketing.</p>
        </div>

        <?php if (!empty($error)): ?>
            <div class="alert alert-danger d-flex align-items-center mb-4">
                <i class="fas fa-exclamation-triangle me-2"></i>
                <?= esc($error) ?>
            </div>
        <?php endif; ?>

        <?php if (!empty($success)): ?>
            <div class="alert alert-success d-flex align-items-center mb-4">
                <i class="fas fa-check-circle me-2"></i>
                <?= esc($success) ?>
            </div>
        <?php endif; ?>

        <?= form_open('/business/auth/first-login', ['class' => 'needs-validation', 'novalidate' => '']) ?>
            <?= csrf_field() ?>
            
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="first_name" class="form-label">First Name <span class="required">*</span></label>
                    <input type="text" 
                           class="form-control" 
                           id="first_name" 
                           name="first_name" 
                           value="<?= old('first_name', $user['first_name'] ?? '') ?>"
                           placeholder="John"
                           required>
                </div>

                <div class="col-md-6 mb-3">
                    <label for="last_name" class="form-label">Last Name <span class="required">*</span></label>
                    <input type="text" 
                           class="form-control" 
                           id="last_name" 
                           name="last_name" 
                           value="<?= old('last_name', $user['last_name'] ?? '') ?>"
                           placeholder="Doe"
                           required>
                </div>
            </div>

            <div class="mb-3">
                <label for="email" class="form-label">Email Address <span class="required">*</span></label>
                <input type="email" 
                       class="form-control" 
                       id="email" 
                       name="email" 
                       value="<?= old('email', (!empty($user['email']) && strpos($user['email'], '@not.published') === false) ? $user['email'] : '') ?>"
                       placeholder="john@business.com"
                       required>
                <small class="text-muted">We'll use this for important updates about your profile and password recovery</small>
            </div>

            <div class="mb-4">
                <label for="phone" class="form-label">Phone Number <span class="required">*</span></label>
                <input type="tel" 
                       class="form-control" 
                       id="phone" 
                       name="phone" 
                       value="<?= old('phone', $user['phone'] ?? '') ?>"
                       placeholder="(423) 555-1234"
                       required>
                <small class="text-muted">In case we need to reach you about your profile</small>
            </div>

            <div class="d-grid">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-check me-2"></i>
                    Complete Profile Setup
                </button>
            </div>
        <?= form_close() ?>

        <div class="info-note">
            <i class="fas fa-shield-alt"></i>
            Your personal information is secure and will only be used for account management purposes.
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Phone number formatting
        document.getElementById('phone').addEventListener('input', function (e) {
            let value = e.target.value.replace(/\D/g, '');
            let formattedValue = '';
            
            if (value.length > 0) {
                if (value.length <= 3) {
                    formattedValue = `(${value}`;
                } else if (value.length <= 6) {
                    formattedValue = `(${value.slice(0, 3)}) ${value.slice(3)}`;
                } else {
                    formattedValue = `(${value.slice(0, 3)}) ${value.slice(3, 6)}-${value.slice(6, 10)}`;
                }
            }
            
            e.target.value = formattedValue;
        });

        // Form validation
        (function () {
            'use strict'
            var forms = document.querySelectorAll('.needs-validation')
            Array.prototype.slice.call(forms)
                .forEach(function (form) {
                    form.addEventListener('submit', function (event) {
                        if (!form.checkValidity()) {
                            event.preventDefault()
                            event.stopPropagation()
                        }
                        form.classList.add('was-validated')
                    }, false)
                })
        })()
    </script>
</body>
</html>