<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?></title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            color: #333;
        }

        .admin-header {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.2);
            padding: 1rem 0;
            position: sticky;
            top: 0;
            z-index: 100;
            box-shadow: 0 2px 20px rgba(0, 0, 0, 0.1);
        }

        .nav-container {
            max-width: 1400px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 2rem;
        }

        .nav-brand {
            font-size: 1.5rem;
            font-weight: 700;
            color: #4a5568;
            text-decoration: none;
        }

        .nav-links {
            display: flex;
            gap: 0;
        }

        .nav-links a {
            color: #4a5568;
            text-decoration: none;
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            transition: all 0.3s ease;
            font-weight: 500;
        }

        .nav-links a:hover {
            background: rgba(102, 126, 234, 0.1);
            color: #667eea;
        }

        .nav-links a.active {
            background: #667eea;
            color: white;
            box-shadow: 0 2px 10px rgba(102, 126, 234, 0.3);
        }

        .user-menu {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .user-info {
            font-size: 0.9rem;
            color: #666;
        }

        .logout-btn {
            background: #e53e3e;
            color: white;
            padding: 0.5rem 1rem;
            border-radius: 6px;
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .logout-btn:hover {
            background: #c53030;
            transform: translateY(-1px);
        }

        .main-container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 2rem;
        }

        .page-header {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .page-title {
            font-size: 2.5rem;
            font-weight: 700;
            color: #2d3748;
            margin-bottom: 0.5rem;
        }

        .page-subtitle {
            color: #718096;
            font-size: 1.1rem;
        }

        .search-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 1.5rem;
            margin-bottom: 2rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .search-form {
            display: flex;
            gap: 1rem;
            align-items: center;
        }

        .search-input {
            flex: 1;
            padding: 0.75rem 1rem;
            border: 2px solid #e2e8f0;
            border-radius: 8px;
            font-size: 1rem;
            transition: all 0.3s ease;
        }

        .search-input:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .btn {
            padding: 0.75rem 1.5rem;
            border: none;
            border-radius: 8px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            transition: all 0.3s ease;
            cursor: pointer;
            font-size: 0.95rem;
        }

        .btn:hover {
            transform: translateY(-1px);
            text-decoration: none;
        }

        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
        }

        .btn-primary:hover {
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
            color: white;
        }

        .btn-secondary {
            background: #f7fafc;
            color: #4a5568;
            border: 2px solid #e2e8f0;
        }

        .btn-secondary:hover {
            background: #edf2f7;
            color: #4a5568;
        }

        .btn-sm {
            padding: 0.5rem 1rem;
            font-size: 0.875rem;
        }

        .btn-danger {
            background: #e53e3e;
            color: white;
        }

        .btn-danger:hover {
            background: #c53030;
            color: white;
        }

        .users-table {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 0;
            margin-bottom: 2rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            overflow: hidden;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th {
            background: #f7fafc;
            padding: 1rem;
            text-align: left;
            font-weight: 600;
            color: #4a5568;
            border-bottom: 2px solid #e2e8f0;
            position: sticky;
            top: 0;
        }

        td {
            padding: 1rem;
            border-bottom: 1px solid #e2e8f0;
        }

        tr:hover {
            background: #f7fafc;
        }

        .business-info {
            display: flex;
            flex-direction: column;
            gap: 0.25rem;
        }

        .business-name {
            font-weight: 600;
            color: #2d3748;
        }

        .business-meta {
            font-size: 0.875rem;
            color: #718096;
        }

        .credentials {
            font-family: 'Courier New', monospace;
            background: #edf2f7;
            padding: 0.25rem 0.5rem;
            border-radius: 4px;
            font-size: 0.9rem;
        }

        .password-status {
            display: flex;
            flex-direction: column;
            gap: 0.25rem;
        }

        .status-badge {
            display: inline-flex;
            align-items: center;
            gap: 0.25rem;
            padding: 0.25rem 0.75rem;
            border-radius: 12px;
            font-size: 0.75rem;
            font-weight: 600;
            width: fit-content;
        }

        .status-badge.temporary {
            background: #fef3c7;
            color: #92400e;
        }

        .status-badge.changed {
            background: #dbeafe;
            color: #1e40af;
        }

        .last-login {
            font-size: 0.875rem;
            color: #718096;
        }

        .alert {
            padding: 1rem 1.5rem;
            border-radius: 10px;
            margin-bottom: 2rem;
            border-left: 4px solid;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .alert-success {
            background: #f0fdf4;
            border-color: #38a169;
            color: #276749;
        }

        .alert-info {
            background: #ebf8ff;
            border-color: #4299e1;
            color: #2b6cb0;
        }

        .action-buttons {
            display: flex;
            gap: 0.5rem;
        }

        .no-results {
            text-align: center;
            padding: 3rem;
            color: #718096;
        }

        .no-results-icon {
            font-size: 3rem;
            color: #cbd5e0;
            margin-bottom: 1rem;
        }

        @media (max-width: 1200px) {
            .main-container {
                padding: 1rem;
            }
            
            .search-form {
                flex-direction: column;
            }
            
            .search-input {
                width: 100%;
            }
            
            .btn {
                width: 100%;
                justify-content: center;
            }
            
            .users-table {
                overflow-x: auto;
            }
            
            table {
                min-width: 800px;
            }
        }

        @media (max-width: 768px) {
            .page-title {
                font-size: 1.75rem;
            }
            
            td, th {
                padding: 0.5rem;
                font-size: 0.875rem;
            }
            
            .action-buttons {
                flex-direction: column;
            }
            
            .btn-sm {
                width: 100%;
                justify-content: center;
            }
        }
    </style>
</head>
<body>
    <header class="admin-header">
        <div class="nav-container">
            <a href="/admin/dashboard" class="nav-brand">
                <i class="fas fa-store"></i> Business Directory Admin
            </a>
            
            <nav class="nav-links">
                <a href="/admin/dashboard">
                    <i class="fas fa-tachometer-alt"></i> Dashboard
                </a>
                <a href="/admin/stores">
                    <i class="fas fa-building"></i> Stores
                </a>
                <a href="/admin/hours">
                    <i class="fas fa-clock"></i> Hours
                </a>
                <a href="/admin/categories">
                    <i class="fas fa-tags"></i> Categories
                </a>
                <a href="/admin/tools" class="active">
                    <i class="fas fa-tools"></i> Tools
                </a>
            </nav>
            
            <div class="user-menu">
                <div class="user-info">
                    <i class="fas fa-user-circle"></i>
                    <?= session()->get('admin_name') ?: 'Admin' ?>
                </div>
                <a href="/admin/logout" class="logout-btn">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
            </div>
        </div>
    </header>

    <main class="main-container">
        <div class="page-header">
            <h1 class="page-title">
                <i class="fas fa-key"></i> <?= $heading ?>
            </h1>
            <p class="page-subtitle">
                View and reset business user passwords
            </p>
        </div>

        <?php if (session()->getFlashdata('success')): ?>
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i>
            <?= session()->getFlashdata('success') ?>
        </div>
        <?php endif; ?>

        <?php if (session()->getFlashdata('error')): ?>
        <div class="alert alert-info">
            <i class="fas fa-info-circle"></i>
            <?= session()->getFlashdata('error') ?>
        </div>
        <?php endif; ?>

        <div class="search-card">
            <form method="get" action="/admin/tools/manage-passwords" class="search-form">
                <input type="text" 
                       name="search" 
                       class="search-input" 
                       placeholder="Search by business name, username, or email..." 
                       value="<?= esc($search ?? '') ?>">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-search"></i> Search
                </button>
                <?php if (!empty($search)): ?>
                <a href="/admin/tools/manage-passwords" class="btn btn-secondary">
                    <i class="fas fa-times"></i> Clear
                </a>
                <?php endif; ?>
            </form>
        </div>

        <?php if (!empty($users)): ?>
        <div class="users-table">
            <table>
                <thead>
                    <tr>
                        <th>Business</th>
                        <th>Username</th>
                        <th>Temporary Password</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($users as $user): ?>
                    <tr>
                        <td>
                            <div class="business-info">
                                <span class="business-name"><?= esc($user['store_name']) ?></span>
                                <span class="business-meta">
                                    <?= esc($user['address']) ?><br>
                                    <?= esc($user['phone']) ?>
                                </span>
                            </div>
                        </td>
                        <td>
                            <span class="credentials"><?= esc($user['username']) ?></span>
                        </td>
                        <td>
                            <?php if (!empty($user['temp_password_decrypted'])): ?>
                                <span class="credentials"><?= esc($user['temp_password_decrypted']) ?></span>
                            <?php else: ?>
                                <span style="color: #a0aec0; font-style: italic;">Changed by user</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="password-status">
                                <?php if (!empty($user['temp_password_decrypted'])): ?>
                                    <span class="status-badge temporary">
                                        <i class="fas fa-exclamation-circle"></i> Using temp password
                                    </span>
                                <?php else: ?>
                                    <span class="status-badge changed">
                                        <i class="fas fa-check-circle"></i> Password changed
                                    </span>
                                <?php endif; ?>
                                <?php if (!empty($user['last_login'])): ?>
                                    <span class="last-login">
                                        Last login: <?= date('M j, Y', strtotime($user['last_login'])) ?>
                                    </span>
                                <?php else: ?>
                                    <span class="last-login">Never logged in</span>
                                <?php endif; ?>
                            </div>
                        </td>
                        <td>
                            <div class="action-buttons">
                                <a href="/admin/tools/reset-password/<?= $user['id'] ?>" 
                                   class="btn btn-danger btn-sm"
                                   onclick="return confirm('Reset password for <?= esc($user['store_name']) ?>?')">
                                    <i class="fas fa-redo"></i> Reset
                                </a>
                                <a href="/admin/stores/edit/<?= $user['id'] ?>" 
                                   class="btn btn-secondary btn-sm">
                                    <i class="fas fa-edit"></i> Edit
                                </a>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <?php else: ?>
        <div class="users-table">
            <div class="no-results">
                <div class="no-results-icon">
                    <i class="fas fa-search"></i>
                </div>
                <h3>No Results Found</h3>
                <p>No business users match your search criteria.</p>
            </div>
        </div>
        <?php endif; ?>

        <div style="text-align: center; margin-top: 2rem;">
            <a href="/admin/tools" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to Tools
            </a>
        </div>
    </main>
</body>
</html>